<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
 JBusinessUtil::initializeChosen();

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;

$listOrder = $this->escape($this->state->get('list.ordering'));
$listDirn = $this->escape($this->state->get('list.direction'));
?>

<script type="text/javascript">
window.addEventListener('load', function() {
	Joomla.submitbutton = function(task) {
		if (task != 'offercoupons.delete' || confirm('<?php echo JText::_('ARE_YOU_SURE_YOU_WANT_TO_DELETE', true);?>')) {
			Joomla.submitform(task);
		}
    }
});
</script>

<div id="jbd-container" class="jbd-container">
    <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=offercoupons');?>" method="post" name="adminForm" id="adminForm">
        <div id="j-main-container" class="j-main-container">
            <?php
            // Search tools bar
            echo JLayoutHelper::render('joomla.searchtools.default', array('view' => $this, 'options' => array('filtersHidden' =>JBusinessUtil::setFilterVisibility($this->state))));
            ?>
        </div>
        <div class="clr clearfix"></div>

        <?php if (empty($this->items)) { ?>
            <div class="alert alert-warning">
                <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
            </div>
        <?php } else { ?>
    	<table class="jtable" id="itemList">
    		<thead class="jtable-head">
    			<tr class="jtable-head-row">
                    <th class="jtable-head-row-data">
                        <div class="d-flex justify-content-center align-items-center">
                            <div class="jradio">
                                <input id="jradio-2" type="checkbox" title="<?php echo JText::_('JGLOBAL_CHECK_ALL');?>" onclick="Joomla.checkAll(this)" />
                                <label for="jradio-2"></label>
                            </div>
                        </div>
                    </th>
                    <th class="jtable-head-row-data">
                        <div class="d-flex justify-content-center align-items-center">
                            <span class="jtable-head-row-data-title"> # </span>
                        </div>
                    </th>
    				<th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_COUPON', 'ofc.code', $listDirn, $listOrder); ?></th>
    				<th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_OFFER', 'o.subject', $listDirn, $listOrder); ?></th>
    				<th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_COMPANY', 'co.name', $listDirn, $listOrder); ?></th>
    				<th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_GENERATED_TIME', 'ofc.generated_time', $listDirn, $listOrder); ?></th>
    				<th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_EXPIRATION_TIME', 'o.endDate', $listDirn, $listOrder); ?></th>
    				<th class="jtable-head-row-data" nowrap width='1%'>PDF</th>
    			</tr>
    		</thead>
    		<tfoot>
    			<tr>
    				<td colspan="15">
    					<?php echo $this->pagination->getListFooter(); ?>
    				</td>
    			</tr>
    		</tfoot>
    		<tbody class="jtable-body">
    			<?php $nrcrt = 1; $i=0; 
    			foreach($this->items as $coupon) { ?>
                    <tr class="jtable-body-row">

                        <td class="jtable-body-row-data px-3">
		                    <?php echo HTMLHelper::_('jbdgrid.id', $i, $coupon->id); ?>
                        </td>

                        <td class="jtable-body-row-data">
		                    <?php echo $nrcrt++; ?>
                        </td>

                        <td class="jtable-body-row-data jtable-body-name">
                            <span class="jtable-body-row-data-title">
                                <b><?php echo strtoupper($coupon->code); ?></b>
                            </span>
                        </td>

                        <td class="jtable-body-row-data">
                            <a href='<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=offer.edit&id='. $coupon->offer_id )?>'
                               title="<?php echo JText::_('LNG_CLICK_TO_EDIT'); ?>">
		                        <?php echo $coupon->offer; ?>
                            </a>
                        </td>

                        <td class="jtable-body-row-data">
                            <a href='<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=company.edit&id='. $coupon->company_id )?>'
                               title="<?php echo JText::_('LNG_CLICK_TO_EDIT'); ?>">
			                    <?php echo $coupon->company; ?>
                            </a>
                        </td>

                        <td class="jtable-body-row-data">
		                    <?php echo JBusinessUtil::getDateGeneralFormat($coupon->generated_time); ?>
                        </td>
                        <td class="jtable-body-row-data">
		                    <?php echo JBusinessUtil::getDateGeneralFormat($coupon->expiration_time); ?>
                        </td>

                        <td class="jtable-body-row-data">
                            <div class="row-fluid jbd-buttons-row">
                                <div class="d-flex align-items-center justify-content-center">
                                    <a href='<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=offercoupon.show&id='. $coupon->id )?>'
                                       title='<?php echo JText::_('LNG_CLICK_TO_VIEW'); ?>'
                                       target='_blank'
                                       class="jtable-btn">
                                        <i class="la la-eye"></i>
                                    </a>
                                </div>

                            </div>
                        </td>

                    </tr>
    			<?php
    				$i++;
    			} ?>
    		</tbody>
    	</table>
        <?php } ?>

        <input type="hidden" name="option" value="<?php echo JBusinessUtil::getComponentName()?>" />
    	<input type="hidden" name="task" value="" /> 
    	<input type="hidden" name="offerId" value="" />
    	<input type="hidden" name="boxchecked" value="0" />
    	<?php echo JHTML::_('form.token'); ?> 
    </form>
</div>