<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');

/**
 * The HTML  View.
 */


JBusinessUtil::loadJQueryUI();


JBusinessUtil::enqueueScript('libraries/dropzone/dropzone.js');

JBusinessUtil::enqueueStyle('libraries/dropzone/dropzone.css');
JBusinessUtil::enqueueStyle('libraries/dropzone/basic.css');

JBusinessUtil::enqueueStyle('libraries/jquery/jquery.timepicker.css');
JBusinessUtil::enqueueScript('libraries/jquery/jquery.timepicker.min.js');

JBusinessUtil::enqueueScript('libraries/chosen/ajax-chosen.min.js');


// following translations will be used in js
JText::script('LNG_VIDEO');
JText::script('LNG_MISSING_OFFER_COMPANY');
JText::script("LNG_MISSING_DELETED_COMPANY");
JText::script('LNG_NO_ATTRIBUTES_FOR_CATEGORY');
JText::script('LNG_IMAGE_SIZE_WARNING');

JBusinessUtil::includeValidation();
JHtml::script('jui/fielduser.min.js', false, true, false, false, true);

require_once HELPERS_PATH.'/helper.php';

class JBusinessDirectoryViewOffer extends JBusinessDirectoryAdminView {
	protected $item;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		$this->item	 = $this->get('Item');
		$this->state = $this->get('State');

		$this->companies = $this->get('Companies');
		$this->currencies = $this->get('Currencies');

		if ($this->appSettings->limit_cities_regions) {
			$this->cities = $this->get('Cities');
			$this->regions = $this->get('Regions');
		}

		$this->states = JBusinessDirectoryHelper::getStatuses();
		
		$this->translations = JBusinessDirectoryTranslations::getAllTranslations(OFFER_DESCRIPTION_TRANSLATION, $this->item->id);
		$this->translationsMeta = JBusinessDirectoryTranslations::getAllTranslations(OFFER_META_TRANSLATION, $this->item->id);

		$this->languages = JBusinessUtil::getLanguages();
		
		$this->appSettings = JBusinessUtil::getApplicationSettings();
		
		$this->categoryOptions = JBusinessUtil::getCategoriesOptions(true, CATEGORY_TYPE_OFFER);
		$this->companyOptions = JBusinessUtil::getCompaniesOptions($this->item->companyId);

		$lang = JBusinessUtil::getLanguageTag();
		$key="";
		if (!empty($this->appSettings->google_map_key)) {
			$key="&key=".$this->appSettings->google_map_key;
		}

		
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar() {
		$canDo = JBusinessDirectoryHelper::getActions();
		$input = JFactory::getApplication()->input;
		$input->set('hidemainmenu', true);
		$isNew = ($this->item->id == 0);

		$itemType = $this->state->get('filter.type');

		if ($itemType == OFFER_TYPE_PRODUCT) {
			$newText    = 'COM_JBUSINESSDIRECTORY_NEW_PRODUCT';
			$editText   = 'COM_JBUSINESSDIRECTORY_EDIT_PRODUCT';
		} else {
			$newText    = 'COM_JBUSINESSDIRECTORY_NEW_OFFER';
			$editText   = 'COM_JBUSINESSDIRECTORY_EDIT_OFFER';
		}

		JToolbarHelper::title(JText::_($isNew ? $newText : $editText), 'menu.png');
		
		if ($canDo->get('core.edit')) {
			JToolbarHelper::apply('offer.apply');
			JToolbarHelper::save('offer.save');
		}
	
		if (!$isNew) {
			JToolbarHelper::save2copy('offer.save2copy');
			$url  = JBusinessUtil::getOfferLink($this->item->id, $this->item->alias);
			JToolbarHelper::link($url, JText::_('LNG_VIEW_OFFER'), "link");
		}
			
		JToolbarHelper::cancel('offer.cancel', 'JTOOLBAR_CLOSE');
		
		JToolbarHelper::divider();
		JToolBarHelper::help('', false, DOCUMENTATION_URL.'businessdiradmin.html#offers');
	}
}
