<?php
/**
 * @package    JBusinessDirectory
 * @subpackage  com_jbusinessdirectory
 *
 * @copyright   Copyright (C) 2007 - 2015 CMS Junkie. All rights reserved.
 * @license     GNU General Public License version 2 or later;
 */

defined('_JEXEC') or die('Restricted access');

/**
 * The HTML  View.
 */



JBusinessUtil::enqueueScript('libraries/cropper/cropper.js');
JBusinessUtil::enqueueScript('libraries/cropper/canvas-toBlob.js');
JBusinessUtil::enqueueStyle('libraries/cropper/cropper.css');

JBusinessUtil::includeValidation();

require_once HELPERS_PATH.'/helper.php';

class JBusinessDirectoryViewMembership extends JBusinessDirectoryAdminView {
	protected $item;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		$this->item	 = $this->get('Item');
		$this->state = $this->get('State');
		$this->translations = JBusinessDirectoryTranslations::getAllTranslations(MEMBERSHIP_DESCRIPTION_TRANSLATION, $this->item->id);
		$this->languages = JBusinessUtil::getLanguages();

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JError::raiseError(500, implode("\n", $errors));
			return false;
		}
		$this->addToolbar();

		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar() {
		$canDo = JBusinessDirectoryHelper::getActions();
		$input = JFactory::getApplication()->input;
		$input->set('hidemainmenu', true);
		$isNew = ($this->item->id == 0);

		JToolbarHelper::title(JText::_($isNew ? 'COM_JBUSINESSDIRECTORY_NEW_MEMBERSHIP' : 'COM_JBUSINESSDIRECTORY_EDIT_MEMBERSHIP'), 'menu.png');

		if ($canDo->get('core.edit')) {
			JToolbarHelper::apply('membership.apply');
			JToolbarHelper::save('membership.save');
		}

		JToolbarHelper::cancel('membership.cancel', 'JTOOLBAR_CLOSE');

		JToolbarHelper::divider();
		JToolbarHelper::help('JHELP_JBUSINESSDIRECTORY_MEMBERSHIP_EDIT');
	}
}
