<?php
/**
 * @package    JBusinessDirectory
 * @subpackage  com_jbusinessdirectory
 *
 * @copyright   Copyright (C) 2007 - 2015 CMS Junkie. All rights reserved.
 * @license     GNU General Public License version 2 or later;
 */

defined('_JEXEC') or die('Restricted access');

/**
 * The HTML  View.
 */


require_once HELPERS_PATH.'/helper.php';

class JBusinessDirectoryViewMarketing extends JBusinessDirectoryAdminView {
	protected $logs;

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		JBusinessDirectoryHelper::addSubmenu('marketing');

		$this->logs = $this->get('Logs');
		$this->emailDescriptions = $this->get('EmailDescriptions');
		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JFactory::getApplication()->enqueueMessage(implode("\n", $errors), 'error');
			return false;
		}

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 */
	protected function addToolbar() {
		JToolBarHelper::title('J-BusinessDirectory : ' . JText::_('LNG_MARKETING'), 'generic.png');

		JToolbarHelper::divider();
		JToolBarHelper::custom('ratings.back', 'dashboard', 'dashboard', JText::_("LNG_CONTROL_PANEL"), false, false);
		JToolBarHelper::help('', false, DOCUMENTATION_URL . 'businessdiradmin.html#reports');
	}
}
