<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');

/**
 * The HTML Menus Menu Menus View.
 *
 * @package    JBusinessDirectory
 * @subpackage  com_jbusinessdirectory

 */

require_once HELPERS_PATH.'/helper.php';

class JBusinessDirectoryViewListingRegistrations extends JBusinessDirectoryAdminView {
	protected $items;
	protected $pagination;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		$this->items		= $this->get('Items');
		$this->pagination	= $this->get('Pagination');
		$this->state		= $this->get('State');

		$this->filterForm    = $this->get('FilterForm');
		$this->activeFilters = $this->get('ActiveFilters');

		JBusinessDirectoryHelper::addSubmenu('countries');

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JFactory::getApplication()->enqueueMessage(implode("\n", $errors), 'error');
			return false;
		}

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar() {
		$canDo = JBusinessDirectoryHelper::getActions();
		JToolBarHelper::title('J-BusinessDirectory : '.JText::_('LNG_LISTING_JOINS'), 'generic.png');

		if ($canDo->get('core.edit.state')) {
			JToolbarHelper::publish('listingregistrations.aprove', 'LNG_APPROVE', true);
			JToolbarHelper::unpublish('listingregistrations.disaprove', 'LNG_DISAPPROVE', true);
		}

		if ($canDo->get('core.admin')) {
			JToolbarHelper::preferences('com_jbusinessdirectory');
		}
				
		JToolbarHelper::divider();
		JToolBarHelper::custom('countries.back', 'dashboard', 'dashboard', JText::_('LNG_CONTROL_PANEL'), false);
		JToolBarHelper::help('', false, DOCUMENTATION_URL.'businessdiradmin.html#listingregistrations');
	}
}
