<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');

// Include the component HTML helpers.
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
$jbdTabs = new JBDTabs();
// Load the tooltip behavior.
?>

<script type="text/javascript">
window.addEventListener('load', function() {
	Joomla.submitbutton = function(task) {
		var defaultLang="<?php echo JBusinessUtil::getLanguageTag() ?>";

		jQuery("#item-form").validationEngine('detach');
		var evt = document.createEvent("HTMLEvents");
		evt.initEvent("click", true, true);
		var tab = ("tab-"+defaultLang);
		if(!(document.getElementsByClassName(tab)[0] === undefined || document.getElementsByClassName(tab)[0] === null))
			document.getElementsByClassName(tab)[0].dispatchEvent(evt);
		if (task == 'eventtype.cancel' || !jbdUtils.validateCmpForm(false, false)) {
			Joomla.submitform(task, document.getElementById('item-form'));
		}
		jQuery("#item-form").validationEngine('attach');
    }
});
</script>

<?php
$options = array(
	'onActive' => 'function(title, description){
		description.setStyle("display", "block");
		title.addClass("open").removeClass("closed");
}',
	'onBackground' => 'function(title, description){
		description.setStyle("display", "none");
		title.addClass("closed").removeClass("open");
}',
	'startOffset' => 0,  // 0 starts on the first tab, 1 starts the second, etc...
	'useCookie' => true, // this must not be a string. Don't use quotes.
);
?>
<div id="jbd-container" class="jbd-container jbd-edit-container">
	<form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=eventtype');?>" method="post" name="adminForm" id="item-form">
        <div class="row">
            <div class="col-md-7">
                <div class="row">
                    <div class="col-md-12">
                        <fieldset class="boxed">

                            <h2> <?php echo JText::_('LNG_EVENT_TYPE');?></h2>

                            <div class="form-container label-w-100">

                                <div class="form-group">
                                    <label for="id_id"><?php echo JText::_('LNG_ID')?> </label>
                                    <input type="text"
                                           name="id_id" id="id_id" class="input_txt form-control" value="<?php echo $this->item->id ?>" maxlength="4" disabled>
                                </div>

                                <div class="form-group">
                                    <label for="subject"><?php echo JText::_('LNG_NAME')?><?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY)?> </label>
                                    <?php
                                        if($this->appSettings->enable_multilingual){
                                            $jbdTabs->setOptions($options);
                                            echo $jbdTabs->startTabSet('tab_groupsd_id');
                                            foreach( $this->languages as $k=>$lng ){
                                                echo $jbdTabs->addTab('tab_groupsd_id', 'tab-'.$lng, $k);
                                                $langContent = isset($this->translations[$lng."_name"])?$this->translations[$lng."_name"]:"";
                                                if($lng == JBusinessUtil::getLanguageTag() && empty($langContent)){
                                                    $langContent = $this->item->name;
                                                }
                                                $langContent=$this->escape($langContent);
                                                echo "<input type='text' name='name_$lng' id='name_$lng' class='input_txt form-control validate[required]' value=\"".stripslashes($langContent)."\"  maxLength='100'>";
                                                echo $jbdTabs->endTab();
                                            }
                                            echo $jbdTabs->endTabSet();
                                        } else { ?>
                                            <input type="text" name="name" id="name" class="input_txt form-control validate[required]" value="<?php echo $this->escape($this->item->name) ?>"  maxLength="100">
                                    <?php } ?>
                                </div>

                            </div>

                        </fieldset>
                    </div>
                </div>
            </div>
        </div>
		<input type="hidden" name="option" value="<?php echo JBusinessUtil::getComponentName()?>" />
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="id" value="<?php echo $this->item->id ?>" />
		<?php echo JHTML::_( 'form.token' ); ?>
	</form>
</div>