<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');

/**
 * The HTML  View.
 */

JBusinessUtil::loadJQueryUI();

JBusinessUtil::enqueueStyle('libraries/jquery/jquery.timepicker.css');
JBusinessUtil::enqueueScript('libraries/jquery/jquery.timepicker.min.js');

JBusinessUtil::includeValidation();

JBusinessUtil::enqueueStyle('libraries/dropzone/dropzone.css');
JBusinessUtil::enqueueScript('libraries/dropzone/dropzone.js');
JBusinessUtil::enqueueScript('libraries/chosen/ajax-chosen.min.js');

JBusinessUtil::enqueueStyle('libraries/dropzone/basic.css');


// following translations will be used in js
JText::script('LNG_VIDEO');
JText::script('LNG_NO_ATTRIBUTES_FOR_CATEGORY');
JText::script('LNG_MISSING_EVENT_COMPANY');
JText::script("LNG_MISSING_DELETED_COMPANY");
JText::script('LNG_IMAGE_SIZE_WARNING');

JHtml::script('jui/fielduser.min.js', false, true, false, false, true);

require_once HELPERS_PATH.'/helper.php';

class JBusinessDirectoryViewEvent extends JBusinessDirectoryAdminView {
	protected $item;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		$this->item	 = $this->get('Item');
		$this->state = $this->get('State');

		$this->states = JBusinessDirectoryHelper::getStatuses();
		
		$this->translations = JBusinessDirectoryTranslations::getAllTranslations(EVENT_DESCRIPTION_TRANSLATION, $this->item->id);
		$this->translationsMeta = JBusinessDirectoryTranslations::getAllTranslations(EVENT_META_TRANSLATION, $this->item->id);
		$this->languages = JBusinessUtil::getLanguages();
		
		$this->appSettings = JBusinessUtil::getApplicationSettings();
		$this->categoryOptions = JBusinessUtil::getCategoriesOptions(true, CATEGORY_TYPE_EVENT);
		$this->companyOptions = JBusinessUtil::getCompaniesOptions($this->item->company_id);
		$this->associatedCompanyOptions = JBusinessUtil::getCompaniesOptions($this->item->company_id);
		$this->attendanceModes = JBusinessUtil::getAttendanceModes();

		$this->currencies = $this->get('Currencies');

		if ($this->appSettings->limit_cities_regions) {
			$this->cities = $this->get('Cities');
			$this->regions = $this->get('Regions');
		}

		$lang = JBusinessUtil::getLanguageTag();
		$key="";
		if (!empty($this->appSettings->google_map_key)) {
			$key="&key=".$this->appSettings->google_map_key;
		}

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JFactory::getApplication()->enqueueMessage(implode("\n", $errors), 'error');
			return false;
		}
		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar() {
		$canDo = JBusinessDirectoryHelper::getActions();
		$input = JFactory::getApplication()->input;
		$input->set('hidemainmenu', true);
		$isNew = ($this->item->id == 0);

		JToolbarHelper::title(JText::_($isNew ? 'COM_JBUSINESSDIRECTORY_NEW_EVENT' : 'COM_JBUSINESSDIRECTORY_EDIT_EVENT'), 'menu.png');
		
		if ($canDo->get('core.edit')) {
			JToolbarHelper::apply('event.apply');
			JToolbarHelper::save('event.save');
		}

		if (!$isNew) {
			JToolbarHelper::save2copy('event.save2copy');
			$url  = JBusinessUtil::getEventLink($this->item->id, $this->item->alias);
			JToolbarHelper::link($url, JText::_('LNG_VIEW_EVENT'), "link");
		}

		JToolbarHelper::cancel('event.cancel', 'JTOOLBAR_CLOSE');
		
		JToolbarHelper::divider();
		JToolBarHelper::help('', false, DOCUMENTATION_URL.'businessdiradmin.html#events');
	}
}
