<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');

JHtml::_('bootstrap.tooltip');
JHtml::_('behavior.multiselect');
 JBusinessUtil::initializeChosen();

use Joomla\CMS\Factory;
use Joomla\CMS\HTML\HTMLHelper;
use Joomla\CMS\Language\Multilanguage;
use Joomla\CMS\Language\Text;
use Joomla\CMS\Layout\LayoutHelper;
use Joomla\CMS\Router\Route;
use Joomla\CMS\Session\Session;

$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
?>

<script type="text/javascript">
window.addEventListener('load', function() {
	Joomla.submitbutton = function(task) {
		if (task != 'discounts.delete' || confirm('<?php echo JText::_('ARE_YOU_SURE_YOU_WANT_TO_DELETE', true);?>')) {
			Joomla.submitform(task);
		}
    }
});
</script>

<div id="jbd-container" class="jbd-container">
    <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=discounts');?>" method="post" name="adminForm" id="adminForm">
        <div id="j-main-container" class="j-main-container">
            <?php
            // Search tools bar
            echo
            JLayoutHelper::render('joomla.searchtools.default', array('view' => $this, 'options' => array('filtersHidden' =>JBusinessUtil::setFilterVisibility($this->state))));
            ?>
        </div>
        <div class="clr clearfix"></div>

        <?php if (empty($this->items)) { ?>
            <div class="alert alert-warning">
                <?php echo Text::_('JGLOBAL_NO_MATCHING_RESULTS'); ?>
            </div>
        <?php } else { ?>

            <table class="jtable" id="itemList">
                <thead class="jtable-head">
                    <tr class="jtable-head-row">
                        <td class="jtable-head-row-data"></td>
                        <th class="jtable-head-row-data">
                            <div class="d-flex justify-content-center align-items-center">
                                <div class="jradio">
                                    <input id="jradio-2" type="checkbox" title="<?php echo JText::_('JGLOBAL_CHECK_ALL');?>" onclick="Joomla.checkAll(this)" />
                                    <label for="jradio-2"></label>
                                </div>
                            </div>
                        </th>
                        <th class="jtable-head-row-data">
                            <div class="d-flex justify-content-center align-items-center">
                                <span class="jtable-head-row-data-title"> # </span>
                            </div>
                        </th>

                        <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_NAME', 'co.name', $listDirn, $listOrder); ?></th>
                        <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_CODE', 'co.code', $listDirn, $listOrder); ?></th>
                        <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_START_DATE', 'co.start_date', $listDirn, $listOrder); ?></th>
                        <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_END_DATE', 'co.end_date', $listDirn, $listOrder); ?></th>
                        <th class="jtable-head-row-data"><?php echo JText::_("LNG_PACKAGES")?></th>
                        <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_VALUE', 'co.value', $listDirn, $listOrder); ?></th>
                        <th class="jtable-head-row-data" style="text-align: center"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_STATE', 'co.state', $listDirn, $listOrder); ?></th>
                        <th class="jtable-head-row-data"><?php echo HTMLHelper::_('searchtools.sort', 'LNG_ID', 'co.id', $listDirn, $listOrder); ?></th>
                    </tr>
                </thead>
            <tfoot>
                <tr>
                    <td colspan="15">
                        <?php echo $this->pagination->getListFooter(); ?>
                    </td>
                </tr>
            </tfoot>
            <tbody class="jtable-body">
                <?php $nrcrt = 1; $i=0;
                foreach( $this->items as $discount) { ?>
                    <tr class="jtable-body-row">
                        <td class="jtable-body-row-data">
                            <div class="d-flex align-items-center">
                                <div id="item-status-<?php echo $discount->id?>" class="jtable-body-status <?php echo $discount->state == 1?"bg-success":"bg-danger" ?> "></div>
                            </div>
                        </td>

                        <td class="jtable-body-row-data px-3">
                            <?php echo HTMLHelper::_('jbdgrid.id', $i, $discount->id); ?>
                        </td>

                        <td class="jtable-body-row-data" align="center"><?php echo $nrcrt++?></td>

                        <td class="jtable-body-row-data">
                            <a
                            href='<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=discount.edit&id='. $discount->id )?>'
                            title="<?php echo JText::_('LNG_CLICK_TO_EDIT'); ?>">
                                <b><?php echo $discount->name?></b>
                            </a>
                        </td>

                        <td class="jtable-body-row-data">
                            <?php echo $discount->code ?>
                        </td>

                        <td class="jtable-body-row-data">
                            <?php echo JBusinessUtil::getDateGeneralFormat($discount->start_date) ?>
                        </td>

                        <td class="jtable-body-row-data">
                            <?php echo JBusinessUtil::getDateGeneralFormat($discount->end_date) ?>
                        </td>

                        <td class="jtable-body-row-data">
                            <?php echo $discount->packageNames?>
                        </td>

                        <td class="jtable-body-row-data">
                            <?php echo $discount->value ?> <?php if ($discount->price_type == 2) echo "%"?>
                        </td>

                        <td class="jtable-body-row-data">
                            <?php echo HTMLHelper::_('jbdgrid.published', $discount->state, $i, 'discounts.', true, 'cb', true, true, $discount->id); ?>
                        </td>

                        <td class="jtable-body-row-data">
                            <?php echo $discount->id?>
                        </td>
                    </tr>
                <?php
                    $i++;
                } ?>
            </tbody>
        </table>
        <?php } ?>

        <input type="hidden" name="option"	value="<?php echo JBusinessUtil::getComponentName()?>" />
        <input type="hidden" name="task" value="" />
        <input type="hidden" name="companyId" value="" />
        <input type="hidden" name="boxchecked" value="0" />
        <?php echo JHTML::_('form.token'); ?>
    </form>
</div>
<?php echo $this->loadTemplate('export'); ?>