<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');

// Include the component HTML helpers.
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');

// Load the tooltip behavior.
?>

<script type="text/javascript">
window.addEventListener('load', function() {
	Joomla.submitbutton = function(task) {	
		if (task == 'discount.cancel' || task == 'discount.aprove' || task == 'discount.disaprove' || !jbdUtils.validateCmpForm(false, false)) {
			Joomla.submitform(task, document.getElementById('item-form'));
		}
    }
});
</script>

<?php 
$appSettings = JBusinessUtil::getApplicationSettings();
?>

<div id="jbd-container" class="jbd-container jbd-edit-container">
    <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&layout=edit&id='.(int) $this->item->id); ?>" method="post" name="adminForm" id="item-form" class="form-horizontal">
        <div class="row">
            <div class="col-md-7">
                <div class="row">
                    <div class="col-md-12">
                        <fieldset class="boxed">
                            <h2> <?php echo JText::_('LNG_DISCOUNT_DETAILS');?></h2>
                            <div class="form-container">
                                <div class="form-group">
                                    <div  class="form-detail req"></div>
                                    <label for="subject"><?php echo JText::_('LNG_NAME')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY)?></label>
                                    <input type="text" name="name" id="name" class="form-control validate[required]" value="<?php echo $this->escape($this->item->name) ?>"  maxLength="255">
                                </div>
                                <div class="form-group">
                                    <label for="startDate"><?php echo JText::_('LNG_START_DATE')?> </label>
                                    <?php echo JHTML::_('calendar', $this->item->start_date, 'start_date', 'start_date', $appSettings->calendarFormat, array('class'=>'inputbox calendar-date', 'size'=>'10',  'maxlength'=>'10')); ?>
                                </div>
                                <div class="form-group">
                                    <label for="endDate"><?php echo JText::_('LNG_END_DATE')?> </label>
                                    <?php echo JHTML::_('calendar', $this->item->end_date, 'end_date', 'end_date', $appSettings->calendarFormat, array('class'=>'inputbox calendar-date', 'size'=>'10',  'maxlength'=>'10')); ?>
                                </div>
                                <div class="form-group">
                                    <label for="package_ids"><?php echo JText::_('LNG_PACKAGE')?></label>
                                    <select name="package_ids[]" id="package_ids" data-placeholder="<?php echo JText::_("LNG_SELECT_PACKAGE") ?>" multiple class="chosen-select">
                                        <?php
                                        foreach($this->packages as $package) {
                                            $selected = false;
                                            foreach($this->item->package_ids as $pId) {
                                                if($pId == $package->id)
                                                    $selected = true;
                                            } ?>
                                            <option <?php echo $selected ? "selected" : ""?> value='<?php echo $package->id ?>'>
                                                <?php echo $package->name ?>
                                            </option>
                                        <?php
                                        } ?>
                                    </select>
                                </div>
                                <div class="form-group">
                                    <div  class="form-detail req"></div>
                                    <label for="code"><?php echo JText::_('LNG_COUPON_CODE')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY)?></label>
                                    <input type="text" name="code" id="code" class="form-control validate[required]" value="<?php echo  $this->escape($this->item->code) ?>"  maxLength="50">
                                </div>
                                <div class="form-group">
                                    <div  class="form-detail req"></div>
                                    <label for="uses_per_coupon"><?php echo JText::_('LNG_USES_PER_COUPON')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY)?></label>
                                    <input type="text" name="uses_per_coupon" id="uses_per_coupon" class="form-control validate[required]" value="<?php echo $this->item->uses_per_coupon ?>"  maxLength="50">
                                    <span><?php echo JText::_("LNG_USED").": ". $this->item->coupon_used?></span>
                                </div>
                                <div class="form-group">
                                    <div  class="form-detail req"></div>
                                    <label for="companyId"><?php echo JText::_('LNG_VALUE')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY)?></label>
                                    <input type="text" name="value" id="value" class="form-control validate[required]" value="<?php echo $this->item->value ?>"  maxLength="50">
                                </div>
                                <div class="form-group">
                                    <div class="form-detail req"></div>
                                    <label for="price-type"><?php echo JText::_('LNG_TYPE')?></label>
                                    <fieldset id="price-type" class="radio btn-group btn-group-yesno">
                                        <input type="radio" class="validate[required]" name="price_type" id="price-value" value="1" <?php echo $this->item->price_type==1? 'checked="checked"' :""?> />
                                        <label class="btn" for="price-value"><?php echo JText::_('LNG_VALUE')?></label>
                                        <input type="radio" class="validate[required]" name="price_type" id="price-percent" value="2" <?php echo $this->item->price_type==2? 'checked="checked"' :""?> />
                                        <label class="btn" for="price-percent"><?php echo JText::_('LNG_PERCENT')?></label>
                                    </fieldset>
                                </div>
                                <div class="form-group">
                                    <label for="state"><?php echo JText::_('LNG_STATE')?></label>
                                    <select class="chosen-select" name="state" id="state">
                                        <?php echo JHtml::_('select.options', $this->states, 'value', 'text', $this->item->state);?>
                                    </select>
                                </div>
                            </div>
                        </fieldset>
                    </div>
                </div>
            </div>
        </div>
        <input type="hidden" name="option" value="<?php echo JBusinessUtil::getComponentName()?>" />
        <input type="hidden"name="task" id="task" value="" />
        <input type="hidden" name="id" value="<?php echo $this->item->id ?>" />
        <?php echo JHTML::_( 'form.token' ); ?>
    </form>
</div>

<script>
	window.addEventListener('load', function() {
		jQuery(".chosen-select").chosen({width:"95%", disable_search_threshold: 5, placeholder_text_single: "<?php echo JText::_('LNG_SELECT_OPTION')  ?>" , placeholder_text_single: "<?php echo JText::_('LNG_SELECT_OPTION')  ?>" , placeholder_text_multiple: "<?php echo JText::_('LNG_SELECT_OPTION')  ?>"});
	});
</script>