<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');

/**
 * The HTML  View.
 */

JBusinessUtil::loadJQueryUI();

JBusinessUtil::enqueueScript('libraries/cropper/cropper.js');
JBusinessUtil::enqueueScript('libraries/cropper/canvas-toBlob.js');
JBusinessUtil::enqueueStyle('libraries/cropper/cropper.css');
JBusinessUtil::enqueueScript('libraries/chosen/ajax-chosen.min.js');
JBusinessUtil::includeValidation();

require_once HELPERS_PATH.'/helper.php';

JText::script('LNG_SERVICE');
JText::script('LNG_ITEM');
class JBusinessDirectoryViewCompanyPriceList extends JBusinessDirectoryAdminView {
	protected $item;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		$this->item	 = $this->get('Item');
		$this->state = $this->get('State');
		$this->appSettings = JBusinessUtil::getApplicationSettings();
		
		$this->companyOptions = JBusinessUtil::getCompaniesOptions($this->item->companyId);
		$this->languages = JBusinessUtil::getLanguages();

		// Check for errors.
		if (count($errors = $this->get('Errors'))) {
			JFactory::getApplication()->enqueueMessage(implode("\n", $errors), 'error');
			return false;
		}

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 *
	 * @since   1.6
	 */
	protected function addToolbar() {
		$canDo = JBusinessDirectoryHelper::getActions();
		$input = JFactory::getApplication()->input;
		$input->set('hidemainmenu', true);
		$isNew = ($this->item->companyId == 0);

		JToolbarHelper::title(JText::_($isNew ? 'COM_JBUSINESSDIRECTORY_NEW_COMPANY_PRICE_LIST' : 'COM_JBUSINESSDIRECTORY_EDIT_COMPANY_PRICE_LIST'), 'menu.png');
		
		if ($canDo->get('core.edit')) {
			JToolbarHelper::apply('companypricelist.apply');
			JToolbarHelper::save('companypricelist.save');
		}
		
		JToolbarHelper::cancel('companypricelist.cancel', 'JTOOLBAR_CLOSE');
		
		JToolbarHelper::divider();
		JToolBarHelper::help('', false, DOCUMENTATION_URL.'businessdiradmin.html#companypricelist');
	}
}
