<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved. 
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');

// Include the component HTML helpers.
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
$jbdTabs = new JBDTabs();
// Load the tooltip behavior.
JBusinessUtil::loadJQueryChosen();
$user = JBusinessUtil::getUser();
$item = $this->item;
$totalServices = 0;
?>

<script type="text/javascript">
window.addEventListener('load', function() {
	Joomla.submitbutton = function(task) {
		jQuery("#item-form").validationEngine('detach');
		if (task == 'companypricelist.cancel' || !jbdUtils.validateCmpForm(false, false)) {
			Joomla.submitform(task, document.getElementById('item-form'));
		}
		jQuery("#item-form").validationEngine('attach');
    }
});
</script>

<div id="jbd-container" class="jbd-container jbd-edit-container">
    <?php  if(isset($isProfile)) { ?>
        <div class="row py-2 mb-2">
            <div class="col-md-12">
                <div>
                    <div class="button-row">
                        <button id="save-btn" type="button" class="btn btn-success button-save" onclick="savePriceListCompanyInformation('apply')">
                            <i class="la la-edit"></i> <?php echo JText::_("LNG_SAVE")?>
                        </button>
                        <button type="button" class="btn btn-success button-close" onclick="savePriceListCompanyInformation('save');">
                            <span class="ui-button-text"><i class="la la-check"></i> <?php echo JText::_("LNG_SAVE_AND_CLOSE")?></span>
                        </button>
                        <button type="button" class="btn btn-dark button-cancel" onclick="cancel()">
                            <i class="la la-close"></i> <?php echo JText::_("LNG_CANCEL")?>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    <?php  } ?>

	<form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&layout=edit&id='.(int) $item->id); ?>" method="post" name="adminForm" id="item-form" class="form-horizontal jbd-edit-container" enctype="multipart/form-data">
        <div class="row">
            <div class="<?php echo (!isset($isProfile))?"col-md-7":"col-md-12"?>">
            	 <div class="row">
                    <div class="col-md-12">
                        <fieldset class="boxed">
                            <div class="row align-items-center">
                                <div class="col-md ">
                                    <strong><?php echo JText::_('LNG_SELECT_LISTING')?> <?php echo JBusinessUtil::showMandatory(ATTRIBUTE_MANDATORY)?></strong>
                                </div>
                                <div class="col-md jbd-select-box">
                                    <select id="companyId" name="companyId" class="ajax-chosen-select validate[required]" data-placeholder="<?php echo JText::_("LNG_SELECT_OR_SEARCH_COMPANY") ?>">
			                        	<option value=""><?php echo JText::_("LNG_SELECT_OR_SEARCH_COMPANY")?></option>
			                            <?php if (!empty($this->item->companyId))
			                                echo JHtml::_('select.options', $this->item->companyOptions, 'id', 'name', $this->item->companyId);
			                            ?>
			                            <?php echo JHtml::_('select.options', $this->companyOptions, 'id', 'name', -1); ?>
			                        </select>
                                </div>
                            </div>
                        </fieldset>
                    </div>
                </div>
            
                <div class="">
                    <fieldset class="boxed" style="max-width: unset;">
                        <h3> <?php echo JText::_('LNG_SERVICE_PRICE');?></h3>
                        <p> <?php echo JText::_('LNG_SERVICE_PRICE_TEXT');?></p>
                        <div id="service_details">
                            <?php $i=1;
                            $companyFolderPath = PRICE_LIST_PICTURES_PATH.($item->id+0)."/";
                            $companyFolderPathId =  JBusinessUtil::getUploadUrl().'&t='.strtotime("now").'&picture_type='.PICTURE_TYPE_GALLERY.'&_path_type=1&_target='.urlencode(PRICE_LIST_PICTURES_PATH.($this->item->id+0)."/").'&croppable=1';

                            foreach($item->services as $service) { ?>
                                <div class="form-container" id="service-form-box<?php echo $i ?>">
                                    <div class="row">
                                    	<div class="col-md-12">
                                            <span id="service_header<?php echo $i ?>">
                                                <h5><?php echo JText::_('LNG_ITEM') . ' ' . $i; ?></h5>
                                                <a class="right remove-service" href="javascript:jbdListings.removeService(<?php echo $i; ?>)">(<?php echo JText::_('LNG_REMOVE_SERVICE'); ?>)</a>
                                            </span>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="form-group" id="imageSection">
                                                <label> <?php echo JText::_('LNG_IMAGE'); ?></label>
                                                <div class="jupload logo-jupload">
                                                    <div class="jupload-body">
                                                        <div class="jupload-files">
                                                            <div class="jupload-files-img image-fit-contain picture-preview services"
                                                                 id="service-picture-preview<?php echo $i ?>">
                                                                <?php
                                                                if (!empty($service->service_image)) {
                                                                    echo "<img id='logoImg' src='" . BD_PICTURES_PATH . $service->service_image . "'/>";
                                                                } else {
                                                                    echo "<i class='la la-image'></i>";
                                                                } ?>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    <input type="text" style="visibility:hidden;height:1px;min-height: unset;"
                                                           class="input-imageLocation"
                                                           name="service_image[]"
                                                           id="service-imageLocation<?php echo $i ?>"
                                                           value="<?php echo $service->service_image ?>">
                                                    <div class="jupload-footer">
                                                        <fieldset id="imageSelection1">
                                                            <input type="file" class="input-imageLocationSize"
                                                                   id="service-imageUploader<?php echo $i ?>"
                                                                   name="uploadfile" size="50">
                                                        </fieldset>
                                                        <div class="btn-group" id="imageSelection2">
                                                            <label for="service-imageUploader<?php echo $i ?>"
                                                                   class="btn btn-primary"><?php echo JText::_("LNG_UPLOAD") ?></label>
                                                            <a name="" id="" class="btn btn-danger"
                                                               href="javascript:uploadInstance.removeImage('service-', '<?php echo $i ?>');"
                                                               role="button"><?php echo JText::_("LNG_REMOVE_IMAGE") ?></a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-7">
                                            <div class="form-group">
                                                <label for="service_name"><?php echo JText::_('LNG_SECTION_NAME') ?></label>
                                                <input type="text" name="service_section[]"
                                                       id="service_section<?php echo $i ?>"
                                                       class="form-control"
                                                       value="<?php echo $service->service_section ?>" maxlength="50">
                                            </div>
                                            <div class="row align-items-end">
                                                <div class="col-md">
                                                    <div class="form-group">
                                                        <label for="service_name"><?php echo JText::_('LNG_NAME') ?></label>
                                                        <?php 
                                                        if ($this->appSettings->enable_multilingual) {
                                                            echo $jbdTabs->startTabSet('tab_group_name');
                                                            foreach( $this->languages as $k=>$lng ){
                                                                echo $jbdTabs->addTab('tab_group_name', 'tab-' . $lng, $k);
                                                                $langContent = isset($service->translations[$lng."_name"])?$service->translations[$lng."_name"]:"";
                                                                if($lng == JBusinessUtil::getLanguageTag() && empty($langContent)){
                                                                    $langContent = $service->service_name;
                                                                }
                                                                $nameLangContent = 'name_'.$lng.'[]';
                                                                echo "<input type='text' name='$nameLangContent' id='name_$lng$i' class='input_txt form-control' value=\"".$this->escape($langContent)."\"  maxLength='100'>";
                                                                echo $jbdTabs->endTab();
                                                            }
                                                            echo $jbdTabs->endTabSet();
                                                        } else { ?>
                                                        <input type="text" name="service_name[]"
                                                            id="service_name<?php echo $i ?>"
                                                            class="form-control"
                                                            value="<?php echo $service->service_name ?>" maxlength="50">
                                                        <?php } ?>
                                                    </div>
                                                </div>

                                                <div class="col-md">
                                                    <div class="form-group">
                                                        <label for="service_price"><?php echo JText::_('LNG_PRICE') ?></label>
                                                        <input type="text" name="service_price[]"
                                                               id="service_price<?php echo $i ?>"
                                                               class="form-control"
                                                               value="<?php echo !empty($service->service_price) ? JBusinessUtil::convertPriceFromMysql($service->service_price) : JBusinessUtil::convertPriceFromMysql(0); ?>"
                                                               maxlength="50">
                                                    </div>
                                                </div>
								            </div>

                                            <div class="form-group">
                                                <label for="service_description"><?php echo JText::_('LNG_DESCRIPTION') ?></label>
                                                <?php
                                                if($this->appSettings->enable_multilingual) {
                                                    echo $jbdTabs->startTabSet('tab_groupsd_id');
                                                    foreach( $this->languages  as $k=>$lng ) {
                                                        echo $jbdTabs->addTab('tab_groupsd_id', 'tab-'.$lng, $k);
                                                        $langContent = isset($service->translations[$lng])?$service->translations[$lng]:"";
                                                        if($lng==JBusinessUtil::getLanguageTag() && empty($langContent)) {
                                                            $langContent = $service->service_description;
                                                        }
                                                        $descLangContent = 'description_'.$lng.'[]';

                                                        echo "<textarea name='$descLangContent' id='description_$lng$i' class='input_txt form-control' cols='75' rows='5' maxLength='250'>$langContent</textarea>";
                                                        echo $jbdTabs->endTab();
                                                    }
                                                    echo $jbdTabs->endTabSet();
                                                } else { ?>
                                                <textarea name="service_description[]"
                                                        id="service_description<?php echo $i ?>"
                                                        class="form-control h-auto"
                                                        cols="75" rows="5"
                                                        maxLength="250"><?php echo $service->service_description ?></textarea>
                                                <?php } ?>
                                            </div>
                                        </div>
                                    </div>
                                    <input type="hidden" name="service_id[]" id="service_id<?php echo $i ?>"
                                           value="<?php echo $service->id ?>"/>
                                    <hr/>
                                </div>
                                <?php
                                $i++;
                            } $totalServices = $i-1;?>
                            <?php ?>
                        </div>
                        <span id="total_services" style="display:none;"><?php echo $totalServices ?></span>
                        <a id="add_service" class="right" href="javascript:void(0)" onclick="jbdListings.addNewService('<?php echo $i-1 ?>','<?php echo $companyFolderPath ?>','<?php echo $companyFolderPathId ?>')"><?php echo JText::_('LNG_ADD_NEW_SERVICE'); ?></a>
                    </fieldset>
                </div>
            </div>
        </div>
		<input type="hidden" name="option" value="<?php echo JBusinessUtil::getComponentName()?>" />
		<input type="hidden" name="task" id="task" value="" />
        <input type="hidden" name="id" value="<?php echo $this->item->id ?>" />
        <?php echo JHTML::_( 'form.token' ); ?>
	</form>
</div>

<?php JBusinessUtil::loadUploadScript(); ?>

<script>
    var companyFolder = '<?php echo PRICE_LIST_PICTURES_PATH.($this->item->id+0)."/" ?>';
    var companyFolderPathGallery = '<?php echo JBusinessUtil::getUploadUrl() ?>&t=<?php echo strtotime("now")?>&picture_type=<?php echo PICTURE_TYPE_GALLERY?>&_path_type=1&_target=<?php echo urlencode(PRICE_LIST_PICTURES_PATH.($this->item->id+0)."/")?>&croppable=1';
    var totalServices = '<?php echo count($item->services) ?>';

    var uploadInstance;

    window.addEventListener('load', function() {

        uploadInstance = JBDUploadHelper.getUploadInstance();

        for (let iterator = 0; iterator < totalServices; iterator++) {
            let picId = iterator + 1 ;
            uploadInstance.imageUploader(companyFolder, companyFolderPathGallery, 'service-', picId);
        }

        jQuery(".ajax-chosen-select").chosen({width: "95%",disable_search_threshold:-1,allow_single_deselect: true});
        if(jQuery("#companyId_chosen input").length || jQuery("#companyId_chzn input").length){
            document.querySelector("#companyId_chosen input, #companyId_chzn input").placeholder = "<?php echo JText::_('LNG_COMPANY_SEARCH_HINT')  ?>";
        }
        let userId = 0;
        let isProfile = false;
        if (jbdUtils.getProperty("isProfile") == JBDConstants.IS_FRONT) {
            isProfile = true;
            userId = '<?php echo $user->id ?>';
        }

        let url = jbdUtils.getAjaxUrl('getCompaniesByStringAjax', 'companies', 'managecompanies');

        jQuery("#companyId").ajaxChosen({
                type: 'GET',
                url: url,
                data: {
                    isProfile:isProfile,
                    userId:userId
                },
                dataType: 'json',
                cache:false
            },
            function (data) {
                var results = [];
                jQuery.each(data, function (i, val) {
                    results.push({value: val.id, text: val.name});
                });
                return results;
            },
            {
                width: "95%",disable_search_threshold:-1,allow_single_deselect: true
            }
        );
    });

    function savePriceListCompanyInformation(task) {
        jQuery("#item-form").validationEngine('detach');
        if (jbdUtils.validateCmpForm(false, false, task)) {
            return false;
        }
        jQuery("#item-form").validationEngine('attach');
        jQuery("#task").val('managecompanypricelist.'+task);
        Joomla.submitform('managecompanypricelist.'+task, document.getElementById('item-form'));
    }

    function cancel() {
        jQuery("#task").val('managecompanypricelist.cancel');
        var form = document.adminForm;
        form.submit();
    }
</script>
