<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');

// Load the tooltip behavior.
JHtml::_('behavior.multiselect');

$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));
$canOrder	= true;
$saveOrder	= $listOrder == 'ct.ordering';

$type = $this->state->get('filter.type_id');
?>

<script type="text/javascript">
window.addEventListener('load', function() {
	Joomla.submitbutton = function(task)
	{
		if (task != 'bookmarks.delete' || confirm('<?php echo JText::_('COM_JBUSINESS_DIRECTORY_ITEMS_CONFIRM_DELETE', true);?>'))
		{
			Joomla.submitform(task);
		}
	}
})
</script>
<div id="jbd-container" class="jbd-container">
    <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=bookmarks');?>" method="post" name="adminForm" id="adminForm">
        <div id="j-main-container">
            <div id="filter-bar" class="btn-toolbar">
                <div class="filter-select pull-right fltrt btn-group">
                    <select name="filter_type_id" class="inputbox input-medium" onchange="this.form.submit()">
                        <?php echo JHtml::_('select.options', $this->types, 'value', 'text', $type);?>
                    </select>
                </div>
            </div>
        </div>
        <table class="table table-striped adminlist"  id="itemList">
    		<thead>
    				<tr>
    					<th width="1%" class="hidden-phone">
    						<input type="checkbox" name="checkall-toggle" value="" title="<?php echo JText::_('JGLOBAL_CHECK_ALL'); ?>" onclick="Joomla.checkAll(this)" />
    					</th>
    					<th>
    						<?php echo JHtml::_('grid.sort', 'LNG_ITEM', 'ct.name', $listDirn, $listOrder); ?>
    					</th>
    						<th>
    						<?php echo JHtml::_('grid.sort', 'LNG_USER', 'ct.userName', $listDirn, $listOrder); ?>
    					</th>
    						<th>
    						<?php echo JText::_("LNG_NOTE") ?>
    					</th>
    					<th width="5%" class="nowrap center hidden-phone">
    						<?php echo JText::_('JGRID_HEADING_ID'); ?>
    					</th>
    				</tr>
    			</thead>
    			<tfoot>
    				<tr>
    					<td colspan="15">
    						<?php echo $this->pagination->getListFooter(); ?>
    					</td>
    				</tr>
    			</tfoot>
    			<tbody>
    			<?php $count = count($this->items); ?>
    			<?php foreach ($this->items as $i => $item) :
    				$ordering  = ($listOrder == 'ct.ordering');
    				$canCreate = true;
    				$canEdit   = true;
    				$canChange = true;
    				?>
    				<tr class="jtable-body-row row<?php echo $i % 2; ?>">
    					<td class="center hidden-phone">
    						<?php echo JHtml::_('grid.id', $i, $item->id); ?>
    					</td>
    					<td>
    						<?php if ($canEdit) : ?>
    						<a href="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&task=bookmark.edit&id='.$item->id);?>">
    							<?php echo $this->escape($item->name); ?></a>
    						<?php else : ?>
    							<?php echo $this->escape($item->name); ?>
    						<?php endif; ?>
    					</td>
    					<td class="hidden-phone">
    						<?php echo $item->userName; ?>
    					</td>
    					<td class="hidden-phone">
    						<?php echo $item->note; ?>
    					</td>
    					<td class="center hidden-phone">
    						<?php echo (int) $item->id; ?>
    					</td>
    				</tr>
    			<?php endforeach; ?>
    			
    			</tbody>
    		</table>
    	 
    	 <input type="hidden" name="task" value="" /> 
    	 <input type="hidden" name="id" value="" />
    	 <input type="hidden" name="boxchecked" value="0" />
    	 <input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
    	 <input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
    	 <?php echo JHTML::_( 'form.token' ); ?> 
    </form>
</div>