<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');

// Include the component HTML helpers.
JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');

// Load the tooltip behavior.

$this->item->itemType = $this->item->item_type==BOOKMARK_TYPE_OFFER?JText::_('LNG_OFFER'):JText::_('LNG_COMPANY');
?>

<script type="text/javascript">
window.addEventListener('load', function() {
	Joomla.submitbutton = function(task)
	{
		Joomla.submitform(task, document.getElementById('item-form'));
	}
})
</script>
<div id="jbd-container" class="jbd-container jbd-edit-container">
    <form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=bookmark');?>" method="post" name="adminForm" id="item-form">
    
    	<fieldset class="adminform">
    		<legend><?php echo JText::_('LNG_BOOKMARK'); ?></legend>
    		
    		<TABLE class="admintable"  border=0>
    			<TR>
    				<TD width=10% nowrap class="key"><?php echo JText::_('LNG_ITEM_ID'); ?> :</TD>
    				<TD nowrap width=1% align=left>
    					<input 
    						type		= "text"
    						name		= "item_id"
    						id			= "company_id"
    						value		= '<?php echo $this->item->item_id?>'
    						size		= 32
    						maxlength	= 128
    						AUTOCOMPLETE=OFF
    					/>
    				</TD>
    				<TD>&nbsp;</TD>
    			</TR>
                <TR>
                    <TD width=10% nowrap class="key"><?php echo JText::_('LNG_ITEM_TYPE'); ?> :</TD>
                    <TD nowrap width=1% align=left>
                        <input
                                type		= "text"
                                name		= "itemType"
                                id			= "company_id"
                                value		= '<?php echo $this->item->itemType?>'
                                size		= 32
                                maxlength	= 128
                                disabled    = "true"
                                AUTOCOMPLETE=OFF
                        />
                    </TD>
                    <TD>&nbsp;</TD>
                </TR>
    			<TR>
    				<TD width=10% nowrap class="key"><?php echo JText::_('LNG_USER_ID'); ?> :</TD>
    				<TD nowrap width=1% align=left>
    					<input 
    						type		= "text"
    						name		= "user_id"
    						id			= "company_id"
    						value		= "<?php echo $this->item->user_id ?>" 
    						size		= 32
    						maxlength	= 128
    						AUTOCOMPLETE=OFF
    					/>
    				</TD>
    				<TD>&nbsp;</TD>
    			</TR>
    			<TR>
    				<TD width=10% nowrap class="key"><?php echo JText::_('LNG_NOTE'); ?> :</TD>
    				<TD nowrap width=1% align=left>
    					<textarea name="note" maxlength="255"><?php echo $this->item->note?></textarea>
    				</TD>
    				<TD>&nbsp;</TD>
    			</TR>
    			<tr>
    				<td class="key"><?php echo JText::_('LNG_ID'); ?></td>
    				<td><?php echo $this->item->id ?></td>
    				<TD>&nbsp;</TD>
    			</tr>	
    		</TABLE>
    	</fieldset>
    	
    	<input type="hidden" name="option" value="<?php echo JBusinessUtil::getComponentName()?>" />
    	<input type="hidden" name="task" value="" />
    	<input type="hidden" name="id" value="<?php echo $this->item->id ?>" />
    	<?php echo JHTML::_( 'form.token' ); ?> 
    </form>
</div>