<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

class TableVideos extends JTable {

	/**
	 * Constructor
	 *
	 * @param object Database connector object
	 */
	public function __construct(&$db) {
		parent::__construct('#__jbusinessdirectory_videos', 'id', $db);
	}

	public function setKey($k) {
		$this->_tbl_key = $k;
	}

	// /**
	//  * Get all videos
	//  *
	//  * @return void
	//  */
	// public function getVideos() {
	// 	$db = JFactory::getDBO();
		
	// 	$query = "select v.*, cp.name as category_name 
	// 			  from #__jbusinessdirectory_videos v
	// 			  left join #__jbusinessdirectory_video_category cvc on cvc.category_id=v.main_subcategory and cvc.video_id=v.id
	// 			  left join  #__jbusinessdirectory_categories cp on cp.id=cvc.category_id";
				 

	// 	$db->setQuery($query);
	// 	return $db->loadObjectList();
	// }

	/**
	 * Get total videos
	 *
	 * @param [type] $searchDetails
	 * @return void
	 */
	public function getTotalVideosByCategories($searchDetails) {
		$startTime = microtime(true); // Gets
		$db = JFactory::getDBO();

		$query = $this->getVideosByCategoriesSql($searchDetails);

		$db->setQuery($query);
		$db->execute();
		$result = $db->getNumRows();
		$endTime = microtime(true) - $startTime; // And this at the end of your code

		//echo PHP_EOL . 'Total by cat script took ' . round($endTime, 4) . ' seconds to run. <br/>';

		return $result;
	}

	/**
	 * Get videos results based on searched params
	 *
	 * @param [type] $searchDetails
	 * @param integer $limitstart
	 * @param integer $limit
	 * @return void
	 */
	public function getVideosByCategories($searchDetails, $limitstart = 0, $limit = 0) {
		$startTime = microtime(true); // Gets
		$db =JFactory::getDBO();

		$query = $this->getVideosByCategoriesSql($searchDetails);

		//echo($query);
		$db->setQuery($query, $limitstart, $limit);
		$result = $db->loadObjectList();
		$endTime = microtime(true) - $startTime; // And this at the end of your code

		//echo PHP_EOL . 'Search script took ' . round($endTime, 4) . ' seconds to run. <br/>';
		return $result;
	}

	/**
	 * Generate the video search SQL
	 *
	 * @param [type] $searchDetails
	 * @param boolean $totalCategories
	 * @return void
	 */
	public function getVideosByCategoriesSql($searchDetails, $totalCategories = false) {
		$db =JFactory::getDBO();
		$appSettings = JBusinessUtil::getApplicationSettings();

		foreach ($searchDetails as &$searchDetail) {
			if (!empty($searchDetail) && !is_array($searchDetail)) {
				$searchDetail = stripslashes($searchDetail);
				$searchDetail = $db->escape($searchDetail);
			}
		}

		$keyword = isset($searchDetails['keyword'])?$searchDetails['keyword']:null;
		$categoriesIDs = isset($searchDetails["categoriesIds"])?$searchDetails["categoriesIds"]:null;
		$facetedSearch = isset($searchDetails["facetedSearch"])?$searchDetails["facetedSearch"]:null;
		$excludedIDs = isset($searchDetails["excludedIDs"])?$searchDetails["excludedIDs"]:null;
		$orderBy = isset($searchDetails["orderBy"])?$searchDetails["orderBy"]:null;
		$categoryName = isset($searchDetails["categoryName"])?$searchDetails["categoryName"]:null;
		$customAttributes = isset($searchDetails["customAttributes"])?$searchDetails["customAttributes"]:null;

		$whereCatCond = '';
		if (!empty($categoriesIDs) && count($categoriesIDs)>0) {
			$whereCatCond .= " and cc.category_id in (";
			$categoryIds = implode(", ", $categoriesIDs);
			$whereCatCond .= $categoryIds;
			$whereCatCond .= ")";
		}

		if ($facetedSearch == 1) {
			if (!empty($categoriesIDs)) {
				//dump($categoriesIDs);
				foreach ($categoriesIDs as $categoryId) {
					$values = explode(",", $categoryId);
					$whereCatCond .= ' or (0  ';
					foreach ($values as $value) {
						$whereCatCond .= " or cg.id REGEXP '[[:<:]]".$value."[[:>:]]' ";
					}
					$whereCatCond .= ' ) ';
				}
			}
		}

		$catNameFilter = "";
		if(isset($categoryName)){
			$catNameFilter = " and cg.name like '%$categoryName%'";
		}

		$whereNameCond='';
		if (!empty($keyword)) {
			$keywords = explode(" ", $keyword);
			$fields= array("vd.name","vd.description");

			$sqlFilter="";
			foreach ($fields as $field) {
				if ($field=="vd.name") {
					continue;
				}
				$sqlFilter .= "("."$field LIKE '%".implode("%' and $field LIKE '%", $keywords) . "%') OR ";
			}

			$whereNameCond=" and ($sqlFilter  vd.name like '%$keyword%') ";
		}

		if (empty($asc_desc)) {
			$asc_desc = "";
		}

		$excludedFilter = "";
		if(!empty($excludedIDs)){
			$ids = implode(",",$excludedIDs);
			$excludedFilter = "and vd.id not in ($ids)";
		}
		$customAttrFilter="";
		$customAttrIdFilter="";
		if (!empty($customAttributes)) {
			$customAttrFilterS="";
			$index=0;
			foreach ($customAttributes as $key => $value) {
				$index++;
				$values = explode(",", $value);
				$filter = "";
				$j=0;
				foreach ($values as $value2) {
					$value2 = $db->escape($value2);
					if (is_numeric($value2)) {
						if ($j>0) {
							$filter .=" and ";
						}
						$filter.=" (ca.value like '%$value2%' or ca.option_id = $value2) ";
					} else {
						if ($j>0) {
							$filter .=" and ";
						}
						$filter.=" (ca.value like '%$value2%')";
					}
					$j++;
				}
				if ($index>1) {
					$customAttrFilterS .=" or ";
				}
		
				if (!empty($filter)) {
					$customAttrFilterS .=" (ca.attribute_id = $key  and $filter )";
				}
			}
			$customAttrIds = array_keys($customAttributes);
			sort($customAttrIds);
			if (!empty($customAttrFilterS)) {
				$customAttrIdFilter = " and attributeSelection ='".implode(",", $customAttrIds)."'";
				$customAttrFilter=" and ($customAttrFilterS) ";
			}
		}
		
		if ($orderBy=="rand()" || empty($orderBy)) {
			$orderBy = "vd.created";
			$asc_desc = "desc";
		}

		$having = " having 1 ";
		if (!empty($customAttrIdFilter)) {
			$having .= " $customAttrIdFilter";
		}

		$query = " 
			select vd.*, bcm.name as mainSubcategoryName, bcm.color as cat_color"
			.(!empty($customAttrFilter)?", GROUP_CONCAT(DISTINCT a.id ORDER BY a.id) as attributeSelection ":"")." "
			.(!empty($whereCatCond)?", GROUP_CONCAT( DISTINCT cg.id,'|',cg.name,'|',cg.alias,'|',cg.icon,'|',cg.color  ORDER BY cg.name separator '#|') as categories":"")."
			from #__jbusinessdirectory_videos as vd "
			.(!empty($whereCatCond) || !empty($catNameFilter)?"
			left join #__jbusinessdirectory_video_category cc on vd.id=cc.video_id
			left join #__jbusinessdirectory_categories cg on cg.id=cc.category_id and cg.published=1":"")." 
			left join #__jbusinessdirectory_categories bcm on bcm.id=vd.main_subcategory and bcm.published=1
			".(!empty($customAttrFilter)?"
			left join #__jbusinessdirectory_video_attributes AS ca on ca.video_id=vd.id
			left join #__jbusinessdirectory_attributes a on ca.attribute_id = a.id
			left join #__jbusinessdirectory_attribute_options as ao on ao.attribute_id = a.id ":"")."
			where 1 $whereNameCond $whereCatCond $excludedFilter $catNameFilter $customAttrFilter
			group by vd.id
			$having
			order by $orderBy $asc_desc
		";

		//dump($query);

		return $query;
	}

	/**
	 * Get video based on the id
	 *
	 * @param [type] $videoId
	 * @return void
	 */
	public function getVideo($videoId) {
		$videoId = (int) $videoId;
		$db = JFactory::getDBO();

		$query = "select vd.*,
					GROUP_CONCAT( DISTINCT cg.id,'|',cg.name,'|',cg.alias,'|',cg.icon,'|',cg.color  ORDER BY cg.name separator '#|') as categories
					from #__jbusinessdirectory_videos as vd
					left join #__jbusinessdirectory_video_category cc on vd.id=cc.video_id
					left join #__jbusinessdirectory_categories cg on cg.id=cc.category_id and cg.published=1 
					where vd.id='$videoId'";

		$db->setQuery($query);
		return $db->loadObject();
	}

	/**
	 * Check video alias
	 *
	 * @param [type] $id
	 * @param [type] $alias
	 * @return void
	 */
	public function checkAlias($id, $alias) {
		$db =JFactory::getDBO();
		$query = "SELECT count(*) as nr FROM #__jbusinessdirectory_videos  WHERE alias='$alias' and id<>$id";
		$db->setQuery($query);
		$result = $db->loadObject();
		return $result->nr;
	}

}
