<?php
/*------------------------------------------------------------------------
 # JBusinessDirectory
# author CMSJunkie
# copyright Copyright (C) 2012 cmsjunkie.com. All Rights Reserved.
# @license - http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
# Websites: http://www.cmsjunkie.com
# Technical Support:  Forum - http://www.cmsjunkie.com/forum/j-businessdirectory/?p=1
-------------------------------------------------------------------------*/

defined('_JEXEC') or die('Restricted access');

jimport('joomla.plugin.plugin');

if(php_sapi_name() === 'cli' ){
	return;
}

if (file_exists(JPATH_SITE.'/components/com_jbusinessdirectory/helpers/defines.php')) {
	require_once JPATH_SITE.'/components/com_jbusinessdirectory/helpers/defines.php';
} else {
	return;
}

if (defined('HELPERS_PATH') && file_exists(HELPERS_PATH.'/utils.php')) {
	require_once HELPERS_PATH.'/utils.php';
}

require_once 'jbdrouter.php';

/**
 * Joomla! System Remember Me Plugin
 *
 * @package		Joomla.Plugin
 * @subpackage	System.remember
 */
class plgSystemUrlTranslator extends JPlugin {

	/**
	 * Jooma hook
	 *
	 * @return void
	 */
	public function onAfterInitialise(){
		// get joomla application object
		$app = JFactory::getApplication();
		
		if ($app->isClient('administrator')) {
			return;
		}

		if(php_sapi_name() === 'cli' ){
			return;
		}

		// attach parse and build rules to Joomla router
		if(!JBusinessUtil::isJoomla3()){
			$joomlaRouter     = $app->getRouter();
			$router = new JBDRouter($this->params);
			$joomlaRouter->attachParseRule(array($router, 'parseRule'));
			//$joomlaRouter->attachBuildRule(array($router, 'buildRule'));
		}

		// pretend SEF is on, mostly for Joomla SEF plugin to work
		// as it checks directly 'sef' value in config, instead of
		// using $router->getMode()
		//JFactory::$config->set('sef', 1);
		//exit;
	}

	public function onAfterRoute() {
		$app = JFactory::getApplication();

		// No remember me for admin
		if ($app->isClient('administrator')) {
			return;
		}

		if(php_sapi_name() === 'cli' ){
			return;
		}
		
		$jbdRouter = new JBDRouter($this->params);
		$params = $jbdRouter->getRouteParams();

		if (!empty($params)) {
			$jinput = JFactory::getApplication()->input;
			foreach ($params as $key => $param) {
				$jinput->set($key, $param);
			}
		}

		return;
	}

	
}
