<?php
/**
* @package     Joomla.Site
* @subpackage  mod_articles_latest
*
* @copyright   Copyright (C) 2007 - 2015 CMS Junkie. All rights reserved.
* @license     GNU General Public License version 2 or later;
*/

defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Factory;

require_once JPATH_SITE.'/components/com_jbusinessdirectory/helpers/defines.php';
require_once HELPERS_PATH.'/utils.php';

JBusinessUtil::includeCSSLibraries();

JBusinessUtil::enqueueStyle('css/common.css');
JBusinessUtil::enqueueStyle('css/line-awesome.css');

$appSettings = JBusinessUtil::getApplicationSettings();

JHtml::_('stylesheet', 'modules/mod_jbusiness_events/assets/style.css');
JHtml::_('script', 'modules/mod_jbusiness_events/assets/js/script.js');

JHtml::_('jquery.framework', true, true);

if ($params->get('viewtype') == 'slider') {
	JBusinessUtil::enqueueStyle('libraries/slick/slick.css');
	JBusinessUtil::enqueueScript('libraries/slick/slick.js');
}

if ($appSettings->enable_ratings) {
	JBusinessUtil::enqueueStyle('libraries/star-rating/star-rating.css');
	JBusinessUtil::enqueueScript('libraries/star-rating/star-rating.js');
}

JBusinessUtil::loadBaseScripts();

require_once HELPERS_PATH.'/translations.php';

// Include the syndicate functions only once
require_once __DIR__ . '/helper.php';

JBusinessUtil::loadSiteLanguage();
JBusinessUtil::includeCSSLibraries();

//load items through cache mechanism
$cache = Factory::getCache('mod_jbusiness_events', '');
if ($cache->contains($module->id)) {
	$items = $cache->get($module->id);
} else {
	$items = modJBusinessEventsHelper::getList($params);
	$cache->store($items, $module->id, 'mod_jbusiness_events');
}
$showLocation = $params->get('showLocation');
$showListingName = $params->get('showlistingName');

$newTab = ($appSettings->open_listing_on_new_tab)?" target='_blank'":"";
if ($appSettings->enable_multilingual) {
	JBusinessDirectoryTranslations::updateEventsTranslation($items);
}

$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));

$backgroundCss="";
if ($params->get('backgroundColor')) {
	$backgroundCss = "background-color:".$params->get('backgroundColor').";";
}

$borderCss="";
if ($params->get('borderColor')) {
	$borderCss="border-color:".$params->get('borderColor').";";
}
$menuItemId = JBusinessUtil::getApplicationSettings()->menu_item_id;

$categoryParam = "";
$categoriesIds = $params->get('categoryIds');
if (isset($categoriesIds) && count($categoriesIds)>0 && $categoriesIds[0]!= 0 && $categoriesIds[0]!= "") {
	$categoryParam="&categorySearch=".$categoriesIds[0];
}

$menuItemId ="";
if ($params->get('mItemId')) {
	$menuItemId="&Itemid=".$params->get('mItemId');
}
$viewAllLink = JRoute::_('index.php?option=com_jbusinessdirectory&view=events&resetSearch=1'.$menuItemId.$categoryParam);

$span = $params->get('layout-type')=="vertical"?"col-12":$params->get('phoneGridOption', 'col-12').' '.$params->get('tabletGridOption', 'col-md-6').' '.$params->get('desktopGridOption', "col-lg-4");

require JModuleHelper::getLayoutPath('mod_jbusiness_events', "default_".$params->get('viewtype'));
