<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.controllerform');

/**
 * The Offer Controller
 *
 */
class JBusinessDirectoryControllerOffer extends JControllerForm {
	/**
	 * Dummy method to redirect back to standard controller
	 *
	 */
	public function display($cachable = false, $urlparams = false) {
		$this->setRedirect(JRoute::_('index.php?option=com_jbusinessdirectory&view=offers', false));
	}

	public function add() {
		$app = JFactory::getApplication();
		$context = 'com_jbusinessdirectory.edit.offer';
	
		$result = parent::add();
		if ($result) {
			if (!($type = $app->getUserState('com_jbusinessdirectory.offers.filter.type'))) {
				$type = JFactory::getApplication()->input->getInt('type', OFFER_TYPE_OFFER);
			}
			$this->setRedirect(JRoute::_('index.php?option=com_jbusinessdirectory&filter_type='.$type. '&view=offer'. $this->getRedirectToItemAppend(), false));
		}
	
		return $result;
	}
	
	
	/**
	 * Method to cancel an edit.
	 *
	 * @param   string  $key  The name of the primary key of the URL variable.
	 *
	 * @return  boolean  True if access level checks pass, false otherwise.
	 */
	public function cancel($key = null) {
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
	
		$app = JFactory::getApplication();
		$context = 'com_jbusinessdirectory.edit.offer';
		//$result = parent::cancel();

		if (!($type = $app->getUserState('com_jbusinessdirectory.offers.filter.type'))) {
			$type = JFactory::getApplication()->input->getInt('type', OFFER_TYPE_OFFER);
		}

		$app->setUserState('com_jbusinessdirectory.edit.offer.data', null);

		// Redirect to the list screen.
		$this->setRedirect(JRoute::_('index.php?option=' . $this->option .'&filter_type='.$type. '&view=' . $this->view_list . $this->getRedirectToListAppend(), false));
	}
	
	/**
	 * Method to edit an existing record.
	 *
	 * @param   string  $key     The name of the primary key of the URL variable.
	 * @param   string  $urlVar  The name of the URL variable if different from the primary key
	 * (sometimes required to avoid router collisions).
	 *
	 * @return  boolean  True if access level check and checkout passes, false otherwise.
	 *
	 */
	public function edit($key = null, $urlVar = null) {
		$app = JFactory::getApplication();
		$result = parent::edit();
	
		return true;
	}
	
	/**
	 * save a record (and redirect to main page)
	 * @return void
	 */
	public function save($key = null, $urlVar = null) {
		// Check for request forgeries.
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));
		$app      = JFactory::getApplication();
		$model = $this->getModel('offer');
		$data = JFactory::getApplication()->input->getArray();

		$data['description'] = JFactory::getApplication()->input->get('description', '', 'RAW');
		
		$context  = 'com_jbusinessdirectory.edit.offer';
		$task     = $this->getTask();
		$recordId = JFactory::getApplication()->input->getInt('id');

		if ($task == 'save2copy') {
			$data['id'] = '';
		}

		$data["pictures"] = $this->preparePictures($data);
		
		if (isset($data['url']) && strlen($data['url'])>1) {
			if (!preg_match("~^(?:f|ht)tps?://~i", $data['url'])) {
				$data['url'] = "http://" . $data['url'];
			}

			$data['url'] = "http://" . $data['url'];
		}
		
		if (!$model->save($data)) {
			// Save the data in the session.
			$app->setUserState('com_jbusinessdirectory.edit.offer.data', $data);
			
			// Redirect back to the edit screen.
			$this->setMessage(JText::sprintf('JLIB_APPLICATION_ERROR_SAVE_FAILED', $model->getError()), 'Error');
			$this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&filter_type='.$data['item_type']. '&view=' . $this->view_item . $this->getRedirectToItemAppend($recordId), false));
			
			return false;
		} elseif (!empty($model->getErrors())) {
			$implodeErrors = implode('<br />', $model->getErrors());
			$this->setMessage(JText::sprintf('COM_JBUSINESSDIRECTORY_SAVED_WARNING', $implodeErrors), 'Warning');
		} else {
			$this->setMessage(JText::_('COM_JBUSINESSDIRECTORY_OFFER_SAVE_SUCCESS'));
		}
		
		// Redirect the user and adjust session state based on the chosen task.
		switch ($task) {
			case 'apply':
				// Set the row data in the session.
				$recordId = $model->getState($this->context . '.id');
				$this->holdEditId($context, $recordId);
				$app->setUserState('com_jbusinessdirectory.edit.offer.data', null);
			
				// Redirect back to the edit screen.
				$this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&filter_type='.$data['item_type']. '&view=' . $this->view_item . $this->getRedirectToItemAppend($recordId), false));
				break;

			default:
				// Clear the row id and data in the session.
				$this->releaseEditId($context, $recordId);
				$app->setUserState('com_jbusinessdirectory.edit.offer.data', null);
							
				// Redirect to the list screen.
				$this->setRedirect(JRoute::_('index.php?option=' . $this->option . '&filter_type='.$data['item_type']. '&view=' . $this->view_list . $this->getRedirectToListAppend(), false));
				break;
		}
	}
	
	
	public function preparePictures($data) {
		//save images
		$pictures					= array();
		foreach ($data as $key => $value) {
			if (strpos($key, 'picture_title') !== false
				||
				strpos($key, 'picture_info') !== false
				||
				strpos($key, 'picture_path') !== false
				||
				strpos($key, 'picture_enable') !== false
			) {
				foreach ($value as $k => $v) {
					if (!isset($pictures[$k])) {
						$pictures[$k] = array('picture_title' => '', 'picture_info'=>'', 'picture_path'=>'','picture_enable'=>1);
					}
					$pictures[$k][$key] = $v;
				}
			}
		}
	
		return $pictures;
	}

	public function aprove() {
		$model = $this->getModel('Offer');
		$error = !$model->changeAprovalState(1);

		$cid  = $this->input->get('cid', array(), 'array');
		$ajax = $this->input->get('ajax');
		if (!empty($ajax)) {
			$response          = array();
			$response["cid"]   = $cid[0];
			$response["error"] = $error;

			echo json_encode($response);

			exit;
		}

		$this->setRedirect(JRoute::_('index.php?option=com_jbusinessdirectory&view=offers', false));
	}

	public function disaprove() {
		$model = $this->getModel('Offer');
		$error = !$model->changeAprovalState(-1);

		$cid  = $this->input->get('cid', array(), 'array');
		$ajax = $this->input->get('ajax');
		if (!empty($ajax)) {
			$response          = array();
			$response["cid"]   = $cid[0];
			$response["error"] = $error;

			echo json_encode($response);

			exit;
		}

		$this->setRedirect(JRoute::_('index.php?option=com_jbusinessdirectory&view=offers', false));
	}
	
	public function chageState() {
		$model = $this->getModel('Offer');
	
		if ($model->changeState()) {
			$msg = JText::_('');
		} else {
			$msg = JText::_('LNG_ERROR_CHANGE_STATE');
		}
	
	
		$this->setRedirect(JRoute::_('index.php?option=com_jbusinessdirectory&view=offers', $msg));
	}
	
	
	public function changeStateOfferOfTheDay() {
		$model = $this->getModel('Offer');
	
		if ($model->changeStateOfferOfTheDay()) {
			$msg = JText::_('');
		} else {
			$msg = JText::_('LNG_ERROR_CHANGE_STATE');
		}
	
		$this->setRedirect(JRoute::_('index.php?option=com_jbusinessdirectory&view=offers', $msg));
	}
	
	public function changeStateFeatured() {
		$cid  = $this->input->post->get('cid', array(), 'array');
		
		if (!empty($cid)) {
			$model = $this->getModel('Offer');
			if ($model->changeStateFeatured($cid[0])) {
				$msg = JText::_('');
			} else {
				$msg = JText::_('LNG_ERROR_CHANGE_STATE');
			}
		}
		
		$this->setRedirect(JRoute::_('index.php?option=com_jbusinessdirectory&view=offers', $msg));
	}

	/**
	 * Method to run batch operations.
	 *
	 * @param   object  $model  The model.
	 *
	 * @return  boolean   True if successful, false otherwise and internal error is set.
	 *
	 * @since   1.6
	 */
	public function batch($model = null) {
		JSession::checkToken() or jexit(JText::_('JINVALID_TOKEN'));

		// Set the model
		$model = $this->getModel('Offer', '', array());

		$vars = $this->input->post->get('batch', array(), 'array');
		$cid  = $this->input->post->get('cid', array(), 'array');

		// Attempt to run the batch operation.
		if ($model->batch($vars, $cid, null)) {
			$this->setMessage(JText::_('JLIB_APPLICATION_SUCCESS_BATCH'));
		} else {
			$this->setMessage(JText::sprintf('JLIB_APPLICATION_ERROR_BATCH_FAILED', $model->getError()), 'warning');
		}

		// Preset the redirect
		$this->setRedirect(JRoute::_('index.php?option=com_jbusinessdirectory&view=offers' . $this->getRedirectToListAppend(), false));

		return parent::batch($model);
	}

	/**
	 * Method to retrieve attributes by ajax
	 */
	public function getAttributesAjax() {
		$categoryId = JFactory::getApplication()->input->get('categoryId');
		$offerId = JFactory::getApplication()->input->get('offerId');

		$model = $this->getModel('Offer');
		$result = $model->getAttributesAjax($categoryId, $offerId);

		/* Send as JSON */
		header("Content-Type: application/json", true);
		echo json_encode($result);
		exit;
	}

	/**
	 * Method that retrieves the selling options by ajax
	 *
	 * @throws Exception
	 * @since version
	 */
	public function getSellingOptionsAjax(){
		$categoryId = JFactory::getApplication()->input->get('categoryId');
		$offerId = JFactory::getApplication()->input->get('offerId');

		$model = $this->getModel('Offer');
		$result = $model->getSellingOptionsAjax($offerId, $categoryId);

		/* Send as JSON */
		header("Content-Type: application/json", true);
		echo json_encode($result);
		exit;
	}

	/**
	 * Method to retrieve listing by ajax
	 */
	public function getListingAddressAjax() {
		$companyId = JFactory::getApplication()->input->get('companyId');

		$model  = $this->getModel('Offer');
		$result = $model->getListing($companyId);

		/* Send as JSON */
		header("Content-Type: application/json", true);
		echo json_encode($result);
		exit;
	}

	/**
	 * Method to retrieve cities by region (ajax)
	 */
	public function getCitiesByRegionsAjax() {
		$regionName = JFactory::getApplication()->input->get('regionName', '', 'RAW');

		$model  = $this->getModel('Offer');
		$result = $model->getCities($regionName);

		/* Send as JSON */
		header("Content-Type: application/json", true);
		echo json_encode($result);
		exit;
	}

	/**
	 * Method to retrieve counties by country (ajax)
	 */
	public function getRegionsByCountryAjax() {
		$countryId = (int) JFactory::getApplication()->input->get('countryId');

		$model  = $this->getModel('Offer');
		$result = $model->getRegions($countryId);

		/* Send as JSON */
		header("Content-Type: application/json", true);
		echo json_encode($result);
		exit;
	}
}
