<?php
declare(strict_types=1);
/**
 * @package       hoolawhoops
 * @author        Alexandre ELISÉ <developpeur@application2000.com>
 * @link          https://www.application2000.com
 * @copyright (c) 2019 . Alexandre ELISÉ . Tous droits réservés.
 * @license       GPL-2.0+
 */

use Joomla\CMS\Plugin\CMSPlugin;
use Whoops\Handler\PrettyPageHandler;
use Whoops\Run;

defined('_JEXEC') or die;

/**
 * @package     ${NAMESPACE}
 *
 * @since       version
 */
class PlgSystemHoolawhoops extends CMSPlugin
{
	protected $app;
	protected $db;

	/**
	 * Constructor.
	 *
	 * @param   object &$subject  The object to observe.
	 * @param   array   $config   An optional associative array of configuration settings.
	 *
	 * @since 1.5
	 */
	public function __construct(&$subject, $config)
	{
		parent::__construct($subject, $config);

		// if we enable pretty debug in plugin params
		if ($this->params->get('pretty_debug', 0) === 1)
		{

			JLoader::registerNamespace('Whoops\\', __DIR__ . '/vendor/filp/whoops/src/Whoops', false, false, 'psr4');

			$whoops = new Run;
			$whoops->pushHandler(new PrettyPageHandler);
			$whoops->register();
		}
	}
}
