<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');
 
// Include the syndicate functions only once
require_once JPATH_SITE.'/components/com_jbusinessdirectory/helpers/defines.php';
require_once HELPERS_PATH.'/utils.php';
require_once HELPERS_PATH.'/translations.php';

require_once BD_CLASSES_PATH .'/services/QuoteService.php';

require_once(dirname(__FILE__).'/helper.php');

JHtml::_('jquery.framework', true, true);

JHtml::_('stylesheet', 'modules/mod_jbusinesscategories/assets/style.css');
JHtml::_('script', 'modules/mod_jbusinesscategories/assets/js/script.js');

JBusinessUtil::loadBaseScripts();

$appSettings = JBusinessUtil::getApplicationSettings();

if (strpos($params->get('viewtype'), 'slider')!==false) {
	JBusinessUtil::enqueueStyle('libraries/slick/slick.css');
	JBusinessUtil::enqueueScript('libraries/slick/slick.js');
} else {
	JBusinessUtil::enqueueStyle('libraries/metis-menu/metisMenu.css');
	JBusinessUtil::enqueueScript('libraries/metis-menu/metisMenu.js');
}

$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));
JBusinessUtil::includeCSSLibraries();
JBusinessUtil::loadSiteLanguage();
JBusinessUtil::includeValidation();

$helper = new modJBusinessCategoriesHelper();

$categoriesIds = $params->get('categoryIds');

if (!JBusinessUtil::isAppInstalled(JBD_APP_QUOTE_REQUESTS)) {
	$params->set('linkquoterequests', 0);
}

if (strpos($params->get('viewtype'), 'slider')!==false) {
	$categories = $helper->getCategoriesByIdsOnSlider($params, $categoriesIds);
} elseif ($params->get('viewtype') == 'menu') {
	$categories = $helper->getCategoriesByIdsOnMenu($categoriesIds);
} else {
	$categories = $helper->getCategories($params, $categoriesIds, true);
}

if ($appSettings->category_order == ORDER_ALPHABETICALLY && !empty($categories)) {
	require_once(HELPERS_PATH.'/category_lib.php');
	$categoryService = new JBusinessDirectorCategoryLib();
	$categories = $categoryService->sortCategoryView($categories);
}

if ($appSettings->enable_multilingual) {
	JBusinessDirectoryTranslations::updateCategoriesTranslation($categories);
}

$linkQuoteRequests = $params->get('linkquoterequests');
if ($linkQuoteRequests && JBusinessUtil::isAppInstalled(JBD_APP_QUOTE_REQUESTS)) {
	JBusinessUtil::enqueueStyle('libraries/modal/jquery.modal.css');
	JBusinessUtil::enqueueScript('libraries/modal/jquery.modal.js');

	echo QuoteService::initializeQuoteRequets();
}

$viewAllLink = JRoute::_('index.php?option=com_jbusinessdirectory&view=categories&categoryType='.CATEGORY_TYPE_BUSINESS);
$span = $params->get('phoneGridOption', 'col-12').' '.$params->get('tabletGridOption', 'col-md-6').' '.$params->get('desktopGridOption', "col-lg-4");

require JModuleHelper::getLayoutPath('mod_jbusinesscategories', "default_".$params->get('viewtype'));
