<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

require_once JPATH_SITE.'/components/com_jbusinessdirectory/helpers/defines.php';
require_once HELPERS_PATH.'/utils.php';
require_once HELPERS_PATH.'/translations.php';

// Include the syndicate functions only once
require_once(dirname(__FILE__).DS.'helper.php');

JHtml::_('jquery.framework', true, true);

JText::script('LNG_SELECT_OPTION');

JBusinessUtil::includeCSSLibraries();

JBusinessUtil::enqueueStyle('libraries/chosen/chosen.css');
JBusinessUtil::enqueueStyle('libraries/range-slider/ion.rangeSlider.css');
JBusinessUtil::enqueueStyle('libraries/range-slider/ion.rangeSlider.skinFlat.css');
JHtml::_('stylesheet', 'media/com_jbusinessdirectory/css/search-module.css');

JBusinessUtil::loadJQueryUI();

JBusinessUtil::loadBaseScripts();
JBusinessUtil::loadMapScripts();

JBusinessUtil::enqueueScript('libraries/range-slider/ion.rangeSlider.js');
JBusinessUtil::loadJQueryChosen();
JHtml::_('script', 'modules/mod_jbusiness_event_search/assets/js/script.js');

JBusinessUtil::enqueueStyle('libraries/jquery/jquery.timepicker.css');
JBusinessUtil::enqueueScript('libraries/jquery/jquery.timepicker.min.js');

JBusinessUtil::enqueueScript('libraries/moment/moment.min.js');
JBusinessUtil::enqueueStyle('libraries/date/daterangepicker.css');
JBusinessUtil::enqueueScript('libraries/date/daterangepicker.js');
$appSettings = JBusinessUtil::getApplicationSettings();
$key="";
if (!empty($appSettings->google_map_key)) {
	$key="&key=".$appSettings->google_map_key;
}
$lang = JBusinessUtil::getLanguageTag();

JBusinessUtil::loadSiteLanguage();
$session = JFactory::getSession();

$preserve = $params->get('preserve');

$geoLocation = $session->get("geolocation");
$startDate = $session->get('ev-startDate') && $preserve?$session->get('ev-startDate'):"";
$endDate = $session->get('ev-endDate') && $preserve?$session->get('ev-endDate'):"";

$jsSettings = JBusinessUtil::addJSSettings();
$jsSettings->isProfile = 1;

if (!defined('JBD_UTILS_LOADED')) {
	$document = JFactory::getDocument();
	$document->addScriptDeclaration('
		window.addEventListener("load",function() {
	        jbdUtils.setProperties(' . json_encode($jsSettings) . ');
		});		
	');
	define('JBD_UTILS_LOADED', 1);
}


if ($params->get('showCountries')) {
	$countries = modJBusinessEventSearchHelper::getCountries();
	if ($appSettings->enable_multilingual) {
		JBusinessDirectoryTranslations::updateCountriesTranslation($countries);
	}
}

if ($params->get('showTypes')) {
	$types =  modJBusinessEventSearchHelper::getTypes();
}

if ($params->get('showProvince')) {
	$provinces = modJBusinessEventSearchHelper::getProvinces();
}

$choices = 0;
if ($params->get('linklocation')) {
	if ($params->get('showCountries') && !$params->get('showRegions')) {
		$choices = 1;
	} elseif ($params->get('showCountries')) {
		$choices = 2;
	} elseif ($params->get('showRegions')) {
		$choices = 3;
	}
}

$categories = array();
$subCategories = array();
$separateCategories  = $params->get('separateCategories');
$availableCategories = $params->get('availableCategories');
if (is_array($availableCategories) && !($availableCategories[0]==0 && count($availableCategories)==1)) {
	$categories = modJBusinessEventSearchHelper::getMainCategories();
	$subCategories = modJBusinessEventSearchHelper::getSubCategories();

	if ($appSettings->enable_multilingual) {
		JBusinessDirectoryTranslations::updateCategoriesTranslation($categories);
		JBusinessDirectoryTranslations::updateCategoriesTranslation($subCategories);
	}

	$availableCategories = array_filter($availableCategories);
	if (!empty($availableCategories)) {
		foreach ($categories as $key => $category) {
			if (!in_array($category->id, $availableCategories)) {
				unset($categories[$key]);
			}
		}
		foreach ($subCategories as $key => $category) {
			if (!in_array($category->id, $availableCategories)) {
				unset($subCategories[$key]);
			}
		}
	}
	foreach ($categories as $category) {
		foreach ($subCategories as $key => $subCat) {
			if ($category->id == $subCat->parent_id) {
				if (!isset($category->subcategories)) {
					$category->subcategories = array();
				}
				$category->subcategories[] = $subCat;
				unset($subCategories[$key]);
			}
		}
	}
	$params->set('separateCategories', 0);
	$separateCategories = 0;
} elseif ($params->get('showCategories')) {
	$categories = modJBusinessEventSearchHelper::getMainCategories();
	$subCategories = modJBusinessEventSearchHelper::getSubCategories();

	if ($appSettings->enable_multilingual) {
		JBusinessDirectoryTranslations::updateCategoriesTranslation($categories);
		JBusinessDirectoryTranslations::updateCategoriesTranslation($subCategories);
	}

	if ($params->get('showSubCategories') && !$separateCategories) {
		foreach ($categories as $category) {
			foreach ($subCategories as $key => $subCat) {
				if ($category->id == $subCat->parent_id) {
					if (!isset($category->subcategories)) {
						$category->subcategories = array();
					}
					$category->subcategories[] = $subCat;
				}
			}
		}
	}
}

if ($appSettings->category_order == ORDER_ALPHABETICALLY && count($categories)>0) {
	require_once HELPERS_PATH.'/category_lib.php';
	$categoryService = new JBusinessDirectorCategoryLib();
	$categories = $categoryService->sortCategories($categories, false, true);
}

if (is_array($availableCategories)) {
	reset($availableCategories);
	if (!(current($availableCategories)==0 && count($availableCategories)==1)) {
		foreach ($subCategories as $key => $subCat) {
			end($categories)->subcategories[] = $subCat;
		}
	}
}

$appSettings = JBusinessUtil::getApplicationSettings();
if ($params->get('showCities')) {
	if ($appSettings->limit_cities_regions ==1) {
		$cities =  modJBusinessEventSearchHelper::getActivityCities();
	} else {
		$cities =  modJBusinessEventSearchHelper::getCities();
	}
}

$maxRadius = $params->get("max-radius");
if (empty($maxRadius)) {
	$maxRadius = 500;
}

if ($params->get('showMap')) {
	$maxEvents = $params->get('maxEvents');
	if (empty($maxEvents)) {
		$maxEvents = 200;
	}
	$events =  modJBusinessEventSearchHelper::getEvents($maxEvents);
}

if ($appSettings->enable_multilingual) {
	JBusinessDirectoryTranslations::updateEventTypesTranslation($types);
}

if ($params->get('showRegions')) {
	if ($appSettings->limit_cities_regions == 1) {
		$regions = modJBusinessEventSearchHelper::getActivityRegions();
	} else {
		$regions = modJBusinessEventSearchHelper::getRegions();
	}
}

$attributes = $params->get('customAttributes');
$atrributesValues = $session->get('customAtrributes');
if (!$params->get('preserve')) {
	$atrributesValues = array();
}

if (!empty($attributes)) {
	$customAttributes = modJBusinessEventSearchHelper::getCustomAttributes($attributes, $atrributesValues);
}

$menuItemId ="";
if ($params->get('mItemId')) {
	$menuItemId="&Itemid=".$params->get('mItemId');
}

$layoutType = $params->get('layout-type', 'horizontal');
$moduleclass_sfx = htmlspecialchars($params->get('moduleclass_sfx'));

$radius = JFactory::getApplication()->input->getInt("radius");
if (!isset($radius)) {
	$radius = $params->get('radius');
}

$bgStyle = !empty($params->get('bg-color'))?"padding: 20px;background-color:".$params->get('bg-color'):"";
	
require(JModuleHelper::getLayoutPath('mod_jbusiness_event_search', $params->get('base-layout', 'default')));
