
--
-- Table structure for table `#__action_logs`
--

DROP TABLE IF EXISTS `#__action_logs`;
CREATE TABLE IF NOT EXISTS `#__action_logs` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `message_language_key` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date` datetime NOT NULL,
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_id` int(11) NOT NULL DEFAULT '0',
  `item_id` int(11) NOT NULL DEFAULT '0',
  `ip_address` varchar(40) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.0.0.0',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_user_id_logdate` (`user_id`,`log_date`),
  KEY `idx_user_id_extension` (`user_id`,`extension`),
  KEY `idx_extension_item_id` (`extension`,`item_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__action_logs_extensions`
--

DROP TABLE IF EXISTS `#__action_logs_extensions`;
CREATE TABLE IF NOT EXISTS `#__action_logs_extensions` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `extension` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__action_logs_extensions`
--

INSERT INTO `#__action_logs_extensions` (`id`, `extension`) VALUES
(1, 'com_banners'),
(2, 'com_cache'),
(3, 'com_categories'),
(4, 'com_config'),
(5, 'com_contact'),
(6, 'com_content'),
(7, 'com_installer'),
(8, 'com_media'),
(9, 'com_menus'),
(10, 'com_messages'),
(11, 'com_modules'),
(12, 'com_newsfeeds'),
(13, 'com_plugins'),
(14, 'com_redirect'),
(15, 'com_tags'),
(16, 'com_templates'),
(17, 'com_users'),
(18, 'com_checkin'),
(19, 'com_scheduler');

-- --------------------------------------------------------

--
-- Table structure for table `#__action_logs_users`
--

DROP TABLE IF EXISTS `#__action_logs_users`;
CREATE TABLE IF NOT EXISTS `#__action_logs_users` (
  `user_id` int(11) UNSIGNED NOT NULL,
  `notify` tinyint(1) UNSIGNED NOT NULL,
  `extensions` text COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`user_id`),
  KEY `idx_notify` (`notify`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__action_log_config`
--

DROP TABLE IF EXISTS `#__action_log_config`;
CREATE TABLE IF NOT EXISTS `#__action_log_config` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `id_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title_holder` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `text_prefix` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=21 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__action_log_config`
--

INSERT INTO `#__action_log_config` (`id`, `type_title`, `type_alias`, `id_holder`, `title_holder`, `table_name`, `text_prefix`) VALUES
(1, 'article', 'com_content.article', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
(2, 'article', 'com_content.form', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
(3, 'banner', 'com_banners.banner', 'id', 'name', '#__banners', 'PLG_ACTIONLOG_JOOMLA'),
(4, 'user_note', 'com_users.note', 'id', 'subject', '#__user_notes', 'PLG_ACTIONLOG_JOOMLA'),
(5, 'media', 'com_media.file', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
(6, 'category', 'com_categories.category', 'id', 'title', '#__categories', 'PLG_ACTIONLOG_JOOMLA'),
(7, 'menu', 'com_menus.menu', 'id', 'title', '#__menu_types', 'PLG_ACTIONLOG_JOOMLA'),
(8, 'menu_item', 'com_menus.item', 'id', 'title', '#__menu', 'PLG_ACTIONLOG_JOOMLA'),
(9, 'newsfeed', 'com_newsfeeds.newsfeed', 'id', 'name', '#__newsfeeds', 'PLG_ACTIONLOG_JOOMLA'),
(10, 'link', 'com_redirect.link', 'id', 'old_url', '#__redirect_links', 'PLG_ACTIONLOG_JOOMLA'),
(11, 'tag', 'com_tags.tag', 'id', 'title', '#__tags', 'PLG_ACTIONLOG_JOOMLA'),
(12, 'style', 'com_templates.style', 'id', 'title', '#__template_styles', 'PLG_ACTIONLOG_JOOMLA'),
(13, 'plugin', 'com_plugins.plugin', 'extension_id', 'name', '#__extensions', 'PLG_ACTIONLOG_JOOMLA'),
(14, 'component_config', 'com_config.component', 'extension_id', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
(15, 'contact', 'com_contact.contact', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA'),
(16, 'module', 'com_modules.module', 'id', 'title', '#__modules', 'PLG_ACTIONLOG_JOOMLA'),
(17, 'access_level', 'com_users.level', 'id', 'title', '#__viewlevels', 'PLG_ACTIONLOG_JOOMLA'),
(18, 'banner_client', 'com_banners.client', 'id', 'name', '#__banner_clients', 'PLG_ACTIONLOG_JOOMLA'),
(19, 'application_config', 'com_config.application', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
(20, 'task', 'com_scheduler.task', 'id', 'title', '#__scheduler_tasks', 'PLG_ACTIONLOG_JOOMLA');

-- --------------------------------------------------------

--
-- Table structure for table `#__assets`
--

DROP TABLE IF EXISTS `#__assets`;
CREATE TABLE IF NOT EXISTS `#__assets` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int(11) NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int(10) UNSIGNED NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.\n',
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=MyISAM AUTO_INCREMENT=134 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__assets`
--

INSERT INTO `#__assets` (`id`, `parent_id`, `lft`, `rgt`, `level`, `name`, `title`, `rules`) VALUES
(1, 0, 0, 241, 0, 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
(2, 1, 1, 2, 1, 'com_admin', 'com_admin', '{}'),
(3, 1, 3, 6, 1, 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(4, 1, 7, 8, 1, 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(5, 1, 9, 10, 1, 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(6, 1, 11, 12, 1, 'com_config', 'com_config', '{}'),
(7, 1, 13, 16, 1, 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(8, 1, 17, 46, 1, 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1}}'),
(9, 1, 47, 48, 1, 'com_cpanel', 'com_cpanel', '{}'),
(10, 1, 49, 50, 1, 'com_installer', 'com_installer', '{\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'),
(11, 1, 51, 52, 1, 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1}}'),
(12, 1, 53, 54, 1, 'com_login', 'com_login', '{}'),
(13, 1, 55, 56, 1, 'com_mailto', 'com_mailto', '{}'),
(14, 1, 57, 58, 1, 'com_massmail', 'com_massmail', '{}'),
(15, 1, 59, 60, 1, 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'),
(16, 1, 61, 70, 1, 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1}}'),
(17, 1, 71, 72, 1, 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
(18, 1, 73, 174, 1, 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1}}'),
(19, 1, 175, 178, 1, 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(20, 1, 179, 180, 1, 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1}}'),
(21, 1, 181, 182, 1, 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1}}'),
(22, 1, 183, 184, 1, 'com_search', 'com_search', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(23, 1, 185, 186, 1, 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1}}'),
(24, 1, 187, 190, 1, 'com_users', 'com_users', '{\"core.admin\":{\"7\":1}}'),
(26, 1, 191, 192, 1, 'com_wrapper', 'com_wrapper', '{}'),
(27, 8, 18, 19, 2, 'com_content.category.2', 'Uncategorised', '{}'),
(28, 3, 4, 5, 2, 'com_banners.category.3', 'Uncategorised', '{}'),
(29, 7, 14, 15, 2, 'com_contact.category.4', 'Uncategorised', '{}'),
(30, 19, 176, 177, 2, 'com_newsfeeds.category.5', 'Uncategorised', '{}'),
(32, 24, 188, 189, 2, 'com_users.category.7', 'Uncategorised', '{}'),
(33, 1, 193, 194, 1, 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
(34, 1, 195, 196, 1, 'com_joomlaupdate', 'com_joomlaupdate', '{}'),
(35, 1, 197, 198, 1, 'com_tags', 'com_tags', '{}'),
(36, 1, 199, 200, 1, 'com_contenthistory', 'com_contenthistory', '{}'),
(37, 1, 201, 202, 1, 'com_ajax', 'com_ajax', '{}'),
(38, 1, 203, 204, 1, 'com_postinstall', 'com_postinstall', '{}'),
(40, 18, 74, 75, 2, 'com_modules.module.2', 'Login', '{}'),
(41, 18, 76, 77, 2, 'com_modules.module.3', 'Popular Articles', '{}'),
(42, 18, 78, 79, 2, 'com_modules.module.4', 'Recently Added Articles', '{}'),
(43, 18, 80, 81, 2, 'com_modules.module.8', 'Toolbar', '{}'),
(44, 18, 82, 83, 2, 'com_modules.module.9', 'Quick Icons', '{}'),
(45, 18, 84, 85, 2, 'com_modules.module.10', 'Logged-in Users', '{}'),
(46, 18, 86, 87, 2, 'com_modules.module.12', 'Admin Menu', '{}'),
(47, 18, 88, 89, 2, 'com_modules.module.13', 'Admin Submenu', '{}'),
(48, 18, 90, 91, 2, 'com_modules.module.14', 'User Status', '{}'),
(49, 18, 92, 93, 2, 'com_modules.module.15', 'Title', '{}'),
(51, 18, 94, 95, 2, 'com_modules.module.17', 'Breadcrumbs', '{}'),
(52, 18, 96, 97, 2, 'com_modules.module.79', 'Multilanguage status', '{}'),
(53, 18, 98, 99, 2, 'com_modules.module.86', 'Joomla Version', '{}'),
(54, 16, 62, 63, 2, 'com_menus.menu.1', 'Main Menu', '{}'),
(55, 18, 100, 101, 2, 'com_modules.module.87', 'Sample Data', '{}'),
(56, 1, 205, 224, 1, 'com_sppagebuilder', 'SP Page Builder', '{}'),
(58, 18, 102, 103, 2, 'com_modules.module.89', 'SP Page Builder', '{}'),
(59, 18, 104, 105, 2, 'com_modules.module.90', 'SP Page Builder Admin Menu', '{}'),
(60, 56, 206, 207, 2, 'com_sppagebuilder.page.1', 'Home', '{}'),
(61, 1, 225, 226, 1, 'com_spsimpleportfolio', 'SP Simple Portfolio', '{}'),
(62, 1, 227, 228, 1, 'com_speasyimagegallery', 'COM_SPEASYIMAGEGALLERY', '{}'),
(63, 18, 106, 107, 2, 'com_modules.module.91', 'Photos', '{}'),
(65, 1, 229, 230, 1, '#__speasyimagegallery_albums.1', '#__speasyimagegallery_albums.1', '{}'),
(66, 56, 208, 209, 2, 'com_sppagebuilder.page.2', 'About', '{}'),
(67, 56, 210, 211, 2, 'com_sppagebuilder.page.3', 'Contact', '{}'),
(68, 56, 212, 213, 2, 'com_sppagebuilder.page.4', 'Services', '{}'),
(69, 8, 20, 45, 2, 'com_content.category.8', 'Blog', '{}'),
(70, 69, 21, 22, 3, 'com_content.article.1', 'Preparing some to impress your audiance', '{}'),
(71, 69, 23, 24, 3, 'com_content.article.2', 'After Setbacks and Suits, Miami to Open Science', '{}'),
(72, 69, 25, 26, 3, 'com_content.article.3', 'The New Threat to Wolves in and Around Yellowstone', '{}'),
(73, 18, 108, 109, 2, 'com_modules.module.93', 'Information', '{}'),
(74, 18, 110, 111, 2, 'com_modules.module.94', 'Blog', '{}'),
(75, 16, 64, 65, 2, 'com_menus.menu.2', 'Company', '{}'),
(76, 16, 66, 67, 2, 'com_menus.menu.3', 'Quick Links', '{}'),
(77, 18, 112, 113, 2, 'com_modules.module.95', 'Company', '{}'),
(78, 69, 27, 28, 3, 'com_content.article.4', 'Broke a Glass? Someday You Might 3-D-Print a New One', '{}'),
(79, 69, 29, 30, 3, 'com_content.article.5', 'Jimmy Kimmel Sheds Light on Health Coverage', '{}'),
(80, 69, 31, 32, 3, 'com_content.article.6', 'As Arctic Ice Vanishes, New Shipping Routes Open', '{}'),
(81, 69, 33, 34, 3, 'com_content.article.7', 'Want to Make More Baskets? Science Has the Answer', '{}'),
(82, 69, 35, 36, 3, 'com_content.article.8', 'Debate Over Paris Climate Deal Could Turn on a Single Phrase', '{}'),
(83, 69, 37, 38, 3, 'com_content.article.9', 'The Making of a Legacy: First Steps in the Trump Era', '{}'),
(84, 18, 114, 115, 2, 'com_modules.module.96', 'Joomla Module', '{}'),
(87, 18, 116, 117, 2, 'com_modules.module.97', 'Tags', '{}'),
(88, 18, 118, 119, 2, 'com_modules.module.98', 'Latest Articles', '{}'),
(89, 18, 120, 121, 2, 'com_modules.module.99', 'Offcanvas', '{}'),
(90, 1, 231, 232, 1, 'com_fields', 'com_fields', '{}'),
(91, 1, 233, 234, 1, 'com_associations', 'com_associations', '{}'),
(92, 1, 235, 236, 1, 'com_privacy', 'com_privacy', '{}'),
(93, 1, 237, 238, 1, 'com_actionlogs', 'com_actionlogs', '{}'),
(131, 1, 239, 240, 1, 'com_jbusinessdirectory', 'JBusinessDirectory', '{}'),
(95, 18, 122, 123, 2, 'com_modules.module.100', 'JBusinessDirectory Events Search', '{}'),
(96, 18, 124, 125, 2, 'com_modules.module.101', 'Events simple 2', '{}'),
(97, 18, 126, 127, 2, 'com_modules.module.102', 'Business Listings Slider', '{}'),
(98, 18, 128, 129, 2, 'com_modules.module.103', 'Listings Search', '{}'),
(99, 18, 130, 131, 2, 'com_modules.module.104', 'JBusinessDirectory Offer Search', '{}'),
(100, 18, 132, 133, 2, 'com_modules.module.105', 'Offers Simple', '{}'),
(101, 18, 134, 135, 2, 'com_modules.module.106', 'JBusinessDirectory - Progress', '{}'),
(102, 18, 136, 137, 2, 'com_modules.module.107', 'Categories- cons', '{}'),
(103, 18, 138, 139, 2, 'com_modules.module.108', 'JBusinessCategoriesEvents', '{}'),
(104, 18, 140, 141, 2, 'com_modules.module.109', 'JBusinessCategoriesOffers', '{}'),
(132, 18, 172, 173, 2, 'com_modules.module.146', 'J-BusinessDirectory', '{}'),
(106, 56, 214, 215, 2, 'com_sppagebuilder.page.5', 'Home Map', '{}'),
(107, 69, 39, 40, 3, 'com_content.article.10', 'Good city break', '{}'),
(108, 69, 41, 42, 3, 'com_content.article.11', 'The best attractions', '{}'),
(109, 69, 43, 44, 3, 'com_content.article.12', 'Cozy locations', '{}'),
(110, 18, 142, 143, 2, 'com_modules.module.111', 'User module', '{}'),
(111, 18, 144, 145, 2, 'com_modules.module.112', 'mod_jbusiness_user', '{}'),
(112, 18, 146, 147, 2, 'com_modules.module.113', 'User module', '{}'),
(129, 18, 170, 171, 2, 'com_modules.module.145', 'Main Slider', '{}'),
(114, 56, 216, 217, 2, 'com_sppagebuilder.page.6', 'Home Slider', '{}'),
(115, 18, 148, 149, 2, 'com_modules.module.115', 'Listings Search with Map', '{}'),
(116, 18, 150, 151, 2, 'com_modules.module.116', 'Business Listings Simple 2', '{}'),
(117, 18, 152, 153, 2, 'com_modules.module.117', 'Business Listings Simple', '{}'),
(118, 18, 154, 155, 2, 'com_modules.module.118', 'Discount offers', '{}'),
(119, 18, 156, 157, 2, 'com_modules.module.119', 'Offers Slider', '{}'),
(120, 18, 158, 159, 2, 'com_modules.module.120', 'Events default', '{}'),
(121, 18, 160, 161, 2, 'com_modules.module.121', 'Events slider', '{}'),
(122, 18, 162, 163, 2, 'com_modules.module.122', 'Events simple', '{}'),
(123, 56, 218, 219, 2, 'com_sppagebuilder.page.7', 'Home Map', '{}'),
(124, 56, 220, 221, 2, 'com_sppagebuilder.page.8', 'Home Map (2)', '{}'),
(125, 56, 222, 223, 2, 'com_sppagebuilder.page.9', 'Home Video', '{}'),
(126, 18, 164, 165, 2, 'com_modules.module.123', 'Categories Slider', '{}'),
(127, 18, 166, 167, 2, 'com_modules.module.124', ' JBusinessDirectory Listing Search - Vertical ', '{}'),
(128, 18, 168, 169, 2, 'com_modules.module.125', 'JBusinessDirectory Listing Search', '{}'),
(130, 16, 68, 69, 2, 'com_menus.menu.4', 'Hidden', '{}');

-- --------------------------------------------------------

--
-- Table structure for table `#__associations`
--

DROP TABLE IF EXISTS `#__associations`;
CREATE TABLE IF NOT EXISTS `#__associations` (
  `id` int(11) NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__banners`
--

DROP TABLE IF EXISTS `#__banners`;
CREATE TABLE IF NOT EXISTS `#__banners` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT '0',
  `type` int(11) NOT NULL DEFAULT '0',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `imptotal` int(11) NOT NULL DEFAULT '0',
  `impmade` int(11) NOT NULL DEFAULT '0',
  `clicks` int(11) NOT NULL DEFAULT '0',
  `clickurl` varchar(200) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `custombannercode` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL,
  `sticky` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint(1) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  `checked_out` int(10) UNSIGNED DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `reset` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100)),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__banner_clients`
--

DROP TABLE IF EXISTS `#__banner_clients`;
CREATE TABLE IF NOT EXISTS `#__banner_clients` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extrainfo` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `own_prefix` tinyint(4) NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint(4) NOT NULL DEFAULT '-1',
  `track_clicks` tinyint(4) NOT NULL DEFAULT '-1',
  `track_impressions` tinyint(4) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__banner_tracks`
--

DROP TABLE IF EXISTS `#__banner_tracks`;
CREATE TABLE IF NOT EXISTS `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int(10) UNSIGNED NOT NULL,
  `banner_id` int(10) UNSIGNED NOT NULL,
  `count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__categories`
--

DROP TABLE IF EXISTS `#__categories`;
CREATE TABLE IF NOT EXISTS `#__categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext COLLATE utf8mb4_unicode_ci,
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci,
  `metadesc` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta keywords for the page.',
  `metadata` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL,
  `modified_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__categories`
--

INSERT INTO `#__categories` (`id`, `asset_id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `extension`, `title`, `alias`, `note`, `description`, `published`, `checked_out`, `checked_out_time`, `access`, `params`, `metadesc`, `metakey`, `metadata`, `created_user_id`, `created_time`, `modified_user_id`, `modified_time`, `hits`, `language`, `version`) VALUES
(1, 0, 0, 0, 13, 0, '', 'system', 'ROOT', 'root', '', '', 1, NULL, NULL, 1, '{}', '', '', '{}', 584, '2021-09-15 10:42:32', 584, '2021-09-15 10:42:32', 0, '*', 1),
(2, 27, 1, 1, 2, 1, 'uncategorised', 'com_content', 'Uncategorised', 'uncategorised', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 584, '2021-09-15 10:42:32', 584, '2021-09-15 10:42:32', 0, '*', 1),
(3, 28, 1, 3, 4, 1, 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 584, '2021-09-15 10:42:32', 584, '2021-09-15 10:42:32', 0, '*', 1),
(4, 29, 1, 5, 6, 1, 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 584, '2021-09-15 10:42:32', 584, '2021-09-15 10:42:32', 0, '*', 1),
(5, 30, 1, 7, 8, 1, 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 584, '2021-09-15 10:42:32', 584, '2021-09-15 10:42:32', 0, '*', 1),
(7, 32, 1, 9, 10, 1, 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 584, '2021-09-15 10:42:32', 584, '2021-09-15 10:42:32', 0, '*', 1),
(8, 69, 1, 11, 12, 1, 'blog', 'com_content', 'Blog', 'blog', '', '', 1, NULL, NULL, 1, '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', 584, '2021-09-15 10:42:32', 0, '2021-09-15 10:42:32', 0, '*', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__contact_details`
--

DROP TABLE IF EXISTS `#__contact_details`;
CREATE TABLE IF NOT EXISTS `#__contact_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `con_position` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text COLLATE utf8mb4_unicode_ci,
  `suburb` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misc` mediumtext COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_to` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_con` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `catid` int(11) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `mobile` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `webpage` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname1` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname2` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname3` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(7) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `metadesc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Set if contact is featured.',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__contact_details`
--

INSERT INTO `#__contact_details` (`id`, `name`, `alias`, `con_position`, `address`, `suburb`, `state`, `country`, `postcode`, `telephone`, `fax`, `misc`, `image`, `email_to`, `default_con`, `published`, `checked_out`, `checked_out_time`, `ordering`, `params`, `user_id`, `catid`, `access`, `mobile`, `webpage`, `sortname1`, `sortname2`, `sortname3`, `language`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `metakey`, `metadesc`, `metadata`, `featured`, `publish_up`, `publish_down`, `version`, `hits`) VALUES
(1, 'Contact', 'contact', '', '', '', '', '', '', '', '', '', '', '', 0, 1, NULL, NULL, 1, '{\"show_contact_category\":\"\",\"show_contact_list\":\"\",\"presentation_style\":\"\",\"show_tags\":\"\",\"show_info\":\"\",\"show_name\":\"\",\"show_position\":\"\",\"show_email\":\"\",\"add_mailto_link\":\"\",\"show_street_address\":\"\",\"show_suburb\":\"\",\"show_state\":\"\",\"show_postcode\":\"\",\"show_country\":\"\",\"show_telephone\":\"\",\"show_mobile\":\"\",\"show_fax\":\"\",\"show_webpage\":\"\",\"show_image\":\"\",\"show_misc\":\"\",\"allow_vcard\":\"\",\"show_articles\":\"\",\"articles_display_num\":\"\",\"show_profile\":\"\",\"show_links\":\"\",\"linka_name\":\"\",\"linka\":false,\"linkb_name\":\"\",\"linkb\":false,\"linkc_name\":\"\",\"linkc\":false,\"linkd_name\":\"\",\"linkd\":false,\"linke_name\":\"\",\"linke\":false,\"contact_layout\":\"\",\"show_email_form\":\"\",\"show_email_copy\":\"\",\"validate_session\":\"\",\"custom_reply\":\"\",\"redirect\":\"\"}', 13, 4, 1, '', '', '', '', '', '*', '2021-09-15 10:42:32', 584, '', '2021-09-15 10:42:32', 584, '', '', '{\"robots\":\"\",\"rights\":\"\"}', 0, NULL, NULL, 11, 85);

-- --------------------------------------------------------

--
-- Table structure for table `#__content`
--

DROP TABLE IF EXISTS `#__content`;
CREATE TABLE IF NOT EXISTS `#__content` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `fulltext` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(3) NOT NULL DEFAULT '0',
  `catid` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `images` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribs` varchar(5120) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `metakey` text COLLATE utf8mb4_unicode_ci,
  `metadesc` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `access` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `metadata` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint(3) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(191))
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__content`
--

INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `note`) VALUES
(1, 70, 'Preparing some to impress your audiance', 'how-marching-for-science-risks-politicizing-it', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2022-09-15 10:42:32', 584, '', '2022-09-15 10:42:32', 584, NULL, NULL, '2021-09-15 10:42:32', NULL, '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"video\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"http:\\/\\/vimeo.com\\/73961982\"}', 14, 11, '', '', 1, 39, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(2, 71, 'After Setbacks and Suits, Miami to Open Science', 'after-setbacks-and-suits-miami-to-open-science-museum', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2022-09-15 10:42:32', 584, '', '2022-09-15 10:42:32', 584, NULL, NULL, '2021-09-15 10:42:32', NULL, '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2018\\/02\\/23\\/blog2.jpg\",\"helix_ultimate_article_format\":\"audio\",\"helix_ultimate_audio\":\"<iframe scrolling=\\\"no\\\" frameborder=\\\"no\\\" allow=\\\"autoplay\\\" src=\\\"https:\\/\\/w.soundcloud.com\\/player\\/?url=https%3A\\/\\/api.soundcloud.com\\/tracks\\/399014505&color=%23ff5500&auto_play=false&hide_related=false&show_comments=true&show_user=true&show_reposts=false&show_teaser=true&visual=true\\\"><\\/iframe>\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 8, 10, '', '', 1, 5, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(3, 72, 'The New Threat to Wolves in and Around Yellowstone', 'the-new-threat-to-wolves-in-and-around-yellowstone', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2022-09-15 10:42:32', 584, '', '2022-09-15 10:42:32', 584, NULL, NULL, '2021-09-15 10:42:32', NULL, '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2018\\/02\\/23\\/blog12.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 10, 9, '', '', 1, 5, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(4, 78, 'Broke a Glass? Someday You Might 3-D-Print a New One', 'broke-a-glass-someday-you-might-3-d-print-a-new-one', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2022-09-15 10:42:32', 584, '', '2022-09-15 10:42:32', 584, NULL, NULL, '2021-09-15 10:42:32', NULL, '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2018\\/02\\/23\\/blog4.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 5, 8, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(5, 79, 'Jimmy Kimmel Sheds Light on Health Coverage', 'jimmy-kimmel-sheds-light-on-health-coverage', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2022-09-15 10:42:32', 584, '', '2022-09-15 10:42:32', 584, NULL, NULL, '2021-09-15 10:42:32', NULL, '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2018\\/02\\/23\\/blog5.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 5, 7, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(6, 80, 'As Arctic Ice Vanishes, New Shipping Routes Open', 'as-arctic-ice-vanishes-new-shipping-routes-open', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2022-09-15 10:42:32', 584, '', '2022-09-15 10:42:32', 584, NULL, NULL, '2021-09-15 10:42:32', NULL, '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2018\\/02\\/23\\/blog6.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"http:\\/\\/vimeo.com\\/73961982\"}', 7, 6, '', '', 1, 3, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(7, 81, 'Want to Make More Baskets? Science Has the Answer', 'want-to-make-more-baskets-science-has-the-answer', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2022-09-15 10:42:32', 584, '', '2022-09-15 10:42:32', 584, NULL, NULL, '2021-09-15 10:42:32', NULL, '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2018\\/02\\/23\\/blog7.jpg\",\"helix_ultimate_article_format\":\"gallery\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"{\\\"helix_ultimate_gallery_images\\\":[\\\"images\\/2018\\/02\\/23\\/blog31.jpg\\\",\\\"images\\/2018\\/02\\/23\\/blog41.jpg\\\",\\\"images\\/2018\\/02\\/23\\/blog51.jpg\\\",\\\"images\\/2018\\/02\\/23\\/blog111.jpg\\\"]}\",\"helix_ultimate_video\":\"\"}', 6, 5, '', '', 1, 2, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(8, 82, 'Debate Over Paris Climate Deal Could Turn on a Single Phrase', 'debate-over-paris-climate-deal-could-turn-on-a-single-phrase', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2022-09-15 10:42:32', 584, '', '2022-09-15 10:42:32', 584, NULL, NULL, '2021-09-15 10:42:32', NULL, '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2018\\/02\\/23\\/blog10.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 5, 4, '', '', 1, 11, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(9, 83, 'The Making of a Legacy: First Steps in the Trump Era', 'the-making-of-a-legacy-first-steps-in-the-trump-era', '<p>It won’t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.</p>\r\n', '\r\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today’s video game was not at all there when video game first conceptualized and played ever.</p>\r\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself</strong>, “Wow, what a deal!”. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:</p>\r\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.</p>\r\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.</p>\r\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.</p>\r\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.</p>', 1, 8, '2022-09-15 10:42:32', 584, '', '2022-09-15 10:42:32', 584, NULL, NULL, '2021-09-15 10:42:32', NULL, '{\"image_intro\":\"\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"images\\/2018\\/02\\/23\\/blog81.jpg\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 3, '', '', 1, 16, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(10, 107, 'Good city break', 'good-city-break', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 8, '2022-09-15 10:42:32', 584, '', '2022-09-15 10:42:32', 584, NULL, NULL, '2021-09-15 10:42:32', NULL, '{\"image_intro\":\"images\\/content\\/traveller-experience.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/content\\/traveller-experience.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 4, 2, '', '', 1, 1, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '');
INSERT INTO `#__content` (`id`, `asset_id`, `title`, `alias`, `introtext`, `fulltext`, `state`, `catid`, `created`, `created_by`, `created_by_alias`, `modified`, `modified_by`, `checked_out`, `checked_out_time`, `publish_up`, `publish_down`, `images`, `urls`, `attribs`, `version`, `ordering`, `metakey`, `metadesc`, `access`, `hits`, `metadata`, `featured`, `language`, `note`) VALUES
(11, 108, 'The best attractions', 'find-the-best-attractions', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 8, '2022-09-15 10:42:32', 584, '', '2022-09-15 10:42:32', 584, NULL, NULL, '2021-09-15 10:42:32', NULL, '{\"image_intro\":\"images\\/content\\/having_fun.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/content\\/having_fun.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 3, 1, '', '', 1, 12, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', ''),
(12, 109, 'Cozy locations', 'cozy-locations', '<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.</p>\r\n', '\r\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus</p>', 1, 8, '2022-09-15 10:42:32', 584, '', '2022-09-15 10:42:32', 584, NULL, NULL, '2021-09-15 10:42:32', NULL, '{\"image_intro\":\"images\\/content\\/having_cofee.jpg\",\"float_intro\":\"\",\"image_intro_alt\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/content\\/having_cofee.jpg\",\"float_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":false,\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":false,\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":false,\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_associations\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_icons\":\"\",\"show_print_icon\":\"\",\"show_email_icon\":\"\",\"show_vote\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\",\"helix_ultimate_image\":\"\",\"helix_ultimate_article_format\":\"standard\",\"helix_ultimate_audio\":\"\",\"helix_ultimate_gallery\":\"\",\"helix_ultimate_video\":\"\"}', 2, 0, '', '', 1, 2, '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\",\"xreference\":\"\"}', 0, '*', '');

-- --------------------------------------------------------

--
-- Table structure for table `#__contentitem_tag_map`
--

DROP TABLE IF EXISTS `#__contentitem_tag_map`;
CREATE TABLE IF NOT EXISTS `#__contentitem_tag_map` (
  `type_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_content_id` int(10) UNSIGNED NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int(11) NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int(10) UNSIGNED NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint(8) NOT NULL COMMENT 'PK from the content_type table',
  UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`),
  KEY `idx_tag_type` (`tag_id`,`type_id`),
  KEY `idx_date_id` (`tag_date`,`tag_id`),
  KEY `idx_core_content_id` (`core_content_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Maps items from content tables to tags';

-- --------------------------------------------------------

--
-- Table structure for table `#__content_frontpage`
--

DROP TABLE IF EXISTS `#__content_frontpage`;
CREATE TABLE IF NOT EXISTS `#__content_frontpage` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `featured_up` datetime DEFAULT NULL,
  `featured_down` datetime DEFAULT NULL,
  PRIMARY KEY (`content_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__content_rating`
--

DROP TABLE IF EXISTS `#__content_rating`;
CREATE TABLE IF NOT EXISTS `#__content_rating` (
  `content_id` int(11) NOT NULL DEFAULT '0',
  `rating_sum` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `rating_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lastip` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__content_rating`
--

INSERT INTO `#__content_rating` (`content_id`, `rating_sum`, `rating_count`, `lastip`) VALUES
(1, 5, 1, '::1'),
(3, 5, 1, '::1'),
(9, 5, 1, '10.0.1.2');

-- --------------------------------------------------------

--
-- Table structure for table `#__content_types`
--

DROP TABLE IF EXISTS `#__content_types`;
CREATE TABLE IF NOT EXISTS `#__content_types` (
  `type_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(2048) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rules` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_mappings` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `router` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'JSON string for com_contenthistory options',
  PRIMARY KEY (`type_id`),
  KEY `idx_alias` (`type_alias`(100))
) ENGINE=MyISAM AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__content_types`
--

INSERT INTO `#__content_types` (`type_id`, `type_title`, `type_alias`, `table`, `rules`, `field_mappings`, `router`, `content_history_options`) VALUES
(1, 'Article', 'com_content.article', '{\"special\":{\"dbtable\":\"#__content\",\"key\":\"id\",\"type\":\"ArticleTable\",\"prefix\":\"Joomla\\\\Component\\\\Content\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"state\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"introtext\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"attribs\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"asset_id\", \"note\":\"note\"}, \"special\":{\"fulltext\":\"fulltext\"}}', 'ContentHelperRoute::getArticleRoute', '{\"formFile\":\"administrator\\/components\\/com_content\\/models\\/forms\\/article.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(2, 'Contact', 'com_contact.contact', '{\"special\":{\"dbtable\":\"#__contact_details\",\"key\":\"id\",\"type\":\"ContactTable\",\"prefix\":\"Joomla\\\\Component\\\\Contact\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"address\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"image\", \"core_urls\":\"webpage\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"con_position\":\"con_position\",\"suburb\":\"suburb\",\"state\":\"state\",\"country\":\"country\",\"postcode\":\"postcode\",\"telephone\":\"telephone\",\"fax\":\"fax\",\"misc\":\"misc\",\"email_to\":\"email_to\",\"default_con\":\"default_con\",\"user_id\":\"user_id\",\"mobile\":\"mobile\",\"sortname1\":\"sortname1\",\"sortname2\":\"sortname2\",\"sortname3\":\"sortname3\"}}', 'ContactHelperRoute::getContactRoute', '{\"formFile\":\"administrator\\/components\\/com_contact\\/models\\/forms\\/contact.xml\",\"hideFields\":[\"default_con\",\"checked_out\",\"checked_out_time\",\"version\",\"xreference\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[ {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ] }'),
(3, 'Newsfeed', 'com_newsfeeds.newsfeed', '{\"special\":{\"dbtable\":\"#__newsfeeds\",\"key\":\"id\",\"type\":\"NewsfeedTable\",\"prefix\":\"Joomla\\\\Component\\\\Newsfeeds\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"xreference\", \"asset_id\":\"null\"}, \"special\":{\"numarticles\":\"numarticles\",\"cache_time\":\"cache_time\",\"rtl\":\"rtl\"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{\"formFile\":\"administrator\\/components\\/com_newsfeeds\\/models\\/forms\\/newsfeed.xml\",\"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(4, 'User', 'com_users.user', '{\"special\":{\"dbtable\":\"#__users\",\"key\":\"id\",\"type\":\"UserTable\",\"prefix\":\"Joomla\\\\Component\\\\Users\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"null\",\"core_alias\":\"username\",\"core_created_time\":\"registerDate\",\"core_modified_time\":\"null\",\"core_body\":\"null\", \"core_hits\":\"null\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"access\":\"null\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"null\", \"core_language\":\"null\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"null\", \"core_ordering\":\"null\", \"core_metakey\":\"null\", \"core_metadesc\":\"null\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{}}', '', ''),
(5, 'Article Category', 'com_content.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContentHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(6, 'Contact Category', 'com_contact.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContactHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(7, 'Newsfeeds Category', 'com_newsfeeds.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(8, 'Tag', 'com_tags.tag', '{\"special\":{\"dbtable\":\"#__tags\",\"key\":\"tag_id\",\"type\":\"TagTable\",\"prefix\":\"Joomla\\\\Component\\\\Tags\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"null\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\"}}', 'TagsHelperRoute::getTagRoute', '{\"formFile\":\"administrator\\/components\\/com_tags\\/models\\/forms\\/tag.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"lft\", \"rgt\", \"level\", \"path\", \"urls\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(9, 'Banner', 'com_banners.banner', '{\"special\":{\"dbtable\":\"#__banners\",\"key\":\"id\",\"type\":\"BannerTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"null\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"core_xreference\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"imptotal\":\"imptotal\", \"impmade\":\"impmade\", \"clicks\":\"clicks\", \"clickurl\":\"clickurl\", \"custombannercode\":\"custombannercode\", \"cid\":\"cid\", \"purchase_type\":\"purchase_type\", \"track_impressions\":\"track_impressions\", \"track_clicks\":\"track_clicks\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/banner.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"reset\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"imptotal\", \"impmade\", \"reset\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"cid\",\"targetTable\":\"#__banner_clients\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
(10, 'Banners Category', 'com_banners.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
(11, 'Banner Client', 'com_banners.client', '{\"special\":{\"dbtable\":\"#__banner_clients\",\"key\":\"id\",\"type\":\"ClientTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/models\\/forms\\/client.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\"], \"ignoreChanges\":[\"checked_out\", \"checked_out_time\"], \"convertToInt\":[], \"displayLookup\":[]}'),
(12, 'User Notes', 'com_users.note', '{\"special\":{\"dbtable\":\"#__user_notes\",\"key\":\"id\",\"type\":\"NoteTable\",\"prefix\":\"Joomla\\\\Component\\\\Users\\\\Administrator\\\\Table\\\\\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_users\\/models\\/forms\\/note.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\"], \"convertToInt\":[\"publish_up\", \"publish_down\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
(13, 'User Notes Category', 'com_users.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"Category\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"core_xreference\":\"null\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/models\\/forms\\/category.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}');

-- --------------------------------------------------------

--
-- Table structure for table `#__core_log_searches`
--

DROP TABLE IF EXISTS `#__core_log_searches`;
CREATE TABLE IF NOT EXISTS `#__core_log_searches` (
  `search_term` varchar(128) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `hits` int(10) UNSIGNED NOT NULL DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__extensions`
--

DROP TABLE IF EXISTS `#__extensions`;
CREATE TABLE IF NOT EXISTS `#__extensions` (
  `extension_id` int(11) NOT NULL AUTO_INCREMENT,
  `package_id` int(11) NOT NULL DEFAULT '0' COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `changelogurl` text COLLATE utf8mb4_unicode_ci,
  `folder` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint(3) NOT NULL,
  `enabled` tinyint(3) NOT NULL DEFAULT '0',
  `access` int(10) UNSIGNED NOT NULL DEFAULT '1',
  `protected` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate if the extension is protected. Protected extensions cannot be disabled.',
  `manifest_cache` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out` int(10) UNSIGNED DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) DEFAULT '0',
  `state` int(11) DEFAULT '0',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `locked` tinyint(4) NOT NULL DEFAULT '0' COMMENT 'Flag to indicate if the extension is locked. Locked extensions cannot be uninstalled.',
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10105 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__extensions`
--

INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `changelogurl`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `checked_out`, `checked_out_time`, `ordering`, `state`, `note`, `locked`) VALUES
(10085, 0, 'plg_system_accessibility', 'plugin', 'accessibility', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_accessibility\",\"type\":\"plugin\",\"creationDate\":\"2020-02-15\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_ACCESSIBILITY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"accessibility\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10086, 802, 'English (en-GB)', 'language', 'en-GB', NULL, '', 3, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"June 2022\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.5\",\"description\":\"en-GB api language\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(2, 0, 'com_wrapper', 'component', 'com_wrapper', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"wrapper\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(3, 0, 'com_admin', 'component', 'com_admin', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(4, 0, 'com_banners', 'component', 'com_banners', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"banners\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\",\"save_history\":\"1\",\"history_limit\":10}', '', NULL, NULL, 0, 0, NULL, 1),
(5, 0, 'com_cache', 'component', 'com_cache', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(6, 0, 'com_categories', 'component', 'com_categories', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(7, 0, 'com_checkin', 'component', 'com_checkin', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(8, 0, 'com_contact', 'component', 'com_contact', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '{\"contact_layout\":\"_:default\",\"show_contact_category\":\"hide\",\"save_history\":\"1\",\"history_limit\":10,\"show_contact_list\":\"0\",\"presentation_style\":\"plain\",\"show_tags\":\"1\",\"show_info\":\"1\",\"show_name\":\"0\",\"show_position\":\"1\",\"show_email\":\"0\",\"add_mailto_link\":\"1\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_image\":\"1\",\"image\":\"\",\"show_misc\":\"1\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"articles_display_num\":\"10\",\"show_profile\":\"0\",\"show_user_custom_fields\":[\"-1\"],\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"0\",\"maxLevel\":\"-1\",\"show_subcat_desc\":\"1\",\"show_empty_categories\":\"0\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_subcat_desc_cat\":\"1\",\"show_empty_categories_cat\":\"0\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"0\",\"show_pagination_limit\":\"0\",\"show_headings\":\"1\",\"show_image_heading\":\"0\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"initial_sort\":\"ordering\",\"captcha\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"0\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_feed_link\":\"1\",\"sef_advanced\":0,\"sef_ids\":0,\"custom_fields_enable\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(9, 0, 'com_cpanel', 'component', 'com_cpanel', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"Jun 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10, 0, 'com_installer', 'component', 'com_installer', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\"}', '{\"show_jed_info\":\"1\",\"cachetimeout\":\"6\",\"minimum_stability\":\"4\"}', '', NULL, NULL, 0, 0, NULL, 1),
(11, 0, 'com_languages', 'component', 'com_languages', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}', '', NULL, NULL, 0, 0, NULL, 1),
(12, 0, 'com_login', 'component', 'com_login', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(13, 0, 'com_media', 'component', 'com_media', NULL, '', 1, 1, 0, 1, '{\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '{\"upload_extensions\":\"bmp,csv,doc,gif,ico,jpg,jpeg,odg,odp,ods,odt,pdf,png,ppt,txt,xcf,xls,BMP,CSV,DOC,GIF,ICO,JPG,JPEG,ODG,ODP,ODS,ODT,PDF,PNG,PPT,TXT,XCF,XLS\",\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"allowed_media_usergroup\":\"3\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\",\"upload_mime_illegal\":\"text\\/html\"}', '', NULL, NULL, 0, 0, NULL, 1),
(14, 0, 'com_menus', 'component', 'com_menus', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"menus\"}', '{\"page_title\":\"\",\"show_page_heading\":0,\"page_heading\":\"\",\"pageclass_sfx\":\"\"}', '', NULL, NULL, 0, 0, NULL, 1),
(15, 0, 'com_messages', 'component', 'com_messages', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(16, 0, 'com_modules', 'component', 'com_modules', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"modules\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(17, 0, 'com_newsfeeds', 'component', 'com_newsfeeds', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{\"newsfeed_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_character_count\":\"0\",\"feed_display_order\":\"des\",\"float_first\":\"right\",\"float_second\":\"right\",\"show_tags\":\"1\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(18, 0, 'com_plugins', 'component', 'com_plugins', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(19, 10088, 'com_search', 'component', 'com_search', '', '', 1, 1, 1, 0, '{\"name\":\"com_search\",\"type\":\"component\",\"creationDate\":\"17.06.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"filename\":\"search\"}', '{\"enabled\":\"0\",\"search_phrases\":\"1\",\"search_areas\":\"1\",\"show_date\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\"}', '', NULL, NULL, 0, 0, NULL, 0),
(20, 0, 'com_templates', 'component', 'com_templates', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\"}', '{\"template_positions_display\":\"0\",\"upload_limit\":\"10\",\"image_formats\":\"gif,bmp,jpg,jpeg,png\",\"source_formats\":\"txt,less,ini,xml,js,php,css,scss,sass\",\"font_formats\":\"woff,ttf,otf\",\"compressed_formats\":\"zip\"}', '', NULL, NULL, 0, 0, NULL, 1),
(22, 0, 'com_content', 'component', 'com_content', NULL, '', 1, 1, 0, 1, '{\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"1\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"info_block_position\":\"0\",\"info_block_show_title\":\"1\",\"show_category\":\"1\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_associations\":\"0\",\"flags\":\"1\",\"show_author\":\"1\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"1\",\"show_item_navigation\":\"1\",\"show_vote\":\"1\",\"show_readmore\":\"1\",\"show_readmore_title\":\"0\",\"readmore_limit\":\"100\",\"show_tags\":\"1\",\"show_icons\":\"1\",\"show_print_icon\":\"1\",\"show_email_icon\":\"1\",\"show_hits\":\"1\",\"record_hits\":\"1\",\"show_noauth\":\"0\",\"urls_position\":\"0\",\"captcha\":\"\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"save_history\":\"1\",\"history_limit\":10,\"show_urls_images_frontend\":\"0\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"none\",\"float_fulltext\":\"none\",\"category_layout\":\"_:blog\",\"show_category_heading_title_text\":\"1\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"1\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_subcat_desc\":\"1\",\"show_cat_num_articles\":\"0\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":\"1\",\"num_intro_articles\":\"4\",\"num_columns\":\"2\",\"num_links\":\"4\",\"multi_column_order\":\"0\",\"show_subcategory_content\":\"0\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"list_show_votes\":\"0\",\"list_show_ratings\":\"0\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_featured\":\"show\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"feed_show_readmore\":\"0\",\"sef_advanced\":1,\"sef_ids\":1,\"custom_fields_enable\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(23, 0, 'com_config', 'component', 'com_config', NULL, '', 1, 1, 0, 1, '{\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"config\"}', '{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"9\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', NULL, NULL, 0, 0, NULL, 1),
(24, 0, 'com_redirect', 'component', 'com_redirect', NULL, '', 1, 1, 0, 0, '{\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(25, 0, 'com_users', 'component', 'com_users', NULL, '', 1, 1, 0, 1, '{\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"April 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"users\"}', '{\"allowUserRegistration\":\"1\",\"new_usertype\":\"2\",\"guest_usergroup\":\"9\",\"sendpassword\":\"1\",\"useractivation\":\"2\",\"mail_to_admin\":\"1\",\"captcha\":\"\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"domains\":[],\"reset_count\":\"10\",\"reset_time\":\"1\",\"minimum_length\":\"4\",\"minimum_integers\":\"0\",\"minimum_symbols\":\"0\",\"minimum_uppercase\":\"0\",\"minimum_lowercase\":\"0\",\"save_history\":\"1\",\"history_limit\":5,\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\",\"debugUsers\":\"1\",\"debugGroups\":\"1\",\"sef_advanced\":0,\"custom_fields_enable\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(27, 0, 'com_finder', 'component', 'com_finder', NULL, '', 1, 1, 0, 0, '{\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '{\"enabled\":\"0\",\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_autosuggest\":\"1\",\"show_suggested_query\":\"1\",\"show_explained_query\":\"1\",\"show_advanced\":\"1\",\"show_advanced_tips\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"sort_order\":\"relevance\",\"sort_direction\":\"desc\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"memory_table_limit\":30000,\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stem\":\"1\",\"stemmer\":\"snowball\",\"enable_logging\":\"0\"}', '', NULL, NULL, 0, 0, NULL, 1),
(28, 0, 'com_joomlaupdate', 'component', 'com_joomlaupdate', NULL, '', 1, 1, 0, 1, '{\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"August 2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.3\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\"}', '{\"updatesource\":\"default\",\"customurl\":\"\"}', '', NULL, NULL, 0, 0, NULL, 1),
(29, 0, 'com_tags', 'component', 'com_tags', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_tags\",\"type\":\"component\",\"creationDate\":\"December 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{\"tag_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_tag_title\":\"0\",\"tag_list_show_tag_image\":\"0\",\"tag_list_show_tag_description\":\"0\",\"tag_list_image\":\"\",\"tag_list_orderby\":\"title\",\"tag_list_orderby_direction\":\"ASC\",\"show_headings\":\"0\",\"tag_list_show_date\":\"0\",\"tag_list_show_item_image\":\"0\",\"tag_list_show_item_description\":\"0\",\"tag_list_item_maximum_characters\":0,\"return_any_or_all\":\"1\",\"include_children\":\"0\",\"maximum\":200,\"tag_list_language_filter\":\"all\",\"tags_layout\":\"_:default\",\"all_tags_orderby\":\"title\",\"all_tags_orderby_direction\":\"ASC\",\"all_tags_show_tag_image\":\"0\",\"all_tags_show_tag_descripion\":\"0\",\"all_tags_tag_maximum_characters\":20,\"all_tags_show_tag_hits\":\"0\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"tag_field_ajax_mode\":\"1\",\"show_feed_link\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(30, 0, 'com_contenthistory', 'component', 'com_contenthistory', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_contenthistory\",\"type\":\"component\",\"creationDate\":\"May 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENTHISTORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contenthistory\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(31, 0, 'com_ajax', 'component', 'com_ajax', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_ajax\",\"type\":\"component\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_AJAX_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ajax\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(32, 0, 'com_postinstall', 'component', 'com_postinstall', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_postinstall\",\"type\":\"component\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_POSTINSTALL_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(33, 0, 'com_fields', 'component', 'com_fields', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_fields\",\"type\":\"component\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(34, 0, 'com_associations', 'component', 'com_associations', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_associations\",\"type\":\"component\",\"creationDate\":\"January 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ASSOCIATIONS_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(35, 0, 'com_privacy', 'component', 'com_privacy', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_privacy\",\"type\":\"component\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacy\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(36, 0, 'com_actionlogs', 'component', 'com_actionlogs', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_actionlogs\",\"type\":\"component\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\"}', '{\"ip_logging\":0,\"csv_delimiter\":\",\",\"loggable_extensions\":[\"com_banners\",\"com_cache\",\"com_categories\",\"com_checkin\",\"com_config\",\"com_contact\",\"com_content\",\"com_installer\",\"com_media\",\"com_menus\",\"com_messages\",\"com_modules\",\"com_newsfeeds\",\"com_plugins\",\"com_redirect\",\"com_tags\",\"com_templates\",\"com_users\"]}', '', NULL, NULL, 0, 0, NULL, 1),
(103, 0, 'lib_joomla', 'library', 'joomla', NULL, '', 0, 1, 1, 1, '{\"name\":\"lib_joomla\",\"type\":\"library\",\"creationDate\":\"2008\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"https:\\/\\/www.joomla.org\",\"version\":\"13.1\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"mediaversion\":\"8f522202f3c9b8c2fdc847dde597656a\"}', '', NULL, NULL, 0, 0, NULL, 1),
(10045, 0, 'com_workflow', 'component', 'com_workflow', NULL, '', 1, 1, 0, 1, '{\"name\":\"com_workflow\",\"type\":\"component\",\"creationDate\":\"June 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WORKFLOW_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10046, 0, 'plg_workflow_publishing', 'plugin', 'publishing', NULL, 'workflow', 0, 1, 1, 0, '{\"name\":\"plg_workflow_publishing\",\"type\":\"plugin\",\"creationDate\":\"March 2020\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_PUBLISHING_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"publishing\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10047, 0, 'plg_workflow_featuring', 'plugin', 'featuring', NULL, 'workflow', 0, 1, 1, 0, '{\"name\":\"plg_workflow_featuring\",\"type\":\"plugin\",\"creationDate\":\"March 2020\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_FEATURING_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"featuring\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10048, 0, 'plg_workflow_notification', 'plugin', 'notification', NULL, 'workflow', 0, 1, 1, 0, '{\"name\":\"plg_workflow_notification\",\"type\":\"plugin\",\"creationDate\":\"May 2020\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_NOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"notification\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(106, 0, 'lib_phpass', 'library', 'phpass', NULL, '', 0, 1, 1, 1, '{\"name\":\"lib_phpass\",\"type\":\"library\",\"creationDate\":\"2004-2006\",\"author\":\"Solar Designer\",\"copyright\":\"\",\"authorEmail\":\"solar@openwall.com\",\"authorUrl\":\"https:\\/\\/www.openwall.com\\/phpass\\/\",\"version\":\"0.3\",\"description\":\"LIB_PHPASS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpass\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(200, 0, 'mod_articles_archive', 'module', 'mod_articles_archive', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_archive\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(201, 0, 'mod_articles_latest', 'module', 'mod_articles_latest', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_latest\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(202, 0, 'mod_articles_popular', 'module', 'mod_articles_popular', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_popular\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(203, 0, 'mod_banners', 'module', 'mod_banners', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_banners\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(204, 0, 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_breadcrumbs\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(205, 0, 'mod_custom', 'module', 'mod_custom', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(206, 0, 'mod_feed', 'module', 'mod_feed', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(207, 0, 'mod_footer', 'module', 'mod_footer', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_footer\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(208, 0, 'mod_login', 'module', 'mod_login', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(209, 0, 'mod_menu', 'module', 'mod_menu', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(210, 0, 'mod_articles_news', 'module', 'mod_articles_news', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_news\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(211, 0, 'mod_random_image', 'module', 'mod_random_image', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"July 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_random_image\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(212, 0, 'mod_related_items', 'module', 'mod_related_items', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_related_items\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(213, 10088, 'mod_search', 'module', 'mod_search', '', '', 0, 1, 1, 0, '{\"name\":\"mod_search\",\"type\":\"module\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"filename\":\"mod_search\"}', '', '', NULL, NULL, 0, 0, NULL, 0),
(214, 0, 'mod_stats', 'module', 'mod_stats', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(215, 0, 'mod_syndicate', 'module', 'mod_syndicate', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"May 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_syndicate\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(216, 0, 'mod_users_latest', 'module', 'mod_users_latest', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"December 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_users_latest\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(218, 0, 'mod_whosonline', 'module', 'mod_whosonline', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_whosonline\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(219, 0, 'mod_wrapper', 'module', 'mod_wrapper', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"October 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_wrapper\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(220, 0, 'mod_articles_category', 'module', 'mod_articles_category', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_category\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(221, 0, 'mod_articles_categories', 'module', 'mod_articles_categories', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_articles_categories\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(222, 0, 'mod_languages', 'module', 'mod_languages', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"February 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_languages\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(223, 0, 'mod_finder', 'module', 'mod_finder', NULL, '', 0, 1, 0, 0, '{\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_finder\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(300, 0, 'mod_custom', 'module', 'mod_custom', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_custom\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(301, 0, 'mod_feed', 'module', 'mod_feed', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"July 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_feed\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(302, 0, 'mod_latest', 'module', 'mod_latest', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_latest\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(303, 0, 'mod_logged', 'module', 'mod_logged', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"January 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_logged\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(304, 0, 'mod_login', 'module', 'mod_login', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"March 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_login\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(305, 0, 'mod_menu', 'module', 'mod_menu', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_menu\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(307, 0, 'mod_popular', 'module', 'mod_popular', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_popular\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(308, 0, 'mod_quickicon', 'module', 'mod_quickicon', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_quickicon\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10068, 0, 'plg_webservices_banners', 'plugin', 'banners', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_banners\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"banners\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10069, 0, 'plg_webservices_config', 'plugin', 'config', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_config\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"config\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10070, 0, 'plg_webservices_contact', 'plugin', 'contact', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_contact\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10071, 0, 'plg_webservices_languages', 'plugin', 'languages', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_languages\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languages\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(311, 0, 'mod_title', 'module', 'mod_title', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_title\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(312, 0, 'mod_toolbar', 'module', 'mod_toolbar', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_toolbar\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(313, 0, 'mod_multilangstatus', 'module', 'mod_multilangstatus', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"September 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_multilangstatus\"}', '{\"cache\":\"0\"}', '', NULL, NULL, 0, 0, NULL, 1),
(314, 0, 'mod_version', 'module', 'mod_version', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"January 2012\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_version\"}', '{\"format\":\"short\",\"product\":\"1\",\"cache\":\"0\"}', '', NULL, NULL, 0, 0, NULL, 1),
(315, 0, 'mod_stats_admin', 'module', 'mod_stats_admin', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_stats_admin\",\"type\":\"module\",\"creationDate\":\"July 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_stats_admin\"}', '{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"0\",\"increase\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', NULL, NULL, 0, 0, NULL, 1),
(316, 0, 'mod_tags_popular', 'module', 'mod_tags_popular', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_tags_popular\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_popular\"}', '{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"owncache\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(317, 0, 'mod_tags_similar', 'module', 'mod_tags_similar', NULL, '', 0, 1, 1, 0, '{\"name\":\"mod_tags_similar\",\"type\":\"module\",\"creationDate\":\"January 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_SIMILAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_tags_similar\"}', '{\"maximum\":\"5\",\"matchtype\":\"any\",\"owncache\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(318, 0, 'mod_sampledata', 'module', 'mod_sampledata', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_sampledata\",\"type\":\"module\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"MOD_SAMPLEDATA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sampledata\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(319, 0, 'mod_latestactions', 'module', 'mod_latestactions', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_latestactions\",\"type\":\"module\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_LATESTACTIONS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_latestactions\"}', '{}', '', NULL, '1970-01-01 00:00:00', 0, 0, NULL, 1);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `changelogurl`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `checked_out`, `checked_out_time`, `ordering`, `state`, `note`, `locked`) VALUES
(320, 0, 'mod_privacy_dashboard', 'module', 'mod_privacy_dashboard', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_privacy_dashboard\",\"type\":\"module\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_PRIVACY_DASHBOARD_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_privacy_dashboard\"}', '{}', '', NULL, '1970-01-01 00:00:00', 0, 0, NULL, 1),
(401, 0, 'plg_authentication_joomla', 'plugin', 'joomla', NULL, 'authentication', 0, 1, 1, 1, '{\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(402, 0, 'plg_authentication_ldap', 'plugin', 'ldap', NULL, 'authentication', 0, 0, 1, 0, '{\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"ldap\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', NULL, NULL, 3, 0, NULL, 1),
(403, 0, 'plg_content_contact', 'plugin', 'contact', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_contact\",\"type\":\"plugin\",\"creationDate\":\"January 2014\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2014 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.2\",\"description\":\"PLG_CONTENT_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(404, 0, 'plg_content_emailcloak', 'plugin', 'emailcloak', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"emailcloak\"}', '{\"mode\":\"1\"}', '', NULL, NULL, 1, 0, NULL, 1),
(406, 0, 'plg_content_loadmodule', 'plugin', 'loadmodule', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"loadmodule\"}', '{\"style\":\"xhtml\"}', '', NULL, '2011-09-18 15:22:50', 0, 0, NULL, 1),
(407, 0, 'plg_content_pagebreak', 'plugin', 'pagebreak', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', NULL, NULL, 4, 0, NULL, 1),
(408, 0, 'plg_content_pagenavigation', 'plugin', 'pagenavigation', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"January 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagenavigation\"}', '{\"position\":\"1\"}', '', NULL, NULL, 5, 0, NULL, 1),
(409, 0, 'plg_content_vote', 'plugin', 'vote', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"vote\"}', '', '', NULL, NULL, 6, 0, NULL, 1),
(410, 0, 'plg_editors_codemirror', 'plugin', 'codemirror', NULL, 'editors', 0, 1, 1, 0, '{\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"Copyright (C) 2014 - 2021 by Marijn Haverbeke <marijnh@gmail.com> and others\",\"authorEmail\":\"marijnh@gmail.com\",\"authorUrl\":\"https:\\/\\/codemirror.net\\/\",\"version\":\"5.65.2\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"codemirror\"}', '{\"lineNumbers\":\"1\",\"lineWrapping\":\"1\",\"matchTags\":\"1\",\"matchBrackets\":\"1\",\"marker-gutter\":\"1\",\"autoCloseTags\":\"1\",\"autoCloseBrackets\":\"1\",\"autoFocus\":\"1\",\"theme\":\"default\",\"tabmode\":\"indent\"}', '', NULL, NULL, 1, 0, NULL, 1),
(411, 0, 'plg_editors_none', 'plugin', 'none', NULL, 'editors', 0, 1, 1, 1, '{\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"September 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"none\"}', '', '', NULL, NULL, 2, 0, NULL, 1),
(412, 0, 'plg_editors_tinymce', 'plugin', 'tinymce', NULL, 'editors', 0, 1, 1, 0, '{\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-2021\",\"author\":\"Tiny Technologies, Inc\",\"copyright\":\"Tiny Technologies, Inc\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"https:\\/\\/www.tiny.cloud\",\"version\":\"5.10.3\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tinymce\"}', '{\"configuration\":{\"toolbars\":{\"2\":{\"toolbar1\":[\"bold\",\"underline\",\"strikethrough\",\"|\",\"undo\",\"redo\",\"|\",\"bullist\",\"numlist\",\"|\",\"pastetext\"]},\"1\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"formatselect\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"code\",\"|\",\"hr\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"pastetext\",\"preview\"]},\"0\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"styleselect\",\"|\",\"formatselect\",\"fontselect\",\"fontsizeselect\",\"|\",\"searchreplace\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"image\",\"|\",\"code\",\"|\",\"forecolor\",\"backcolor\",\"|\",\"fullscreen\",\"|\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"emoticons\",\"media\",\"hr\",\"ltr\",\"rtl\",\"|\",\"cut\",\"copy\",\"paste\",\"pastetext\",\"|\",\"visualchars\",\"visualblocks\",\"nonbreaking\",\"blockquote\",\"template\",\"|\",\"print\",\"preview\",\"codesample\",\"insertdatetime\",\"removeformat\"]}},\"setoptions\":{\"2\":{\"access\":[\"1\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"0\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"1\":{\"access\":[\"6\",\"2\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"0\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"0\":{\"access\":[\"7\",\"4\",\"8\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}}},\"sets_amount\":3,\"html_height\":\"550\",\"html_width\":\"750\"}', '', NULL, NULL, 3, 0, NULL, 1),
(413, 0, 'plg_editors-xtd_article', 'plugin', 'article', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"October 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"article\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(414, 0, 'plg_editors-xtd_image', 'plugin', 'image', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"image\"}', '', '', NULL, NULL, 2, 0, NULL, 1),
(415, 0, 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"August 2004\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"pagebreak\"}', '', '', NULL, NULL, 3, 0, NULL, 1),
(416, 0, 'plg_editors-xtd_readmore', 'plugin', 'readmore', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"March 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"readmore\"}', '', '', NULL, NULL, 4, 0, NULL, 1),
(417, 10088, 'plg_search_categories', 'plugin', 'categories', '', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_categories\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"PLG_SEARCH_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 0),
(418, 10088, 'plg_search_contacts', 'plugin', 'contacts', '', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_contacts\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"filename\":\"contacts\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 0),
(419, 10088, 'plg_search_content', 'plugin', 'content', '', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_content\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"PLG_SEARCH_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 0),
(420, 10088, 'plg_search_newsfeeds', 'plugin', 'newsfeeds', '', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{\"search_limit\":\"50\",\"search_content\":\"1\",\"search_archived\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 0),
(422, 0, 'plg_system_languagefilter', 'plugin', 'languagefilter', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"July 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagefilter\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(10038, 0, 'atum', 'template', 'atum', NULL, '', 1, 1, 1, 0, '{\"name\":\"atum\",\"type\":\"template\",\"creationDate\":\"September 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_ATUM_XML_DESCRIPTION\",\"group\":\"\",\"inheritable\":true,\"filename\":\"templateDetails\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10039, 0, 'cassiopeia', 'template', 'cassiopeia', NULL, '', 0, 1, 1, 0, '{\"name\":\"cassiopeia\",\"type\":\"template\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_CASSIOPEIA_XML_DESCRIPTION\",\"group\":\"\",\"inheritable\":true,\"filename\":\"templateDetails\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(424, 0, 'plg_system_cache', 'plugin', 'cache', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"February 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cache\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', NULL, NULL, 9, 0, NULL, 1),
(425, 0, 'plg_system_debug', 'plugin', 'debug', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"debug\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', NULL, NULL, 4, 0, NULL, 1),
(426, 0, 'plg_system_log', 'plugin', 'log', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"log\"}', '', '', NULL, NULL, 5, 0, NULL, 1),
(427, 0, 'plg_system_redirect', 'plugin', 'redirect', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"redirect\"}', '', '', NULL, NULL, 6, 0, NULL, 1),
(428, 0, 'plg_system_remember', 'plugin', 'remember', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"April 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"remember\"}', '', '', NULL, NULL, 7, 0, NULL, 1),
(429, 0, 'plg_system_sef', 'plugin', 'sef', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"December 2007\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sef\"}', '', '', NULL, NULL, 8, 0, NULL, 1),
(430, 0, 'plg_system_logout', 'plugin', 'logout', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"April 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logout\"}', '', '', NULL, NULL, 3, 0, NULL, 1),
(431, 0, 'plg_user_contactcreator', 'plugin', 'contactcreator', NULL, 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"August 2009\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contactcreator\"}', '{\"autowebpage\":\"\",\"category\":\"34\",\"autopublish\":\"0\"}', '', NULL, NULL, 1, 0, NULL, 1),
(432, 0, 'plg_user_joomla', 'plugin', 'joomla', NULL, 'user', 0, 1, 1, 0, '{\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"December 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{\"autoregister\":\"1\",\"mail_to_user\":\"1\",\"forceLogout\":\"1\"}', '', NULL, NULL, 2, 0, NULL, 1),
(433, 0, 'plg_user_profile', 'plugin', 'profile', NULL, 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"January 2008\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"profile\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(434, 0, 'plg_extension_joomla', 'plugin', 'joomla', NULL, 'extension', 0, 1, 1, 0, '{\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"May 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(435, 0, 'plg_content_joomla', 'plugin', 'joomla', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"November 2010\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(436, 0, 'plg_system_languagecode', 'plugin', 'languagecode', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"November 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"languagecode\"}', '', '', NULL, NULL, 10, 0, NULL, 1),
(437, 0, 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', NULL, 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomlaupdate\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(438, 0, 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', NULL, 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"extensionupdate\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(439, 0, 'plg_captcha_recaptcha', 'plugin', 'recaptcha', NULL, 'captcha', 0, 0, 1, 0, '{\"name\":\"plg_captcha_recaptcha\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.4.0\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"recaptcha\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', NULL, NULL, 0, 0, NULL, 1),
(440, 0, 'plg_system_highlight', 'plugin', 'highlight', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"highlight\"}', '', '', NULL, NULL, 7, 0, NULL, 1),
(441, 0, 'plg_content_finder', 'plugin', 'finder', NULL, 'content', 0, 0, 1, 0, '{\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"December 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(442, 0, 'plg_finder_categories', 'plugin', 'categories', NULL, 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"categories\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(443, 0, 'plg_finder_contacts', 'plugin', 'contacts', NULL, 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contacts\"}', '', '', NULL, NULL, 2, 0, NULL, 1),
(444, 0, 'plg_finder_content', 'plugin', 'content', NULL, 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '', '', NULL, NULL, 3, 0, NULL, 1),
(445, 0, 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', NULL, 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"August 2011\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '', '', NULL, NULL, 4, 0, NULL, 1),
(447, 0, 'plg_finder_tags', 'plugin', 'tags', NULL, 'finder', 0, 1, 1, 0, '{\"name\":\"plg_finder_tags\",\"type\":\"plugin\",\"creationDate\":\"February 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(448, 0, 'plg_twofactorauth_totp', 'plugin', 'totp', NULL, 'twofactorauth', 0, 0, 1, 0, '{\"name\":\"plg_twofactorauth_totp\",\"type\":\"plugin\",\"creationDate\":\"August 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_TOTP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"totp\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(449, 0, 'plg_authentication_cookie', 'plugin', 'cookie', NULL, 'authentication', 0, 1, 1, 0, '{\"name\":\"plg_authentication_cookie\",\"type\":\"plugin\",\"creationDate\":\"July 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_COOKIE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"cookie\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(450, 0, 'plg_twofactorauth_yubikey', 'plugin', 'yubikey', NULL, 'twofactorauth', 0, 0, 1, 0, '{\"name\":\"plg_twofactorauth_yubikey\",\"type\":\"plugin\",\"creationDate\":\"September 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_TWOFACTORAUTH_YUBIKEY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"yubikey\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(451, 10088, 'plg_search_tags', 'plugin', 'tags', '', 'search', 0, 1, 1, 0, '{\"name\":\"plg_search_tags\",\"type\":\"plugin\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2014 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0-dev\",\"description\":\"\",\"group\":\"\",\"filename\":\"tags\"}', '{\"search_limit\":\"50\",\"show_tagged_items\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 0),
(452, 0, 'plg_system_updatenotification', 'plugin', 'updatenotification', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_updatenotification\",\"type\":\"plugin\",\"creationDate\":\"May 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2015 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_UPDATENOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"updatenotification\"}', '{\"lastrun\":1657109078}', '', NULL, NULL, 0, 0, NULL, 1),
(453, 0, 'plg_editors-xtd_module', 'plugin', 'module', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_module\",\"type\":\"plugin\",\"creationDate\":\"October 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2015 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_MODULE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"module\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(454, 0, 'plg_system_stats', 'plugin', 'stats', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_stats\",\"type\":\"plugin\",\"creationDate\":\"November 2013\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_STATS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"stats\"}', '{\"mode\":3,\"lastrun\":\"\",\"unique_id\":\"6d30f13db174eb0c94efb885594275cd80da3e3a\",\"interval\":12}', '', NULL, NULL, 0, 0, NULL, 1),
(455, 0, 'plg_installer_packageinstaller', 'plugin', 'packageinstaller', NULL, 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_packageinstaller\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"packageinstaller\"}', '', '', NULL, NULL, 1, 0, NULL, 1),
(456, 0, 'plg_installer_folderinstaller', 'plugin', 'folderinstaller', NULL, 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_folderinstaller\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"folderinstaller\"}', '', '', NULL, NULL, 2, 0, NULL, 1),
(457, 0, 'plg_installer_urlinstaller', 'plugin', 'urlinstaller', NULL, 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_urlinstaller\",\"type\":\"plugin\",\"creationDate\":\"May 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"urlinstaller\"}', '', '', NULL, NULL, 3, 0, NULL, 1),
(458, 0, 'plg_quickicon_phpversioncheck', 'plugin', 'phpversioncheck', NULL, 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_phpversioncheck\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"phpversioncheck\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(459, 0, 'plg_editors-xtd_menu', 'plugin', 'menu', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_menu\",\"type\":\"plugin\",\"creationDate\":\"August 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"menu\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(460, 0, 'plg_editors-xtd_contact', 'plugin', 'contact', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_contact\",\"type\":\"plugin\",\"creationDate\":\"October 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(461, 0, 'plg_system_fields', 'plugin', 'fields', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_fields\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_SYSTEM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(462, 0, 'plg_fields_calendar', 'plugin', 'calendar', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_calendar\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CALENDAR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"calendar\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(463, 0, 'plg_fields_checkboxes', 'plugin', 'checkboxes', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_checkboxes\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"checkboxes\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(464, 0, 'plg_fields_color', 'plugin', 'color', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_color\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_COLOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"color\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(465, 0, 'plg_fields_editor', 'plugin', 'editor', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_editor\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_EDITOR_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"editor\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(466, 0, 'plg_fields_imagelist', 'plugin', 'imagelist', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_imagelist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"imagelist\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(467, 0, 'plg_fields_integer', 'plugin', 'integer', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_integer\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_INTEGER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"integer\"}', '{\"multiple\":\"0\",\"first\":\"1\",\"last\":\"100\",\"step\":\"1\"}', '', NULL, NULL, 0, 0, NULL, 1),
(468, 0, 'plg_fields_list', 'plugin', 'list', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_list\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_LIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"list\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(469, 0, 'plg_fields_media', 'plugin', 'media', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_media\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(470, 0, 'plg_fields_radio', 'plugin', 'radio', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_radio\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"radio\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(471, 0, 'plg_fields_sql', 'plugin', 'sql', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_sql\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_SQL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sql\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(472, 0, 'plg_fields_text', 'plugin', 'text', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_text\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"text\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(473, 0, 'plg_fields_textarea', 'plugin', 'textarea', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_textarea\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"textarea\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(474, 0, 'plg_fields_url', 'plugin', 'url', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_url\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_URL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"url\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(475, 0, 'plg_fields_user', 'plugin', 'user', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_user\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(476, 0, 'plg_fields_usergrouplist', 'plugin', 'usergrouplist', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_usergrouplist\",\"type\":\"plugin\",\"creationDate\":\"March 2016\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"usergrouplist\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(477, 0, 'plg_content_fields', 'plugin', 'fields', NULL, 'content', 0, 1, 1, 0, '{\"name\":\"plg_content_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_CONTENT_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(478, 0, 'plg_editors-xtd_fields', 'plugin', 'fields', NULL, 'editors-xtd', 0, 1, 1, 0, '{\"name\":\"plg_editors-xtd_fields\",\"type\":\"plugin\",\"creationDate\":\"February 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"fields\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(479, 0, 'plg_sampledata_blog', 'plugin', 'blog', NULL, 'sampledata', 0, 1, 1, 0, '{\"name\":\"plg_sampledata_blog\",\"type\":\"plugin\",\"creationDate\":\"July 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"blog\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(480, 0, 'plg_system_sessiongc', 'plugin', 'sessiongc', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_sessiongc\",\"type\":\"plugin\",\"creationDate\":\"February 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.6\",\"description\":\"PLG_SYSTEM_SESSIONGC_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sessiongc\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(482, 0, 'plg_content_confirmconsent', 'plugin', 'confirmconsent', NULL, 'content', 0, 0, 1, 0, '{\"name\":\"plg_content_confirmconsent\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_CONTENT_CONFIRMCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"confirmconsent\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(483, 0, 'plg_system_actionlogs', 'plugin', 'actionlogs', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"actionlogs\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(484, 0, 'plg_actionlog_joomla', 'plugin', 'joomla', NULL, 'actionlog', 0, 1, 1, 0, '{\"name\":\"plg_actionlog_joomla\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_ACTIONLOG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"joomla\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(485, 0, 'plg_system_privacyconsent', 'plugin', 'privacyconsent', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"April 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacyconsent\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(486, 0, 'plg_system_logrotation', 'plugin', 'logrotation', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_logrotation\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_LOGROTATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"logrotation\"}', '{\"lastrun\":1657109083}', '', NULL, NULL, 0, 0, NULL, 1),
(487, 0, 'plg_privacy_user', 'plugin', 'user', NULL, 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_user\",\"type\":\"plugin\",\"creationDate\":\"May 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"user\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(488, 0, 'plg_quickicon_privacycheck', 'plugin', 'privacycheck', NULL, 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_privacycheck\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_QUICKICON_PRIVACYCHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacycheck\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(489, 0, 'plg_user_terms', 'plugin', 'terms', NULL, 'user', 0, 0, 1, 0, '{\"name\":\"plg_user_terms\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TERMS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"terms\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(490, 0, 'plg_privacy_contact', 'plugin', 'contact', NULL, 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_contact\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"contact\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(491, 0, 'plg_privacy_content', 'plugin', 'content', NULL, 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_content\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(492, 0, 'plg_privacy_message', 'plugin', 'message', NULL, 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_message\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_MESSAGE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"message\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1);
INSERT INTO `#__extensions` (`extension_id`, `package_id`, `name`, `type`, `element`, `changelogurl`, `folder`, `client_id`, `enabled`, `access`, `protected`, `manifest_cache`, `params`, `custom_data`, `checked_out`, `checked_out_time`, `ordering`, `state`, `note`, `locked`) VALUES
(493, 0, 'plg_privacy_actionlogs', 'plugin', 'actionlogs', NULL, 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"actionlogs\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(494, 0, 'plg_captcha_recaptcha_invisible', 'plugin', 'recaptcha_invisible', NULL, 'captcha', 0, 0, 1, 0, '{\"name\":\"plg_captcha_recaptcha_invisible\",\"type\":\"plugin\",\"creationDate\":\"November 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8\",\"description\":\"PLG_CAPTCHA_RECAPTCHA_INVISIBLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"recaptcha_invisible\"}', '{\"public_key\":\"\",\"private_key\":\"\",\"theme\":\"clean\"}', '', NULL, NULL, 0, 0, NULL, 1),
(495, 0, 'plg_privacy_consents', 'plugin', 'consents', NULL, 'privacy', 0, 1, 1, 0, '{\"name\":\"plg_privacy_consents\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONSENTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"consents\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(600, 802, 'English (en-GB)', 'language', 'en-GB', NULL, '', 0, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"June 2022\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.5\",\"description\":\"en-GB site language\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(601, 802, 'English (en-GB)', 'language', 'en-GB', NULL, '', 1, 1, 1, 1, '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"June 2022\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.5\",\"description\":\"en-GB administrator language\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(700, 0, 'files_joomla', 'file', 'joomla', NULL, '', 0, 1, 1, 1, '{\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"June 2022\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.5\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(802, 0, 'English (en-GB) Language Pack', 'package', 'pkg_en-GB', NULL, '', 0, 1, 1, 1, '{\"name\":\"English (en-GB) Language Pack\",\"type\":\"package\",\"creationDate\":\"June 2022\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.5.1\",\"description\":\"en-GB language pack\",\"group\":\"\",\"filename\":\"pkg_en-GB\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10000, 0, 'SP Page Builder', 'component', 'com_sppagebuilder', '', '', 1, 1, 0, 0, '{\"name\":\"SP Page Builder\",\"type\":\"component\",\"creationDate\":\"Sep 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (c) 2010 - 2022 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"3.8.7\",\"description\":\"\",\"group\":\"\",\"filename\":\"sppagebuilder\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10001, 0, 'SP Page Builder', 'module', 'mod_sppagebuilder', '', '', 0, 1, 0, 0, '{\"name\":\"SP Page Builder\",\"type\":\"module\",\"creationDate\":\"Oct 2016\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (c) 2010 - 2021 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.5\",\"description\":\"Module to display content from SP Page Builder\",\"group\":\"\",\"filename\":\"mod_sppagebuilder\"}', '{\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10002, 0, 'mod_sppagebuilder_icons', 'module', 'mod_sppagebuilder_icons', NULL, '', 1, 1, 2, 0, '{\"name\":\"mod_sppagebuilder_icons\",\"type\":\"module\",\"creationDate\":\"August 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2016 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.0.2\",\"description\":\"MOD_SPPAGEBUILDER_ICONS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sppagebuilder_icons\"}', '[]', '', NULL, NULL, 0, 0, NULL, 0),
(10003, 0, 'mod_sppagebuilder_admin_menu', 'module', 'mod_sppagebuilder_admin_menu', NULL, '', 1, 1, 2, 0, '{\"name\":\"mod_sppagebuilder_admin_menu\",\"type\":\"module\",\"creationDate\":\"August 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (c) 2010 - 2021 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"1.4\",\"description\":\"MOD_SPPAGEBUILDER_MENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_sppagebuilder_admin_menu\"}', '[]', '', NULL, NULL, 0, 0, NULL, 0),
(10099, 0, 'System - Helix Ultimate Framework', 'plugin', 'helixultimate', '', 'system', 0, 1, 1, 0, '{\"name\":\"System - Helix Ultimate Framework\",\"type\":\"plugin\",\"creationDate\":\"Feb 2018\",\"author\":\"JoomShaper.com\",\"copyright\":\"Copyright (C) 2010 - 2022 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"2.0.10\",\"description\":\"Helix Ultimate Framework - Joomla Template Framework by JoomShaper\",\"group\":\"\",\"filename\":\"helixultimate\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10007, 0, 'SP Simple Portfolio', 'component', 'com_spsimpleportfolio', '', '', 1, 0, 0, 0, '{\"name\":\"SP Simple Portfolio\",\"type\":\"component\",\"creationDate\":\"December 2015\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (c) 2010- 2022 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"2.0.6\",\"description\":\"Simple Portfolio Component for Joomla\",\"group\":\"\",\"filename\":\"spsimpleportfolio\"}', '{\"square\":\"600x600\",\"rectangle\":\"600x400\",\"tower\":\"600X800\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10008, 0, 'COM_SPEASYIMAGEGALLERY', 'component', 'com_speasyimagegallery', '', '', 1, 1, 0, 0, '{\"name\":\"COM_SPEASYIMAGEGALLERY\",\"type\":\"component\",\"creationDate\":\"Mar 2017\",\"author\":\"JoomShaper\",\"copyright\":\"@JoomShaper 2010 - 2021. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"2.0.2\",\"description\":\"A simple image gallery component for Joomla.\",\"group\":\"\",\"filename\":\"speasyimagegallery\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10009, 0, 'SP Easy Image Gallery Module', 'module', 'mod_speasyimagegallery', '', '', 0, 1, 0, 0, '{\"name\":\"SP Easy Image Gallery Module\",\"type\":\"module\",\"creationDate\":\"Mar 2016\",\"author\":\"JoomShaper\",\"copyright\":\"@JoomShaper 2010 - 2021. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"http:\\/\\/www.joomshaper.com\",\"version\":\"2.0.2\",\"description\":\"Module to display albums or album images from SP Easy Image Gallery component.\",\"group\":\"\",\"filename\":\"mod_speasyimagegallery\"}', '{\"layout\":\"album\",\"albums_column\":\"3\",\"albums_column_sm\":\"4\",\"albums_column_xs\":\"6\",\"albums_gutter\":\"20\",\"albums_gutter_sm\":\"15\",\"albums_gutter_xs\":\"10\",\"album_limit\":\"8\",\"album_layout\":\"default\",\"album_column\":\"3\",\"album_column_sm\":\"4\",\"album_column_xs\":\"6\",\"album_gutter\":\"20\",\"album_gutter_sm\":\"15\",\"album_gutter_xs\":\"10\",\"show_title\":\"1\",\"show_desc\":\"1\",\"show_count\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"itemid\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10010, 0, 'SP Simple Portfolio Module', 'module', 'mod_spsimpleportfolio', '', '', 0, 0, 0, 0, '{\"name\":\"SP Simple Portfolio Module\",\"type\":\"module\",\"creationDate\":\"December 2014\",\"author\":\"JoomShaper\",\"copyright\":\"Copyright (C) 2010 - 2022 JoomShaper. All rights reserved.\",\"authorEmail\":\"support@joomshaper.com\",\"authorUrl\":\"www.joomshaper.com\",\"version\":\"2.0.6\",\"description\":\"Module to display latest item from SP Simple Portfolio\",\"group\":\"\",\"filename\":\"mod_spsimpleportfolio\"}', '{\"show_filter\":\"1\",\"category_id\":\"\",\"layout_type\":\"default\",\"columns\":\"3\",\"thumbnail_type\":\"masonry\",\"popup_image\":\"default\",\"limit\":\"12\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10088, 0, 'pkg_search', 'package', 'pkg_search', NULL, '', 0, 1, 1, 0, '{\"name\":\"pkg_search\",\"type\":\"package\",\"creationDate\":\"17.08.2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters. All rights reserved.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"\",\"group\":\"\",\"filename\":\"pkg_search\"}', '', '', NULL, NULL, 0, 0, NULL, 0),
(10102, 0, 'JBusinessDirectory', 'component', 'com_jbusinessdirectory', '', '', 1, 1, 0, 0, '{\"name\":\"JBusinessDirectory\",\"type\":\"component\",\"creationDate\":\"November 2011\",\"author\":\"CMSJunkie\",\"copyright\":\"(C) CMSJunkie. All rights reserved.\",\"authorEmail\":\"info@cmsjunkie.com\",\"authorUrl\":\"www.cmsjunkie.com\",\"version\":\"5.7.5\",\"description\":\"JBusinessDirectory\",\"group\":\"\",\"filename\":\"jbusinessdirectory\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10016, 0, 'JBusinessDirectory Events Search', 'module', 'mod_jbusiness_event_search', '', '', 0, 1, 0, 0, '{\"name\":\"JBusinessDirectory Events Search\",\"type\":\"module\",\"creationDate\":\"January 2015\",\"author\":\"CMSJunkie\",\"copyright\":\"(C) CMSJunkie. All rights reserved.\",\"authorEmail\":\"info@cmsjunkie.com\",\"authorUrl\":\"www.cmsjunkie.com\",\"version\":\"1.0.0\",\"description\":\"Search module for events\",\"group\":\"\",\"filename\":\"mod_jbusiness_event_search\"}', '{\"layout-type\":\"horizontal\",\"bg-color\":\"\",\"customAttributes\":\"\",\"radius\":\"0\",\"showMap\":\"0\",\"mapHeight\":\"450px\",\"mapWidth\":\"100%\",\"maxEvents\":\"250\",\"minLetters\":\"3\",\"showOnlyMap\":\"0\",\"enableAutosuggestion\":\"1\",\"showKeyword\":\"1\",\"mandatoryKeyword\":\"0\",\"enableKeywordSuggestion\":\"1\",\"showCategories\":\"1\",\"mandatoryCategories\":\"0\",\"showSubCategories\":\"1\",\"availableCategories\":\"\",\"showTypes\":\"1\",\"mandatoryTypes\":\"0\",\"showDateRange\":\"1\",\"mandatoryDateRange\":\"0\",\"showCities\":\"1\",\"mandatoryCities\":\"0\",\"showRegions\":\"0\",\"mandatoryRegions\":\"0\",\"showCountries\":\"0\",\"mandatoryCountries\":\"0\",\"showZipcode\":\"1\",\"mandatoryZipCode\":\"0\",\"showProvince\":\"1\",\"mandatoryProvince\":\"0\",\"linklocation\":\"0\",\"autocomplete\":\"0\",\"preserve\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10017, 0, 'JBusinessDirectory - Events', 'module', 'mod_jbusiness_events', '', '', 0, 1, 0, 0, '{\"name\":\"JBusinessDirectory - Events\",\"type\":\"module\",\"creationDate\":\"August 2015\",\"author\":\"CMSJunkie\",\"copyright\":\"(C) CMSJunkie. All rights reserved.\",\"authorEmail\":\"info@cmsjunkie.com\",\"authorUrl\":\"www.cmsjunkie.com\",\"version\":\"3.1.0\",\"description\":\"Display the events based on selected criterias\",\"group\":\"\",\"filename\":\"mod_jbusiness_events\"}', '{\"viewtype\":\"default\",\"layout-type\":\"horizontal\",\"categoryIds\":\"\",\"city\":\"\",\"region\":\"\",\"type\":\"\",\"count\":\"8\",\"only_featured\":\"0\",\"geo_location\":\"0\",\"radius\":\"100\",\"order\":\"0\",\"backgroundColor\":\"#EAEAEA\",\"borderColor\":\"#AAAAAA\",\"showviewall\":\"0\",\"showlistingName\":\"0\",\"showLocation\":\"0\",\"nrVisibleItems\":\"4\",\"nrItemsToScrool\":\"1\",\"autoplay\":\"0\",\"autoplaySpeed\":\"2000\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10018, 0, 'JBusinessDirectory - Business Listings', 'module', 'mod_jbusiness_listings', '', '', 0, 1, 0, 0, '{\"name\":\"JBusinessDirectory - Business Listings\",\"type\":\"module\",\"creationDate\":\"November 2013\",\"author\":\"CMSJunkie\",\"copyright\":\"(C) CMSJunkie. All rights reserved.\",\"authorEmail\":\"info@cmsjunkie.com\",\"authorUrl\":\"www.cmsjunkie.com\",\"version\":\"3.5.0\",\"description\":\"JBusinessDirectory\",\"group\":\"\",\"filename\":\"mod_jbusiness_listings\"}', '{\"viewtype\":\"simple\",\"layout-type\":\"horizontal\",\"link_target\":\"1\",\"categoryIds\":\"\",\"type\":\"\",\"city\":\"\",\"region\":\"\",\"country\":\"\",\"plan\":\"\",\"count\":\"8\",\"only_featured\":\"0\",\"only_campaign\":\"0\",\"only_with_logo\":\"0\",\"geo_location\":\"0\",\"nearby\":\"0\",\"radius\":\"100\",\"order\":\"0\",\"showviewall\":\"0\",\"backgroundColor\":\"#EAEAEA\",\"borderColor\":\"#AAAAAA\",\"nrVisibleItems\":\"4\",\"nrItemsToScrool\":\"1\",\"autoplay\":\"0\",\"autoplaySpeed\":\"2000\",\"max-numbers-row\":\"5\",\"image_size\":\"2\",\"show-header\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10019, 0, 'JBusinessDirectory Listing Search', 'module', 'mod_jbusiness_listings_search', '', '', 0, 1, 0, 0, '{\"name\":\"JBusinessDirectory Listing Search\",\"type\":\"module\",\"creationDate\":\"November 2011\",\"author\":\"CMSJunkie\",\"copyright\":\"(C) CMSJunkie. All rights reserved.\",\"authorEmail\":\"info@cmsjunkie.com\",\"authorUrl\":\"www.cmsjunkie.com\",\"version\":\"3.0.0\",\"description\":\"JBusinessDirectory\",\"group\":\"\",\"filename\":\"mod_jbusiness_listings_search\"}', '{\"base-layout\":\"standard\",\"layout-type\":\"horizontal\",\"bg-color\":\"\",\"customAttributes\":\"\",\"radius\":\"50\",\"max-radius\":\"300\",\"showMap\":\"0\",\"mapHeight\":\"450px\",\"mapWidth\":\"100%\",\"maxListings\":\"250\",\"minLetters\":\"3\",\"showOnlyMap\":\"0\",\"enableAutosuggestion\":\"1\",\"showKeyword\":\"1\",\"mandatoryKeyword\":\"0\",\"enableKeywordSuggestion\":\"1\",\"showCategories\":\"1\",\"mandatoryCategories\":\"0\",\"showSubCategories\":\"1\",\"separateCategories\":\"0\",\"availableCategories\":\"\",\"showTypes\":\"1\",\"mandatoryTypes\":\"0\",\"availableTypes\":\"\",\"showCities\":\"1\",\"mandatoryCities\":\"0\",\"showRegions\":\"0\",\"mandatoryRegions\":\"0\",\"showCountries\":\"0\",\"mandatoryCountries\":\"0\",\"showZipcode\":\"1\",\"mandatoryZipCode\":\"0\",\"mandatoryLocationSuggestion\":\"0\",\"showProvince\":\"0\",\"mandatoryProvince\":\"0\",\"autocomplete\":\"0\",\"autolocation\":\"0\",\"linklocation\":\"0\",\"preserve\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10020, 0, 'JBusinessDirectory Offer Search', 'module', 'mod_jbusiness_offer_search', '', '', 0, 1, 0, 0, '{\"name\":\"JBusinessDirectory Offer Search\",\"type\":\"module\",\"creationDate\":\"January 2015\",\"author\":\"CMSJunkie\",\"copyright\":\"(C) CMSJunkie. All rights reserved.\",\"authorEmail\":\"info@cmsjunkie.com\",\"authorUrl\":\"www.cmsjunkie.com\",\"version\":\"1.0.0\",\"description\":\"JBusinessDirectory Offer Search\",\"group\":\"\",\"filename\":\"mod_jbusiness_offer_search\"}', '{\"layout-type\":\"horizontal\",\"bg-color\":\"\",\"customAttributes\":\"\",\"radius\":\"0\",\"showMap\":\"0\",\"mapHeight\":\"450px\",\"mapWidth\":\"100%\",\"maxOffers\":\"250\",\"minLetters\":\"3\",\"showOnlyMap\":\"0\",\"enableAutosuggestion\":\"1\",\"showKeyword\":\"1\",\"mandatoryKeyword\":\"0\",\"enableKeywordSuggestion\":\"1\",\"showCategories\":\"1\",\"mandatoryCategories\":\"0\",\"showSubCategories\":\"1\",\"availableCategories\":\"\",\"showTypes\":\"1\",\"mandatoryTypes\":\"0\",\"showCities\":\"1\",\"mandatoryCities\":\"0\",\"showRegions\":\"0\",\"mandatoryRegions\":\"0\",\"showZipcode\":\"1\",\"mandatoryZipCode\":\"0\",\"showCountries\":\"0\",\"mandatoryCountries\":\"0\",\"showProvince\":\"1\",\"mandatoryProvince\":\"0\",\"showMinPrice\":\"0\",\"showMaxPrice\":\"0\",\"max-price\":\"1000\",\"linklocation\":\"0\",\"autocomplete\":\"0\",\"preserve\":\"1\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10021, 0, 'JBusinessDirectory - Offers', 'module', 'mod_jbusiness_offers', '', '', 0, 1, 0, 0, '{\"name\":\"JBusinessDirectory - Offers\",\"type\":\"module\",\"creationDate\":\"June 2014\",\"author\":\"CMSJunkie\",\"copyright\":\"(C) CMSJunkie. All rights reserved.\",\"authorEmail\":\"info@cmsjunkie.com\",\"authorUrl\":\"www.cmsjunkie.com\",\"version\":\"3.0.0\",\"description\":\"Display the offers based on selected criterias\",\"group\":\"\",\"filename\":\"mod_jbusiness_offers\"}', '{\"viewtype\":\"default\",\"layout-type\":\"horizontal\",\"categoryIds\":\"\",\"citySearch\":\"\",\"count\":\"5\",\"only_featured\":\"0\",\"geo_location\":\"0\",\"radius\":\"100\",\"order\":\"0\",\"itemId\":\"0\",\"backgroundColor\":\"#EAEAEA\",\"borderColor\":\"#AAAAAA\",\"showviewall\":\"0\",\"showlistingName\":\"0\",\"showLocation\":\"0\",\"showOfferFree\":\"1\",\"nrVisibleItems\":\"4\",\"nrItemsToScrool\":\"1\",\"autoplay\":\"0\",\"autoplaySpeed\":\"2000\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10022, 0, 'JBusinessDirectory - Progress', 'module', 'mod_jbusiness_progress', '', '', 0, 1, 0, 0, '{\"name\":\"JBusinessDirectory - Progress\",\"type\":\"module\",\"creationDate\":\"November 2013\",\"author\":\"CMSJunkie\",\"copyright\":\"(C) CMSJunkie. All rights reserved.\",\"authorEmail\":\"info@cmsjunkie.com\",\"authorUrl\":\"www.cmsjunkie.com\",\"version\":\"1.0.0\",\"description\":\"JBusinessDirectory - Progress\",\"group\":\"\",\"filename\":\"mod_jbusiness_progress\"}', '{\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10023, 0, 'JBusinessCategories', 'module', 'mod_jbusinesscategories', '', '', 0, 1, 0, 0, '{\"name\":\"JBusinessCategories\",\"type\":\"module\",\"creationDate\":\"January 2012\",\"author\":\"CMSJunkie\",\"copyright\":\"(C) CMSJunkie. All rights reserved.\",\"authorEmail\":\"info@cmsjunkie.com\",\"authorUrl\":\"www.cmsjunkie.com\",\"version\":\"1.1.0\",\"description\":\"JBusinessCategories\",\"group\":\"\",\"filename\":\"mod_jbusinesscategories\"}', '{\"viewtype\":\"menu\",\"categoryIds\":\"0\",\"showviewall\":\"0\",\"nrVisibleItems\":\"4\",\"nrItemsToScrool\":\"1\",\"autoplay\":\"0\",\"autoplaySpeed\":\"2000\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10024, 0, 'JBusinessCategoriesEvents', 'module', 'mod_jbusinesscategoriesevents', '', '', 0, 1, 0, 0, '{\"name\":\"JBusinessCategoriesEvents\",\"type\":\"module\",\"creationDate\":\"December 2015\",\"author\":\"CMSJunkie\",\"copyright\":\"(C) CMSJunkie. All rights reserved.\",\"authorEmail\":\"info@cmsjunkie.com\",\"authorUrl\":\"www.cmsjunkie.com\",\"version\":\"1.0.0\",\"description\":\"JBusinessCategoriesEvents\",\"group\":\"\",\"filename\":\"mod_jbusinesscategoriesevents\"}', '{\"viewtype\":\"menu\",\"categoryIds\":\"0\",\"showviewall\":\"0\",\"nrVisibleItems\":\"4\",\"nrItemsToScrool\":\"1\",\"autoplay\":\"0\",\"autoplaySpeed\":\"2000\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10025, 0, 'JBusinessCategoriesOffers', 'module', 'mod_jbusinesscategoriesoffers', '', '', 0, 1, 0, 0, '{\"name\":\"JBusinessCategoriesOffers\",\"type\":\"module\",\"creationDate\":\"July 2013\",\"author\":\"CMSJunkie\",\"copyright\":\"(C) CMSJunkie. All rights reserved.\",\"authorEmail\":\"info@cmsjunkie.com\",\"authorUrl\":\"www.cmsjunkie.com\",\"version\":\"1.0.0\",\"description\":\"JBusinessCategoriesOffers\",\"group\":\"\",\"filename\":\"mod_jbusinesscategoriesoffers\"}', '{\"viewtype\":\"menu\",\"categoryIds\":\"0\",\"showviewall\":\"0\",\"nrVisibleItems\":\"4\",\"nrItemsToScrool\":\"1\",\"autoplay\":\"0\",\"autoplaySpeed\":\"2000\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10104, 0, 'J-BusinessDirectory Url Translator', 'plugin', 'urltranslator', '', 'system', 0, 1, 1, 0, '{\"name\":\"J-BusinessDirectory Url Translator\",\"type\":\"plugin\",\"creationDate\":\"May 2012\",\"author\":\"CMS Junkie\",\"copyright\":\"(C) CMSJunkie. All rights reserved.\",\"authorEmail\":\"info@cmsjunkie.com\",\"authorUrl\":\"www.cmsjunkie.com\",\"version\":\"3.0.0\",\"description\":\"This plugin is used for url translation.\",\"group\":\"\",\"filename\":\"urltranslator\"}', '[]', '', NULL, NULL, 0, 0, NULL, 0),
(10103, 0, 'MOD_JBUSINESSDIRECTORY_ICONS', 'module', 'mod_jbusinessdirectory_icons', '', '', 1, 1, 2, 0, '{\"name\":\"MOD_JBUSINESSDIRECTORY_ICONS\",\"type\":\"module\",\"creationDate\":\"December 2015\",\"author\":\"CMSJunkie\",\"copyright\":\"(C) CMSJunkie. All rights reserved.\",\"authorEmail\":\"info@cmsjunkie.com\",\"authorUrl\":\"www.cmsjunkie.com\",\"version\":\"1.0.0\",\"description\":\"MOD_JBUSINESSDIRECTORY_ICONS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_jbusinessdirectory_icons\"}', '[]', '', NULL, NULL, 0, 0, NULL, 0),
(10028, 0, 'plg_system_hoolawhoops', 'plugin', 'hoolawhoops', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_hoolawhoops\",\"type\":\"plugin\",\"creationDate\":\"2019-02-09\",\"author\":\"Alexandre ELIS\\u00c9\",\"copyright\":\"Copyright (C) 2019 . Alexandre ELIS\\u00c9 (www.application2000.com). All rights reserved.\",\"authorEmail\":\"developpeur@application2000.com\",\"authorUrl\":\"www.application2000.com\",\"version\":\"1.1.0\",\"description\":\"HoolaWhoops - System plugin - Show pretty errors based on filp\\/whoops library\",\"group\":\"\",\"filename\":\"hoolawhoops\"}', '{\"pretty_debug\":1}', '', NULL, NULL, 0, 0, NULL, 0),
(10029, 0, 'mod_jbusiness_user', 'module', 'mod_jbusiness_user', '', '', 0, 1, 0, 0, '{\"name\":\"mod_jbusiness_user\",\"type\":\"module\",\"creationDate\":\"August 2019\",\"author\":\"CMSJunkie\",\"copyright\":\"Copyright (C) 2007 - 2019 CMSJunkie. All rights reserved.\",\"authorEmail\":\"info@cmsjunkie.com\",\"authorUrl\":\"www.cmsjunkie.com\",\"version\":\"2.3.2\",\"description\":\"Module for user login\\/register.\",\"group\":\"\",\"filename\":\"mod_jbusiness_user\"}', '{\"greeting\":\"1\",\"name\":\"0\",\"profilelink\":\"0\",\"usesecure\":\"0\",\"usetext\":\"0\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10098, 0, 'Home Page Slider', 'module', 'mod_showplus', '', '', 0, 1, 0, 0, '{\"name\":\"Home Page Slider\",\"type\":\"module\",\"creationDate\":\"Jan 23, 2022\",\"author\":\"Levente Hunyadi\",\"copyright\":\"\\u00a9 2011-2018 Levente Hunyadi. All rights reserved.\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/hunyadi.info.hu\\/projects\\/showplus\",\"version\":\"3.0.0\",\"description\":\"SHOWPLUS_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_showplus\"}', '{\"folder\":\"images\\/headers\",\"width\":\"100%\",\"height_desktop\":\"800px\",\"height_tablet\":\"400px\",\"height_mobile\":\"300px\",\"alignment\":\"center\",\"orientation\":\"horizontal-bottom\",\"autohide\":\"0\",\"buttons\":\"1\",\"captions\":\"1\",\"target\":\"_self\",\"delay\":\"3000\",\"duration\":\"800\",\"transition\":\"fade\",\"transition_easing\":\"linear\",\"transition_timing\":\"in:out\",\"margin\":\"\",\"border_style\":\"\",\"border_width\":\"\",\"border_color\":\"\",\"padding\":\"\",\"background_color\":\"\",\"thumb_width\":\"60\",\"thumb_height\":\"40\",\"links\":\"1\",\"thumb_cache\":\"1\",\"thumb_folder\":\"thumbs\",\"thumb_quality\":\"85\",\"labels\":\"labels\",\"labels_multilingual\":\"0\",\"sort_criterion\":\"labels-filename\",\"sort_order\":\"0\",\"library\":\"default\",\"debug\":\"0\",\"moduleclass_sfx\":\"\"}', '', NULL, NULL, 0, 0, NULL, 0),
(10031, 0, 'J-Network', 'template', 'j-network', NULL, '', 0, 1, 1, 0, '{\"name\":\"J-Network\",\"type\":\"template\",\"creationDate\":\"August 2019\",\"author\":\"CMS Junkie\",\"copyright\":\"Copyright (C) 2007 - 2019 JoomShaper.com. All rights reserved.\",\"authorEmail\":\"info@cmsjunkie.com\",\"authorUrl\":\"http:\\/\\/www.cmsjunkie.com\",\"version\":\"2.1.0\",\"description\":\"J-Network - creating communties\",\"group\":\"\",\"filename\":\"templateDetails\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10036, 0, 'plg_behaviour_taggable', 'plugin', 'taggable', NULL, 'behaviour', 0, 1, 1, 0, '{\"name\":\"plg_behaviour_taggable\",\"type\":\"plugin\",\"creationDate\":\"August 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_TAGGABLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"taggable\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10037, 0, 'plg_behaviour_versionable', 'plugin', 'versionable', NULL, 'behaviour', 0, 1, 1, 0, '{\"name\":\"plg_behaviour_versionable\",\"type\":\"plugin\",\"creationDate\":\"August 2015\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_VERSIONABLE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"versionable\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10040, 0, 'plg_filesystem_local', 'plugin', 'local', NULL, 'filesystem', 0, 1, 1, 0, '{\"name\":\"plg_filesystem_local\",\"type\":\"plugin\",\"creationDate\":\"April 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FILESYSTEM_LOCAL_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"local\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10041, 0, 'plg_media-action_crop', 'plugin', 'crop', NULL, 'media-action', 0, 1, 1, 0, '{\"name\":\"plg_media-action_crop\",\"type\":\"plugin\",\"creationDate\":\"January 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_CROP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"crop\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10042, 0, 'plg_media-action_resize', 'plugin', 'resize', NULL, 'media-action', 0, 1, 1, 0, '{\"name\":\"plg_media-action_resize\",\"type\":\"plugin\",\"creationDate\":\"January 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_RESIZE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"resize\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10043, 0, 'plg_media-action_rotate', 'plugin', 'rotate', NULL, 'media-action', 0, 1, 1, 0, '{\"name\":\"plg_media-action_rotate\",\"type\":\"plugin\",\"creationDate\":\"January 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_ROTATE_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"rotate\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10044, 0, 'plg_system_httpheaders', 'plugin', 'httpheaders', NULL, 'system', 0, 0, 1, 0, '{\"name\":\"plg_system_httpheaders\",\"type\":\"plugin\",\"creationDate\":\"October 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_HTTPHEADERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"httpheaders\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10049, 0, 'plg_extension_namespacemap', 'plugin', 'namespacemap', NULL, 'extension', 0, 1, 1, 1, '{\"name\":\"plg_extension_namespacemap\",\"type\":\"plugin\",\"creationDate\":\"May 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_NAMESPACEMAP_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"namespacemap\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10050, 0, 'plg_installer_override', 'plugin', 'override', NULL, 'installer', 0, 1, 1, 0, '{\"name\":\"plg_installer_override\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_OVERRIDE_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"override\"}', '', '', NULL, NULL, 4, 0, NULL, 1),
(10051, 0, 'plg_quickicon_overridecheck', 'plugin', 'overridecheck', NULL, 'quickicon', 0, 0, 1, 0, '{\"name\":\"plg_quickicon_overridecheck\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_OVERRIDECHECK_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"overridecheck\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10052, 0, 'plg_extension_finder', 'plugin', 'finder', NULL, 'extension', 0, 1, 1, 0, '{\"name\":\"plg_extension_finder\",\"type\":\"plugin\",\"creationDate\":\"June 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"finder\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10053, 0, 'plg_api-authentication_basic', 'plugin', 'basic', NULL, 'api-authentication', 0, 0, 1, 0, '{\"name\":\"plg_api-authentication_basic\",\"type\":\"plugin\",\"creationDate\":\"November 2005\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_BASIC_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"basic\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10054, 0, 'plg_webservices_content', 'plugin', 'content', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_content\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"content\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10055, 0, 'com_mails', 'component', 'com_mails', NULL, '', 1, 1, 1, 1, '{\"name\":\"com_mails\",\"type\":\"component\",\"creationDate\":\"January 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MAILS_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10056, 0, 'plg_system_skipto', 'plugin', 'skipto', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_skipto\",\"type\":\"plugin\",\"creationDate\":\"February 2020\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_SKIPTO_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"skipto\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10057, 0, 'plg_sampledata_multilang', 'plugin', 'multilang', NULL, 'sampledata', 0, 1, 1, 0, '{\"name\":\"plg_sampledata_multilang\",\"type\":\"plugin\",\"creationDate\":\"July 2018\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SAMPLEDATA_MULTILANG_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"multilang\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10058, 0, 'plg_installer_webinstaller', 'plugin', 'webinstaller', NULL, 'installer', 0, 0, 1, 0, '{\"name\":\"plg_installer_webinstaller\",\"type\":\"plugin\",\"creationDate\":\"April 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_WEBINSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"webinstaller\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10059, 0, 'plg_fields_subform', 'plugin', 'subform', NULL, 'fields', 0, 1, 1, 0, '{\"name\":\"plg_fields_subform\",\"type\":\"plugin\",\"creationDate\":\"June 2017\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FIELDS_SUBFORM_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"subform\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10060, 0, 'plg_system_webauthn', 'plugin', 'webauthn', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_webauthn\",\"type\":\"plugin\",\"creationDate\":\"2019-07-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_WEBAUTHN_DESCRIPTION\",\"group\":\"\",\"filename\":\"webauthn\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10061, 0, 'mod_loginsupport', 'module', 'mod_loginsupport', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_loginsupport\",\"type\":\"module\",\"creationDate\":\"June 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_LOGINSUPPORT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_loginsupport\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10062, 0, 'mod_frontend', 'module', 'mod_frontend', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_frontend\",\"type\":\"module\",\"creationDate\":\"July 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_FRONTEND_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_frontend\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10063, 0, 'mod_messages', 'module', 'mod_messages', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_messages\",\"type\":\"module\",\"creationDate\":\"July 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_messages\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10064, 0, 'mod_post_installation_messages', 'module', 'mod_post_installation_messages', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_post_installation_messages\",\"type\":\"module\",\"creationDate\":\"July2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_POST_INSTALLATION_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_post_installation_messages\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10065, 0, 'mod_user', 'module', 'mod_user', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_user\",\"type\":\"module\",\"creationDate\":\"July 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_USER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_user\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10066, 0, 'mod_submenu', 'module', 'mod_submenu', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"February 2006\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_submenu\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10067, 0, 'mod_privacy_status', 'module', 'mod_privacy_status', NULL, '', 1, 1, 1, 0, '{\"name\":\"mod_privacy_status\",\"type\":\"module\",\"creationDate\":\"July 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_PRIVACY_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"mod_privacy_status\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10072, 0, 'plg_webservices_menus', 'plugin', 'menus', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_menus\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"menus\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10073, 0, 'plg_webservices_messages', 'plugin', 'messages', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_messages\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"messages\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10074, 0, 'plg_webservices_modules', 'plugin', 'modules', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_modules\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"modules\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10075, 0, 'plg_webservices_newsfeeds', 'plugin', 'newsfeeds', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"newsfeeds\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10076, 0, 'plg_webservices_plugins', 'plugin', 'plugins', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_plugins\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PLUGINS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"plugins\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10077, 0, 'plg_webservices_privacy', 'plugin', 'privacy', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_privacy\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"privacy\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10078, 0, 'plg_webservices_redirect', 'plugin', 'redirect', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_redirect\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"redirect\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10079, 0, 'plg_webservices_tags', 'plugin', 'tags', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_tags\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tags\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10080, 0, 'plg_webservices_templates', 'plugin', 'templates', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_templates\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"templates\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10081, 0, 'plg_webservices_users', 'plugin', 'users', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_users\",\"type\":\"plugin\",\"creationDate\":\"September 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_USERS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"users\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10082, 0, 'plg_webservices_installer', 'plugin', 'installer', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_installer\",\"type\":\"plugin\",\"creationDate\":\"June 2020\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_INSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"installer\"}', '{}', '', NULL, NULL, 0, 0, NULL, 0),
(10083, 0, 'plg_user_token', 'plugin', 'token', NULL, 'user', 0, 1, 1, 0, '{\"name\":\"plg_user_token\",\"type\":\"plugin\",\"creationDate\":\"November 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"token\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10084, 0, 'plg_api-authentication_token', 'plugin', 'token', NULL, 'api-authentication', 0, 1, 1, 0, '{\"name\":\"plg_api-authentication_token\",\"type\":\"plugin\",\"creationDate\":\"November 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"token\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10087, 0, 'plg_quickicon_downloadkey', 'plugin', 'downloadkey', NULL, 'quickicon', 0, 1, 1, 0, '{\"name\":\"plg_quickicon_downloadkey\",\"type\":\"plugin\",\"creationDate\":\"October 2019\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_DOWNLOADKEY_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"downloadkey\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10089, 0, 'com_scheduler', 'component', 'com_scheduler', NULL, '', 1, 1, 1, 0, '{\"name\":\"com_scheduler\",\"type\":\"component\",\"creationDate\":\"July 2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.0\",\"description\":\"COM_SCHEDULER_XML_DESCRIPTION\",\"group\":\"\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1),
(10090, 0, 'plg_system_schedulerunner', 'plugin', 'schedulerunner', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_schedulerunner\",\"type\":\"plugin\",\"creationDate\":\"August 2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_SYSTEM_SCHEDULERUNNER_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"schedulerunner\"}', '{}', '', NULL, NULL, 15, 0, NULL, 0),
(10091, 0, 'plg_system_task_notification', 'plugin', 'tasknotification', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_task_notification\",\"type\":\"plugin\",\"creationDate\":\"September 2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_SYSTEM_TASK_NOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"tasknotification\"}', '', '', NULL, NULL, 22, 0, NULL, 1),
(10092, 0, 'plg_task_check_files', 'plugin', 'checkfiles', NULL, 'task', 0, 1, 1, 0, '{\"name\":\"plg_task_check_files\",\"type\":\"plugin\",\"creationDate\":\"August 2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_CHECK_FILES_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"checkfiles\"}', '{}', '', NULL, NULL, 15, 0, NULL, 0),
(10093, 0, 'plg_task_demo_tasks', 'plugin', 'demotasks', NULL, 'task', 0, 1, 1, 0, '{\"name\":\"plg_task_demo_tasks\",\"type\":\"plugin\",\"creationDate\":\"July 2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_DEMO_TASKS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"demotasks\"}', '{}', '', NULL, NULL, 15, 0, NULL, 0),
(10094, 0, 'plg_task_requests', 'plugin', 'requests', NULL, 'task', 0, 1, 1, 0, '{\"name\":\"plg_task_requests\",\"type\":\"plugin\",\"creationDate\":\"August 2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_REQUESTS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"requests\"}', '{}', '', NULL, NULL, 15, 0, NULL, 0),
(10095, 0, 'plg_task_site_status', 'plugin', 'sitestatus', NULL, 'task', 0, 1, 1, 0, '{\"name\":\"plg_task_site_status\",\"type\":\"plugin\",\"creationDate\":\"August 2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_SITE_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"sitestatus\"}', '{}', '', NULL, NULL, 15, 0, NULL, 0),
(10096, 0, 'plg_system_jooa11y', 'plugin', 'jooa11y', NULL, 'system', 0, 1, 1, 0, '{\"name\":\"plg_system_jooa11y\",\"type\":\"plugin\",\"creationDate\":\"February 2022\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_SYSTEM_JOOA11Y_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"jooa11y\"}', '', '', NULL, NULL, 0, 0, NULL, 1),
(10097, 0, 'plg_webservices_media', 'plugin', 'media', NULL, 'webservices', 0, 1, 1, 0, '{\"name\":\"plg_webservices_media\",\"type\":\"plugin\",\"creationDate\":\"May 2021\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.0\",\"description\":\"PLG_WEBSERVICES_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"filename\":\"media\"}', '{}', '', NULL, NULL, 0, 0, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__fields`
--

DROP TABLE IF EXISTS `#__fields`;
CREATE TABLE IF NOT EXISTS `#__fields` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `group_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `label` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `default_value` text COLLATE utf8mb4_unicode_ci,
  `type` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'text',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `required` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `fieldparams` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_time` datetime NOT NULL,
  `created_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1',
  `only_use_in_subform` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_user_id` (`created_user_id`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__fields_categories`
--

DROP TABLE IF EXISTS `#__fields_categories`;
CREATE TABLE IF NOT EXISTS `#__fields_categories` (
  `field_id` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`field_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__fields_groups`
--

DROP TABLE IF EXISTS `#__fields_groups`;
CREATE TABLE IF NOT EXISTS `#__fields_groups` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `asset_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `context` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int(11) NOT NULL DEFAULT '0',
  `params` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created` datetime NOT NULL,
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `modified` datetime NOT NULL,
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `access` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_created_by` (`created_by`),
  KEY `idx_access` (`access`),
  KEY `idx_context` (`context`(191)),
  KEY `idx_language` (`language`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__fields_values`
--

DROP TABLE IF EXISTS `#__fields_values`;
CREATE TABLE IF NOT EXISTS `#__fields_values` (
  `field_id` int(10) UNSIGNED NOT NULL,
  `item_id` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'Allow references to items which have strings as ids, eg. none db systems.',
  `value` text COLLATE utf8mb4_unicode_ci,
  KEY `idx_field_id` (`field_id`),
  KEY `idx_item_id` (`item_id`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__finder_filters`
--

DROP TABLE IF EXISTS `#__finder_filters`;
CREATE TABLE IF NOT EXISTS `#__finder_filters` (
  `filter_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '1',
  `created` datetime NOT NULL,
  `created_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `checked_out` int(10) UNSIGNED DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `map_count` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `data` text COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` mediumtext COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`filter_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__finder_links`
--

DROP TABLE IF EXISTS `#__finder_links`;
CREATE TABLE IF NOT EXISTS `#__finder_links` (
  `link_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `url` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `route` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title` varchar(400) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `indexdate` datetime NOT NULL,
  `md5sum` varchar(32) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `state` int(11) NOT NULL DEFAULT '1',
  `access` int(11) NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `publish_start_date` datetime DEFAULT NULL,
  `publish_end_date` datetime DEFAULT NULL,
  `start_date` datetime DEFAULT NULL,
  `end_date` datetime DEFAULT NULL,
  `list_price` double UNSIGNED NOT NULL DEFAULT '0',
  `sale_price` double UNSIGNED NOT NULL DEFAULT '0',
  `type_id` int(11) NOT NULL,
  `object` mediumblob NOT NULL,
  PRIMARY KEY (`link_id`),
  KEY `idx_type` (`type_id`),
  KEY `idx_title` (`title`(100)),
  KEY `idx_md5` (`md5sum`),
  KEY `idx_url` (`url`(75)),
  KEY `idx_published_list` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`list_price`),
  KEY `idx_published_sale` (`published`,`state`,`access`,`publish_start_date`,`publish_end_date`,`sale_price`),
  KEY `idx_language` (`language`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__finder_links_terms`
--

DROP TABLE IF EXISTS `#__finder_links_terms`;
CREATE TABLE IF NOT EXISTS `#__finder_links_terms` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `term_id` int(10) UNSIGNED NOT NULL,
  `weight` float UNSIGNED NOT NULL DEFAULT '0',
  PRIMARY KEY (`link_id`,`term_id`),
  KEY `idx_term_weight` (`term_id`,`weight`),
  KEY `idx_link_term_weight` (`link_id`,`term_id`,`weight`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__finder_logging`
--

DROP TABLE IF EXISTS `#__finder_logging`;
CREATE TABLE IF NOT EXISTS `#__finder_logging` (
  `searchterm` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `md5sum` varchar(32) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `query` blob NOT NULL,
  `hits` int(11) NOT NULL DEFAULT '1',
  `results` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`md5sum`),
  KEY `searchterm` (`searchterm`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__finder_taxonomy`
--

DROP TABLE IF EXISTS `#__finder_taxonomy`;
CREATE TABLE IF NOT EXISTS `#__finder_taxonomy` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `parent_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `path` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `access` tinyint(3) UNSIGNED NOT NULL DEFAULT '1',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_access` (`access`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`),
  KEY `idx_parent_published` (`parent_id`,`state`,`access`),
  KEY `idx_level` (`level`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__finder_taxonomy`
--

INSERT INTO `#__finder_taxonomy` (`id`, `parent_id`, `lft`, `rgt`, `level`, `path`, `title`, `alias`, `state`, `access`, `language`) VALUES
(1, 0, 0, 1, 0, '', 'ROOT', 'root', 1, 1, '*');

-- --------------------------------------------------------

--
-- Table structure for table `#__finder_taxonomy_map`
--

DROP TABLE IF EXISTS `#__finder_taxonomy_map`;
CREATE TABLE IF NOT EXISTS `#__finder_taxonomy_map` (
  `link_id` int(10) UNSIGNED NOT NULL,
  `node_id` int(10) UNSIGNED NOT NULL,
  PRIMARY KEY (`link_id`,`node_id`),
  KEY `link_id` (`link_id`),
  KEY `node_id` (`node_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__finder_terms`
--

DROP TABLE IF EXISTS `#__finder_terms`;
CREATE TABLE IF NOT EXISTS `#__finder_terms` (
  `term_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `term` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `stem` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `common` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `phrase` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `weight` float UNSIGNED NOT NULL DEFAULT '0',
  `soundex` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `links` int(10) NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`term_id`),
  UNIQUE KEY `idx_term_language` (`term`,`language`),
  KEY `idx_term_phrase` (`term`,`phrase`),
  KEY `idx_stem_phrase` (`stem`,`phrase`),
  KEY `idx_soundex_phrase` (`soundex`,`phrase`),
  KEY `idx_stem` (`stem`),
  KEY `idx_language` (`language`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__finder_terms_common`
--

DROP TABLE IF EXISTS `#__finder_terms_common`;
CREATE TABLE IF NOT EXISTS `#__finder_terms_common` (
  `term` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `custom` int(11) NOT NULL DEFAULT '0',
  UNIQUE KEY `idx_term_language` (`term`,`language`),
  KEY `idx_lang` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__finder_terms_common`
--

INSERT INTO `#__finder_terms_common` (`term`, `language`, `custom`) VALUES
('a', 'en', 0),
('about', 'en', 0),
('above', 'en', 0),
('after', 'en', 0),
('again', 'en', 0),
('against', 'en', 0),
('all', 'en', 0),
('am', 'en', 0),
('an', 'en', 0),
('and', 'en', 0),
('any', 'en', 0),
('are', 'en', 0),
('aren\'t', 'en', 0),
('as', 'en', 0),
('at', 'en', 0),
('be', 'en', 0),
('because', 'en', 0),
('been', 'en', 0),
('before', 'en', 0),
('being', 'en', 0),
('below', 'en', 0),
('between', 'en', 0),
('both', 'en', 0),
('but', 'en', 0),
('by', 'en', 0),
('can\'t', 'en', 0),
('cannot', 'en', 0),
('could', 'en', 0),
('couldn\'t', 'en', 0),
('did', 'en', 0),
('didn\'t', 'en', 0),
('do', 'en', 0),
('does', 'en', 0),
('doesn\'t', 'en', 0),
('doing', 'en', 0),
('don\'t', 'en', 0),
('down', 'en', 0),
('during', 'en', 0),
('each', 'en', 0),
('few', 'en', 0),
('for', 'en', 0),
('from', 'en', 0),
('further', 'en', 0),
('had', 'en', 0),
('hadn\'t', 'en', 0),
('has', 'en', 0),
('hasn\'t', 'en', 0),
('have', 'en', 0),
('haven\'t', 'en', 0),
('having', 'en', 0),
('he', 'en', 0),
('he\'d', 'en', 0),
('he\'ll', 'en', 0),
('he\'s', 'en', 0),
('her', 'en', 0),
('here', 'en', 0),
('here\'s', 'en', 0),
('hers', 'en', 0),
('herself', 'en', 0),
('him', 'en', 0),
('himself', 'en', 0),
('his', 'en', 0),
('how', 'en', 0),
('how\'s', 'en', 0),
('i', 'en', 0),
('i\'d', 'en', 0),
('i\'ll', 'en', 0),
('i\'m', 'en', 0),
('i\'ve', 'en', 0),
('if', 'en', 0),
('in', 'en', 0),
('into', 'en', 0),
('is', 'en', 0),
('isn\'t', 'en', 0),
('it', 'en', 0),
('it\'s', 'en', 0),
('its', 'en', 0),
('itself', 'en', 0),
('let\'s', 'en', 0),
('me', 'en', 0),
('more', 'en', 0),
('most', 'en', 0),
('mustn\'t', 'en', 0),
('my', 'en', 0),
('myself', 'en', 0),
('no', 'en', 0),
('nor', 'en', 0),
('not', 'en', 0),
('of', 'en', 0),
('off', 'en', 0),
('on', 'en', 0),
('once', 'en', 0),
('only', 'en', 0),
('or', 'en', 0),
('other', 'en', 0),
('ought', 'en', 0),
('our', 'en', 0),
('ours', 'en', 0),
('ourselves', 'en', 0),
('out', 'en', 0),
('over', 'en', 0),
('own', 'en', 0),
('same', 'en', 0),
('shan\'t', 'en', 0),
('she', 'en', 0),
('she\'d', 'en', 0),
('she\'ll', 'en', 0),
('she\'s', 'en', 0),
('should', 'en', 0),
('shouldn\'t', 'en', 0),
('so', 'en', 0),
('some', 'en', 0),
('such', 'en', 0),
('than', 'en', 0),
('that', 'en', 0),
('that\'s', 'en', 0),
('the', 'en', 0),
('their', 'en', 0),
('theirs', 'en', 0),
('them', 'en', 0),
('themselves', 'en', 0),
('then', 'en', 0),
('there', 'en', 0),
('there\'s', 'en', 0),
('these', 'en', 0),
('they', 'en', 0),
('they\'d', 'en', 0),
('they\'ll', 'en', 0),
('they\'re', 'en', 0),
('they\'ve', 'en', 0),
('this', 'en', 0),
('those', 'en', 0),
('through', 'en', 0),
('to', 'en', 0),
('too', 'en', 0),
('under', 'en', 0),
('until', 'en', 0),
('up', 'en', 0),
('very', 'en', 0),
('was', 'en', 0),
('wasn\'t', 'en', 0),
('we', 'en', 0),
('we\'d', 'en', 0),
('we\'ll', 'en', 0),
('we\'re', 'en', 0),
('we\'ve', 'en', 0),
('were', 'en', 0),
('weren\'t', 'en', 0),
('what', 'en', 0),
('what\'s', 'en', 0),
('when', 'en', 0),
('when\'s', 'en', 0),
('where', 'en', 0),
('where\'s', 'en', 0),
('which', 'en', 0),
('while', 'en', 0),
('who', 'en', 0),
('who\'s', 'en', 0),
('whom', 'en', 0),
('why', 'en', 0),
('why\'s', 'en', 0),
('with', 'en', 0),
('won\'t', 'en', 0),
('would', 'en', 0),
('wouldn\'t', 'en', 0),
('you', 'en', 0),
('you\'d', 'en', 0),
('you\'ll', 'en', 0),
('you\'re', 'en', 0),
('you\'ve', 'en', 0),
('your', 'en', 0),
('yours', 'en', 0),
('yourself', 'en', 0),
('yourselves', 'en', 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__finder_tokens`
--

DROP TABLE IF EXISTS `#__finder_tokens`;
CREATE TABLE IF NOT EXISTS `#__finder_tokens` (
  `term` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `stem` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `common` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `phrase` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `weight` float UNSIGNED NOT NULL DEFAULT '1',
  `context` tinyint(1) UNSIGNED NOT NULL DEFAULT '2',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  KEY `idx_word` (`term`),
  KEY `idx_context` (`context`),
  KEY `idx_stem` (`stem`),
  KEY `idx_language` (`language`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__finder_tokens_aggregate`
--

DROP TABLE IF EXISTS `#__finder_tokens_aggregate`;
CREATE TABLE IF NOT EXISTS `#__finder_tokens_aggregate` (
  `term_id` int(10) UNSIGNED NOT NULL,
  `term` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `stem` varchar(75) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `common` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `phrase` tinyint(1) UNSIGNED NOT NULL DEFAULT '0',
  `term_weight` float UNSIGNED NOT NULL DEFAULT '0',
  `context` tinyint(1) UNSIGNED NOT NULL DEFAULT '2',
  `context_weight` float UNSIGNED NOT NULL DEFAULT '0',
  `total_weight` float UNSIGNED NOT NULL DEFAULT '0',
  `language` char(7) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  KEY `token` (`term`),
  KEY `keyword_id` (`term_id`)
) ENGINE=MEMORY DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__finder_types`
--

DROP TABLE IF EXISTS `#__finder_types`;
CREATE TABLE IF NOT EXISTS `#__finder_types` (
  `id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `title` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `mime` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `title` (`title`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- --------------------------------------------------------

--
-- Table structure for table `#__history`
--

DROP TABLE IF EXISTS `#__history`;
CREATE TABLE IF NOT EXISTS `#__history` (
  `version_id` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
  `item_id` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `version_note` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'Optional version name',
  `save_date` datetime NOT NULL,
  `editor_user_id` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `character_count` int(10) UNSIGNED NOT NULL DEFAULT '0' COMMENT 'Number of characters in this version.',
  `sha1_hash` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'SHA1 hash of the version_data column.',
  `version_data` mediumtext COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'json-encoded string of version data',
  `keep_forever` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0=auto delete; 1=keep',
  PRIMARY KEY (`version_id`),
  KEY `idx_ucm_item_id` (`item_id`),
  KEY `idx_save_date` (`save_date`)
) ENGINE=MyISAM AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

--
-- Dumping data for table `#__history`
--

INSERT INTO `#__history` (`version_id`, `item_id`, `version_note`, `save_date`, `editor_user_id`, `character_count`, `sha1_hash`, `version_data`, `keep_forever`) VALUES
(1, 'com_contact.contact.1', '', '2021-09-15 10:42:32', 584, 1688, 'a28eb900b520a7030741fc7fc174a65c7aad0cb5', '{\"id\":1,\"name\":\"Contact\",\"alias\":\"contact\",\"con_position\":\"\",\"address\":\"\",\"suburb\":\"\",\"state\":\"\",\"country\":\"\",\"postcode\":\"\",\"telephone\":\"\",\"fax\":\"\",\"misc\":\"\",\"image\":\"\",\"email_to\":\"\",\"default_con\":0,\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"ordering\":1,\"params\":\"{\\\"show_contact_category\\\":\\\"\\\",\\\"show_contact_list\\\":\\\"\\\",\\\"presentation_style\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_info\\\":\\\"\\\",\\\"show_name\\\":\\\"\\\",\\\"show_position\\\":\\\"\\\",\\\"show_email\\\":\\\"\\\",\\\"add_mailto_link\\\":\\\"\\\",\\\"show_street_address\\\":\\\"\\\",\\\"show_suburb\\\":\\\"\\\",\\\"show_state\\\":\\\"\\\",\\\"show_postcode\\\":\\\"\\\",\\\"show_country\\\":\\\"\\\",\\\"show_telephone\\\":\\\"\\\",\\\"show_mobile\\\":\\\"\\\",\\\"show_fax\\\":\\\"\\\",\\\"show_webpage\\\":\\\"\\\",\\\"show_image\\\":\\\"\\\",\\\"show_misc\\\":\\\"\\\",\\\"allow_vcard\\\":\\\"\\\",\\\"show_articles\\\":\\\"\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"\\\",\\\"show_links\\\":\\\"\\\",\\\"linka_name\\\":\\\"\\\",\\\"linka\\\":false,\\\"linkb_name\\\":\\\"\\\",\\\"linkb\\\":false,\\\"linkc_name\\\":\\\"\\\",\\\"linkc\\\":false,\\\"linkd_name\\\":\\\"\\\",\\\"linkd\\\":false,\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"\\\",\\\"show_email_form\\\":\\\"\\\",\\\"show_email_copy\\\":\\\"\\\",\\\"banned_email\\\":\\\"\\\",\\\"banned_subject\\\":\\\"\\\",\\\"banned_text\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":0,\"catid\":\"4\",\"access\":\"1\",\"mobile\":\"\",\"webpage\":false,\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2018-02-22 18:30:43\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 18:30:43\",\"modified_by\":null,\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":1,\"hits\":null}', 0),
(2, 'com_contact.contact.1', '', '2021-09-15 10:42:32', 584, 1712, 'f0c36e09d47e25ad97c973c5e8c3c10ea556f83d', '{\"id\":1,\"name\":\"Contact\",\"alias\":\"contact\",\"con_position\":\"\",\"address\":\"\",\"suburb\":\"\",\"state\":\"\",\"country\":\"\",\"postcode\":\"\",\"telephone\":\"\",\"fax\":\"\",\"misc\":\"\",\"image\":\"\",\"email_to\":\"\",\"default_con\":0,\"published\":\"1\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 18:31:13\",\"ordering\":\"1\",\"params\":\"{\\\"show_contact_category\\\":\\\"\\\",\\\"show_contact_list\\\":\\\"\\\",\\\"presentation_style\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_info\\\":\\\"\\\",\\\"show_name\\\":\\\"\\\",\\\"show_position\\\":\\\"\\\",\\\"show_email\\\":\\\"\\\",\\\"add_mailto_link\\\":\\\"\\\",\\\"show_street_address\\\":\\\"\\\",\\\"show_suburb\\\":\\\"\\\",\\\"show_state\\\":\\\"\\\",\\\"show_postcode\\\":\\\"\\\",\\\"show_country\\\":\\\"\\\",\\\"show_telephone\\\":\\\"\\\",\\\"show_mobile\\\":\\\"\\\",\\\"show_fax\\\":\\\"\\\",\\\"show_webpage\\\":\\\"\\\",\\\"show_image\\\":\\\"\\\",\\\"show_misc\\\":\\\"\\\",\\\"allow_vcard\\\":\\\"\\\",\\\"show_articles\\\":\\\"\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"\\\",\\\"show_links\\\":\\\"\\\",\\\"linka_name\\\":\\\"\\\",\\\"linka\\\":false,\\\"linkb_name\\\":\\\"\\\",\\\"linkb\\\":false,\\\"linkc_name\\\":\\\"\\\",\\\"linkc\\\":false,\\\"linkd_name\\\":\\\"\\\",\\\"linkd\\\":false,\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"\\\",\\\"show_email_form\\\":\\\"\\\",\\\"show_email_copy\\\":\\\"\\\",\\\"banned_email\\\":\\\"\\\",\\\"banned_subject\\\":\\\"\\\",\\\"banned_text\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":\"871\",\"catid\":\"4\",\"access\":\"1\",\"mobile\":\"\",\"webpage\":false,\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2018-02-22 18:30:43\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 18:31:44\",\"modified_by\":\"871\",\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":2,\"hits\":\"1\"}', 0),
(3, 'com_contact.contact.1', '', '2021-09-15 10:42:32', 584, 1805, '73cb062813e3aa45647d92fb2e13638720efe036', '{\"id\":1,\"name\":\"Contact\",\"alias\":\"contact\",\"con_position\":\"Founder & CEO\",\"address\":\"2261 Byers Lane\",\"suburb\":\"Paradise\",\"state\":\"California\",\"country\":\"USA\",\"postcode\":\"95969\",\"telephone\":\"530-873-7429\",\"fax\":\"\",\"misc\":\"\",\"image\":\"\",\"email_to\":\"email@email.com\",\"default_con\":0,\"published\":\"1\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 18:32:56\",\"ordering\":\"1\",\"params\":\"{\\\"show_contact_category\\\":\\\"\\\",\\\"show_contact_list\\\":\\\"\\\",\\\"presentation_style\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_info\\\":\\\"\\\",\\\"show_name\\\":\\\"\\\",\\\"show_position\\\":\\\"\\\",\\\"show_email\\\":\\\"\\\",\\\"add_mailto_link\\\":\\\"\\\",\\\"show_street_address\\\":\\\"\\\",\\\"show_suburb\\\":\\\"\\\",\\\"show_state\\\":\\\"\\\",\\\"show_postcode\\\":\\\"\\\",\\\"show_country\\\":\\\"\\\",\\\"show_telephone\\\":\\\"\\\",\\\"show_mobile\\\":\\\"\\\",\\\"show_fax\\\":\\\"\\\",\\\"show_webpage\\\":\\\"\\\",\\\"show_image\\\":\\\"\\\",\\\"show_misc\\\":\\\"\\\",\\\"allow_vcard\\\":\\\"\\\",\\\"show_articles\\\":\\\"\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"\\\",\\\"show_links\\\":\\\"\\\",\\\"linka_name\\\":\\\"\\\",\\\"linka\\\":false,\\\"linkb_name\\\":\\\"\\\",\\\"linkb\\\":false,\\\"linkc_name\\\":\\\"\\\",\\\"linkc\\\":false,\\\"linkd_name\\\":\\\"\\\",\\\"linkd\\\":false,\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"\\\",\\\"show_email_form\\\":\\\"\\\",\\\"show_email_copy\\\":\\\"\\\",\\\"banned_email\\\":\\\"\\\",\\\"banned_subject\\\":\\\"\\\",\\\"banned_text\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":\"871\",\"catid\":\"4\",\"access\":\"1\",\"mobile\":\"858-774-4605\",\"webpage\":false,\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2018-02-22 18:30:43\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 18:34:50\",\"modified_by\":\"871\",\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":3,\"hits\":\"3\"}', 0),
(4, 'com_contact.contact.1', '', '2021-09-15 10:42:32', 584, 1806, '015836154c4087cd75381bcf24c32a74856fce67', '{\"id\":1,\"name\":\"Contact\",\"alias\":\"contact\",\"con_position\":\"Founder & CEO\",\"address\":\"2261 Byers Lane\",\"suburb\":\"Paradise\",\"state\":\"California\",\"country\":\"USA\",\"postcode\":\"95969\",\"telephone\":\"530-873-7429\",\"fax\":\"\",\"misc\":\"\",\"image\":\"\",\"email_to\":\"email@email.com\",\"default_con\":0,\"published\":\"1\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 18:34:50\",\"ordering\":\"1\",\"params\":\"{\\\"show_contact_category\\\":\\\"\\\",\\\"show_contact_list\\\":\\\"\\\",\\\"presentation_style\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_info\\\":\\\"0\\\",\\\"show_name\\\":\\\"\\\",\\\"show_position\\\":\\\"\\\",\\\"show_email\\\":\\\"\\\",\\\"add_mailto_link\\\":\\\"\\\",\\\"show_street_address\\\":\\\"\\\",\\\"show_suburb\\\":\\\"\\\",\\\"show_state\\\":\\\"\\\",\\\"show_postcode\\\":\\\"\\\",\\\"show_country\\\":\\\"\\\",\\\"show_telephone\\\":\\\"\\\",\\\"show_mobile\\\":\\\"\\\",\\\"show_fax\\\":\\\"\\\",\\\"show_webpage\\\":\\\"\\\",\\\"show_image\\\":\\\"\\\",\\\"show_misc\\\":\\\"\\\",\\\"allow_vcard\\\":\\\"\\\",\\\"show_articles\\\":\\\"\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"\\\",\\\"show_links\\\":\\\"\\\",\\\"linka_name\\\":\\\"\\\",\\\"linka\\\":false,\\\"linkb_name\\\":\\\"\\\",\\\"linkb\\\":false,\\\"linkc_name\\\":\\\"\\\",\\\"linkc\\\":false,\\\"linkd_name\\\":\\\"\\\",\\\"linkd\\\":false,\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"\\\",\\\"show_email_form\\\":\\\"\\\",\\\"show_email_copy\\\":\\\"\\\",\\\"banned_email\\\":\\\"\\\",\\\"banned_subject\\\":\\\"\\\",\\\"banned_text\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":\"871\",\"catid\":\"4\",\"access\":\"1\",\"mobile\":\"858-774-4605\",\"webpage\":false,\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2018-02-22 18:30:43\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 18:35:27\",\"modified_by\":\"871\",\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":4,\"hits\":\"4\"}', 0),
(5, 'com_contact.contact.1', '', '2021-09-15 10:42:32', 584, 1807, 'd92c4b80f57b46eb128d3c052ce72b365a445593', '{\"id\":1,\"name\":\"Contact\",\"alias\":\"contact\",\"con_position\":\"Founder & CEO\",\"address\":\"2261 Byers Lane\",\"suburb\":\"Paradise\",\"state\":\"California\",\"country\":\"USA\",\"postcode\":\"95969\",\"telephone\":\"530-873-7429\",\"fax\":\"\",\"misc\":\"\",\"image\":\"\",\"email_to\":\"email@email.com\",\"default_con\":0,\"published\":\"1\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 18:35:27\",\"ordering\":\"1\",\"params\":\"{\\\"show_contact_category\\\":\\\"\\\",\\\"show_contact_list\\\":\\\"\\\",\\\"presentation_style\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_info\\\":\\\"0\\\",\\\"show_name\\\":\\\"\\\",\\\"show_position\\\":\\\"\\\",\\\"show_email\\\":\\\"\\\",\\\"add_mailto_link\\\":\\\"\\\",\\\"show_street_address\\\":\\\"\\\",\\\"show_suburb\\\":\\\"\\\",\\\"show_state\\\":\\\"\\\",\\\"show_postcode\\\":\\\"\\\",\\\"show_country\\\":\\\"\\\",\\\"show_telephone\\\":\\\"\\\",\\\"show_mobile\\\":\\\"\\\",\\\"show_fax\\\":\\\"\\\",\\\"show_webpage\\\":\\\"\\\",\\\"show_image\\\":\\\"\\\",\\\"show_misc\\\":\\\"0\\\",\\\"allow_vcard\\\":\\\"\\\",\\\"show_articles\\\":\\\"\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"\\\",\\\"show_links\\\":\\\"\\\",\\\"linka_name\\\":\\\"\\\",\\\"linka\\\":false,\\\"linkb_name\\\":\\\"\\\",\\\"linkb\\\":false,\\\"linkc_name\\\":\\\"\\\",\\\"linkc\\\":false,\\\"linkd_name\\\":\\\"\\\",\\\"linkd\\\":false,\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"\\\",\\\"show_email_form\\\":\\\"\\\",\\\"show_email_copy\\\":\\\"\\\",\\\"banned_email\\\":\\\"\\\",\\\"banned_subject\\\":\\\"\\\",\\\"banned_text\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":\"871\",\"catid\":\"4\",\"access\":\"1\",\"mobile\":\"858-774-4605\",\"webpage\":false,\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2018-02-22 18:30:43\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 18:35:40\",\"modified_by\":\"871\",\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":5,\"hits\":\"5\"}', 0),
(6, 'com_contact.contact.1', '', '2021-09-15 10:42:32', 584, 1813, 'aed2056cf88e90092020aa9771335945de73c590', '{\"id\":1,\"name\":\"Contact\",\"alias\":\"contact\",\"con_position\":\"Founder & CEO\",\"address\":\"2261 Byers Lane\",\"suburb\":\"Paradise\",\"state\":\"California\",\"country\":\"USA\",\"postcode\":\"95969\",\"telephone\":\"530-873-7429\",\"fax\":\"\",\"misc\":\"\",\"image\":\"\",\"email_to\":\"email@email.com\",\"default_con\":0,\"published\":\"1\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 18:35:40\",\"ordering\":\"1\",\"params\":\"{\\\"show_contact_category\\\":\\\"\\\",\\\"show_contact_list\\\":\\\"\\\",\\\"presentation_style\\\":\\\"plain\\\",\\\"show_tags\\\":\\\"0\\\",\\\"show_info\\\":\\\"0\\\",\\\"show_name\\\":\\\"\\\",\\\"show_position\\\":\\\"\\\",\\\"show_email\\\":\\\"\\\",\\\"add_mailto_link\\\":\\\"\\\",\\\"show_street_address\\\":\\\"\\\",\\\"show_suburb\\\":\\\"\\\",\\\"show_state\\\":\\\"\\\",\\\"show_postcode\\\":\\\"\\\",\\\"show_country\\\":\\\"\\\",\\\"show_telephone\\\":\\\"\\\",\\\"show_mobile\\\":\\\"\\\",\\\"show_fax\\\":\\\"\\\",\\\"show_webpage\\\":\\\"\\\",\\\"show_image\\\":\\\"\\\",\\\"show_misc\\\":\\\"0\\\",\\\"allow_vcard\\\":\\\"\\\",\\\"show_articles\\\":\\\"\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"\\\",\\\"show_links\\\":\\\"\\\",\\\"linka_name\\\":\\\"\\\",\\\"linka\\\":false,\\\"linkb_name\\\":\\\"\\\",\\\"linkb\\\":false,\\\"linkc_name\\\":\\\"\\\",\\\"linkc\\\":false,\\\"linkd_name\\\":\\\"\\\",\\\"linkd\\\":false,\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"\\\",\\\"show_email_form\\\":\\\"\\\",\\\"show_email_copy\\\":\\\"\\\",\\\"banned_email\\\":\\\"\\\",\\\"banned_subject\\\":\\\"\\\",\\\"banned_text\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":\"871\",\"catid\":\"4\",\"access\":\"1\",\"mobile\":\"858-774-4605\",\"webpage\":false,\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2018-02-22 18:30:43\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 18:36:08\",\"modified_by\":\"871\",\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":6,\"hits\":\"6\"}', 0),
(7, 'com_content.category.8', '', '2021-09-15 10:42:32', 584, 545, '13087800f7529bd2b71295e4b611c73f5e5647ac', '{\"id\":8,\"asset_id\":69,\"parent_id\":\"1\",\"lft\":\"11\",\"rgt\":12,\"level\":1,\"path\":null,\"extension\":\"com_content\",\"title\":\"Blog\",\"alias\":\"blog\",\"note\":\"\",\"description\":\"\",\"published\":\"1\",\"checked_out\":null,\"checked_out_time\":null,\"access\":\"1\",\"params\":\"{\\\"category_layout\\\":\\\"\\\",\\\"image\\\":\\\"\\\",\\\"image_alt\\\":\\\"\\\"}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{\\\"author\\\":\\\"\\\",\\\"robots\\\":\\\"\\\"}\",\"created_user_id\":\"871\",\"created_time\":\"2018-02-22 19:27:43\",\"modified_user_id\":null,\"modified_time\":\"2018-02-22 19:27:43\",\"hits\":\"0\",\"language\":\"*\",\"version\":null}', 0),
(9, 'com_content.article.1', '', '2021-09-15 10:42:32', 584, 2006, '03eb9910859a60f44035508ab78c1b88c5ea9340', '{\"id\":1,\"asset_id\":\"70\",\"title\":\"How Marching for Science Risks Politicizing It\",\"alias\":\"how-marching-for-science-risks-politicizing-it\",\"introtext\":\"\",\"fulltext\":\"\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 19:28:20\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 19:28:15\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(10, 'com_content.article.1', '', '2021-09-15 10:42:32', 584, 5227, '6898bfb0da0110f0daaeb6f24f2c633bd596328b', '{\"id\":1,\"asset_id\":\"70\",\"title\":\"How Marching for Science Risks Politicizing It\",\"alias\":\"how-marching-for-science-risks-politicizing-it\",\"introtext\":\"<p><strong>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game, it has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever. <\\/strong><\\/p>\\r\\n<p>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 19:29:28\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 19:29:11\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(11, 'com_content.article.1', '', '2021-09-15 10:42:32', 584, 5266, '635b8014059df4c0bf8d01b76d06556ba4433271', '{\"id\":1,\"asset_id\":\"70\",\"title\":\"How Marching for Science Risks Politicizing It\",\"alias\":\"how-marching-for-science-risks-politicizing-it\",\"introtext\":\"<p><strong>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game, it has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever. <\\/strong><\\/p>\\r\\n<p>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"fulltext\":\"\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 19:38:44\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 19:38:29\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/22\\\\\\/blog1.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":4,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"1\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(12, 'com_content.article.1', '', '2021-09-15 10:42:32', 584, 5270, '1c8fe2c610dee9004578cef480ec1cf69ce70c6e', '{\"id\":1,\"asset_id\":\"70\",\"title\":\"How Marching for Science Risks Politicizing It\",\"alias\":\"how-marching-for-science-risks-politicizing-it\",\"introtext\":\"<p><strong>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game, it has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever. <\\/strong><\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 19:40:58\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 19:40:48\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/22\\\\\\/blog1.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":5,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"2\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(13, 'com_content.article.1', '', '2021-09-15 10:42:32', 584, 5251, '41f57f4617673f65e331a8004e9ceebf89d6fc6b', '{\"id\":1,\"asset_id\":\"70\",\"title\":\"How Marching for Science Risks Politicizing It\",\"alias\":\"how-marching-for-science-risks-politicizing-it\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game, it has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 19:42:00\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 19:41:48\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/22\\\\\\/blog1.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":6,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"2\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(14, 'com_content.article.1', '', '2021-09-15 10:42:32', 584, 5269, 'b1243bf02880ad9d30c1f030fa571a84fc3f65bf', '{\"id\":1,\"asset_id\":\"70\",\"title\":\"How Marching for Science Risks Politicizing It\",\"alias\":\"how-marching-for-science-risks-politicizing-it\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game, it has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 19:42:11\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 19:42:00\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/22\\\\\\/blog1.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":7,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"2\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0);
INSERT INTO `#__history` (`version_id`, `item_id`, `version_note`, `save_date`, `editor_user_id`, `character_count`, `sha1_hash`, `version_data`, `keep_forever`) VALUES
(15, 'com_content.article.1', '', '2021-09-15 10:42:32', 584, 5280, 'd5ae5a8f104e8dc3ace3226dd8286e85a923a2d7', '{\"id\":1,\"asset_id\":\"70\",\"title\":\"How Marching for Science Risks Politicizing It\",\"alias\":\"how-marching-for-science-risks-politicizing-it\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 19:42:57\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 19:42:11\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/22\\\\\\/blog1.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":8,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"3\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(16, 'com_content.article.2', '', '2021-09-15 10:42:32', 584, 5248, '4b7bbc3ecef156562f3360b23262b8e7dfaf6b41', '{\"id\":2,\"asset_id\":71,\"title\":\"How Marching for Science Risks Politicizing It (2)\",\"alias\":\"how-marching-for-science-risks-politicizing-it-2\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":0,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 19:43:48\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/22\\\\\\/blog1.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(17, 'com_content.article.3', '', '2021-09-15 10:42:32', 584, 5248, '3b23b01a01505d1c270a9629355af8c4501743f0', '{\"id\":3,\"asset_id\":72,\"title\":\"How Marching for Science Risks Politicizing It (3)\",\"alias\":\"how-marching-for-science-risks-politicizing-it-3\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":0,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 19:43:53\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/22\\\\\\/blog1.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(18, 'com_content.article.3', '', '2021-09-15 10:42:32', 584, 5228, 'a0a25d5ab2cd31623bfd2472d6eefb8c8050741a', '{\"id\":3,\"asset_id\":\"72\",\"title\":\"How Marching for Science Risks Politicizing It (3)\",\"alias\":\"how-marching-for-science-risks-politicizing-it-3\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":0,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 19:44:15\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 19:43:53\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(19, 'com_content.article.3', '', '2021-09-15 10:42:32', 584, 5247, '689a4b3f44f7dd7e9001c78fa5cc65cac36e9d42', '{\"id\":3,\"asset_id\":\"72\",\"title\":\"How Marching for Science Risks Politicizing It (3)\",\"alias\":\"how-marching-for-science-risks-politicizing-it-3\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 19:44:24\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 19:44:19\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(20, 'com_content.article.2', '', '2021-09-15 10:42:32', 584, 5287, '42791ceba81f8a42780d90ef8b465d32ebde5e23', '{\"id\":2,\"asset_id\":\"71\",\"title\":\"How Marching for Science Risks Politicizing It (2)\",\"alias\":\"how-marching-for-science-risks-politicizing-it-2\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 19:44:35\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 19:44:26\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/22\\\\\\/blog11.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(21, 'com_content.article.1', '', '2021-09-15 10:42:32', 584, 5280, 'a762e1e7da1c5bca6465b5a2e4ecbaccba291b7b', '{\"id\":1,\"asset_id\":\"70\",\"title\":\"How Marching for Science Risks Politicizing It\",\"alias\":\"how-marching-for-science-risks-politicizing-it\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 19:44:44\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 19:44:37\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/22\\\\\\/blog3.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":9,\"ordering\":\"2\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"5\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(22, 'com_content.article.3', '', '2021-09-15 10:42:32', 584, 5287, 'd4f1ed09b4abc1ad55d603b8b5b58ec8e35b4d99', '{\"id\":3,\"asset_id\":\"72\",\"title\":\"How Marching for Science Risks Politicizing It (3)\",\"alias\":\"how-marching-for-science-risks-politicizing-it-3\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 19:44:56\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 19:44:50\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/22\\\\\\/blog12.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":4,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0);
INSERT INTO `#__history` (`version_id`, `item_id`, `version_note`, `save_date`, `editor_user_id`, `character_count`, `sha1_hash`, `version_data`, `keep_forever`) VALUES
(23, 'com_content.article.2', '', '2021-09-15 10:42:32', 584, 5287, '219ca281f1273034e886fb54a35258207231ebef', '{\"id\":2,\"asset_id\":\"71\",\"title\":\"How Marching for Science Risks Politicizing It (2)\",\"alias\":\"how-marching-for-science-risks-politicizing-it-2\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-22 19:45:10\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-22 19:45:00\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/22\\\\\\/blog21.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(24, 'com_content.article.3', '', '2021-09-15 10:42:32', 584, 5286, '3998155d8e60d35c138166566c4cc29b824adc7a', '{\"id\":3,\"asset_id\":\"72\",\"title\":\"How Marching for Science Risks Politicizing It (3)\",\"alias\":\"how-marching-for-science-risks-politicizing-it-3\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:30:14\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:30:04\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog1.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":5,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"1\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(25, 'com_content.article.3', '', '2021-09-15 10:42:32', 584, 5287, '6a016e976714c56c9c9a5bdc493c769d0d44f0f9', '{\"id\":3,\"asset_id\":\"72\",\"title\":\"How Marching for Science Risks Politicizing It (3)\",\"alias\":\"how-marching-for-science-risks-politicizing-it-3\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:35:46\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:35:36\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog11.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":6,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"2\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(26, 'com_content.article.3', '', '2021-09-15 10:42:32', 584, 5287, '654656c410afabc4f4bd6c6a4829b6f99896b1f8', '{\"id\":3,\"asset_id\":\"72\",\"title\":\"How Marching for Science Risks Politicizing It (3)\",\"alias\":\"how-marching-for-science-risks-politicizing-it-3\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:36:14\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:35:46\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog12.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":7,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"2\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(27, 'com_content.article.3', '', '2021-09-15 10:42:32', 584, 5287, '190854aaa2d7dd90a1a02fe54a63e164cd5f4f76', '{\"id\":3,\"asset_id\":\"72\",\"title\":\"The New Threat to Wolves in and Around Yellowstone\",\"alias\":\"how-marching-for-science-risks-politicizing-it-3\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:37:19\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:36:14\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog12.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":8,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"2\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(28, 'com_content.article.2', '', '2021-09-15 10:42:32', 584, 5290, '332f0fe9784309b6c9d0d352e185736f5a50d491', '{\"id\":2,\"asset_id\":\"71\",\"title\":\"After Setbacks and Suits, Miami to Open Science Museum\",\"alias\":\"how-marching-for-science-risks-politicizing-it-2\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:37:39\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:37:22\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog2.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":4,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"3\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(30, 'com_content.article.4', '', '2021-09-15 10:42:32', 584, 5253, '09c1a244e9e69ad390f005364cf970722f673715', '{\"id\":4,\"asset_id\":78,\"title\":\"The New Threat to Wolves in and Around Yellowstone (2)\",\"alias\":\"how-marching-for-science-risks-politicizing-it-4\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":0,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:38:55\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog12.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(31, 'com_content.article.4', '', '2021-09-15 10:42:32', 584, 5232, '58e7013d88c8021e585018893eb79d297b6378b0', '{\"id\":4,\"asset_id\":\"78\",\"title\":\"The New Threat to Wolves in and Around Yellowstone (2)\",\"alias\":\"how-marching-for-science-risks-politicizing-it-4\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":0,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:39:00\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:38:55\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0);
INSERT INTO `#__history` (`version_id`, `item_id`, `version_note`, `save_date`, `editor_user_id`, `character_count`, `sha1_hash`, `version_data`, `keep_forever`) VALUES
(32, 'com_content.article.5', '', '2021-09-15 10:42:32', 584, 5213, '06eed09f2b18259f16c346a650991160a37c21ca', '{\"id\":5,\"asset_id\":79,\"title\":\"The New Threat to Wolves in and Around Yellowstone (3)\",\"alias\":\"how-marching-for-science-risks-politicizing-it-5\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":0,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:39:31\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(33, 'com_content.article.6', '', '2021-09-15 10:42:32', 584, 5213, 'f0b778148b71077b3ccec45d759665095075ef34', '{\"id\":6,\"asset_id\":80,\"title\":\"The New Threat to Wolves in and Around Yellowstone (4)\",\"alias\":\"how-marching-for-science-risks-politicizing-it-6\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":0,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:39:32\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(34, 'com_content.article.7', '', '2021-09-15 10:42:32', 584, 5213, '36f8afab1bd94ff93ccd7fab8ac3ec00bcf4840d', '{\"id\":7,\"asset_id\":81,\"title\":\"The New Threat to Wolves in and Around Yellowstone (5)\",\"alias\":\"how-marching-for-science-risks-politicizing-it-7\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":0,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:39:33\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(35, 'com_content.article.8', '', '2021-09-15 10:42:32', 584, 5213, '388ba8b18b05d54c07b1364f1434268aba13c302', '{\"id\":8,\"asset_id\":82,\"title\":\"The New Threat to Wolves in and Around Yellowstone (6)\",\"alias\":\"how-marching-for-science-risks-politicizing-it-8\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":0,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:39:34\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(36, 'com_content.article.9', '', '2021-09-15 10:42:32', 584, 5213, '5344fd1887607bae6686fcaefda260261a7ca318', '{\"id\":9,\"asset_id\":83,\"title\":\"The New Threat to Wolves in and Around Yellowstone (7)\",\"alias\":\"how-marching-for-science-risks-politicizing-it-9\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":0,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:39:36\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(38, 'com_content.article.4', '', '2021-09-15 10:42:32', 584, 5269, 'c1516b2da00c4db1eae85a5115bca933e2fd7d3d', '{\"id\":4,\"asset_id\":\"78\",\"title\":\"Broke a Glass? Someday You Might 3-D-Print a New One\",\"alias\":\"how-marching-for-science-risks-politicizing-it-4\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":0,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:39:55\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:39:42\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog4.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"6\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(39, 'com_content.article.5', '', '2021-09-15 10:42:32', 584, 5291, '15f84f193b9362d36cb7cec48a56f5b75dfec22f', '{\"id\":5,\"asset_id\":\"79\",\"title\":\"Jimmy Kimmel Sheds Light on Health Coverage for Infants With Birth Defects\",\"alias\":\"how-marching-for-science-risks-politicizing-it-5\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":0,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:40:20\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:40:07\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog5.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"5\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(40, 'com_content.article.6', '', '2021-09-15 10:42:32', 584, 5265, '1400efef4a42e53189c5db8f0f468c1b6df4d46d', '{\"id\":6,\"asset_id\":\"80\",\"title\":\"As Arctic Ice Vanishes, New Shipping Routes Open\",\"alias\":\"how-marching-for-science-risks-politicizing-it-6\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":0,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:40:36\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:40:24\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog6.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"4\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0);
INSERT INTO `#__history` (`version_id`, `item_id`, `version_note`, `save_date`, `editor_user_id`, `character_count`, `sha1_hash`, `version_data`, `keep_forever`) VALUES
(41, 'com_content.article.7', '', '2021-09-15 10:42:32', 584, 5285, '99d3dc0f35dd58911efdbc7d6730d8a13c1fae65', '{\"id\":7,\"asset_id\":\"81\",\"title\":\"Want to Make More Baskets? Science Has the Answer\",\"alias\":\"how-marching-for-science-risks-politicizing-it-7\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:41:03\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:40:48\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog7.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"3\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(42, 'com_content.article.8', '', '2021-09-15 10:42:32', 584, 5296, '31dcbc12ee02dc5ae234a6ac641f2cabc24c81fb', '{\"id\":8,\"asset_id\":\"82\",\"title\":\"Debate Over Paris Climate Deal Could Turn on a Single Phrase\",\"alias\":\"how-marching-for-science-risks-politicizing-it-8\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:41:23\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:41:05\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog8.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"2\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(43, 'com_content.article.9', '', '2021-09-15 10:42:32', 584, 5292, 'f60f7206e145886ff83582057481ce7cd8cdce93', '{\"id\":9,\"asset_id\":\"83\",\"title\":\"The Making of a Legacy: First Steps in the Trump Era\",\"alias\":\"the-making-of-a-legacy-first-steps-in-the-trump-era\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:42:08\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:41:34\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog81.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(44, 'com_content.article.8', '', '2021-09-15 10:42:32', 584, 5308, 'a97d6fe74a317a2308d231856d37a1de9dfdea26', '{\"id\":8,\"asset_id\":\"82\",\"title\":\"Debate Over Paris Climate Deal Could Turn on a Single Phrase\",\"alias\":\"debate-over-paris-climate-deal-could-turn-on-a-single-phrase\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:42:25\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:42:21\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog8.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"2\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(45, 'com_content.article.7', '', '2021-09-15 10:42:32', 584, 5285, '080752ff21f5ef03190c04994eafff0209b4aec4', '{\"id\":7,\"asset_id\":\"81\",\"title\":\"Want to Make More Baskets? Science Has the Answer\",\"alias\":\"want-to-make-more-baskets-science-has-the-answer\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:42:32\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:42:28\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog7.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"3\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(46, 'com_content.article.6', '', '2021-09-15 10:42:32', 584, 5283, '9842123046f6a14f78004a8ed2e3ca34cf1e315f', '{\"id\":6,\"asset_id\":\"80\",\"title\":\"As Arctic Ice Vanishes, New Shipping Routes Open\",\"alias\":\"as-arctic-ice-vanishes-new-shipping-routes-open\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:42:47\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:42:44\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog6.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"4\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(47, 'com_content.article.5', '', '2021-09-15 10:42:32', 584, 5336, 'd906ae572aaaef998fa001bd6f5a7be7d96b34f7', '{\"id\":5,\"asset_id\":\"79\",\"title\":\"Jimmy Kimmel Sheds Light on Health Coverage for Infants With Birth Defects\",\"alias\":\"jimmy-kimmel-sheds-light-on-health-coverage-for-infants-with-birth-defects\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:42:55\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:42:52\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog5.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"5\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(48, 'com_content.article.4', '', '2021-09-15 10:42:32', 584, 5291, '8320737c625f93edfd5ea0a86fbd0c553f45bec4', '{\"id\":4,\"asset_id\":\"78\",\"title\":\"Broke a Glass? Someday You Might 3-D-Print a New One\",\"alias\":\"broke-a-glass-someday-you-might-3-d-print-a-new-one\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:43:01\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:42:58\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog4.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":4,\"ordering\":\"6\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0);
INSERT INTO `#__history` (`version_id`, `item_id`, `version_note`, `save_date`, `editor_user_id`, `character_count`, `sha1_hash`, `version_data`, `keep_forever`) VALUES
(49, 'com_content.article.3', '', '2021-09-15 10:42:32', 584, 5289, '77c0117f778119493c833f127cdb1c369f74755b', '{\"id\":3,\"asset_id\":\"72\",\"title\":\"The New Threat to Wolves in and Around Yellowstone\",\"alias\":\"the-new-threat-to-wolves-in-and-around-yellowstone\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:43:07\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:43:04\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog12.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":9,\"ordering\":\"7\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"3\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(50, 'com_content.article.2', '', '2021-09-15 10:42:32', 584, 5295, 'bed4c1910f040230c050b57b8673bcaf4cf91e0d', '{\"id\":2,\"asset_id\":\"71\",\"title\":\"After Setbacks and Suits, Miami to Open Science Museum\",\"alias\":\"after-setbacks-and-suits-miami-to-open-science-museum\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:43:13\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:43:10\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog2.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":5,\"ordering\":\"8\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"3\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(51, 'com_content.article.6', '', '2021-09-15 10:42:32', 584, 5332, '6f5e964179972e5615a60adadb83b80dc4c32cfe', '{\"id\":6,\"asset_id\":\"80\",\"title\":\"As Arctic Ice Vanishes, New Shipping Routes Open\",\"alias\":\"as-arctic-ice-vanishes-new-shipping-routes-open\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:46:07\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:46:02\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog6.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"video\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"https:\\\\\\/\\\\\\/www.youtube.com\\\\\\/watch?v=C-DfipidnOE\\\"}\",\"version\":4,\"ordering\":\"4\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"2\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(52, 'com_content.article.6', '', '2021-09-15 10:42:32', 584, 5332, '6dd45fc3352f1c4b751855897f278f68f9109cca', '{\"id\":6,\"asset_id\":\"80\",\"title\":\"As Arctic Ice Vanishes, New Shipping Routes Open\",\"alias\":\"as-arctic-ice-vanishes-new-shipping-routes-open\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:46:56\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:46:07\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog6.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"video\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"https:\\\\\\/\\\\\\/www.youtube.com\\\\\\/watch?v=YZcT74ZqkOA\\\"}\",\"version\":5,\"ordering\":\"4\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"2\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(53, 'com_content.article.5', '', '2021-09-15 10:42:32', 584, 5274, '2e7645632d1007c89cf8f4dfd5047cad2eb3052b', '{\"id\":5,\"asset_id\":\"79\",\"title\":\"Jimmy Kimmel Sheds Light on Health Coverage\",\"alias\":\"jimmy-kimmel-sheds-light-on-health-coverage\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:47:22\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:47:16\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog5.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":4,\"ordering\":\"5\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(54, 'com_content.article.7', '', '2021-09-15 10:42:32', 584, 5571, 'c296d051c14a1e4d981479e1516408c057754cc2', '{\"id\":7,\"asset_id\":\"81\",\"title\":\"Want to Make More Baskets? Science Has the Answer\",\"alias\":\"want-to-make-more-baskets-science-has-the-answer\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-22 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:48:35\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:48:18\",\"publish_up\":\"2018-02-22 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog7.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"gallery\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"{\\\\\\\"helix_ultimate_gallery_images\\\\\\\":[\\\\\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog21.jpg\\\\\\\",\\\\\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog31.jpg\\\\\\\",\\\\\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog41.jpg\\\\\\\",\\\\\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog51.jpg\\\\\\\",\\\\\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog111.jpg\\\\\\\"]}\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":4,\"ordering\":\"3\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(56, 'com_content.article.2', '', '2021-09-15 10:42:32', 584, 5295, '1250722414f2c2b95034bafca190f0d816de6279', '{\"id\":2,\"asset_id\":\"71\",\"title\":\"After Setbacks and Suits, Miami to Open Science Museum\",\"alias\":\"after-setbacks-and-suits-miami-to-open-science-museum\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-02 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:49:56\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:49:44\",\"publish_up\":\"2018-02-02 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog2.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":6,\"ordering\":\"8\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"3\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(57, 'com_content.article.3', '', '2021-09-15 10:42:32', 584, 5290, 'c8f2bebcc42713ee4487d0e8ba6317fe9a9c4a50', '{\"id\":3,\"asset_id\":\"72\",\"title\":\"The New Threat to Wolves in and Around Yellowstone\",\"alias\":\"the-new-threat-to-wolves-in-and-around-yellowstone\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-03 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:50:13\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:49:59\",\"publish_up\":\"2018-02-03 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog12.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":10,\"ordering\":\"7\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"3\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0);
INSERT INTO `#__history` (`version_id`, `item_id`, `version_note`, `save_date`, `editor_user_id`, `character_count`, `sha1_hash`, `version_data`, `keep_forever`) VALUES
(58, 'com_content.article.4', '', '2021-09-15 10:42:32', 584, 5291, 'c90fb37f84df281ba3d34f8d89deea03f59b04f1', '{\"id\":4,\"asset_id\":\"78\",\"title\":\"Broke a Glass? Someday You Might 3-D-Print a New One\",\"alias\":\"broke-a-glass-someday-you-might-3-d-print-a-new-one\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-04 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:50:26\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:50:17\",\"publish_up\":\"2018-02-04 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog4.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":5,\"ordering\":\"6\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(59, 'com_content.article.5', '', '2021-09-15 10:42:32', 584, 5274, 'dbb8a1849066c5adf3b6aa3fdf57c43e251e57ae', '{\"id\":5,\"asset_id\":\"79\",\"title\":\"Jimmy Kimmel Sheds Light on Health Coverage\",\"alias\":\"jimmy-kimmel-sheds-light-on-health-coverage\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-05 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:50:43\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:50:34\",\"publish_up\":\"2018-02-05 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog5.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":5,\"ordering\":\"5\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(60, 'com_content.article.6', '', '2021-09-15 10:42:32', 584, 5332, '36e35f4d4d448044be90311b43d6a69e59614723', '{\"id\":6,\"asset_id\":\"80\",\"title\":\"As Arctic Ice Vanishes, New Shipping Routes Open\",\"alias\":\"as-arctic-ice-vanishes-new-shipping-routes-open\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-06 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:51:04\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:50:49\",\"publish_up\":\"2018-02-06 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog6.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"video\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"https:\\\\\\/\\\\\\/www.youtube.com\\\\\\/watch?v=YZcT74ZqkOA\\\"}\",\"version\":6,\"ordering\":\"4\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"2\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(61, 'com_content.article.7', '', '2021-09-15 10:42:32', 584, 5571, 'bb7974e1a29dacc9248ea9e0ae8059da3b1f2fce', '{\"id\":7,\"asset_id\":\"81\",\"title\":\"Want to Make More Baskets? Science Has the Answer\",\"alias\":\"want-to-make-more-baskets-science-has-the-answer\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-07 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:51:21\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:51:12\",\"publish_up\":\"2018-02-07 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog7.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"gallery\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"{\\\\\\\"helix_ultimate_gallery_images\\\\\\\":[\\\\\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog21.jpg\\\\\\\",\\\\\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog31.jpg\\\\\\\",\\\\\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog41.jpg\\\\\\\",\\\\\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog51.jpg\\\\\\\",\\\\\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog111.jpg\\\\\\\"]}\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":5,\"ordering\":\"3\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(62, 'com_content.article.8', '', '2021-09-15 10:42:32', 584, 5308, 'afeb7d593006488f8cf138fccccc59365e98974b', '{\"id\":8,\"asset_id\":\"82\",\"title\":\"Debate Over Paris Climate Deal Could Turn on a Single Phrase\",\"alias\":\"debate-over-paris-climate-deal-could-turn-on-a-single-phrase\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-08 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:51:31\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:51:24\",\"publish_up\":\"2018-02-08 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog8.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":4,\"ordering\":\"2\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(63, 'com_content.article.9', '', '2021-09-15 10:42:32', 584, 5292, 'c1f2596945695af79dc4bcad1d5f8266bec254c8', '{\"id\":9,\"asset_id\":\"83\",\"title\":\"The Making of a Legacy: First Steps in the Trump Era\",\"alias\":\"the-making-of-a-legacy-first-steps-in-the-trump-era\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-09 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:51:44\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:51:34\",\"publish_up\":\"2018-02-09 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog81.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(64, 'com_content.article.8', '', '2021-09-15 10:42:32', 584, 5309, 'b15feba65540751fcbca38d694abe12bc95679fb', '{\"id\":8,\"asset_id\":\"82\",\"title\":\"Debate Over Paris Climate Deal Could Turn on a Single Phrase\",\"alias\":\"debate-over-paris-climate-deal-could-turn-on-a-single-phrase\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-08 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:52:06\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:51:54\",\"publish_up\":\"2018-02-08 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog10.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":5,\"ordering\":\"2\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(65, 'com_content.article.2', '', '2021-09-15 10:42:32', 584, 5631, 'ebad979e33a27706f89dd3397220f7fa244016b7', '{\"id\":2,\"asset_id\":\"71\",\"title\":\"After Setbacks and Suits, Miami to Open Science Museum\",\"alias\":\"after-setbacks-and-suits-miami-to-open-science-museum\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-02 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:55:49\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:53:32\",\"publish_up\":\"2018-02-02 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog2.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"audio\\\",\\\"helix_ultimate_audio\\\":\\\"<iframe scrolling=\\\\\\\"no\\\\\\\" frameborder=\\\\\\\"no\\\\\\\" allow=\\\\\\\"autoplay\\\\\\\" src=\\\\\\\"https:\\\\\\/\\\\\\/w.soundcloud.com\\\\\\/player\\\\\\/?url=https%3A\\\\\\/\\\\\\/api.soundcloud.com\\\\\\/tracks\\\\\\/399014505&color=%23ff5500&auto_play=false&hide_related=false&show_comments=true&show_user=true&show_reposts=false&show_teaser=true&visual=true\\\\\\\"><\\\\\\/iframe>\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":7,\"ordering\":\"8\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"3\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0);
INSERT INTO `#__history` (`version_id`, `item_id`, `version_note`, `save_date`, `editor_user_id`, `character_count`, `sha1_hash`, `version_data`, `keep_forever`) VALUES
(66, 'com_content.article.7', '', '2021-09-15 10:42:32', 584, 5522, '771264299fac9121b7b6db6ecb2ee2517fc779b5', '{\"id\":7,\"asset_id\":\"81\",\"title\":\"Want to Make More Baskets? Science Has the Answer\",\"alias\":\"want-to-make-more-baskets-science-has-the-answer\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2018-02-07 19:28:07\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 06:56:23\",\"modified_by\":\"871\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 06:56:16\",\"publish_up\":\"2018-02-07 19:28:07\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog7.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"gallery\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"{\\\\\\\"helix_ultimate_gallery_images\\\\\\\":[\\\\\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog31.jpg\\\\\\\",\\\\\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog41.jpg\\\\\\\",\\\\\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog51.jpg\\\\\\\",\\\\\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog111.jpg\\\\\\\"]}\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":6,\"ordering\":\"3\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\"}', 0),
(67, 'com_contact.contact.1', '', '2021-09-15 10:42:32', 584, 1845, 'f066feeb859e8a11fd93ba7f825f1346fe672460', '{\"id\":1,\"name\":\"Contact\",\"alias\":\"contact\",\"con_position\":\"Founder & CEO\",\"address\":\"6\\/14, Block - A, Lalmatia\",\"suburb\":\"Dhaka\",\"state\":\"Dhaka\",\"country\":\"USA\",\"postcode\":\"1207\",\"telephone\":\"530-873-7429\",\"fax\":\"858-774-4605\",\"misc\":\"\",\"image\":\"\",\"email_to\":\"email@email.com\",\"default_con\":0,\"published\":\"1\",\"checked_out\":\"871\",\"checked_out_time\":\"2018-02-23 14:36:51\",\"ordering\":\"1\",\"params\":\"{\\\"show_contact_category\\\":\\\"\\\",\\\"show_contact_list\\\":\\\"\\\",\\\"presentation_style\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_info\\\":\\\"\\\",\\\"show_name\\\":\\\"\\\",\\\"show_position\\\":\\\"\\\",\\\"show_email\\\":\\\"\\\",\\\"add_mailto_link\\\":\\\"\\\",\\\"show_street_address\\\":\\\"\\\",\\\"show_suburb\\\":\\\"\\\",\\\"show_state\\\":\\\"\\\",\\\"show_postcode\\\":\\\"\\\",\\\"show_country\\\":\\\"\\\",\\\"show_telephone\\\":\\\"\\\",\\\"show_mobile\\\":\\\"\\\",\\\"show_fax\\\":\\\"\\\",\\\"show_webpage\\\":\\\"\\\",\\\"show_image\\\":\\\"\\\",\\\"show_misc\\\":\\\"\\\",\\\"allow_vcard\\\":\\\"\\\",\\\"show_articles\\\":\\\"\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"\\\",\\\"show_links\\\":\\\"\\\",\\\"linka_name\\\":\\\"\\\",\\\"linka\\\":false,\\\"linkb_name\\\":\\\"\\\",\\\"linkb\\\":false,\\\"linkc_name\\\":\\\"\\\",\\\"linkc\\\":false,\\\"linkd_name\\\":\\\"\\\",\\\"linkd\\\":false,\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"\\\",\\\"show_email_form\\\":\\\"\\\",\\\"show_email_copy\\\":\\\"\\\",\\\"banned_email\\\":\\\"\\\",\\\"banned_subject\\\":\\\"\\\",\\\"banned_text\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":\"871\",\"catid\":\"4\",\"access\":\"1\",\"mobile\":\"858-774-4605\",\"webpage\":\"https:\\/\\/www.joomshaper.com\",\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2018-02-22 18:30:43\",\"created_by\":\"871\",\"created_by_alias\":\"\",\"modified\":\"2018-02-23 14:37:19\",\"modified_by\":\"871\",\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":9,\"hits\":\"51\"}', 0),
(69, 'com_tags.tag.2', '', '2021-09-15 10:42:32', 584, 566, '616ddb7dc48fc6f8b6aa2e90ed3ce7a453fa7683', '{\"id\":2,\"parent_id\":\"1\",\"lft\":\"1\",\"rgt\":2,\"level\":1,\"path\":\"animations\",\"title\":\"Animations\",\"alias\":\"animations\",\"note\":\"\",\"description\":null,\"published\":1,\"checked_out\":\"0\",\"checked_out_time\":\"2018-02-26 06:42:28\",\"access\":1,\"params\":\"{}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{}\",\"created_user_id\":\"871\",\"created_time\":\"2018-02-26 06:42:28\",\"created_by_alias\":\"\",\"modified_user_id\":\"0\",\"modified_time\":\"2018-02-26 06:42:28\",\"images\":\"{}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\",\"publish_up\":\"2018-02-26 06:42:28\",\"publish_down\":\"2018-02-26 06:42:28\"}', 0),
(72, 'com_tags.tag.3', '', '2021-09-15 10:42:32', 584, 557, 'c0edb34678c58ff31cdc044bee28948585deed14', '{\"id\":3,\"parent_id\":\"1\",\"lft\":\"3\",\"rgt\":4,\"level\":1,\"path\":\"builder\",\"title\":\"Builder\",\"alias\":\"builder\",\"note\":\"\",\"description\":null,\"published\":1,\"checked_out\":\"0\",\"checked_out_time\":\"2018-02-26 06:51:56\",\"access\":1,\"params\":\"{}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{}\",\"created_user_id\":\"871\",\"created_time\":\"2018-02-26 06:51:56\",\"created_by_alias\":\"\",\"modified_user_id\":\"0\",\"modified_time\":\"2018-02-26 06:51:56\",\"images\":\"{}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\",\"publish_up\":\"2018-02-26 06:51:56\",\"publish_down\":\"2018-02-26 06:51:56\"}', 0),
(73, 'com_tags.tag.4', '', '2021-09-15 10:42:32', 584, 560, 'bdbac141cab03c1486f4010ded1bba033bd93755', '{\"id\":4,\"parent_id\":\"1\",\"lft\":\"5\",\"rgt\":6,\"level\":1,\"path\":\"dropdown\",\"title\":\"Dropdown\",\"alias\":\"dropdown\",\"note\":\"\",\"description\":null,\"published\":1,\"checked_out\":\"0\",\"checked_out_time\":\"2018-02-26 06:51:56\",\"access\":1,\"params\":\"{}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{}\",\"created_user_id\":\"871\",\"created_time\":\"2018-02-26 06:51:56\",\"created_by_alias\":\"\",\"modified_user_id\":\"0\",\"modified_time\":\"2018-02-26 06:51:56\",\"images\":\"{}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\",\"publish_up\":\"2018-02-26 06:51:56\",\"publish_down\":\"2018-02-26 06:51:56\"}', 0),
(74, 'com_tags.tag.5', '', '2021-09-15 10:42:32', 584, 548, '6f8b4de9ad01f97b562f1697b821a5f06ceb1825', '{\"id\":5,\"parent_id\":\"1\",\"lft\":\"7\",\"rgt\":8,\"level\":1,\"path\":\"drag\",\"title\":\"Drag\",\"alias\":\"drag\",\"note\":\"\",\"description\":null,\"published\":1,\"checked_out\":\"0\",\"checked_out_time\":\"2018-02-26 06:51:56\",\"access\":1,\"params\":\"{}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{}\",\"created_user_id\":\"871\",\"created_time\":\"2018-02-26 06:51:56\",\"created_by_alias\":\"\",\"modified_user_id\":\"0\",\"modified_time\":\"2018-02-26 06:51:56\",\"images\":\"{}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\",\"publish_up\":\"2018-02-26 06:51:56\",\"publish_down\":\"2018-02-26 06:51:56\"}', 0),
(75, 'com_tags.tag.6', '', '2021-09-15 10:42:32', 584, 549, 'd4530eda7a9326d3acd0bc35e5b21c4b739fca26', '{\"id\":6,\"parent_id\":\"1\",\"lft\":\"9\",\"rgt\":10,\"level\":1,\"path\":\"drop\",\"title\":\"Drop\",\"alias\":\"drop\",\"note\":\"\",\"description\":null,\"published\":1,\"checked_out\":\"0\",\"checked_out_time\":\"2018-02-26 06:51:56\",\"access\":1,\"params\":\"{}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{}\",\"created_user_id\":\"871\",\"created_time\":\"2018-02-26 06:51:56\",\"created_by_alias\":\"\",\"modified_user_id\":\"0\",\"modified_time\":\"2018-02-26 06:51:56\",\"images\":\"{}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\",\"publish_up\":\"2018-02-26 06:51:56\",\"publish_down\":\"2018-02-26 06:51:56\"}', 0),
(76, 'com_tags.tag.7', '', '2021-09-15 10:42:32', 584, 565, '1f97921c5724fa6e309d9c3287b754a1d726c2a6', '{\"id\":7,\"parent_id\":\"1\",\"lft\":\"11\",\"rgt\":12,\"level\":1,\"path\":\"mega-menu\",\"title\":\"Mega Menu\",\"alias\":\"mega-menu\",\"note\":\"\",\"description\":null,\"published\":1,\"checked_out\":\"0\",\"checked_out_time\":\"2018-02-26 06:51:56\",\"access\":1,\"params\":\"{}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{}\",\"created_user_id\":\"871\",\"created_time\":\"2018-02-26 06:51:56\",\"created_by_alias\":\"\",\"modified_user_id\":\"0\",\"modified_time\":\"2018-02-26 06:51:56\",\"images\":\"{}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\",\"publish_up\":\"2018-02-26 06:51:56\",\"publish_down\":\"2018-02-26 06:51:56\"}', 0),
(77, 'com_tags.tag.8', '', '2021-09-15 10:42:32', 584, 562, '5228699d9d4dd34664e7a338b6cde8fb04e21434', '{\"id\":8,\"parent_id\":\"1\",\"lft\":\"13\",\"rgt\":14,\"level\":1,\"path\":\"features\",\"title\":\"Features\",\"alias\":\"features\",\"note\":\"\",\"description\":null,\"published\":1,\"checked_out\":\"0\",\"checked_out_time\":\"2018-02-26 06:51:56\",\"access\":1,\"params\":\"{}\",\"metadesc\":\"\",\"metakey\":\"\",\"metadata\":\"{}\",\"created_user_id\":\"871\",\"created_time\":\"2018-02-26 06:51:56\",\"created_by_alias\":\"\",\"modified_user_id\":\"0\",\"modified_time\":\"2018-02-26 06:51:56\",\"images\":\"{}\",\"urls\":\"{}\",\"hits\":\"0\",\"language\":\"*\",\"version\":\"1\",\"publish_up\":\"2018-02-26 06:51:56\",\"publish_down\":\"2018-02-26 06:51:56\"}', 0),
(78, 'com_content.article.10', '', '2021-09-15 10:42:32', 584, 3126, 'ad64b008dea169dd3c806e2724aed5a9d1548b7c', '{\"id\":10,\"asset_id\":107,\"title\":\"Tips for a good city breack\",\"alias\":\"tips-for-a-good-city-breack\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2019-08-07 11:30:37\",\"created_by\":\"246\",\"created_by_alias\":\"\",\"modified\":\"2019-08-07 11:30:37\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2019-08-07 11:30:37\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/content\\\\\\/traveller-experience.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"images\\\\\\/content\\\\\\/traveller-experience.jpg\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', 0),
(79, 'com_content.article.10', '', '2021-09-15 10:42:32', 584, 3123, '53eda454e4d86680645c5e9a426425d76e933d2e', '{\"id\":10,\"asset_id\":\"107\",\"title\":\"Good city breack\",\"alias\":\"good-city-breack\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2019-08-07 11:30:37\",\"created_by\":\"246\",\"created_by_alias\":\"\",\"modified\":\"2019-08-07 11:32:00\",\"modified_by\":\"246\",\"checked_out\":\"246\",\"checked_out_time\":\"2019-08-07 11:30:37\",\"publish_up\":\"2019-08-07 11:30:37\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/content\\\\\\/traveller-experience.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"images\\\\\\/content\\\\\\/traveller-experience.jpg\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":2,\"ordering\":\"0\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', 0),
(80, 'com_content.article.11', '', '2021-09-15 10:42:32', 584, 3102, 'ef74b2fd24a2395433cd9e14c229944f2c1e8cc1', '{\"id\":11,\"asset_id\":108,\"title\":\"Find the best attractions\",\"alias\":\"find-the-best-attractions\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2019-08-07 11:33:03\",\"created_by\":\"246\",\"created_by_alias\":\"\",\"modified\":\"2019-08-07 11:33:03\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2019-08-07 11:33:03\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/content\\\\\\/having_fun.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"images\\\\\\/content\\\\\\/having_fun.jpg\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', 0),
(81, 'com_content.article.10', '', '2021-09-15 10:42:32', 584, 3121, 'a54bfebe98a2353f42892e2ccfedacaedeb89059', '{\"id\":10,\"asset_id\":\"107\",\"title\":\"Good city break\",\"alias\":\"good-city-break\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2019-08-07 11:30:37\",\"created_by\":\"246\",\"created_by_alias\":\"\",\"modified\":\"2019-08-07 11:34:04\",\"modified_by\":\"246\",\"checked_out\":\"246\",\"checked_out_time\":\"2019-08-07 11:33:56\",\"publish_up\":\"2019-08-07 11:30:37\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/content\\\\\\/traveller-experience.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"images\\\\\\/content\\\\\\/traveller-experience.jpg\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":4,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', 0),
(82, 'com_content.article.12', '', '2021-09-15 10:42:32', 584, 3084, 'b2a4ec6dde2a550faecaeb588f682576f82a3f77', '{\"id\":12,\"asset_id\":109,\"title\":\"Cozy locations\",\"alias\":\"cozy-locations\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2019-08-07 11:35:05\",\"created_by\":\"246\",\"created_by_alias\":\"\",\"modified\":\"2019-08-07 11:35:05\",\"modified_by\":null,\"checked_out\":null,\"checked_out_time\":null,\"publish_up\":\"2019-08-07 11:35:05\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/content\\\\\\/having_cofee.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"images\\\\\\/content\\\\\\/having_cofee.jpg\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":1,\"ordering\":null,\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":null,\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', 0),
(83, 'com_content.article.11', '', '2021-09-15 10:42:32', 584, 3116, '9d28c8df916414ec0cfb17016e02c1ec950e1e3a', '{\"id\":11,\"asset_id\":\"108\",\"title\":\"The best attractions\",\"alias\":\"find-the-best-attractions\",\"introtext\":\"<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>Pellentesque habitant morbi tristique senectus et netus et malesuada fames ac turpis egestas. Vestibulum tortor quam, feugiat vitae, ultricies eget, tempor sit amet, ante. Donec eu libero sit amet quam egestas semper. Aenean ultricies mi vitae est. Mauris placerat eleifend leo. Quisque sit amet est et sapien ullamcorper pharetra. Vestibulum erat wisi, condimentum sed, commodo vitae, ornare sit amet, wisi. Aenean fermentum, elit eget tincidunt condimentum, eros ipsum rutrum orci, sagittis tempus lacus enim ac dui. Donec non enim in turpis pulvinar facilisis. Ut felis. Praesent dapibus, neque id cursus faucibus, tortor neque egestas augue, eu vulputate magna eros eu erat. Aliquam erat volutpat. Nam dui mi, tincidunt quis, accumsan porttitor, facilisis luctus, metus<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2019-08-07 11:33:03\",\"created_by\":\"246\",\"created_by_alias\":\"\",\"modified\":\"2019-08-07 11:38:09\",\"modified_by\":\"246\",\"checked_out\":\"246\",\"checked_out_time\":\"2019-08-07 11:38:03\",\"publish_up\":\"2019-08-07 11:33:03\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"images\\\\\\/content\\\\\\/having_fun.jpg\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"images\\\\\\/content\\\\\\/having_fun.jpg\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":3,\"ordering\":\"1\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"0\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', 0),
(84, 'com_content.article.6', '', '2021-09-15 10:42:32', 584, 5327, '1190bd88610c843750287443715c1f7d691049c9', '{\"id\":6,\"asset_id\":\"80\",\"title\":\"As Arctic Ice Vanishes, New Shipping Routes Open\",\"alias\":\"as-arctic-ice-vanishes-new-shipping-routes-open\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2019-08-01 11:54:04\",\"created_by\":\"246\",\"created_by_alias\":\"\",\"modified\":\"2019-08-18 07:02:06\",\"modified_by\":\"246\",\"checked_out\":\"246\",\"checked_out_time\":\"2019-08-18 07:01:51\",\"publish_up\":\"2019-08-01 11:54:04\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog6.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"standard\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"http:\\\\\\/\\\\\\/vimeo.com\\\\\\/73961982\\\"}\",\"version\":7,\"ordering\":\"6\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"3\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', 0),
(85, 'com_content.article.1', '', '2021-09-15 10:42:32', 584, 5264, '9befbeb3f0345ded51046a0dfaf35cfdf1fabbcd', '{\"id\":1,\"asset_id\":\"70\",\"title\":\"Preparing some to impress\",\"alias\":\"how-marching-for-science-risks-politicizing-it\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2019-08-01 11:54:04\",\"created_by\":\"246\",\"created_by_alias\":\"\",\"modified\":\"2019-08-18 07:03:57\",\"modified_by\":\"246\",\"checked_out\":\"246\",\"checked_out_time\":\"2019-08-18 07:03:24\",\"publish_up\":\"2019-08-01 11:54:04\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"video\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"http:\\\\\\/\\\\\\/vimeo.com\\\\\\/73961982\\\"}\",\"version\":12,\"ordering\":\"11\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"35\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', 0);
INSERT INTO `#__history` (`version_id`, `item_id`, `version_note`, `save_date`, `editor_user_id`, `character_count`, `sha1_hash`, `version_data`, `keep_forever`) VALUES
(86, 'com_content.article.1', '', '2021-09-15 10:42:32', 584, 5278, '7507e6257b65e65f243072b4d229ef77528ec9e5', '{\"id\":1,\"asset_id\":\"70\",\"title\":\"Preparing some to impress your audiance\",\"alias\":\"how-marching-for-science-risks-politicizing-it\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2019-08-01 11:54:04\",\"created_by\":\"246\",\"created_by_alias\":\"\",\"modified\":\"2019-08-18 07:04:17\",\"modified_by\":\"246\",\"checked_out\":\"246\",\"checked_out_time\":\"2019-08-18 07:03:57\",\"publish_up\":\"2019-08-01 11:54:04\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"\\\",\\\"helix_ultimate_article_format\\\":\\\"video\\\",\\\"helix_ultimate_audio\\\":\\\"\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"http:\\\\\\/\\\\\\/vimeo.com\\\\\\/73961982\\\"}\",\"version\":13,\"ordering\":\"11\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"35\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', 0),
(87, 'com_content.article.2', '', '2021-09-15 10:42:32', 584, 5635, '81ce3e158f2032491a5683ff3717a617a5971598', '{\"id\":2,\"asset_id\":\"71\",\"title\":\"After Setbacks and Suits, Miami to Open Science\",\"alias\":\"after-setbacks-and-suits-miami-to-open-science-museum\",\"introtext\":\"<p>It won\\u2019t be a bigger problem to find one video game lover in your neighbor. Since the introduction of Virtual Game.<\\/p>\\r\\n\",\"fulltext\":\"\\r\\n<p>It has been achieving great heights so far as its popularity and technological advancement are concerned. The history of video game is as interesting as a fairy tale. The quality of today\\u2019s video game was not at all there when video game first conceptualized and played ever.<\\/p>\\r\\n<p><strong>If you are looking at blank cassettes on the web, you may be very confused at the difference in price. You may see some for as low as $.17 each. You may be saying to yourself<\\/strong>, \\u201cWow, what a deal!\\u201d. But be careful, check out the quality before you make your purchase. Make sure the tape will fit your needs. If you are using your cassette tapes to record something fast, and the life of the cassette will be short, then maybe the cheap ones are for you. However, if you need a quality recording, or are looking to keep that cassette for some time, then you will need to be prepared to pay a little more. The quality you receive will be well worth the added cost. Spoken word applications are one use that requires a higher quality cassette. Going with cheap blank cassettes will certainly result in poor quality originals and duplicates. If you are involved in recording speeches, sermons, lectures, audio books or teaching tapes, then you will find the points below of great interest. So what are some of the differences, and what should you be looking for? The following is a list of suggestions on the type of tapes to use:<\\/p>\\r\\n<p>1. The cassette shell should be held together with a five-screw design. This type of design will help to keep the shell from warping. If the shell warps, the tape will not be able to move smoothly for good recording or playback. It may not be able to move at all. The five-screw design also allows the cassette to be taken apart if necessary. So, if the shell got damaged, the tape could be moved to a different shell, for continued use. 2. Using Type I tape is sufficient for spoken word applications. You still need to make sure that the tape is of good quality. Poor quality tape will result in a poor quality recording. It can even cause undue wear on copiers, and more frequent cleaning of the copier heads.<\\/p>\\r\\n<p>3. Make sure that the felt pad that presses the tape against the head is sufficient. The larger the pad the better the tape to head contact allowing for better quality recording. Even a slight separation between the tape and the head will result in a poor recording.<\\/p>\\r\\n<p>4. Pins and rollers are also important. The rollers are what guide the tape around the corners of the cassette. The pins hold the rollers in place. Some manufacturers will use plastic pins. This has the potential of the roller and the pin becoming welded under heated conditions. Also, if the rollers are of cheap quality, the tape may not move smoothly while recording or copying. The tape can even become damaged due to friction.<\\/p>\\r\\n<p>5. Slip sheets are the sleeves between the tape and the case. These are also important since they help the tape to travel smoother. Smooth travel of the tape is critical to a good recording.<\\/p>\",\"state\":1,\"catid\":\"8\",\"created\":\"2019-08-01 11:54:04\",\"created_by\":\"246\",\"created_by_alias\":\"\",\"modified\":\"2019-08-18 07:04:55\",\"modified_by\":\"246\",\"checked_out\":\"246\",\"checked_out_time\":\"2019-08-18 07:04:49\",\"publish_up\":\"2019-08-01 11:54:04\",\"publish_down\":\"0000-00-00 00:00:00\",\"images\":\"{\\\"image_intro\\\":\\\"\\\",\\\"float_intro\\\":\\\"\\\",\\\"image_intro_alt\\\":\\\"\\\",\\\"image_intro_caption\\\":\\\"\\\",\\\"image_fulltext\\\":\\\"\\\",\\\"float_fulltext\\\":\\\"\\\",\\\"image_fulltext_alt\\\":\\\"\\\",\\\"image_fulltext_caption\\\":\\\"\\\"}\",\"urls\":\"{\\\"urla\\\":false,\\\"urlatext\\\":\\\"\\\",\\\"targeta\\\":\\\"\\\",\\\"urlb\\\":false,\\\"urlbtext\\\":\\\"\\\",\\\"targetb\\\":\\\"\\\",\\\"urlc\\\":false,\\\"urlctext\\\":\\\"\\\",\\\"targetc\\\":\\\"\\\"}\",\"attribs\":\"{\\\"article_layout\\\":\\\"\\\",\\\"show_title\\\":\\\"\\\",\\\"link_titles\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_intro\\\":\\\"\\\",\\\"info_block_position\\\":\\\"\\\",\\\"info_block_show_title\\\":\\\"\\\",\\\"show_category\\\":\\\"\\\",\\\"link_category\\\":\\\"\\\",\\\"show_parent_category\\\":\\\"\\\",\\\"link_parent_category\\\":\\\"\\\",\\\"show_associations\\\":\\\"\\\",\\\"show_author\\\":\\\"\\\",\\\"link_author\\\":\\\"\\\",\\\"show_create_date\\\":\\\"\\\",\\\"show_modify_date\\\":\\\"\\\",\\\"show_publish_date\\\":\\\"\\\",\\\"show_item_navigation\\\":\\\"\\\",\\\"show_icons\\\":\\\"\\\",\\\"show_print_icon\\\":\\\"\\\",\\\"show_email_icon\\\":\\\"\\\",\\\"show_vote\\\":\\\"\\\",\\\"show_hits\\\":\\\"\\\",\\\"show_noauth\\\":\\\"\\\",\\\"urls_position\\\":\\\"\\\",\\\"alternative_readmore\\\":\\\"\\\",\\\"article_page_title\\\":\\\"\\\",\\\"show_publishing_options\\\":\\\"\\\",\\\"show_article_options\\\":\\\"\\\",\\\"show_urls_images_backend\\\":\\\"\\\",\\\"show_urls_images_frontend\\\":\\\"\\\",\\\"helix_ultimate_image\\\":\\\"images\\\\\\/2018\\\\\\/02\\\\\\/23\\\\\\/blog2.jpg\\\",\\\"helix_ultimate_article_format\\\":\\\"audio\\\",\\\"helix_ultimate_audio\\\":\\\"<iframe scrolling=\\\\\\\"no\\\\\\\" frameborder=\\\\\\\"no\\\\\\\" allow=\\\\\\\"autoplay\\\\\\\" src=\\\\\\\"https:\\\\\\/\\\\\\/w.soundcloud.com\\\\\\/player\\\\\\/?url=https%3A\\\\\\/\\\\\\/api.soundcloud.com\\\\\\/tracks\\\\\\/399014505&color=%23ff5500&auto_play=false&hide_related=false&show_comments=true&show_user=true&show_reposts=false&show_teaser=true&visual=true\\\\\\\"><\\\\\\/iframe>\\\",\\\"helix_ultimate_gallery\\\":\\\"\\\",\\\"helix_ultimate_video\\\":\\\"\\\"}\",\"version\":8,\"ordering\":\"10\",\"metakey\":\"\",\"metadesc\":\"\",\"access\":\"1\",\"hits\":\"5\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"author\\\":\\\"\\\",\\\"rights\\\":\\\"\\\",\\\"xreference\\\":\\\"\\\"}\",\"featured\":\"0\",\"language\":\"*\",\"xreference\":\"\",\"note\":\"\"}', 0),
(88, 'com_contact.contact.1', '', '2021-09-15 10:42:32', 584, 1643, '59deb98e976feffc848f9021612bd148e205e250', '{\"id\":1,\"name\":\"Contact\",\"alias\":\"contact\",\"con_position\":\"\",\"address\":\"\",\"suburb\":\"\",\"state\":\"\",\"country\":\"\",\"postcode\":\"\",\"telephone\":\"\",\"fax\":\"\",\"misc\":\"\",\"image\":\"\",\"email_to\":\"\",\"default_con\":0,\"published\":\"1\",\"checked_out\":\"13\",\"checked_out_time\":\"2019-09-16 20:35:23\",\"ordering\":\"1\",\"params\":\"{\\\"show_contact_category\\\":\\\"\\\",\\\"show_contact_list\\\":\\\"\\\",\\\"presentation_style\\\":\\\"\\\",\\\"show_tags\\\":\\\"\\\",\\\"show_info\\\":\\\"\\\",\\\"show_name\\\":\\\"\\\",\\\"show_position\\\":\\\"\\\",\\\"show_email\\\":\\\"\\\",\\\"add_mailto_link\\\":\\\"\\\",\\\"show_street_address\\\":\\\"\\\",\\\"show_suburb\\\":\\\"\\\",\\\"show_state\\\":\\\"\\\",\\\"show_postcode\\\":\\\"\\\",\\\"show_country\\\":\\\"\\\",\\\"show_telephone\\\":\\\"\\\",\\\"show_mobile\\\":\\\"\\\",\\\"show_fax\\\":\\\"\\\",\\\"show_webpage\\\":\\\"\\\",\\\"show_image\\\":\\\"\\\",\\\"show_misc\\\":\\\"\\\",\\\"allow_vcard\\\":\\\"\\\",\\\"show_articles\\\":\\\"\\\",\\\"articles_display_num\\\":\\\"\\\",\\\"show_profile\\\":\\\"\\\",\\\"show_links\\\":\\\"\\\",\\\"linka_name\\\":\\\"\\\",\\\"linka\\\":false,\\\"linkb_name\\\":\\\"\\\",\\\"linkb\\\":false,\\\"linkc_name\\\":\\\"\\\",\\\"linkc\\\":false,\\\"linkd_name\\\":\\\"\\\",\\\"linkd\\\":false,\\\"linke_name\\\":\\\"\\\",\\\"linke\\\":false,\\\"contact_layout\\\":\\\"\\\",\\\"show_email_form\\\":\\\"\\\",\\\"show_email_copy\\\":\\\"\\\",\\\"validate_session\\\":\\\"\\\",\\\"custom_reply\\\":\\\"\\\",\\\"redirect\\\":\\\"\\\"}\",\"user_id\":\"13\",\"catid\":\"4\",\"access\":\"1\",\"mobile\":\"\",\"webpage\":false,\"sortname1\":\"\",\"sortname2\":\"\",\"sortname3\":\"\",\"language\":\"*\",\"created\":\"2019-09-11 12:18:30\",\"created_by\":\"13\",\"created_by_alias\":\"\",\"modified\":\"2019-09-16 20:35:31\",\"modified_by\":\"13\",\"metakey\":\"\",\"metadesc\":\"\",\"metadata\":\"{\\\"robots\\\":\\\"\\\",\\\"rights\\\":\\\"\\\"}\",\"featured\":\"0\",\"xreference\":\"\",\"publish_up\":\"0000-00-00 00:00:00\",\"publish_down\":\"0000-00-00 00:00:00\",\"version\":11,\"hits\":\"83\"}', 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_application_settings`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_application_settings`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_application_settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `value` text,
  `text` varchar(100) DEFAULT NULL,
  `description` varchar(110) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=345 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_application_settings`
--

INSERT INTO `#__jbusinessdirectory_application_settings` (`id`, `name`, `value`, `text`, `description`) VALUES
(3, 'applicationsettings_id', '1', '', ''),
(4, 'company_name', 'JBusinessDirectory', 'LNG_DIRECTORY_NAME', 'LNG_NAME_BUSINESS_DETAILS'),
(5, 'company_email', 'office@office.com', 'LNG_DIRECTORY_EMAIL', 'LNG_EMAIL_BUSINESS_DETAILS'),
(6, 'currency_id', '143', 'LNG_CURRENCY_NAME', 'LNG_NAME_CURRENCY_DESCRIPTION'),
(7, 'country_ids', '', 'LNG_SELECT_ZIPCODE_COUNTRY', 'LNG_SELECT_ZIPCODE_COUNTRY_DESCRIPTION'),
(8, 'css_style', '', '', ''),
(9, 'css_module_style', 'style.css', '', ''),
(10, 'show_frontend_language', '1', '', ''),
(11, 'default_frontend_language', 'en-GB', '', ''),
(12, 'date_format_id', '2', 'LNG_DATE_FORMAT', 'LNG_DATE_FORMAT_DESCRIPTION'),
(13, 'enable_cache', '0', 'LNG_ENABLE_CACHE', 'LNG_ENABLE_CACHE_DESCRIPTION'),
(14, 'enable_packages', '0', 'LNG_ENABLE_PACKAGES', 'LNG_ENABLE_PACKAGES_DESCRIPTION'),
(15, 'edit_form_mode', '2', 'LNG_EDIT_FORM_MODE', 'LNG_EDIT_FORM_MODE_DESCRIPTION'),
(16, 'enable_ratings', '1', 'LNG_ENABLE_RATINGS', 'LNG_ENABLE_RATINGS_DESCRIPTION'),
(17, 'enable_reviews', '1', 'LNG_ENABLE_REVIEWS', 'LNG_ENABLE_REVIEWS_DESCRIPTION'),
(18, 'enable_offers', '1', 'LNG_ENABLE_OFFERS', 'LNG_ENABLE_OFFERS_DESCRIPTION'),
(19, 'enable_offer_coupons', '1', 'LNG_ENABLE_OFFER_COUPONS', 'LNG_ENABLE_OFFER_COUPONS_DESCRIPTION'),
(20, 'enable_events', '1', 'LNG_ENABLE_EVENTS', 'LNG_ENABLE_EVENTS_DESCRIPTION'),
(21, 'enable_seo', '1', 'LNG_SEO_MECHANISM', 'LNG_SEO_MECHANISM'),
(22, 'enable_rss', '0', 'LNG_ENABLE_RSS', 'LNG_ENABLE_RSS_DESCRIPTION'),
(23, 'enable_search_filter', '1', 'LNG_ENABLE_SEARCH_FILTER', 'LNG_ENABLE_SEARCH_FILTER_DESCRIPTION'),
(24, 'enable_search_letters', '0', '', ''),
(25, 'enable_reviews_users', '0', 'LNG_ENABLE_REVIEWS_USERS_ONLY', 'LNG_ENABLE_REVIEWS_USERS_ONLY_DESCRIPTION'),
(26, 'enable_socials', '1', 'LNG_ENABLE_SOCIALS', 'LNG_ENABLE_SOCIALS_DESCRIPTION'),
(27, 'enable_numbering', '1', 'LNG_ENABLE_NUMBERING', 'LNG_ENABLE_NUMBERING_DESCRIPTION'),
(28, 'enable_search_filter_offers', '1', 'LNG_ENABLE_SEARCH_FILTER_OFFERS', 'LNG_ENABLE_SEARCH_FILTER_OFFERS_DESCRIPTION'),
(29, 'enable_search_filter_events', '1', 'LNG_ENABLE_SEARCH_FILTER_EVENTS', 'LNG_ENABLE_SEARCH_FILTER_EVENTS_DESCRIPTION'),
(30, 'show_search_map', '1', 'LNG_SHOW_SEARCH_MAP', 'LNG_SHOW_SEARCH_MAP_DESCRIPTION'),
(31, 'show_search_description', '1', '', ''),
(32, 'show_details_user', '0', 'LNG_SHOW_DETAILS_ONLY_FOR_USERS_INFO', 'LNG_SHOW_DETAILS_ONLY_FOR_USERS_DESCRIPTION'),
(33, 'company_view', '5', 'LNG_COMPANY_VIEW', 'LNG_COMPANY_VIEW_DESCRIPTION'),
(34, 'category_view', '3', 'LNG_CATEGORIES_VIEW', 'LNG_CATEGORIES_VIEW_DESCRIPTION'),
(35, 'search_result_view', '6', 'LNG_SEARCH_RESULT_VIEW', 'LNG_SEARCH_RESULT_VIEW_DESCRIPTION'),
(36, 'captcha', '0', 'LNG_ENABLE_CAPTCHA', 'LNG_ENABLE_CAPTCHA_DESCRIPTION'),
(37, 'nr_images_slide', '5', '', ''),
(38, 'show_pending_approval', '0', 'LNG_SHOW_PENDING_APPROVAL', 'LNG_SHOW_PENDING_APPROVAL_DESCRIPTION'),
(39, 'allow_multiple_companies', '1', '', ''),
(40, 'meta_description', '', 'LNG_META_DESCRIPTION', 'LNG_META_DESCRIPTION_META'),
(41, 'meta_keywords', '', 'LNG_META_KEYWORDS', 'LNG_META_KEYWORDS_META'),
(42, 'meta_description_facebook', '', 'LNG_META_DESCRIPTION_FACEBOOK', 'LNG_META_DESCRIPTION_FACEBOOK_META'),
(43, 'limit_cities_regions', '1', 'LNG_LIMIT_CITIES_REGIONS', 'LNG_LIMIT_CITIES_DESCRIPTION'),
(44, 'metric', '1', 'LNG_METRIC', 'LNG_METRIC_DESCRIPTION'),
(45, 'user_location', '1', '', ''),
(46, 'search_type', '0', 'LNG_LISTING_SEARCH_FILTER', 'LNG_LISTING_SEARCH_FILTER_DESCRIPTION'),
(47, 'zipcode_search_type', '0', 'LNG_ZIPCODE_SEARCH_TYPE', 'LNG_ZIPCODE_SEARCH_TYPE_DESCRIPTION'),
(48, 'map_auto_show', '0', 'LNG_MAP_AUTO_SHOW', 'LNG_MAP_AUTO_SHOW_DESCRIPTION'),
(49, 'menu_item_id', '', 'LNG_MENU_ITEM_ID', 'LNG_MENU_ITEM_ID_SEO'),
(50, 'order_id', '', '', ''),
(51, 'order_email', '', '', ''),
(52, 'claim_business', '1', 'LNG_ENABLE_CLAIM_BUSINESS', 'LNG_ENABLE_CLAIM_BUSINESS_DESCRIPTION'),
(53, 'terms_conditions', '', 'LNG_COMPANY_TERMS_AND_CONDITIONS', 'LNG_TERMS_CONDITIONS_DESCRIPTION'),
(54, 'reviews_terms_conditions', '', 'LNG_REVIEW_TERMS_AND_CONDITIONS', 'LNG_REVIEWS_TERMS_CONDITIONS_DESCRIPTION'),
(55, 'contact_terms_conditions', '', 'LNG_CONTACT_TERMS_AND_CONDITIONS', 'LNG_CONTACT_TERMS_CONDITIONS_DESCRIPTION'),
(56, 'vat', '0', 'LNG_VAT', 'LNG_VAT_NUMBER_INVOICE'),
(57, 'expiration_day_notice', '', 'LNG_EXPIRATION_DAYS_NOTICE', 'LNG_EXPIRATION_DAYS_NOTICE_DESCRIPTION'),
(58, 'show_cat_description', '1', 'LNG_SHOW_CAT_DESCRIPTION', 'LNG_SHOW_CAT_DESCRIPTION_DESCRIPTION'),
(59, 'direct_processing', '0', '', ''),
(60, 'max_video', '10', 'LNG_MAX_VIDEOS', 'LNG_MAX_VIDEOS_DESCRIPTION'),
(61, 'max_pictures', '15', 'LNG_MAX_PICTURES', 'LNG_MAX_PICTURES_DESCRIPTION'),
(62, 'show_secondary_locations', '0', 'LNG_SHOW_SECONDARY_LOCATIONS', 'LNG_SHOW_SECONDARY_LOCATIONS_DESCRIPTION'),
(63, 'search_view_mode', '0', 'LNG_DEFAULT_SEARCH_VIEW', 'LNG_DEFAULT_SEARCH_VIEW_DESCRIPTION'),
(64, 'address_format', '1', 'LNG_ADDRESS_FORMAT', 'LNG_ADDRESS_FORMAT_DESCRIPTION'),
(65, 'offer_search_results_grid_view', '0', 'LNG_OFFER_SEARCH_RESULT_GRID_VIEW', 'LNG_OFFER_SEARCH_RESULT_GRID_VIEW_DESCRIPTION'),
(66, 'offer_search_results_list_view', '1', 'LNG_OFFER_SEARCH_RESULT_LIST_VIEW', 'LNG_OFFER_SEARCH_RESULT_LIST_VIEW_DESCRIPTION'),
(67, 'events_search_results_list_view', '1', 'LNG_EVENTS_SEARCH_RESULT_LIST_VIEW', 'LNG_EVENTS_SEARCH_RESULT_LIST_VIEW_DESCRIPTION'),
(68, 'enable_multilingual', '0', 'LNG_ENABLE_MULTILINGUAL', 'LNG_ENABLE_MULTILINGUAL_DESCRIPTION'),
(69, 'offers_view_mode', '0', 'LNG_DEFAULT_OFFERS_VIEW', 'LNG_DEFAULT_OFFERS_VIEW_DESCRIPTION'),
(70, 'enable_geolocation', '1', 'LNG_ENABLE_GEOLOCATION', 'LNG_ENABLE_GEOLOCATION_DESCRIPTION'),
(71, 'enable_map_clustering', '1', 'LNG_ENABLE_MAP_CLUSTERING', 'LNG_ENABLE_MAP_CLUSTERING_DESCRIPTION'),
(72, 'add_url_id', '0', 'LNG_ADD_URL_ID', 'LNG_ADD_URL_ID_SEO'),
(73, 'add_url_language', '0', 'LNG_ADD_URL_LANGUAGE', 'LNG_ADD_URL_LANGUAGE_SEO'),
(74, 'currency_display', '1', 'LNG_CURRENCY_DISPLAY', 'LNG_CURRENCY_DISPLAY_DESCRIPTION'),
(75, 'amount_separator', '1', 'LNG_AMOUNT_SEPARATOR', 'LNG_AMOUNT_SEPARATOR_DESCRIPTION'),
(76, 'currency_location', '1', 'LNG_SHOW_CURRENCY', 'LNG_SHOW_CURRENCY_DESCRIPTION'),
(77, 'currency_symbol', '1', 'LNG_CURRENCY_SYMBOL', 'LNG_CURRENCY_SYMBOL_DESCRIPTION'),
(78, 'show_email', '1', 'LNG_SHOW_EMAIL', 'LNG_SHOW_EMAIL_DESCRIPTION'),
(79, 'enable_attachments', '1', 'LNG_ENABLE_ATTACHMENTS', 'LNG_ENABLE_ATTACHMENTS_DESCRIPTION'),
(80, 'order_search_listings', 'packageOrder desc', 'LNG_ORDER_SEARCH_LISTINGS', 'LNG_ORDER_SEARCH_LISTINGS_DESCRIPTION'),
(81, 'order_search_offers', '', 'LNG_ORDER_SEARCH_OFFERS', 'LNG_ORDER_SEARCH_OFFERS_DESCRIPTION'),
(82, 'order_search_events', '', 'LNG_ORDER_SEARCH_EVENTS', 'LNG_ORDER_SEARCH_EVENTS_DESCRIPTION'),
(83, 'events_search_view', '2', 'LNG_DEFAULT_EVENTS_VIEW', 'LNG_DEFAULT_EVENTS_VIEW_DESCRIPTION'),
(84, 'enable_bookmarks', '1', 'LNG_ENABLE_BOOKMARKS', 'LNG_ENABLE_BOOKMARKS_DESCRIPTION'),
(85, 'max_attachments', '5', 'LNG_MAX_ATTACHMENTS', 'LNG_MAX_ATTACHMENTS_DESCRIPTION'),
(86, 'max_categories', '10', 'LNG_MAX_CATEGORIES', 'LNG_MAX_CATEGORIES_DESCRIPTION'),
(87, 'max_offers', '20', 'LNG_MAX_OFFERS', 'LNG_MAX_OFFERS_DESCRIPTION'),
(88, 'max_events', '20', 'LNG_MAX_EVENTS', 'LNG_MAX_EVENTS_DESCRIPTION'),
(89, 'max_business', '20', 'LNG_MAX_BUSINESS_LISTINGS', 'LNG_MAX_BUSINESS_LISTINGS_REACHED'),
(90, 'time_format', 'h:i A', 'LNG_TIME_FORMAT', 'LNG_TIME_FORMAT_DESCRIPTION'),
(91, 'front_end_acl', '0', 'LNG_ENABLE_FRONT_END_ACL', 'LNG_ENABLE_FRONT_END_ACL_DESCRIPTION'),
(92, 'listing_url_type', '1', 'LNG_URL_TYPE', 'LNG_URL_TYPE_SEO'),
(93, 'search_result_grid_view', '1', 'LNG_SEARCH_RESULTS_GRID_VIEW', 'LNG_SEARCH_RESULTS_GRID_VIEW_DESCRIPTION'),
(94, 'facebook', 'http://www.facebook.com', 'LNG_FACEBOOK', 'LNG_FACEBOOK_BUSINESS_DETAILS'),
(95, 'twitter', 'http://www.twiter.com', 'LNG_TWITTER', 'LNG_TWITTER_BUSINESS_DETAILS'),
(96, 'googlep', 'http://www.googleplus.com', '', ''),
(97, 'linkedin', 'http://www.linkedin.com', 'LNG_LINKEDIN', 'LNG_LINKEDIN_BUSINESS_DETAILS'),
(98, 'youtube', 'http://www.youtube.com', 'LNG_YOUTUBE', 'LNG_YOUTUBE_BUSINESS_DETAILS'),
(99, 'logo', '/app/directorylogo-1519226466.jpg', 'LNG_LOGO', 'LNG_LOGO_BUSINESS_DETAILS'),
(100, 'map_latitude', '', 'LNG_LATITUDE', 'LNG_LATITUDE_DESCRIPTION'),
(101, 'map_longitude', '', 'LNG_LONGITUDE', 'LNG_LONGITUDE_DESCRIPTION'),
(102, 'map_zoom', '15', 'LNG_ZOOM', 'LNG_ZOOM_DESCRIPTION'),
(103, 'map_enable_auto_locate', '1', 'LNG_ENABLE_AUTO_LOCATE', 'LNG_ENABLE_AUTO_LOCATE_DESCRIPTION'),
(104, 'map_apply_search', '0', 'LNG_APPLY_SEARCH', 'LNG_APPLY_SEARCH_DESCRIPTION'),
(105, 'google_map_key', '', 'LNG_GOOGLE_MAP_KEY', 'LNG_GOOGLE_MAP_KEY_DESCRIPTION'),
(106, 'google_map_key_zipcode', '', 'LNG_GOOGLE_MAP_KEY_ZIPCODE', 'LNG_GOOGLE_MAP_KEY_ZIPCODE_DESCRIPTION'),
(107, 'submit_method', 'post', 'LNG_LISTING_SUBMIT_METHOD', 'LNG_LISTING_SUBMIT_METHOD_DESCRIPTION'),
(108, 'add_country_address', '1', 'LNG_ADD_COUNTRY_ADDRESS', 'LNG_ADD_COUNTRY_ADDRESS_DESCRIPTION'),
(109, 'usergroup', '2', 'LNG_CHOOSE_USERGROUP', 'LNG_CHOOSE_USERGROUP_DESCRIPTION'),
(110, 'business_usergroup', '', 'LNG_BUSINESS_USERGROUP', 'LNG_BUSINESS_USERGROUP_DESCRIPTION'),
(111, 'category_url_type', '1', 'LNG_CATEGORY_URL_TYPE', 'LNG_CATEGORY_URL_TYPE_SEO'),
(112, 'enable_menu_alias_url', '0', 'LNG_ADD_MENU_ALIAS_URL', 'LNG_ADD_MENU_ALIAS_URL_SEO'),
(113, 'url_menu_alias', '', 'LNG_URL_MENU_ALIAS_SEO', 'LNG_URL_MENU_ALIAS_SEO'),
(114, 'adaptive_height_gallery', '0', 'LNG_GALLERY_ADAPTIVE_HEIGHT', 'LNG_GALLERY_ADAPTIVE_HEIGHT_DESCRIPTION'),
(115, 'autoplay_gallery', '0', 'LNG_GALLERY_AUTOPLAY', 'LNG_GALLERY_AUTOPLAY_DESCRIPTION'),
(116, 'invoice_company_name', '', 'LNG_DIRECTORY_INVOICE_NAME', 'LNG_NAME_INVOICE'),
(117, 'invoice_company_address', '', 'LNG_ADDRESS', 'LNG_ADDRESS_INVOICE'),
(118, 'invoice_company_phone', '', 'LNG_TELEPHONE_NUMBER', 'LNG_TELEPHONE_NUMBER_INVOICE'),
(119, 'invoice_company_email', '', 'LNG_DIRECTORY_INVOICE_EMAIL', 'LNG_EMAIL_NUMBER_INVOICE'),
(120, 'invoice_vat', '0', 'LNG_VAT', 'LNG_VAT_NUMBER_INVOICE'),
(121, 'invoice_details', '', 'LNG_INVOICE_DETAILS', 'LNG_INVOICE_DETAILS_NUMBER_INVOICE'),
(122, 'invoice_prefix', '', 'LNG_PREFIX_NUMBER', 'LNG_PREFIX_NUMBER_NUMBER_INVOICE'),
(123, 'show_total_business_count', '0', 'LNG_SHOW_TOTAL_BUSINESS_COUNT', 'LNG_SHOW_TOTAL_BUSINESS_COUNT_DESCRIPTION'),
(124, 'enable_event_reservation', '0', 'LNG_ENABLE_EVENT_RESERVATION', 'LNG_ENABLE_EVENT_RESERVATION_DESCRIPTION'),
(125, 'enable_https_payment', '0', 'LNG_ENABLE_HTTPS_ON_PAYMENT', 'LNG_ENABLE_HTTPS_ON_PAYMENT_INFO'),
(126, 'search_fields', 'cp.name,cp.slogan,cg.name,cp.meta_description,cp.short_description,cp.phone,cp.address,cp.postalCode,cp.city,cp.county', 'LNG_SELECT_SEARCH_FIELDS', 'LNG_SELECT_SEARCH_FIELDS_DESCRIPTION'),
(127, 'search_filter_fields', 'categories,types,countries,regions,cities,starRating', 'LNG_SELECT_FILTER_FIELDS', 'LNG_SELECT_SEARCH_FILTER_DESCRIPTION'),
(128, 'url_fields', '', 'LNG_URL_FIELDS', 'LNG_URL_FIELDS'),
(129, 'show_pending_review', '0', 'LNG_SHOW_PENDING_REVIEW', 'LNG_SHOW_PENDING_REVIEW_DESCRIPTION'),
(130, 'show_view_count', '1', 'LNG_COMPANY_VIEW_COUNT', 'LNG_COMPANY_VIEW_COUNT_DESCRIPTION'),
(131, 'business_update_notification', '1', 'LNG_BUSINESS_UPDATE_NOTIFICATION', 'LNG_BUSINESS_UPDATE_NOTIFICATION_DESCRIPTION'),
(132, 'enable_offer_selling', '0', 'LNG_ENABLE_OFFER_SELLING', 'LNG_ENABLE_OFFER_SELLING_DESCRIPTION'),
(133, 'offer_view', '1', 'LNG_OFFER_VIEW', 'LNG_OFFER_VIEW_DESCRIPTION'),
(134, 'event_view', '1', 'LNG_EVENT_VIEW', 'LNG_EVENT_VIEW_DESCRIPTION'),
(135, 'allow_user_creation', '0', 'LNG_ALLOW_USER_CREATION', 'LNG_ALLOW_USER_CREATION_DESCRIPTION'),
(136, 'enable_event_appointments', '0', 'LNG_ENABLE_EVENT_APPOINTMENTS', 'LNG_ENABLE_EVENT_APPOINTMENTS_DESCRIPTION'),
(137, 'enable_services', '0', 'LNG_ENABLE_COMPANY_SERVICES', 'LNG_ENABLE_COMPANY_SERVICES_DESCRIPTION'),
(138, 'social_profile', '0', 'LNG_SOCIAL_PROFILE', 'LNG_SOCIAL_PROFILE_DESCRIPTION'),
(139, 'enable_reporting', '0', 'LNG_ENABLE_REPORTING', 'LNG_ENABLE_REPORTING_DESCRIPTION'),
(140, 'enable_event_subscription', '0', 'LNG_ENABLE_EVENT_SUBSCRIPTION', 'LNG_ENABLE_EVENT_SUBSCRIPTION_DESCRIPTION'),
(141, 'show_contact_form', '1', 'LNG_SHOW_CONTACT_FORM', 'LNG_SHOW_CONTACT_FORM_DESCRIPTION'),
(142, 'enable_attribute_category', '0', 'LNG_ENABLE_ATTRIBUTE_CATEGORY', 'LNG_ENABLE_ATTRIBUTE_CATEGORY_DESCRIPTION'),
(143, 'enable_criteria_category', '0', 'LNG_ENABLE_CRITERIA_CATEGORY', 'LNG_ENABLE_CRITERIA_CATEGORY_DESCRIPTION'),
(144, 'max_review_images', '6', 'LNG_MAX_IMAGES_REVIEW', 'LNG_MAX_IMAGES_REVIEW_DESCRIPTION'),
(145, 'apply_attr_offers', '0', '', ''),
(146, 'apply_attr_events', '0', '', ''),
(147, 'map_marker', '', 'LNG_MAP_MARKER', 'LNG_MAP_MARKER_DETAILS'),
(148, 'enable_link_following', '0', 'LNG_ENABLE_LINK_FOLLOWING', 'LNG_ENABLE_LINK_FOLLOWING_DESCRIPTION'),
(149, 'item_decouple', '0', 'LNG_ITEM_DECOUPLE', 'LNG_ITEM_DECOUPLE_DESCRIPTION'),
(150, 'search_filter_items', '5', 'LNG_SEARCH_FILTER_ITEM', 'LNG_SEARCH_FILTER_ITEM_DESCRIPTION'),
(151, 'price_list_view', '1', 'LNG_PRICE_LIST_VIEW', 'LNG_PRICE_LIST_VIEW_DESCRIPTION'),
(152, 'cover_width', '1000', 'LNG_COVER_WIDTH', 'LNG_COVER_WIDTH_DESCRIPTION'),
(153, 'cover_height', '400', 'LNG_COVER_HEIGHT', 'LNG_COVER_HEIGHT_DESCRIPTION'),
(154, 'gallery_height', '400', 'LNG_GALLERY_HEIGHT', 'LNG_GALLERY_HEIGHT_DESCRIPTION'),
(155, 'gallery_width', '400', 'LNG_GALLERY_WIDTH', 'LNG_GALLERY_WIDTH_DESCRIPTION'),
(156, 'logo_width', '800', 'LNG_LOGO_WIDTH', 'LNG_LOGO_WIDTH_DESCRIPTION'),
(157, 'logo_height', '800', 'LNG_LOGO_HEIGHT', 'LNG_LOGO_HEIGHT_DESCRIPTION'),
(158, 'enable_crop', '1', 'LNG_ENABLE_CROPPING', 'LNG_ENABLE_CROPPING_DESCRIPTION'),
(159, 'enable_resolution_check', '0', 'LNG_RESTRICT_IMAGE_SIZE', 'LNG_RESTRICT_IMAGE_SIZE_DESCRIPTION'),
(160, 'show_offer_free', '1', 'LNG_SHOW_OFFER_FREE_PRICE', 'LNG_SHOW_OFFER_FREE_PRICE_DESCRIPTION'),
(161, 'default_time_zone', '-11:00', 'LNG_DEFAULT_TIME_ZONE', 'LNG_DEFAULT_TIME_ZONE_DESCRIPTION'),
(162, 'category_order', '1', 'LNG_CATEGORY_ORDER', 'LNG_CATEGORY_ORDER_DESCRIPTION'),
(163, 'custom_address', '{street_number} {address},{area},{city} {postal_code},{region},{province},{country}', 'LNG_CUSTOM_ADDRESS', 'LNG_ADDRESS_FORMAT_DESCRIPTION'),
(164, 'redirect_contact_url', '', 'LNG_REDIRECT_CONTACT_URL', 'LNG_REDIRECT_CONTACT_URL_DESC'),
(165, 'chat_port', '3000', 'LNG_CHAT_PORT', 'LNG_CHAT_PORT_DESCRIPTION'),
(166, 'firebase_server_key', '', 'LNG_FIREBASE_SERVER_KEY', 'LNG_FIREBASE_SERVER_KEY_DESCRIPTION'),
(167, 'event_booking_timeout', '', 'LNG_EVENT_BOOKING_TIMEOUT', 'LNG_EVENT_BOOKING_TIMEOUT_DESCRIPTION'),
(168, 'sms_domain', '', 'LNG_SMS_DOMAIN', 'LNG_SMS_DOMAIN_DESCRIPTION'),
(169, 'map_type', '1', 'LNG_MAP_TYPE', 'LNG_MAP_TYPE_DESCRIPTION'),
(170, 'bing_map_key', '', 'LNG_BING_MAP_KEY', 'LNG_BING_MAP_KEY_DESCRIPTION'),
(171, 'dir_list_limit', '20', 'LNG_DIR_LIST_LIMIT', 'LNG_DIR_LIST_LIMIT_DESCRIPTION'),
(172, 'show_custom_markers', '1', 'LNG_SHOW_CUSTOM_MARKERS', 'LNG_SHOW_CUSTOM_MARKERS_DESCRIPTION'),
(173, 'conference_view_mode', '', 'LNG_CONFERNCE_VIEW_MODE', 'LNG_CONFERNCE_VIEW_MODE'),
(174, 'sessions_view', '', 'LNG_SESSIONS_VIEW', 'LNG_SESSIONS_VIEW'),
(175, 'speakers_view', '', 'LNG_SPEAKERS_VIEW', 'LNG_SPEAKERS_VIEW'),
(176, 'listing_featured_bg', '', 'LNG_FEATURED_LISTING_BG', 'LNG_FEATURED_LISTING_BG'),
(177, 'show_grid_list_option', '1', 'LNG_SHOW_GRID_LIST_OPTIONS', 'LNG_SHOW_GRID_LIST_OPTIONS_DESCRIPTION'),
(178, 'enable_item_moderation', '1', 'LNG_ENABLE_ITEM_MODERATION', 'LNG_ENABLE_ITEM_MODERATION_DESCRIPTION'),
(179, 'enable_automated_moderation', '0', 'LNG_ENABLE_AUTOMATED_MODERATION', 'LNG_ENABLE_AUTOMATED_MODERATION_DESCRIPTION'),
(180, 'moderate_threshold', '0', 'LNG_MODERATE_THRESHOLD', 'LNG_MODERATE_THRESHOLD_DESCRIPTION'),
(181, 'events_search_results_grid_view', '1', 'LNG_EVENTS_SEARCH_RESULT_GRID_VIEW', 'LNG_EVENTS_SEARCH_RESULT_GRID_VIEW_DESCRIPTION'),
(182, 'show_open_status', '1', 'LNG_SHOW_OPEN_STATUS', 'LNG_SHOW_OPEN_STATUS_DESCRIPTION'),
(183, 'currency_converter_api', '', 'LNG_CURRENCY_CONVERTER_API_KEY', 'LNG_CURRENCY_CONVERTER_API_KEY_DESCRIPTION'),
(184, 'feature_map_marker', '', 'LNG_FEATURE_MAP_MARKER', 'LNG_FEATURE_MAP_MARKER_DETAILS'),
(185, 'offer_submit_method', 'post', 'LNG_OFFER_SUBMIT_METHOD', 'LNG_OFFER_SUBMIT_METHOD_DESCRIPTION'),
(186, 'event_submit_method', 'post', 'LNG_EVENT_SUBMIT_METHOD', 'LNG_EVENT_SUBMIT_METHOD_DESCRIPTION'),
(187, 'offer_search_filter_items', '5', 'LNG_OFFER_SEARCH_FILTER_ITEM', 'LNG_OFFER_SEARCH_FILTER_ITEM_DESCRIPTION'),
(188, 'event_search_filter_items', '5', 'LNG_EVENT_SEARCH_FILTER_ITEM', 'LNG_EVENT_SEARCH_FILTER_ITEM_DESCRIPTION'),
(189, 'offer_search_filter_fields', 'categories,types,countries,regions,cities,starRating', 'LNG_OFFER_SELECT_FILTER_FIELDS', 'LNG_OFFER_SELECT_SEARCH_FILTER_DESCRIPTION'),
(190, 'event_search_filter_fields', 'categories,types,countries,regions,cities,starRating', 'LNG_EVENT_SELECT_FILTER_FIELDS', 'LNG_EVENT_SELECT_SEARCH_FILTER_DESCRIPTION'),
(191, 'offer_search_type', '0', 'LNG_OFFER_SEARCH_FILTER', 'LNG_OFFER_SEARCH_FILTER_DESCRIPTION'),
(192, 'event_search_type', '0', 'LNG_EVENT_SEARCH_FILTER', 'LNG_EVENT_SEARCH_FILTER_DESCRIPTION'),
(193, 'enable_shipping', '0', 'LNG_ENABLE_SHIPPING', 'LNG_ENABLE_SHIPPING_DESCRIPTION'),
(194, 'image_display', '1', 'LNG_IMAGE_DISPLAY', 'LNG_IMAGE_DISPLAY'),
(195, 'front_end_meta_data', '0', 'LNG_ENABLE_FRONT_END_META_DATA', 'LNG_ENABLE_FRONT_END_META_DATA_DSCR'),
(196, 'show_contact_cards', '0', 'LNG_SHOW_CONTACT_CARDS', 'LNG_SHOW_CONTACT_CARDS_DESC'),
(197, 'enable_announcements', '0', 'LNG_ENABLE_ANNOUNCEMENTS', 'LNG_ENABLE_ANNOUNCEMENTS'),
(198, 'enable_price_list', '1', 'LNG_ENABLE_PRICE_LIST', 'LNG_ENABLE_PRICE_LIST_DESCRIPTION'),
(199, 'listing_auto_save', '0', 'LNG_LISTING_AUTO_SAVE', 'LNG_LISTING_AUTO_SAVE_DESCRIPTION'),
(200, 'auto_save_interval', '120000', 'LNG_AUTO_SAVE_INTERVAL', 'LNG_AUTO_SAVE_INTERVAL_DESCRIPTION'),
(201, 'content_responsible', '', 'LNG_CONTENT_RESPONSIBLE_PERSON', 'LNG_CONTENT_RESPONSIBLE_PERSON'),
(202, 'display_attributes_packages', '1', 'LNG_DISPLAY_ATTRIBUTES_PACKAGES', 'LNG_DISPLAY_ATTRIBUTES_PACKAGES_DESCRIPTION'),
(203, 'show_claimed', '1', 'LNG_SHOW_CLAIMED', 'LNG_SHOW_CLAIMED_DESCRIPTION'),
(204, 'enable_map_gdpr', '0', 'LNG_ENABLE_MAP_GDPR', 'LNG_ENABLE_MAP_GDPR_DESCRIPTION'),
(205, 'search_filter_view', '1', 'LNG_SEARCH_FILTER_VIEW', 'LNG_SEARCH_FILTER_VIEW_DESCRIPTION'),
(206, 'search_filter_view_offers', '1', 'LNG_SEARCH_FILTER_VIEW_OFFERS', 'LNG_SEARCH_FILTER_VIEW_OFFERS_DESCRIPTION'),
(207, 'search_filter_view_events', '1', 'LNG_SEARCH_FILTER_VIEW_EVENTS', 'LNG_SEARCH_FILTER_VIEW_OFFERS_DESCRIPTION'),
(208, 'search_filter_type', '2', 'LNG_SEARCH_FILTER_TYPE', 'LNG_SEARCH_FILTER_TYPE_DESCRIPTION'),
(209, 'enable_request_quote', '1', 'LNG_ENABLE_REQUEST_QUOTE', 'LNG_ENABLE_REQUEST_QUOTE_DESCRIPTION'),
(210, 'facebook_client_id', '', 'LNG_FACEBOOK_CLIENT_ID', 'LNG_FACEBOOK_CLIENT_ID_DESCRIPTION'),
(211, 'facebook_client_secret', '', 'LNG_FACEBOOK_CLIENT_SECRET', 'LNG_FACEBOOK_CLIENT_SECRET_DESCRIPTION'),
(212, 'google_client_id', '', 'LNG_GOOGLE_CLIENT_ID', 'LNG_GOOGLE_CLIENT_ID_DESCRIPTION'),
(213, 'google_client_secret', '', 'LNG_GOOGLE_CLIENT_SECRET', 'LNG_GOOGLE_CLIENT_SECRET_DESCRIPTION'),
(214, 'share_reviews', '0', 'LNG_SHARE_REVIEW', 'LNG_SHARE_REVIEW_DESCRIPTION'),
(215, 'open_business_website', '0', 'LNG_OPEN_BUSINESS_URL', 'LNG_OPEN_BUSINESS_URL_DESCRIPTION'),
(216, 'open_listing_on_new_tab', '0', 'LNG_OPEN_LISTING_ON_NEW_TAB', 'LNG_OPEN_LISTING_ON_NEW_TAB_DESCRIPTION'),
(217, 'request_quote_usergroup', '2', 'LNG_CHOOSE_REQUEST_QUOTE_USERGROUP', 'LNG_REQUEST_QUOTE_CHOOSE_USERGROUP_DESCRIPTION'),
(218, 'request_quote_radius', '100', 'LNG_REQUEST_QUOTE_RADIUS', 'LNG_REQUEST_QUOTE_RADIUS_DESCRIPTION'),
(219, 'package_date', '', 'LNG_PACKAGE_FIXED_DATE', 'LNG_PACKAGE_FIXED_DATE_DESCRIPTION'),
(220, 'lock_custom_fields', '1', 'LNG_LOCK_CUSTOM_FIELDS', 'LNG_LOCK_CUSTOM_FIELDS_DESCRIPTION'),
(221, 'show_alias', '1', 'LNG_SHOW_ALIAS', 'LNG_SHOW_ALIAS_DESCRIPTION'),
(222, 'show_apply_discount', '1', 'LNG_SHOW_APPLY_DISCOUNT', 'LNG_SHOW_APPLY_DISCOUNT_DESCRIPTION'),
(223, 'enable_messages', '1', 'LNG_ENABLE_MESSAGES', 'LNG_ENABLE_MESSAGES_DESCRIPTION'),
(224, 'enable_campaigns', '1', 'LNG_ENABLE_CAMPAIGNS', 'LNG_ENABLE_CAMPAIGNS_DESC'),
(225, 'enable_articles', '1', 'LNG_ENABLE_ARTICLES', 'LNG_ENABLE_ARTICLES_DESC'),
(226, 'enable_request_quote_app', '1', 'LNG_ENABLE_REQUEST_QUOTE_APP', 'LNG_ENABLE_REQUEST_QUOTE_APP_DESC'),
(227, 'enable_projects', '1', 'LNG_ENABLE_PROJECTS', 'LNG_ENABLE_PROJECTS_DESC'),
(228, 'mobile_usergroup', '2', 'LNG_CHOOSE_MOBILE_USERGROUP', 'LNG_CHOOSE_MOBILE_USERGROUP_DESCRIPTION'),
(229, 'search_redirect_url', '', 'LNG_SEARCH_REDIRECT_URL', 'LNG_SEARCH_REDIRECT_URL_DESC'),
(230, 'max_listing_events_display', '6', 'LNG_MAX_LISTING_EVENTS_DISPLAY', 'LNG_MAX_LISTING_EVENTS_DISPLAY_DESCRIPTION'),
(231, 'default_processor_types', '', 'LNG_SELECT_DEFAULT_PAYMENT_PROCESSORS', 'LNG_SELECT_DEFAULT_PAYMENT_PROCESSORS_DESCRIPTION'),
(232, 'trail_weeks_dates', '', 'LNG_TRAIL_WEEKS_DATES', 'LNG_TRAIL_WEEKS_DATES_DESCRIPTION'),
(233, 'marker_size', '', 'LNG_MARKER_SIZE', 'LNG_MARKER_SIZE_DESCRIPTION'),
(234, 'type_allowed_registering', '', 'LNG_SELECT_LISTING_TYPE_ALLOWED_TO_REGISTER', 'LNG_SELECT_LISTING_TYPE_ALLOWED_TO_REGISTER_DESCRIPTION'),
(235, 'mix_results', '0', 'LNG_MIX_RESULTS', 'LNG_MIX_RESULTS_DESCRIPTION'),
(236, 'mix_results_offers', '0', 'LNG_MIX_RESULTS', 'LNG_MIX_RESULTS_DESCRIPTION'),
(237, 'mix_results_events', '0', 'LNG_MIX_RESULTS', 'LNG_MIX_RESULTS_DESCRIPTION'),
(238, 'no_image', '/no_image.jpg', 'LNG_NO_IMAGE', 'LNG_NO_IMAGE_DETAILS'),
(239, 'generate_auto_user', '0', 'LNG_GENERATE_AUTO_USER', 'LNG_GENERATE_AUTO_USER_DESCRIPTION'),
(240, 'number_of_decimals', '2', 'LNG_NUMBER_OF_DECIMLAS', 'LNG_NUMBER_OF_DECIMLAS_DESCRIPTION'),
(241, 'listing_category_display', '1', 'LNG_LISTING_CATEGORY_DISPLAY', 'LNG_LISTING_CATEGORY_DISPLAY_DESCRIPTION'),
(242, 'show_secondary_locations_search', '0', 'LNG_SHOW_SECONDARY_LOCATIONS_SEARCH', 'LNG_SHOW_SECONDARY_LOCATIONS_SEARCH_DESCRIPTION'),
(243, 'allow_contribute', '0', 'LNG_ALLOW_CONTRIBUTE', 'LNG_ALLOW_CONTRIBUTE_DESCRIPTION'),
(244, 'business_cp_style', '1', 'LNG_BUSINESS_CP_STYLE', 'LNG_BUSINESS_CP_STYLE_DESCRIPTION'),
(245, 'user_cp_style', '2', 'LNG_USER_CP_STYLE', 'LNG_USER_CP_STYLE_DESCRIPTION'),
(246, 'session_view', '2', 'LNG_SESSION_VIEW', 'LNG_SESSION_VIEW_DESCRIPTION'),
(247, 'linkedin_client_id', '', 'LNG_LINKEDIN_CLIENT_ID', 'LNG_LINKEDIN_CLIENT_ID_DESCRIPTION'),
(248, 'linkedin_client_secret', '', 'LNG_LINKEDIN_CLIENT_SECRET', 'LNG_LINKEDIN_CLIENT_SECRET_DESCRIPTION'),
(249, 'autocomplete_config', '{\"google\":{\"street_number\":[\"street_number\"],\"route\":[\"route\"],\"locality\":[\"locality\",\"administrative_area_level_1\"],\"area_id\":[\"administrative_area_level_2\"],\"administrative_area_level_1\":[\"administrative_area_level_1\"],\"administrative_area_level_2\":[\"administrative_area_level_2\"],\"country\":[\"country\"],\"postal_code\":[\"postal_code\"]},\"bing\":{\"street_number\":[\"street_number\"],\"route\":[\"addressLine\"],\"locality\":[\"city\"],\"area_id\":[\"district\"],\"administrative_area_level_1\":[\"adminDistrict\"],\"administrative_area_level_2\":[\"district\"],\"country\":[\"countryRegion\"],\"postal_code\":[\"postalCode\"]},\"openstreet\":{\"street_number\":[\"street_number\",\"house_number\"],\"route\":[\"street\",\"road\",\"suburb\"],\"locality\":[\"city\",\"town\"],\"area_id\":[\"county\"],\"administrative_area_level_1\":[\"county\"],\"administrative_area_level_2\":[\"state\"],\"country\":[\"country\"],\"postal_code\":[\"postcode\"]}}', 'LNG_AUTOCOMPLETE_CONFIGURATION', 'LNG_AUTOCOMPLETE_CONFIGURATION_DESCRIPTION'),
(250, 'vat_config', '', 'LNG_VAT_CONFIGURATION', 'LNG_VAT_CONFIGURATION_DESCRIPTION'),
(251, 'enable_elastic_search', '0', 'LNG_ENABLE_ELASTIC_SEARCH', 'LNG_ENABLE_ELASTIC_SEARCH_DESCRIPTION'),
(252, 'elastic_search_version', '7', 'LNG_ELASTIC_VERSION', 'LNG_ELASTIC_VERSION_DESCRIPTION'),
(253, 'elastic_endpoint', NULL, 'LNG_ELASTIC_ENDPOINT', 'LNG_ELASTIC_ENDPOINT_DESCRIPTION'),
(254, 'elastic_search_endpoint', NULL, 'LNG_ELASTIC_SEARCH_ENDPOINT', 'LNG_ELASTIC_SEARCH_ENDPOINT_DESCRIPTION'),
(255, 'elastic_search_index', NULL, 'LNG_ELASTIC_SEARCH_INDEX', 'LNG_ELASTIC_SEARCH_INDEX_DESCRIPTION'),
(256, 'elastic_search_user', NULL, 'LNG_ELASTIC_SEARCH_USER', 'LNG_ELASTIC_SEARCH_USER_DESCRIPTION'),
(257, 'elastic_search_password', NULL, 'LNG_ELASTIC_SEARCH_PASSWORD', 'LNG_ELASTIC_SEARCH_PASSWORD_DESCRIPTION'),
(258, 'show_recommended', '1', 'LNG_SHOW_RECOMMENDED', 'LNG_SHOW_RECOMMENDED_DESCRIPTION'),
(259, 'package_upgrade_banner', '0', 'LNG_SHOW_BANNER_UPGRADE_PACKAGE', 'LNG_BANNER_UPGRADE_PACKAGE_DESC'),
(260, 'show_privacy', '0', 'LNG_PRIVACY_POLICY', 'LNG_PRIVACY_POLICY_DESC'),
(261, 'packages_vat_apply', '0', 'LNG_APPLY_VAT_DIRECTLY', 'LNG_APPLY_VAT_DIRECTLY_DESC'),
(262, 'category_url_naming', 'category', 'LNG_CATEGORY_URL_NAMING', 'LNG_CATEGORY_URL_NAMING_DESC'),
(263, 'offer_category_url_naming', 'offer-category', 'LNG_OFFER_CATEGORY_URL_NAMING', 'LNG_OFFER_CATEGORY_URL_NAMING_DESC'),
(264, 'event_category_url_naming', 'event-category', 'LNG_EVENT_CATEGORY_URL_NAMING', 'LNG_EVENT_CATEGORY_URL_NAMING_DESC'),
(265, 'offer_url_naming', 'offer', 'LNG_OFFER_URL_NAMING', 'LNG_OFFER_URL_NAMING_DESC'),
(266, 'event_url_naming', 'event', 'LNG_EVENT_URL_NAMING', 'LNG_EVENT_URL_NAMING_DESC'),
(267, 'city_url_naming', 'city', 'LNG_CITY_URL_NAMING', 'LNG_CITY_URL_NAMING_DESC'),
(268, 'region_url_naming', 'region', 'LNG_REGION_URL_NAMING', 'LNG_REGION_URL_NAMING_DESC'),
(269, 'conference_url_naming', 'conference', 'LNG_CONFERENCE_URL_NAMING', 'LNG_CONFERENCE_URL_NAMING_DESC'),
(270, 'conference_session_url_naming', 'session', 'LNG_CONFERENCE_SESSION_URL_NAMING', 'LNG_CONFERENCE_SESSION_URL_NAMING_DESC'),
(271, 'speaker_url_naming', 'speaker', 'LNG_SPEAKER_URL_NAMING', 'LNG_SPEAKER_URL_NAMING_DESC'),
(272, 'projects_style', '1', 'LNG_BUSINESS_PROJECTS_STYLE', 'LNG_BUSINESS_PROJECTS_STYLE_DESCRIPTION'),
(273, 'projects_show_images', '1', 'LNG_BUSINESS_PROJECTS_SHOW_ADDITIONAL_IMAGES', 'LNG_BUSINESS_PROJECTS_SHOW_ADDITIONAL_IMAGES_DESCRIPTION'),
(274, 'edit_ratings', '0', 'LNG_EDIT_RATINGS', 'LNG_EDIT_RATINGS_DESCRIPTION'),
(275, 'show_cp_suggestions', '0', 'LNG_SHOW_CP_SUGGESTIONS', 'LNG_SHOW_CP_SUGGESTIONS_DESCRIPTION'),
(276, 'privacy_policy', '', 'LNG_PRIVACY_POLICY', 'LNG_PRIVACY_POLICY'),
(277, 'enable_linked_listings', '0', 'LNG_ENABLE_LINKED_LISTINGS', 'LNG_ENABLE_LINKED_LISTINGS_DESC'),
(278, 'speaker_img_width', '600', 'LNG_SPEAKER_IMG_WIDTH', 'LNG_LNG_SPEAKER_IMG_WIDTH_DESCRIPTION'),
(279, 'speaker_img_height', '600', 'LNG_SPEAKER_IMG_HEIGHT', 'LNG_SPEAKER_IMG_HEIGHT_DESCRIPTION'),
(281, 'order_by_fields', 'packageOrder,id_desc,id_asc,companyName_asc,companyName_desc,city,review_score,distance', 'LNG_SELECT_ORDER_BY_FIELDS', 'LNG_SELECT_ORDER_BY_DESCRIPTION'),
(282, 'default_bg_listing', '', 'LNG_DEFAULT_BG_LISTING', 'LNG_DEFAULT_BG_LISTING_DESC'),
(283, 'video_url_naming', 'video', 'LNG_VIDEO_URL_NAMING', 'LNG_VIDEO_URL_NAMING_DESC'),
(284, 'show_offer_price_list', '0', 'LNG_SHOW_PRICE_LIST', 'LNG_SHOW_PRICE_LIST_DESC'),
(285, 'offer_price_list_view_style', '1', 'LNG_OFFER_PRICE_LIST_VIEW_STYLE', 'LNG_OFFER_PRICE_LIST_VIEW_STYLE_DESC'),
(286, 'allow_business_view_style_change', '0', 'LNG_BUSINESS_VIEW_CHANGE', 'LNG_BUSINESS_VIEW_CHANGE_DESC'),
(287, 'location_map_marker', '', 'LNG_LOCATION_MAP_MARKER', 'LNG_LOCATION_MAP_MARKER_DETAILS'),
(288, 'show_terms_conditions_article', '0', 'LNG_TERMS_CONDITIONS_ARTICLE', 'LNG_TERMS_CONDITIONS_ARTICLE_DESC'),
(289, 'terms_conditions_article_id', '', 'LNG_TERMS_CONDITIONS_ARTICLE_ID', 'LNG_TERMS_CONDITIONS_ARTICLE_DESC'),
(290, 'reviews_terms_conditions_article_id', '', 'LNG_REVIEWS_TERMS_CONDITIONS_ARTICLE_ID', 'LNG_REVIEWS_TERMS_CONDITIONS_ARTICLE_ID_DESC'),
(291, 'contact_terms_conditions_article_id', '', 'LNG_CONTACT_TERMS_CONDITIONS_ARTICLE_ID', 'LNG_CONTACT_TERMS_CONDITIONS_ARTICLE_ID_DESC'),
(292, 'privacy_policy_article_id', '', 'LNG_PRICACY_POLICY_ARTICLE_ID', 'LNG_PRICACY_POLICY_ARTICLE_ID_DESC'),
(293, 'appointments_commission', '', 'LNG_APPOINTMENTS_COMMISSION', 'LNG_APPOINTMENTS_COMMISSION_DESC'),
(294, 'offer_selling_commission', '', 'LNG_OFFER_SELLING_COMMISSION', 'LNG_OFFER_SELLING_COMMISSION_DESC'),
(295, 'event_tickets_commission', '', 'LNG_EVENT_TICKETS_COMMISSION', 'LNG_EVENT_TICKETS_COMMISSION_DESC'),
(296, 'display_free_packages_bellow', '0', 'LNG_DISPLAY_FREE_PACKAGES_BELLOW', 'LNG_DISPLAY_FREE_PACKAGES_BELLOW_DESC'),
(297, 'display_packages_by_period', '0', 'LNG_DISPLAY_PACKAGES_BY_PERIOD', 'LNG_DISPLAY_PACKAGES_BY_PERIOD_DESC'),
(298, 'custom_registration', '1', 'LNG_CUSTOM_REGISTRATION', 'LNG_CUSTOM_REGISTRATION_DESC'),
(299, 'last_schema_check_version', '5.7.4', 'LNG_SCHEMA_VERSION_CHECK', 'LNG_SCHEMA_VERSION_CHECK_DESC'),
(300, 'enable_advanced_search_filter', '0', 'LNG_ENABLE_ADVANCED_FILTER', 'LNG_ENABLE_ADVANCED_FILTER_DESC'),
(301, 'videos_url_naming', 'videos', 'LNG_VIDEOS_URL_NAMING', 'LNG_VIDEOS_URL_NAMING_DESC'),
(302, 'show_verified_review_badge', '0', 'LNG_SHOW_VERIFIED_REVIEW_BADGE', 'LNG_SHOW_VERIFIED_REVIEW_BADGE_DESCRIPTION'),
(303, 'user_login_position', '1', 'LNG_USER_LOGIN_POSITION', 'LNG_USER_LOGIN_POSITION_DESCRIPTION'),
(304, 'service_notification_days', '5', 'LNG_SERVICE_NOTIFICATION_DAYS', 'LNG_SERVICE_NOTIFICATION_DAYS_DESCRIPTION'),
(305, 'quote_request_type', '0', 'LNG_QUOTE_REQUEST_TYPE', 'LNG_QUOTE_REQUEST_TYPE_DESCRIPTION'),
(306, 'quote_search_type', '0', 'LNG_QUOTE_SEARCH_TYPE', 'LNG_QUOTE_SEARCH_TYPE_DESCRIPTION'),
(307, 'quotes_search_filter_fields', '', 'LNG_SELECT_FILTER_FIELDS', 'LNG_SELECT_SEARCH_FILTER_DESCRIPTION'),
(308, 'redirect_to_listing', '0', 'LNG_REDIRECT_TO_LISTING', 'LNG_REDIRECT_TO_LISTING_DESCRIPTION'),
(309, 'lazy_loading', '0', 'LNG_LAZY_LOADING', 'LNG_LAZY_LOADING_DESCRIPTION'),
(310, 'trips_url_naming', 'trips', 'LNG_TRIPS_URL_NAMING', 'LNG_TRIPS_URL_NAMING_DESC'),
(311, 'trip_url_naming', 'trip', 'LNG_TRIP_URL_NAMING', 'LNG_TRIP_URL_NAMING_DESC'),
(312, 'search_categories', '', 'LNG_SELECT_SEARCH_CATEGORIES', 'LNG_SELECT_SEARCH_CATEGORIES_DESCRIPTION'),
(313, 'show_top_filter', '0', 'LNG_SHOW_TOP_FILTER', 'LNG_SHOW_TOP_FILTER_DESCRIPTION'),
(314, 'paid_business_usergroup', '', 'LNG_PAID_BUSINESS_USERGROUP', 'LNG_PAID_BUSINESS_USERGROUP_DESCRIPTION'),
(315, 'cities_regions_order', '1', NULL, NULL),
(316, 'uploadLogo', '', NULL, NULL),
(317, 'config-google-street_number', 'street_number', NULL, NULL),
(318, 'config-google-route', 'route', NULL, NULL),
(319, 'config-google-locality', 'locality,administrative_area_level_1', NULL, NULL),
(320, 'config-google-area_id', 'administrative_area_level_2', NULL, NULL),
(321, 'config-google-administrative_area_level_1', 'administrative_area_level_1', NULL, NULL),
(322, 'config-google-administrative_area_level_2', 'administrative_area_level_2', NULL, NULL),
(323, 'config-google-country', 'country', NULL, NULL),
(324, 'config-google-postal_code', 'postal_code', NULL, NULL),
(325, 'config-bing-street_number', 'street_number', NULL, NULL),
(326, 'config-bing-route', 'addressLine', NULL, NULL),
(327, 'config-bing-locality', 'city', NULL, NULL),
(328, 'config-bing-area_id', 'district', NULL, NULL),
(329, 'config-bing-administrative_area_level_1', 'adminDistrict', NULL, NULL),
(330, 'config-bing-administrative_area_level_2', 'district', NULL, NULL),
(331, 'config-bing-country', 'countryRegion', NULL, NULL),
(332, 'config-bing-postal_code', 'postalCode', NULL, NULL),
(333, 'config-openstreet-street_number', 'street_number,house_number', NULL, NULL),
(334, 'config-openstreet-route', 'street,road,suburb', NULL, NULL),
(335, 'config-openstreet-locality', 'city,town', NULL, NULL),
(336, 'config-openstreet-area_id', 'county', NULL, NULL),
(337, 'config-openstreet-administrative_area_level_1', 'county', NULL, NULL),
(338, 'config-openstreet-administrative_area_level_2', 'state', NULL, NULL),
(339, 'config-openstreet-country', 'country', NULL, NULL),
(340, 'config-openstreet-postal_code', 'postcode', NULL, NULL),
(341, 'marker_size_width', '', NULL, NULL),
(342, 'marker_size_height', '', NULL, NULL),
(343, 'css-content', '', NULL, NULL),
(344, 'a2b501e7dcf787da3ebb2ce8d6f066bc', '1', NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_attributes`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_attributes`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_attributes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `code` varchar(100) DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `is_mandatory` int(1) NOT NULL DEFAULT '0',
  `show_in_filter` tinyint(1) NOT NULL DEFAULT '1',
  `only_for_admin` tinyint(1) NOT NULL DEFAULT '0',
  `show_in_front` tinyint(1) NOT NULL DEFAULT '0',
  `show_on_search` tinyint(1) NOT NULL DEFAULT '0',
  `show_icon` tinyint(1) NOT NULL DEFAULT '0',
  `show_name` tinyint(1) NOT NULL DEFAULT '1',
  `color` varchar(10) DEFAULT NULL,
  `group` varchar(255) DEFAULT NULL,
  `ordering` tinyint(4) NOT NULL DEFAULT '0',
  `attribute_type` tinyint(1) NOT NULL DEFAULT '1',
  `show_in_list_view` tinyint(1) NOT NULL DEFAULT '0',
  `use_attribute_for_selling` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_status` (`status`),
  KEY `idx_type` (`type`),
  KEY `idx_attribute_type` (`attribute_type`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_attributes`
--

INSERT INTO `#__jbusinessdirectory_attributes` (`id`, `name`, `code`, `type`, `status`, `is_mandatory`, `show_in_filter`, `only_for_admin`, `show_in_front`, `show_on_search`, `show_icon`, `show_name`, `color`, `group`, `ordering`, `attribute_type`, `show_in_list_view`, `use_attribute_for_selling`) VALUES
(10, 'Multiple checkbox', 'multiple-checkbox', 3, 1, 0, 0, 0, 1, 0, 0, 1, '', '', 0, 1, 0, 0),
(11, 'Attribute 2', 'attribute-2', 3, 1, 0, 0, 0, 1, 0, 0, 0, '', '', 0, 1, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_attribute_category`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_attribute_category`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_attribute_category` (
  `attributeId` int(11) NOT NULL,
  `categoryId` int(11) NOT NULL,
  PRIMARY KEY (`attributeId`,`categoryId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_attribute_category`
--

INSERT INTO `#__jbusinessdirectory_attribute_category` (`attributeId`, `categoryId`) VALUES
(10, -1),
(11, -1);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_attribute_options`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_attribute_options`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_attribute_options` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `attribute_id` int(11) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  `icon` varchar(50) DEFAULT NULL,
  `ordering` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_attribute_id` (`attribute_id`)
) ENGINE=MyISAM AUTO_INCREMENT=59 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_attribute_options`
--

INSERT INTO `#__jbusinessdirectory_attribute_options` (`id`, `attribute_id`, `name`, `icon`, `ordering`) VALUES
(51, 10, 'Option 1', '', 0),
(52, 10, 'Option 2', '', 1),
(53, 10, 'Option 3', '', 2),
(54, 11, 'val 1', '', 0),
(55, 11, 'val 2', '', 1),
(56, 11, 'val 3', '', 2),
(57, 11, 'val 4', '', 3),
(58, 11, 'val 5', '', 4);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_attribute_types`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_attribute_types`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_attribute_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(255) DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_attribute_types`
--

INSERT INTO `#__jbusinessdirectory_attribute_types` (`id`, `code`, `name`) VALUES
(1, 'input', 'Input'),
(2, 'select_box', 'Select Box'),
(3, 'checkbox', 'Checkbox(Multiple Select)'),
(4, 'radio', 'Radio(Single Select)'),
(5, 'header', 'Header'),
(6, 'textarea', 'Textarea'),
(7, 'link', 'Link'),
(8, 'multiselect', 'Multiple Select Box');

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_billing_details`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_billing_details`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_billing_details` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(45) DEFAULT NULL,
  `last_name` varchar(45) DEFAULT NULL,
  `company_name` varchar(55) DEFAULT NULL,
  `address` varchar(255) DEFAULT NULL,
  `street_number` varchar(20) DEFAULT NULL,
  `postal_code` varchar(45) DEFAULT NULL,
  `city` varchar(45) DEFAULT NULL,
  `region` varchar(45) DEFAULT NULL,
  `country` varchar(45) DEFAULT NULL,
  `email` varchar(45) DEFAULT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `vat_details` varchar(455) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_bookmarks`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_bookmarks`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_bookmarks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `item_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `note` varchar(255) DEFAULT NULL,
  `item_type` tinyint(1) DEFAULT '1',
  `ordering` int(11) NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `unq_bkm` (`item_id`,`user_id`,`item_type`),
  KEY `idx_item_id` (`item_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_item_type` (`item_type`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_campaigns`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_campaigns`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_campaigns` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(145) NOT NULL,
  `initial_budget` decimal(12,2) DEFAULT '0.00',
  `budget` decimal(12,2) DEFAULT '0.00',
  `status` tinyint(4) DEFAULT '0',
  `published` tinyint(4) DEFAULT '1',
  `company_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_company_id` (`company_id`),
  KEY `idx_status` (`published`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_campaigns`
--

INSERT INTO `#__jbusinessdirectory_campaigns` (`id`, `name`, `initial_budget`, `budget`, `status`, `published`, `company_id`) VALUES
(1, 'Vintage campaign', '2000.00', '2000.00', 1, 1, 8);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_campaign_has_plans`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_campaign_has_plans`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_campaign_has_plans` (
  `campaign_id` int(11) NOT NULL,
  `campaign_plan_id` int(11) NOT NULL,
  `nr_clicks` int(11) DEFAULT '0',
  PRIMARY KEY (`campaign_id`,`campaign_plan_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_campaign_has_plans`
--

INSERT INTO `#__jbusinessdirectory_campaign_has_plans` (`campaign_id`, `campaign_plan_id`, `nr_clicks`) VALUES
(1, 1, 0),
(1, 2, 0),
(1, 3, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_campaign_plans`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_campaign_plans`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_campaign_plans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(145) DEFAULT NULL,
  `image` varchar(100) DEFAULT NULL,
  `click_price` decimal(12,2) DEFAULT NULL,
  `published` tinyint(4) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_published` (`published`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_campaign_plans`
--

INSERT INTO `#__jbusinessdirectory_campaign_plans` (`id`, `name`, `image`, `click_price`, `published`) VALUES
(1, 'Home page ', '', '1.00', 1),
(2, 'Search results', '', '0.50', 1),
(3, 'Listing details', '', '0.50', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_categories`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_categories`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `parent_id` int(11) NOT NULL DEFAULT '0',
  `lft` int(11) NOT NULL DEFAULT '0',
  `rgt` int(11) NOT NULL DEFAULT '0',
  `level` int(10) UNSIGNED NOT NULL DEFAULT '0',
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `name` varchar(100) DEFAULT NULL,
  `alias` varchar(100) DEFAULT NULL,
  `description` text,
  `published` tinyint(4) NOT NULL DEFAULT '1',
  `imageLocation` varchar(250) DEFAULT NULL,
  `markerLocation` varchar(250) DEFAULT NULL,
  `color` varchar(10) DEFAULT NULL,
  `icon` varchar(50) DEFAULT NULL,
  `path` varchar(255) DEFAULT NULL,
  `clickCount` int(11) NOT NULL DEFAULT '0',
  `meta_title` varchar(255) DEFAULT NULL,
  `meta_description` text,
  `meta_keywords` varchar(255) DEFAULT NULL,
  `iconImgLocation` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_alias` (`alias`),
  KEY `idx_parent` (`parent_id`),
  KEY `idx_name` (`name`),
  KEY `idx_state` (`published`),
  KEY `idx_type` (`type`),
  KEY `idx_lft` (`lft`),
  KEY `idx_rgt` (`rgt`),
  KEY `idx_level` (`level`)
) ENGINE=MyISAM AUTO_INCREMENT=236 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_categories`
--

INSERT INTO `#__jbusinessdirectory_categories` (`id`, `parent_id`, `lft`, `rgt`, `level`, `type`, `name`, `alias`, `description`, `published`, `imageLocation`, `markerLocation`, `color`, `icon`, `path`, `clickCount`, `meta_title`, `meta_description`, `meta_keywords`, `iconImgLocation`) VALUES
(1, 0, 0, 410, 0, 0, 'root', '', '1', 1, '', NULL, '', '0', NULL, 0, NULL, NULL, NULL, NULL),
(12, 1, 31, 32, 1, 1, 'Books', 'books-1-1', '', 1, '/categories/Reading-1519301686.jpg', NULL, '', 'book', 'books-1-1', 0, '', '', '', NULL),
(34, 7, 83, 84, 2, 1, 'Software', 'software', '', 1, '', NULL, '', '', 'electronics-1/software', 0, NULL, NULL, NULL, NULL),
(35, 8, 129, 130, 2, 1, 'Women', 'women', '', 1, '', NULL, '', '', 'fashion-1/women', 0, NULL, NULL, NULL, NULL),
(36, 8, 125, 126, 2, 1, 'Man', 'man', '', 1, '', NULL, '', '', 'fashion-1/man', 0, NULL, NULL, NULL, NULL),
(37, 8, 123, 124, 2, 1, 'Kids & Baby', 'kids-&-baby', '', 1, '', NULL, '', '', 'fashion-1/kids-&-baby', 0, NULL, NULL, NULL, NULL),
(38, 8, 127, 128, 2, 1, 'Shoes', 'shoes', '', 1, '', NULL, '', '', 'fashion-1/shoes', 0, NULL, NULL, NULL, NULL),
(39, 29, 153, 154, 2, 1, 'Grocery & Gourmet Food', 'grocery-&-gourmet-food', '', 1, '', NULL, '', '', 'grocery-health-beauty-1/grocery-&-gourmet-food', 0, NULL, NULL, NULL, NULL),
(40, 29, 159, 160, 2, 1, 'Wine', 'wine', '', 1, '', NULL, '', '', 'grocery-health-beauty-1/wine', 0, NULL, NULL, NULL, NULL),
(41, 29, 157, 158, 2, 1, 'Natural & Organic', 'natural-&-organic', '', 1, '', NULL, '', '', 'grocery-health-beauty-1/natural-&-organic', 0, NULL, NULL, NULL, NULL),
(42, 29, 155, 156, 2, 1, 'Health & Personal Care', 'health-&-personal-care', '', 1, '', NULL, '', '', 'grocery-health-beauty-1/health-&-personal-care', 0, NULL, NULL, NULL, NULL),
(43, 11, 189, 190, 2, 1, 'Kitchen & Dining', 'kitchen-&-dining', '', 1, '', NULL, '', '', 'home-garden-1/kitchen-&-dining', 0, NULL, NULL, NULL, NULL),
(44, 11, 187, 188, 2, 1, 'Furniture & D', 'furniture-&-d', '', 1, '', NULL, '', '', 'home-garden-1/furniture-&-d', 0, NULL, NULL, NULL, NULL),
(45, 11, 185, 186, 2, 1, 'Bedding & Bath', 'bedding-&-bath', '', 1, '', NULL, '', '', 'home-garden-1/bedding-&-bath', 0, NULL, NULL, NULL, NULL),
(46, 11, 191, 192, 2, 1, 'Patio, Lawn & Garden', 'patio,-lawn-&-garden', '', 1, '', NULL, '', '', 'home-garden-1/patio,-lawn-&-garden', 0, NULL, NULL, NULL, NULL),
(47, 11, 183, 184, 2, 1, 'Arts, Crafts & Sewing', 'arts,-crafts-&-sewing', '', 1, '', NULL, '', '', 'home-garden-1/arts,-crafts-&-sewing', 0, NULL, NULL, NULL, NULL),
(48, 30, 227, 228, 2, 1, 'Watches', 'watches', '', 1, '', NULL, '', '', 'jewelry/watches', 0, NULL, NULL, NULL, NULL),
(49, 30, 225, 226, 2, 1, 'Fine Jewelry', 'fine-jewelry', '', 1, '', NULL, '', '', 'jewelry/fine-jewelry', 0, NULL, NULL, NULL, NULL),
(51, 30, 221, 222, 2, 1, 'Fashion Jewelry', 'fashion-jewelry', '', 1, '', NULL, '', '', 'jewelry/fashion-jewelry', 0, NULL, NULL, NULL, NULL),
(52, 30, 223, 224, 2, 1, 'Fashion Jewelry', 'fashion-jewelry', '', 1, '', NULL, '', '', 'jewelry/fashion-jewelry', 0, NULL, NULL, NULL, NULL),
(53, 30, 219, 220, 2, 1, 'Engagement & Wedding', 'engagement-&-wedding', '', 1, '', NULL, '', '', 'jewelry/engagement-&-wedding', 0, NULL, NULL, NULL, NULL),
(54, 10, 259, 260, 2, 1, 'Movies & TV', 'movies-&-tv', '', 1, '', NULL, '', '', 'movies-music-games-1/movies-&-tv', 0, NULL, NULL, NULL, NULL),
(55, 10, 255, 256, 2, 1, 'Blu-ray', 'blu-ray', '', 1, '', NULL, '', '', 'movies-music-games-1/blu-ray', 0, NULL, NULL, NULL, NULL),
(30, 1, 217, 218, 1, 1, 'Jewelry', 'jewelry', '<p>Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po</p>', 1, '/categories/jewelery-1519648439.jpg', NULL, '', 'heart', 'jewelry', 0, '', '', '', NULL),
(5, 1, 337, 338, 1, 1, 'Sports & Outdors', 'sports-outdors-1', '<p>Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po</p>', 1, '/categories/outdoor-1519303622.jpg', NULL, '', 'male', 'sports-outdors-1', 0, '', '', '', NULL),
(31, 7, 75, 76, 2, 1, 'Cell Phones & Accessories', 'cell-phones-&-accessories', '', 1, '', NULL, '', '', 'electronics-1/cell-phones-&-accessories', 0, NULL, NULL, NULL, NULL),
(7, 1, 73, 74, 1, 1, 'Electronics', 'electronics-1', '<p>Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po</p>', 1, '/categories/electronics-1519648407.jpg', NULL, '', 'laptop', 'electronics-1', 0, '', '', '', NULL),
(8, 1, 121, 122, 1, 1, 'Fashion', 'fashion-1', '<p>Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po</p>', 1, '/categories/fashion-1519291715.jpg', NULL, '', 'gift', 'fashion-1', 0, '', '', '', NULL),
(9, 1, 373, 374, 1, 1, 'Toy,Kids & Babies', 'toy-kids-babies-1', '<p>Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po</p>', 1, '/categories/toys-1519648484.jpg', NULL, '', 'cab', 'toy-kids-babies-1', 0, '', '', '', NULL),
(10, 1, 253, 254, 1, 1, 'Movies, Music & Games', 'movies-music-games-1', '', 1, '/categories/music-1519302667.jpg', NULL, '', 'music', 'movies-music-games-1', 0, '', '', '', NULL),
(11, 1, 181, 182, 1, 1, 'Home & Garden', 'home-garden-1', '<p>Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po</p>', 1, '/categories/home-1519291684.jpg', NULL, '', 'home', 'home-garden-1', 0, '', '', '', NULL),
(32, 7, 87, 88, 2, 1, 'Video Games', 'video-games', '', 1, '', NULL, '', '', 'electronics-1/video-games', 0, NULL, NULL, NULL, NULL),
(33, 7, 77, 78, 2, 1, 'Computer Parts & Components', 'computer-parts-&-components', '', 1, '', NULL, '', '', 'electronics-1/computer-parts-&-components', 0, NULL, NULL, NULL, NULL),
(28, 7, 79, 80, 2, 1, 'Electronics Accessories', 'electronics-accessories', '', 1, '', NULL, '', '', 'electronics-1/electronics-accessories', 0, NULL, NULL, NULL, NULL),
(26, 7, 81, 82, 2, 1, 'Home, Audio & Theater', 'home,-audio-&-theater', '', 1, '', NULL, '', '', 'electronics-1/home,-audio-&-theater', 0, NULL, NULL, NULL, NULL),
(25, 7, 85, 86, 2, 1, 'TV ', 'tv-', '', 1, '', NULL, '', '', 'electronics-1/tv-', 0, NULL, NULL, NULL, NULL),
(24, 13, 59, 60, 2, 1, 'Photography', 'photography-1', '', 1, '', NULL, '', 'camera-retro', 'camera-photography-1/photography-1', 0, NULL, NULL, NULL, NULL),
(23, 13, 57, 58, 2, 1, 'Camera', 'camera', '', 1, '', NULL, '', '', 'camera-photography-1/camera', 0, NULL, NULL, NULL, NULL),
(21, 12, 37, 38, 2, 1, 'Textbooks', 'textbooks', '', 1, '', NULL, '', '', 'books-1-1/textbooks', 0, NULL, NULL, NULL, NULL),
(22, 12, 35, 36, 2, 1, 'Children\'s Books', 'children\'s-books', '', 1, '', NULL, '', '', 'books-1-1/children\'s-books', 0, NULL, NULL, NULL, NULL),
(19, 12, 33, 34, 2, 1, 'Books', 'books', '', 1, '', NULL, '', '', 'books-1-1/books', 0, NULL, NULL, NULL, NULL),
(18, 74, 9, 10, 2, 1, 'Tires ', 'tires-', '', 1, '', NULL, '', '', 'automotive-motors-1/tires-', 0, NULL, NULL, NULL, NULL),
(17, 74, 7, 8, 2, 1, 'Car Electronics', 'car-electronics', '', 1, '', NULL, '', '', 'automotive-motors-1/car-electronics', 0, NULL, NULL, NULL, NULL),
(16, 74, 5, 6, 2, 1, 'Automotive Tools', 'automotive-tools', '', 1, '', NULL, '', '', 'automotive-motors-1/automotive-tools', 0, NULL, NULL, NULL, NULL),
(14, 74, 3, 4, 2, 1, 'Automotive Parts', 'automotive-parts', '', 1, '', NULL, '', '', 'automotive-motors-1/automotive-parts', 0, NULL, NULL, NULL, NULL),
(13, 1, 55, 56, 1, 1, 'Camera & Photography', 'camera-photography-1', '<p>Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po</p>', 1, '/categories/photography-1519301785.jpg', NULL, '', 'camera', 'camera-photography-1', 0, '', '', '', NULL),
(56, 10, 263, 264, 2, 1, 'Musical Instruments', 'musical-instruments', '', 1, '', NULL, '', '', 'movies-music-games-1/musical-instruments', 0, NULL, NULL, NULL, NULL),
(57, 10, 261, 262, 2, 1, 'MP3 Downloads', 'mp3-downloads', '', 1, '', NULL, '', '', 'movies-music-games-1/mp3-downloads', 0, NULL, NULL, NULL, NULL),
(58, 10, 257, 258, 2, 1, 'Game Downloads', 'game-downloads', '', 1, '', NULL, '', '', 'movies-music-games-1/game-downloads', 0, NULL, NULL, NULL, NULL),
(59, 5, 341, 342, 2, 1, 'Exercise & Fitness', 'exercise-&-fitness', '', 1, '', NULL, '', '', 'sports-outdors-1/exercise-&-fitness', 0, NULL, NULL, NULL, NULL),
(60, 5, 345, 346, 2, 1, 'Outdoor Recreation', 'outdoor-recreation', '', 1, '', NULL, '', '', 'sports-outdors-1/outdoor-recreation', 0, NULL, NULL, NULL, NULL),
(61, 5, 343, 344, 2, 1, 'Hunting & Fishing', 'hunting-&-fishing', '', 1, '', NULL, '', '', 'sports-outdors-1/hunting-&-fishing', 0, NULL, NULL, NULL, NULL),
(62, 5, 339, 340, 2, 1, 'Cycling', 'cycling', '', 1, '', NULL, '', '', 'sports-outdors-1/cycling', 0, NULL, NULL, NULL, NULL),
(63, 5, 347, 348, 2, 1, 'Team Sports', 'team-sports', '', 1, '', NULL, '', '', 'sports-outdors-1/team-sports', 0, NULL, NULL, NULL, NULL),
(64, 9, 381, 382, 2, 1, 'Toys & Games', 'toys-&-games', '', 1, '', NULL, '', '', 'toy-kids-babies-1/toys-&-games', 0, NULL, NULL, NULL, NULL),
(65, 9, 375, 376, 2, 1, 'Baby', 'baby', '', 1, '', NULL, '', '', 'toy-kids-babies-1/baby', 0, NULL, NULL, NULL, NULL),
(66, 9, 379, 380, 2, 1, 'Clothing (Kids & Baby)', 'clothing-(kids-&-baby)', '', 1, '', NULL, '', '', 'toy-kids-babies-1/clothing-(kids-&-baby)', 0, NULL, NULL, NULL, NULL),
(67, 9, 383, 384, 2, 1, 'Video Games for Kids', 'video-games-for-kids', '', 1, '', NULL, '', '', 'toy-kids-babies-1/video-games-for-kids', 0, NULL, NULL, NULL, NULL),
(68, 9, 377, 378, 2, 1, 'Baby Registry', 'baby-registry', '', 1, '', NULL, '', '', 'toy-kids-babies-1/baby-registry', 0, NULL, NULL, NULL, NULL),
(69, 3, 323, 324, 2, 1, 'Services', 'services', '', 1, '', NULL, '', '', 'services-1/services', 0, NULL, NULL, NULL, NULL),
(70, 3, 321, 322, 2, 1, 'IT Services', 'it-services', '', 1, '', NULL, '', '', 'services-1/it-services', 0, NULL, NULL, NULL, NULL),
(29, 1, 151, 152, 1, 1, 'Health & Beauty', 'grocery-health-beauty-1', '', 1, '/categories/healthbeauty-1519304769.jpg', NULL, '', 'heart', 'grocery-health-beauty-1', 0, '', '', '', NULL),
(3, 1, 319, 320, 1, 1, 'Services', 'services-1', '<p>Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po</p>', 1, '/categories/services-1519303368.jpg', NULL, '', 'area-chart', 'services-1', 0, '', '', '', NULL),
(74, 1, 1, 2, 1, 1, 'Automotive & Motors', 'automotive-motors-1', '<p>Pellentesque convallis est vel velit luctus, in consequat tortor r<strong>utrum. In lectus quam  </strong> , tempor eu a sdf   sdiam ef fi citur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po</p>', 1, '/categories/automotive-1519648388.jpg', NULL, '', 'car', 'automotive-motors-1', 0, '', '', '', NULL),
(75, 1, 295, 296, 1, 1, 'Restaurants', 'restaurants-1', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam purus libero, luctus id felis at, porta malesuada massa. Vestibulum vitae imperdiet justo, eget ullamcorper nunc. Cras eget ligula sodales, congue lacus eget, tincidunt justo. Ut vestibulum bibendum ante, vitae scelerisque leo faucibus id. Nunc congue, justo id porttitor fringilla, ipsum ex rutrum lorem, in sodales nisi ipsum at massa. Duis a cursus ipsum. Aliquam vitae est tortor. Aenean aliquet ultrices magna et efficitur. Mauris c</p>', 1, '/categories/restaurant-1519304216.jpg', NULL, '', 'cutlery', 'restaurants-1', 0, '', '', '', NULL),
(76, 75, 297, 298, 2, 1, 'Asian Restaurants', 'asian-restaurants', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam purus libero, luctus id felis at, porta malesuada massa. Vestibulum vitae imperdiet justo, eget ullamcorper nunc. Cras eget ligula sodales, congue lacus eget, tincidunt justo. Ut vestibulum bibendum ante, vitae scelerisque leo faucibus id. Nunc congue, justo id porttitor fringilla, ipsum ex rutrum lorem, in sodales nisi ipsum at massa. Duis a cursus ipsum. Aliquam vitae est tortor. Aenean aliquet ultrices magna et efficitur.', 1, '', NULL, '', '', 'restaurants-1/asian-restaurants', 0, NULL, NULL, NULL, NULL),
(77, 75, 299, 300, 2, 1, 'French Restaurants', 'french-restaurants', '', 1, '', NULL, '', '', 'restaurants-1/french-restaurants', 0, NULL, NULL, NULL, NULL),
(78, 75, 301, 302, 2, 1, 'Italian Restaurants', 'italian-restaurants', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam purus libero, luctus id felis at, porta malesuada massa. Vestibulum vitae imperdiet justo, eget ullamcorper nunc. Cras eget ligula sodales, congue lacus eget, tincidunt justo. Ut vestibulum bibendum ante, vitae scelerisque leo faucibus id. Nunc congue, justo id porttitor fringilla, ipsum ex rutrum lorem, in sodales nisi ipsum at massa. Duis a cursus ipsum. Aliquam vitae est tortor. Aenean aliquet ultrices magna et efficitur.', 1, '', NULL, '', '', 'restaurants-1/italian-restaurants', 0, NULL, NULL, NULL, NULL),
(79, 1, 289, 290, 1, 1, 'Real Estate', 'real-estate-1', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam purus libero, luctus id felis at, porta malesuada massa. Vestibulum vitae imperdiet justo, eget ullamcorper nunc. Cras eget ligula sodales, congue lacus eget, tincidunt justo. Ut vestibulum bibendum ante, vitae scelerisque leo faucibus id. Nunc congue, justo id porttitor fringilla, ipsum ex rutrum lorem, in sodales nisi ipsum at massa. Duis a cursus ipsum. Aliquam vitae est tortor. Aenean aliquet ultrices magna et efficitur.</p>', 1, '/categories/realestate-1519302775.jpg', NULL, '', 'building', 'real-estate-1', 0, '', '', '', NULL),
(80, 1, 39, 40, 1, 2, 'Books', 'books-1', '', 1, '/categories/image5-1427100316.jpg', NULL, '', '', 'books-1', 0, NULL, NULL, NULL, NULL),
(81, 105, 99, 100, 2, 2, 'Software', 'software', '', 1, '', NULL, '', '', 'electronics/software', 0, NULL, NULL, NULL, NULL),
(82, 106, 139, 140, 2, 2, 'Women', 'women', '', 1, '', NULL, '', '', 'fashion/women', 0, NULL, NULL, NULL, NULL),
(83, 106, 135, 136, 2, 2, 'Man', 'man', '', 1, '', NULL, '', '', 'fashion/man', 0, NULL, NULL, NULL, NULL),
(84, 106, 133, 134, 2, 2, 'Kids & Baby', 'kids-&-baby', '', 1, '', NULL, '', '', 'fashion/kids-&-baby', 0, NULL, NULL, NULL, NULL),
(85, 106, 137, 138, 2, 2, 'Shoes', 'shoes', '', 1, '', NULL, '', '', 'fashion/shoes', 0, NULL, NULL, NULL, NULL),
(86, 140, 163, 164, 2, 2, 'Grocery & Gourmet Food', 'grocery-&-gourmet-food', '', 1, '', NULL, '', '', 'grocery-health-beauty/grocery-&-gourmet-food', 0, NULL, NULL, NULL, NULL),
(87, 140, 169, 170, 2, 2, 'Wine', 'wine', '', 1, '', NULL, '', '', 'grocery-health-beauty/wine', 0, NULL, NULL, NULL, NULL),
(88, 140, 167, 168, 2, 2, 'Natural & Organic', 'natural-&-organic', '', 1, '', NULL, '', '', 'grocery-health-beauty/natural-&-organic', 0, NULL, NULL, NULL, NULL),
(89, 140, 165, 166, 2, 2, 'Health & Personal Care', 'health-&-personal-care', '', 1, '', NULL, '', '', 'grocery-health-beauty/health-&-personal-care', 0, NULL, NULL, NULL, NULL),
(90, 109, 201, 202, 2, 2, 'Kitchen & Dining', 'kitchen-&-dining', '', 1, '', NULL, '', '', 'home-garden/kitchen-&-dining', 0, NULL, NULL, NULL, NULL),
(91, 109, 199, 200, 2, 2, 'Furniture & D', 'furniture-&-d', '', 1, '', NULL, '', '', 'home-garden/furniture-&-d', 0, NULL, NULL, NULL, NULL),
(92, 109, 197, 198, 2, 2, 'Bedding & Bath', 'bedding-&-bath', '', 1, '', NULL, '', '', 'home-garden/bedding-&-bath', 0, NULL, NULL, NULL, NULL),
(93, 109, 203, 204, 2, 2, 'Patio, Lawn & Garden', 'patio,-lawn-&-garden', '', 1, '', NULL, '', '', 'home-garden/patio,-lawn-&-garden', 0, NULL, NULL, NULL, NULL),
(94, 109, 195, 196, 2, 2, 'Arts, Crafts & Sewing', 'arts,-crafts-&-sewing', '', 1, '', NULL, '', '', 'home-garden/arts,-crafts-&-sewing', 0, NULL, NULL, NULL, NULL),
(95, 102, 239, 240, 2, 2, 'Watches', 'watches', '', 1, '', NULL, '', '', 'jewelry-watches/watches', 0, NULL, NULL, NULL, NULL),
(96, 102, 237, 238, 2, 2, 'Fine Jewelry', 'fine-jewelry', '', 1, '', NULL, '', '', 'jewelry-watches/fine-jewelry', 0, NULL, NULL, NULL, NULL),
(97, 102, 233, 234, 2, 2, 'Fashion Jewelry', 'fashion-jewelry', '', 1, '', NULL, '', '', 'jewelry-watches/fashion-jewelry', 0, NULL, NULL, NULL, NULL),
(98, 102, 235, 236, 2, 2, 'Fashion Jewelry', 'fashion-jewelry', '', 1, '', NULL, '', '', 'jewelry-watches/fashion-jewelry', 0, NULL, NULL, NULL, NULL),
(99, 102, 231, 232, 2, 2, 'Engagement & Wedding', 'engagement-&-wedding', '', 1, '', NULL, '', '', 'jewelry-watches/engagement-&-wedding', 0, NULL, NULL, NULL, NULL),
(100, 108, 271, 272, 2, 2, 'Movies & TV', 'movies-&-tv', '', 1, '', NULL, '', '', 'movies-music-games/movies-&-tv', 0, NULL, NULL, NULL, NULL),
(101, 108, 267, 268, 2, 2, 'Blu-ray', 'blu-ray', '', 1, '', NULL, '', '', 'movies-music-games/blu-ray', 0, NULL, NULL, NULL, NULL),
(102, 1, 229, 230, 1, 2, 'Jewelry & Watches', 'jewelry-watches', 'Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po', 1, '/categories/watch-1427100687.jpg', NULL, '', '', 'jewelry-watches', 0, NULL, NULL, NULL, NULL),
(103, 1, 349, 350, 1, 2, 'Sports & Outdors', 'sports-outdors', 'Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po', 1, '/categories/image3-1411751531.jpg', NULL, '', '', 'sports-outdors', 0, NULL, NULL, NULL, NULL),
(104, 105, 91, 92, 2, 2, 'Cell Phones & Accessories', 'cell-phones-&-accessories', '', 1, '', NULL, '', '', 'electronics/cell-phones-&-accessories', 0, NULL, NULL, NULL, NULL),
(105, 1, 89, 90, 1, 2, 'Electronics', 'electronics', 'Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po', 1, '/categories/image6-1427100355.jpg', NULL, '', '', 'electronics', 0, NULL, NULL, NULL, NULL),
(106, 1, 131, 132, 1, 2, 'Fashion', 'fashion', 'Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po', 1, '/categories/slide-image-8-1427100458.jpg', NULL, '', '', 'fashion', 0, NULL, NULL, NULL, NULL),
(107, 1, 385, 386, 1, 2, 'Toy,Kids & Babies', 'toy-kids-babies', 'Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po', 1, '/categories/image1-1427100760.jpg', NULL, '', '', 'toy-kids-babies', 0, NULL, NULL, NULL, NULL),
(108, 1, 265, 266, 1, 2, 'Movies, Music & Games', 'movies-music-games', '', 1, '/categories/image2-1427100712.jpg', NULL, '', '', 'movies-music-games', 0, NULL, NULL, NULL, NULL),
(109, 1, 193, 194, 1, 2, 'Home & Garden', 'home-garden', 'Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po', 1, '/categories/image7-1427100616.jpg', NULL, '', '', 'home-garden', 0, NULL, NULL, NULL, NULL),
(110, 105, 103, 104, 2, 2, 'Video Games', 'video-games', '', 1, '', NULL, '', '', 'electronics/video-games', 0, NULL, NULL, NULL, NULL),
(111, 105, 93, 94, 2, 2, 'Computer Parts & Components', 'computer-parts-&-components', '', 1, '', NULL, '', '', 'electronics/computer-parts-&-components', 0, NULL, NULL, NULL, NULL),
(112, 105, 95, 96, 2, 2, 'Electronics Accessories', 'electronics-accessories', '', 1, '', NULL, '', '', 'electronics/electronics-accessories', 0, NULL, NULL, NULL, NULL),
(113, 105, 97, 98, 2, 2, 'Home, Audio & Theater', 'home,-audio-&-theater', '', 1, '', NULL, '', '', 'electronics/home,-audio-&-theater', 0, NULL, NULL, NULL, NULL),
(114, 105, 101, 102, 2, 2, 'TV ', 'tv-', '', 1, '', NULL, '', '', 'electronics/tv-', 0, NULL, NULL, NULL, NULL),
(115, 124, 65, 66, 2, 2, 'Photography', 'photography', '', 1, '', NULL, '', '', 'camera-photography/photography', 0, NULL, NULL, NULL, NULL),
(116, 124, 63, 64, 2, 2, 'Camera', 'camera', '', 1, '', NULL, '', '', 'camera-photography/camera', 0, NULL, NULL, NULL, NULL),
(117, 80, 45, 46, 2, 2, 'Textbooks', 'textbooks', '', 1, '', NULL, '', '', 'books-1/textbooks', 0, NULL, NULL, NULL, NULL),
(118, 80, 43, 44, 2, 2, 'Children\'s Books', 'children\'s-books', '', 1, '', NULL, '', '', 'books-1/children\'s-books', 0, NULL, NULL, NULL, NULL),
(119, 80, 41, 42, 2, 2, 'Books', 'books', '', 1, '', NULL, '', '', 'books-1/books', 0, NULL, NULL, NULL, NULL),
(120, 142, 19, 20, 2, 2, 'Tires ', 'tires-', '', 1, '', NULL, '', '', 'automotive-motors/tires-', 0, NULL, NULL, NULL, NULL),
(121, 142, 17, 18, 2, 2, 'Car Electronics', 'car-electronics', '', 1, '', NULL, '', '', 'automotive-motors/car-electronics', 0, NULL, NULL, NULL, NULL),
(122, 142, 15, 16, 2, 2, 'Automotive Tools', 'automotive-tools', '', 1, '', NULL, '', '', 'automotive-motors/automotive-tools', 0, NULL, NULL, NULL, NULL),
(123, 142, 13, 14, 2, 2, 'Automotive Parts', 'automotive-parts', '', 1, '', NULL, '', '', 'automotive-motors/automotive-parts', 0, NULL, NULL, NULL, NULL),
(124, 1, 61, 62, 1, 2, 'Camera & Photography', 'camera-photography', 'Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po', 1, '/categories/image7-1427100335.jpg', NULL, '', '', 'camera-photography', 0, NULL, NULL, NULL, NULL),
(125, 108, 275, 276, 2, 2, 'Musical Instruments', 'musical-instruments', '', 1, '', NULL, '', '', 'movies-music-games/musical-instruments', 0, NULL, NULL, NULL, NULL),
(126, 108, 273, 274, 2, 2, 'MP3 Downloads', 'mp3-downloads', '', 1, '', NULL, '', '', 'movies-music-games/mp3-downloads', 0, NULL, NULL, NULL, NULL),
(127, 108, 269, 270, 2, 2, 'Game Downloads', 'game-downloads', '', 1, '', NULL, '', '', 'movies-music-games/game-downloads', 0, NULL, NULL, NULL, NULL),
(128, 103, 353, 354, 2, 2, 'Exercise & Fitness', 'exercise-&-fitness', '', 1, '', NULL, '', '', 'sports-outdors/exercise-&-fitness', 0, NULL, NULL, NULL, NULL),
(129, 103, 357, 358, 2, 2, 'Outdoor Recreation', 'outdoor-recreation', '', 1, '', NULL, '', '', 'sports-outdors/outdoor-recreation', 0, NULL, NULL, NULL, NULL),
(130, 103, 355, 356, 2, 2, 'Hunting & Fishing', 'hunting-&-fishing', '', 1, '', NULL, '', '', 'sports-outdors/hunting-&-fishing', 0, NULL, NULL, NULL, NULL),
(131, 103, 351, 352, 2, 2, 'Cycling', 'cycling', '', 1, '', NULL, '', '', 'sports-outdors/cycling', 0, NULL, NULL, NULL, NULL),
(132, 103, 359, 360, 2, 2, 'Team Sports', 'team-sports', '', 1, '', NULL, '', '', 'sports-outdors/team-sports', 0, NULL, NULL, NULL, NULL),
(133, 107, 393, 394, 2, 2, 'Toys & Games', 'toys-&-games', '', 1, '', NULL, '', '', 'toy-kids-babies/toys-&-games', 0, NULL, NULL, NULL, NULL),
(134, 107, 387, 388, 2, 2, 'Baby', 'baby', '', 1, '', NULL, '', '', 'toy-kids-babies/baby', 0, NULL, NULL, NULL, NULL),
(135, 107, 391, 392, 2, 2, 'Clothing (Kids & Baby)', 'clothing-(kids-&-baby)', '', 1, '', NULL, '', '', 'toy-kids-babies/clothing-(kids-&-baby)', 0, NULL, NULL, NULL, NULL),
(136, 107, 395, 396, 2, 2, 'Video Games for Kids', 'video-games-for-kids', '', 1, '', NULL, '', '', 'toy-kids-babies/video-games-for-kids', 0, NULL, NULL, NULL, NULL),
(137, 107, 389, 390, 2, 2, 'Baby Registry', 'baby-registry', '', 1, '', NULL, '', '', 'toy-kids-babies/baby-registry', 0, NULL, NULL, NULL, NULL),
(138, 141, 329, 330, 2, 2, 'Services', 'services', '', 1, '', NULL, '', '', 'services/services', 0, NULL, NULL, NULL, NULL),
(139, 141, 327, 328, 2, 2, 'IT Services', 'it-services', '', 1, '', NULL, '', '', 'services/it-services', 0, NULL, NULL, NULL, NULL),
(140, 1, 161, 162, 1, 2, 'Health & Beauty', 'grocery-health-beauty', '', 1, '/categories/slide1-the-health-and-beauty-world-1427100497.jpg', NULL, '', '', 'grocery-health-beauty', 0, NULL, NULL, NULL, NULL),
(141, 1, 325, 326, 1, 2, 'Services', 'services', 'Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po', 1, '/categories/image9-1411751440.png', NULL, '', '', 'services', 0, NULL, NULL, NULL, NULL),
(142, 1, 11, 12, 1, 2, 'Automotive & Motors', 'automotive-motors', 'Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po', 1, '/categories/image5-1427100860.jpg', NULL, '', '', 'automotive-motors', 0, NULL, NULL, NULL, NULL),
(143, 1, 303, 304, 1, 2, 'Restaurants', 'restaurants', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam purus libero, luctus id felis at, porta malesuada massa. Vestibulum vitae imperdiet justo, eget ullamcorper nunc. Cras eget ligula sodales, congue lacus eget, tincidunt justo. Ut vestibulum bibendum ante, vitae scelerisque leo faucibus id. Nunc congue, justo id porttitor fringilla, ipsum ex rutrum lorem, in sodales nisi ipsum at massa. Duis a cursus ipsum. Aliquam vitae est tortor. Aenean aliquet ultrices magna et efficitur. Mauris c', 1, '/categories/image3-1427100807.jpg', NULL, '', '', 'restaurants', 0, NULL, NULL, NULL, NULL),
(144, 143, 305, 306, 2, 2, 'Asian Restaurants', 'asian-restaurants', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam purus libero, luctus id felis at, porta malesuada massa. Vestibulum vitae imperdiet justo, eget ullamcorper nunc. Cras eget ligula sodales, congue lacus eget, tincidunt justo. Ut vestibulum bibendum ante, vitae scelerisque leo faucibus id. Nunc congue, justo id porttitor fringilla, ipsum ex rutrum lorem, in sodales nisi ipsum at massa. Duis a cursus ipsum. Aliquam vitae est tortor. Aenean aliquet ultrices magna et efficitur.', 1, '', NULL, '', '', 'restaurants/asian-restaurants', 0, NULL, NULL, NULL, NULL),
(145, 143, 307, 308, 2, 2, 'French Restaurants', 'french-restaurants', '', 1, '', NULL, '', '', 'restaurants/french-restaurants', 0, NULL, NULL, NULL, NULL),
(146, 143, 309, 310, 2, 2, 'Italian Restaurants', 'italian-restaurants', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam purus libero, luctus id felis at, porta malesuada massa. Vestibulum vitae imperdiet justo, eget ullamcorper nunc. Cras eget ligula sodales, congue lacus eget, tincidunt justo. Ut vestibulum bibendum ante, vitae scelerisque leo faucibus id. Nunc congue, justo id porttitor fringilla, ipsum ex rutrum lorem, in sodales nisi ipsum at massa. Duis a cursus ipsum. Aliquam vitae est tortor. Aenean aliquet ultrices magna et efficitur.', 1, '', NULL, '', '', 'restaurants/italian-restaurants', 0, NULL, NULL, NULL, NULL),
(147, 1, 291, 292, 1, 2, 'Real Estate', 'real-estate', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam purus libero, luctus id felis at, porta malesuada massa. Vestibulum vitae imperdiet justo, eget ullamcorper nunc. Cras eget ligula sodales, congue lacus eget, tincidunt justo. Ut vestibulum bibendum ante, vitae scelerisque leo faucibus id. Nunc congue, justo id porttitor fringilla, ipsum ex rutrum lorem, in sodales nisi ipsum at massa. Duis a cursus ipsum. Aliquam vitae est tortor. Aenean aliquet ultrices magna et efficitur.', 1, '/categories/image9-1427100841.jpg', NULL, '', '', 'real-estate', 0, NULL, NULL, NULL, NULL),
(148, 1, 47, 48, 1, 3, 'Books', 'books-1', '', 1, '/categories/image5-1427100316.jpg', NULL, '', '', 'books-1', 0, NULL, NULL, NULL, NULL),
(149, 173, 115, 116, 2, 3, 'Software', 'software', '', 1, '', NULL, '', '', 'electronics/software', 0, NULL, NULL, NULL, NULL),
(150, 174, 149, 150, 2, 3, 'Women', 'women', '', 1, '', NULL, '', '', 'fashion/women', 0, NULL, NULL, NULL, NULL),
(151, 174, 145, 146, 2, 3, 'Man', 'man', '', 1, '', NULL, '', '', 'fashion/man', 0, NULL, NULL, NULL, NULL),
(152, 174, 143, 144, 2, 3, 'Kids & Baby', 'kids-&-baby', '', 1, '', NULL, '', '', 'fashion/kids-&-baby', 0, NULL, NULL, NULL, NULL),
(153, 174, 147, 148, 2, 3, 'Shoes', 'shoes', '', 1, '', NULL, '', '', 'fashion/shoes', 0, NULL, NULL, NULL, NULL),
(154, 208, 173, 174, 2, 3, 'Grocery & Gourmet Food', 'grocery-&-gourmet-food', '', 1, '', NULL, '', '', 'grocery-health-beauty/grocery-&-gourmet-food', 0, NULL, NULL, NULL, NULL),
(155, 208, 179, 180, 2, 3, 'Wine', 'wine', '', 1, '', NULL, '', '', 'grocery-health-beauty/wine', 0, NULL, NULL, NULL, NULL),
(156, 208, 177, 178, 2, 3, 'Natural & Organic', 'natural-&-organic', '', 1, '', NULL, '', '', 'grocery-health-beauty/natural-&-organic', 0, NULL, NULL, NULL, NULL),
(157, 208, 175, 176, 2, 3, 'Health & Personal Care', 'health-&-personal-care', '', 1, '', NULL, '', '', 'grocery-health-beauty/health-&-personal-care', 0, NULL, NULL, NULL, NULL),
(158, 177, 213, 214, 2, 3, 'Kitchen & Dining', 'kitchen-&-dining', '', 1, '', NULL, '', '', 'home-garden/kitchen-&-dining', 0, NULL, NULL, NULL, NULL),
(159, 177, 211, 212, 2, 3, 'Furniture & D', 'furniture-&-d', '', 1, '', NULL, '', '', 'home-garden/furniture-&-d', 0, NULL, NULL, NULL, NULL),
(160, 177, 209, 210, 2, 3, 'Bedding & Bath', 'bedding-&-bath', '', 1, '', NULL, '', '', 'home-garden/bedding-&-bath', 0, NULL, NULL, NULL, NULL),
(161, 177, 215, 216, 2, 3, 'Patio, Lawn & Garden', 'patio,-lawn-&-garden', '', 1, '', NULL, '', '', 'home-garden/patio,-lawn-&-garden', 0, NULL, NULL, NULL, NULL),
(162, 177, 207, 208, 2, 3, 'Arts, Crafts & Sewing', 'arts,-crafts-&-sewing', '', 1, '', NULL, '', '', 'home-garden/arts,-crafts-&-sewing', 0, NULL, NULL, NULL, NULL),
(163, 170, 251, 252, 2, 3, 'Watches', 'watches', '', 1, '', NULL, '', '', 'jewelry-watches/watches', 0, NULL, NULL, NULL, NULL),
(164, 170, 249, 250, 2, 3, 'Fine Jewelry', 'fine-jewelry', '', 1, '', NULL, '', '', 'jewelry-watches/fine-jewelry', 0, NULL, NULL, NULL, NULL),
(165, 170, 245, 246, 2, 3, 'Fashion Jewelry', 'fashion-jewelry', '', 1, '', NULL, '', '', 'jewelry-watches/fashion-jewelry', 0, NULL, NULL, NULL, NULL),
(166, 170, 247, 248, 2, 3, 'Fashion Jewelry', 'fashion-jewelry', '', 1, '', NULL, '', '', 'jewelry-watches/fashion-jewelry', 0, NULL, NULL, NULL, NULL),
(167, 170, 243, 244, 2, 3, 'Engagement & Wedding', 'engagement-&-wedding', '', 1, '', NULL, '', '', 'jewelry-watches/engagement-&-wedding', 0, NULL, NULL, NULL, NULL),
(168, 176, 283, 284, 2, 3, 'Movies & TV', 'movies-&-tv', '', 1, '', NULL, '', '', 'movies-music-games/movies-&-tv', 0, NULL, NULL, NULL, NULL),
(169, 176, 279, 280, 2, 3, 'Blu-ray', 'blu-ray', '', 1, '', NULL, '', '', 'movies-music-games/blu-ray', 0, NULL, NULL, NULL, NULL),
(170, 1, 241, 242, 1, 3, 'Jewelry & Watches', 'jewelry-watches', 'Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po', 1, '/categories/watch-1427100687.jpg', NULL, '', '', 'jewelry-watches', 0, NULL, NULL, NULL, NULL),
(171, 1, 361, 362, 1, 3, 'Sports & Outdors', 'sports-outdors', 'Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po', 1, '/categories/image3-1411751531.jpg', NULL, '', '', 'sports-outdors', 0, NULL, NULL, NULL, NULL),
(172, 173, 107, 108, 2, 3, 'Cell Phones & Accessories', 'cell-phones-&-accessories', '', 1, '', NULL, '', '', 'electronics/cell-phones-&-accessories', 0, NULL, NULL, NULL, NULL),
(173, 1, 105, 106, 1, 3, 'Electronics', 'electronics', 'Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po', 1, '/categories/image6-1427100355.jpg', NULL, '', '', 'electronics', 0, NULL, NULL, NULL, NULL),
(174, 1, 141, 142, 1, 3, 'Fashion', 'fashion', 'Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po', 1, '/categories/slide-image-8-1427100458.jpg', NULL, '', '', 'fashion', 0, NULL, NULL, NULL, NULL),
(175, 1, 397, 398, 1, 3, 'Toy,Kids & Babies', 'toy-kids-babies', 'Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po', 1, '/categories/image1-1427100760.jpg', NULL, '', '', 'toy-kids-babies', 0, NULL, NULL, NULL, NULL),
(176, 1, 277, 278, 1, 3, 'Movies, Music & Games', 'movies-music-games', '', 1, '/categories/image2-1427100712.jpg', NULL, '', '', 'movies-music-games', 0, NULL, NULL, NULL, NULL),
(177, 1, 205, 206, 1, 3, 'Home & Garden', 'home-garden', 'Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po', 1, '/categories/image7-1427100616.jpg', NULL, '', '', 'home-garden', 0, NULL, NULL, NULL, NULL),
(178, 173, 119, 120, 2, 3, 'Video Games', 'video-games', '', 1, '', NULL, '', '', 'electronics/video-games', 0, NULL, NULL, NULL, NULL),
(179, 173, 109, 110, 2, 3, 'Computer Parts & Components', 'computer-parts-&-components', '', 1, '', NULL, '', '', 'electronics/computer-parts-&-components', 0, NULL, NULL, NULL, NULL),
(180, 173, 111, 112, 2, 3, 'Electronics Accessories', 'electronics-accessories', '', 1, '', NULL, '', '', 'electronics/electronics-accessories', 0, NULL, NULL, NULL, NULL),
(181, 173, 113, 114, 2, 3, 'Home, Audio & Theater', 'home,-audio-&-theater', '', 1, '', NULL, '', '', 'electronics/home,-audio-&-theater', 0, NULL, NULL, NULL, NULL),
(182, 173, 117, 118, 2, 3, 'TV ', 'tv-', '', 1, '', NULL, '', '', 'electronics/tv-', 0, NULL, NULL, NULL, NULL),
(183, 192, 71, 72, 2, 3, 'Photography', 'photography', '', 1, '', NULL, '', '', 'camera-photography/photography', 0, NULL, NULL, NULL, NULL),
(184, 192, 69, 70, 2, 3, 'Camera', 'camera', '', 1, '', NULL, '', '', 'camera-photography/camera', 0, NULL, NULL, NULL, NULL),
(185, 148, 53, 54, 2, 3, 'Textbooks', 'textbooks', '', 1, '', NULL, '', '', 'books-1/textbooks', 0, NULL, NULL, NULL, NULL),
(186, 148, 51, 52, 2, 3, 'Children\'s Books', 'children\'s-books', '', 1, '', NULL, '', '', 'books-1/children\'s-books', 0, NULL, NULL, NULL, NULL),
(187, 148, 49, 50, 2, 3, 'Books', 'books', '', 1, '', NULL, '', '', 'books-1/books', 0, NULL, NULL, NULL, NULL),
(188, 210, 29, 30, 2, 3, 'Tires ', 'tires-', '', 1, '', NULL, '', '', 'automotive-motors/tires-', 0, NULL, NULL, NULL, NULL),
(189, 210, 27, 28, 2, 3, 'Car Electronics', 'car-electronics', '', 1, '', NULL, '', '', 'automotive-motors/car-electronics', 0, NULL, NULL, NULL, NULL),
(190, 210, 25, 26, 2, 3, 'Automotive Tools', 'automotive-tools', '', 1, '', NULL, '', '', 'automotive-motors/automotive-tools', 0, NULL, NULL, NULL, NULL),
(191, 210, 23, 24, 2, 3, 'Automotive Parts', 'automotive-parts', '', 1, '', NULL, '', '', 'automotive-motors/automotive-parts', 0, NULL, NULL, NULL, NULL),
(192, 1, 67, 68, 1, 3, 'Camera & Photography', 'camera-photography', 'Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po', 1, '/categories/image7-1427100335.jpg', NULL, '', '', 'camera-photography', 0, NULL, NULL, NULL, NULL),
(193, 176, 287, 288, 2, 3, 'Musical Instruments', 'musical-instruments', '', 1, '', NULL, '', '', 'movies-music-games/musical-instruments', 0, NULL, NULL, NULL, NULL),
(194, 176, 285, 286, 2, 3, 'MP3 Downloads', 'mp3-downloads', '', 1, '', NULL, '', '', 'movies-music-games/mp3-downloads', 0, NULL, NULL, NULL, NULL),
(195, 176, 281, 282, 2, 3, 'Game Downloads', 'game-downloads', '', 1, '', NULL, '', '', 'movies-music-games/game-downloads', 0, NULL, NULL, NULL, NULL),
(196, 171, 365, 366, 2, 3, 'Exercise & Fitness', 'exercise-&-fitness', '', 1, '', NULL, '', '', 'sports-outdors/exercise-&-fitness', 0, NULL, NULL, NULL, NULL),
(197, 171, 369, 370, 2, 3, 'Outdoor Recreation', 'outdoor-recreation', '', 1, '', NULL, '', '', 'sports-outdors/outdoor-recreation', 0, NULL, NULL, NULL, NULL),
(198, 171, 367, 368, 2, 3, 'Hunting & Fishing', 'hunting-&-fishing', '', 1, '', NULL, '', '', 'sports-outdors/hunting-&-fishing', 0, NULL, NULL, NULL, NULL),
(199, 171, 363, 364, 2, 3, 'Cycling', 'cycling', '', 1, '', NULL, '', '', 'sports-outdors/cycling', 0, NULL, NULL, NULL, NULL),
(200, 171, 371, 372, 2, 3, 'Team Sports', 'team-sports', '', 1, '', NULL, '', '', 'sports-outdors/team-sports', 0, NULL, NULL, NULL, NULL),
(201, 175, 405, 406, 2, 3, 'Toys & Games', 'toys-&-games', '', 1, '', NULL, '', '', 'toy-kids-babies/toys-&-games', 0, NULL, NULL, NULL, NULL),
(202, 175, 399, 400, 2, 3, 'Baby', 'baby', '', 1, '', NULL, '', '', 'toy-kids-babies/baby', 0, NULL, NULL, NULL, NULL),
(203, 175, 403, 404, 2, 3, 'Clothing (Kids & Baby)', 'clothing-(kids-&-baby)', '', 1, '', NULL, '', '', 'toy-kids-babies/clothing-(kids-&-baby)', 0, NULL, NULL, NULL, NULL),
(204, 175, 407, 408, 2, 3, 'Video Games for Kids', 'video-games-for-kids', '', 1, '', NULL, '', '', 'toy-kids-babies/video-games-for-kids', 0, NULL, NULL, NULL, NULL),
(205, 175, 401, 402, 2, 3, 'Baby Registry', 'baby-registry', '', 1, '', NULL, '', '', 'toy-kids-babies/baby-registry', 0, NULL, NULL, NULL, NULL),
(206, 209, 335, 336, 2, 3, 'Services', 'services', '', 1, '', NULL, '', '', 'services/services', 0, NULL, NULL, NULL, NULL),
(207, 209, 333, 334, 2, 3, 'IT Services', 'it-services', '', 1, '', NULL, '', '', 'services/it-services', 0, NULL, NULL, NULL, NULL),
(208, 1, 171, 172, 1, 3, 'Health & Beauty', 'grocery-health-beauty', '', 1, '/categories/slide1-the-health-and-beauty-world-1427100497.jpg', NULL, '', '', 'grocery-health-beauty', 0, NULL, NULL, NULL, NULL),
(209, 1, 331, 332, 1, 3, 'Services', 'services', 'Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po', 1, '/categories/image9-1411751440.png', NULL, '', '', 'services', 0, NULL, NULL, NULL, NULL),
(210, 1, 21, 22, 1, 3, 'Automotive & Motors', 'automotive-motors', 'Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices po', 1, '/categories/image5-1427100860.jpg', NULL, '', '', 'automotive-motors', 0, NULL, NULL, NULL, NULL),
(211, 1, 311, 312, 1, 3, 'Restaurants', 'restaurants', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam purus libero, luctus id felis at, porta malesuada massa. Vestibulum vitae imperdiet justo, eget ullamcorper nunc. Cras eget ligula sodales, congue lacus eget, tincidunt justo. Ut vestibulum bibendum ante, vitae scelerisque leo faucibus id. Nunc congue, justo id porttitor fringilla, ipsum ex rutrum lorem, in sodales nisi ipsum at massa. Duis a cursus ipsum. Aliquam vitae est tortor. Aenean aliquet ultrices magna et efficitur. Mauris c', 1, '/categories/image3-1427100807.jpg', NULL, '', '', 'restaurants', 0, NULL, NULL, NULL, NULL),
(212, 211, 313, 314, 2, 3, 'Asian Restaurants', 'asian-restaurants', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam purus libero, luctus id felis at, porta malesuada massa. Vestibulum vitae imperdiet justo, eget ullamcorper nunc. Cras eget ligula sodales, congue lacus eget, tincidunt justo. Ut vestibulum bibendum ante, vitae scelerisque leo faucibus id. Nunc congue, justo id porttitor fringilla, ipsum ex rutrum lorem, in sodales nisi ipsum at massa. Duis a cursus ipsum. Aliquam vitae est tortor. Aenean aliquet ultrices magna et efficitur.', 1, '', NULL, '', '', 'restaurants/asian-restaurants', 0, NULL, NULL, NULL, NULL),
(213, 211, 315, 316, 2, 3, 'French Restaurants', 'french-restaurants', '', 1, '', NULL, '', '', 'restaurants/french-restaurants', 0, NULL, NULL, NULL, NULL),
(214, 211, 317, 318, 2, 3, 'Italian Restaurants', 'italian-restaurants', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam purus libero, luctus id felis at, porta malesuada massa. Vestibulum vitae imperdiet justo, eget ullamcorper nunc. Cras eget ligula sodales, congue lacus eget, tincidunt justo. Ut vestibulum bibendum ante, vitae scelerisque leo faucibus id. Nunc congue, justo id porttitor fringilla, ipsum ex rutrum lorem, in sodales nisi ipsum at massa. Duis a cursus ipsum. Aliquam vitae est tortor. Aenean aliquet ultrices magna et efficitur.', 1, '', NULL, '', '', 'restaurants/italian-restaurants', 0, NULL, NULL, NULL, NULL),
(215, 1, 293, 294, 1, 3, 'Real Estate', 'real-estate', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Etiam purus libero, luctus id felis at, porta malesuada massa. Vestibulum vitae imperdiet justo, eget ullamcorper nunc. Cras eget ligula sodales, congue lacus eget, tincidunt justo. Ut vestibulum bibendum ante, vitae scelerisque leo faucibus id. Nunc congue, justo id porttitor fringilla, ipsum ex rutrum lorem, in sodales nisi ipsum at massa. Duis a cursus ipsum. Aliquam vitae est tortor. Aenean aliquet ultrices magna et efficitur.', 1, '/categories/image9-1427100841.jpg', NULL, '', '', 'real-estate', 0, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_cities`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_cities`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_cities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(65) DEFAULT NULL,
  `region_id` int(11) DEFAULT NULL,
  `ordering` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_region` (`region_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_cities`
--

INSERT INTO `#__jbusinessdirectory_cities` (`id`, `name`, `region_id`, `ordering`) VALUES
(1, 'Toronto', NULL, 0),
(2, 'Montreal', NULL, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_companies`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_companies`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_companies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `alias` varchar(100) DEFAULT NULL,
  `comercialName` varchar(120) DEFAULT NULL,
  `short_description` varchar(255) DEFAULT NULL,
  `description` text,
  `meta_title` varchar(100) DEFAULT NULL,
  `meta_description` text,
  `street_number` varchar(20) DEFAULT NULL,
  `address` varchar(100) DEFAULT NULL,
  `city` varchar(60) DEFAULT NULL,
  `county` varchar(60) DEFAULT NULL,
  `province` varchar(60) DEFAULT NULL,
  `area` varchar(60) DEFAULT NULL,
  `countryId` int(11) DEFAULT NULL,
  `website` varchar(250) DEFAULT NULL,
  `keywords` varchar(250) DEFAULT NULL,
  `registrationCode` varchar(20) DEFAULT NULL,
  `phone` varchar(20) DEFAULT NULL,
  `email` varchar(100) DEFAULT NULL,
  `fax` varchar(20) DEFAULT NULL,
  `state` tinyint(4) DEFAULT '1',
  `typeId` varchar(255) DEFAULT NULL,
  `logoLocation` varchar(245) DEFAULT NULL,
  `creationDate` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `modified` datetime DEFAULT NULL,
  `mainSubcategory` int(11) DEFAULT NULL,
  `latitude` varchar(45) DEFAULT NULL,
  `longitude` varchar(45) DEFAULT NULL,
  `activity_radius` decimal(10,0) DEFAULT NULL,
  `userId` int(11) NOT NULL DEFAULT '0',
  `averageRating` decimal(2,1) NOT NULL DEFAULT '0.0',
  `review_score` decimal(2,1) NOT NULL DEFAULT '0.0',
  `approved` tinyint(1) NOT NULL DEFAULT '0',
  `viewCount` int(11) NOT NULL DEFAULT '0',
  `websiteCount` int(11) NOT NULL DEFAULT '0',
  `contactCount` int(11) NOT NULL DEFAULT '0',
  `taxCode` varchar(45) DEFAULT NULL,
  `package_id` int(11) NOT NULL DEFAULT '0',
  `facebook` varchar(150) DEFAULT NULL,
  `twitter` varchar(150) DEFAULT NULL,
  `googlep` varchar(150) DEFAULT NULL,
  `skype` varchar(150) DEFAULT NULL,
  `linkedin` varchar(150) DEFAULT NULL,
  `youtube` varchar(150) DEFAULT NULL,
  `instagram` varchar(150) DEFAULT NULL,
  `pinterest` varchar(150) DEFAULT NULL,
  `whatsapp` varchar(150) DEFAULT NULL,
  `postalCode` varchar(55) DEFAULT NULL,
  `mobile` varchar(55) DEFAULT NULL,
  `slogan` varchar(255) DEFAULT NULL,
  `publish_only_city` tinyint(1) DEFAULT '0',
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `business_hours` varchar(255) DEFAULT NULL,
  `notes_hours` varchar(255) DEFAULT NULL,
  `custom_tab_name` varchar(100) DEFAULT NULL,
  `custom_tab_content` text,
  `business_cover_image` varchar(245) DEFAULT NULL,
  `publish_start_date` date DEFAULT NULL,
  `publish_end_date` date DEFAULT NULL,
  `notified_date` timestamp NULL DEFAULT NULL,
  `time_zone` varchar(15) DEFAULT NULL,
  `establishment_year` varchar(10) DEFAULT NULL,
  `employees` varchar(100) DEFAULT NULL,
  `ad_image` varchar(250) DEFAULT NULL,
  `disapproval_text` text,
  `yelp_id` varchar(255) DEFAULT NULL,
  `enable_request_quote` tinyint(1) DEFAULT '1',
  `trail_weeks_hours` text,
  `trail_weeks_status` tinyint(1) DEFAULT '1',
  `trail_weeks_address` varchar(100) DEFAULT NULL,
  `ad_caption` varchar(245) DEFAULT NULL,
  `recommended` tinyint(1) DEFAULT '0',
  `ordering` tinyint(4) NOT NULL DEFAULT '0',
  `company_view` tinyint(1) DEFAULT '0',
  `opening_status` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_type` (`typeId`),
  KEY `idx_user` (`userId`),
  KEY `idx_state` (`state`),
  KEY `idx_approved` (`approved`),
  KEY `idx_country` (`countryId`),
  KEY `idx_package` (`package_id`),
  KEY `idx_name` (`name`),
  KEY `idx_keywords` (`keywords`),
  KEY `idx_description` (`description`(100)),
  KEY `idx_city` (`city`),
  KEY `idx_county` (`county`),
  KEY `idx_maincat` (`mainSubcategory`),
  KEY `idx_zipcode` (`latitude`,`longitude`),
  KEY `idx_phone` (`phone`),
  KEY `idx_creationDate` (`creationDate`),
  KEY `idx_review_score` (`review_score`),
  KEY `idx_province` (`province`),
  KEY `idx_area` (`area`),
  KEY `idx_publish_start_date` (`publish_start_date`),
  KEY `idx_publish_end_date` (`publish_end_date`),
  KEY `idx_alias` (`alias`)
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_companies`
--

INSERT INTO `#__jbusinessdirectory_companies` (`id`, `name`, `alias`, `comercialName`, `short_description`, `description`, `meta_title`, `meta_description`, `street_number`, `address`, `city`, `county`, `province`, `area`, `countryId`, `website`, `keywords`, `registrationCode`, `phone`, `email`, `fax`, `state`, `typeId`, `logoLocation`, `creationDate`, `modified`, `mainSubcategory`, `latitude`, `longitude`, `activity_radius`, `userId`, `averageRating`, `review_score`, `approved`, `viewCount`, `websiteCount`, `contactCount`, `taxCode`, `package_id`, `facebook`, `twitter`, `googlep`, `skype`, `linkedin`, `youtube`, `instagram`, `pinterest`, `whatsapp`, `postalCode`, `mobile`, `slogan`, `publish_only_city`, `featured`, `business_hours`, `notes_hours`, `custom_tab_name`, `custom_tab_content`, `business_cover_image`, `publish_start_date`, `publish_end_date`, `notified_date`, `time_zone`, `establishment_year`, `employees`, `ad_image`, `disapproval_text`, `yelp_id`, `enable_request_quote`, `trail_weeks_hours`, `trail_weeks_status`, `trail_weeks_address`, `ad_caption`, `recommended`, `ordering`, `company_view`, `opening_status`) VALUES
(1, 'Wedding Venue', 'wedding-venue', 'Home & Gardem', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut mollis justo nulla, a tempus elit pulvinar eget. Nunc tempus leo in arcu mattis lobortis. Fusce ut sollicitudin nulla. Lorem ipsum dolor sit amet, consectetur adipiscing elit.', '<p>Quisque cursus nunc ut diam pulvinar luctus. Nulla facilisi. Donec porta lorem id diam malesuada nec pretium enim euismod. Donec massa augue, lobortis eu cursus in, tincidunt ut nunc. Proin pellentesque, lorem porttitor commodo hendrerit, enim leo mattis risus, ac viverra ante tellus quis velit. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Morbi dignissim tristique sapien ut pretium. Duis sollicitudin dolor sed nisi venenatis quis fringilla diam suscipit. Sed convallis lectus non nibh suscipit ullamcorper. Fusce in magna ac lacus semper convallis. Morbi sagittis auctor massa vel consequat. Nulla fermentum, sapien a sagittis accumsan, tellus ipsum posuere tellus, a lacinia tortor lacus in nisl. Vestibulum posuere dictum ipsum ac viverra. Integer neque neque, blandit non adipiscing vel, auctor non odio. Maecenas quis nibh a diam eleifend rhoncus sed in turpis. Pellentesque mollis fermentum dolor et mollis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed ullamcorper ante ac nunc commodo vitae rutrum sem placerat. Morbi et nisi metus.</p>', '', '', '123', 'Old San Francisco Rd', 'Sunnyvale', 'California', '', '', 226, 'http://www.garden.com', 'wedding, planning, venue', '342423422', '34242123123', 'email@decoration.com', '434312312321', 1, '6', '/companies/1/cropped-1620394955.jpeg', '2015-12-20 06:37:45', '2021-05-08 18:35:27', 8, '37.3681865', '-122.031385', '0', 0, '4.0', '0.0', 2, 23, 0, 0, '123123', 0, '', '', '', '', '', '', '', '', '', '94086', '', 'Your event in a magical place!', 0, 0, '', '', '', '', '', '0000-00-00', '0000-00-00', NULL, '-11:00', '', '0', NULL, '', NULL, 1, NULL, 1, NULL, NULL, 0, 1, 0, 0),
(4, 'Water Sports', 'water-sports', 'Rent a car', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut mollis justo nulla, a tempus elit pulvinar eget. Nunc tempus leo in arcu mattis lobortis. Fusce ut sollicitudin nulla. Lorem ipsum dolor sit amet, consectetur adipiscing elit.', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut mollis justo nulla, a tempus elit pulvinar eget. Nunc tempus leo in arcu mattis lobortis. Fusce ut sollicitudin nulla. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut laoreet feugiat lectus id ornare. Nulla ut odio eget justo faucibus consectetur. Ut faucibus ultrices accumsan. Aenean leo neque, accumsan ac eleifend vel, pulvinar id urna. Phasellus non malesuada augue. Maecenas id egestas quam, at molestie tortor. Sed quis dictum eros.Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut mollis justo nulla, a tempus elit pulvinar eget. Nunc tempus leo in arcu mattis lobortis. Fusce ut sollicitudin nulla. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Ut laoreet feugiat lectus id ornare. Nulla ut odio eget justo faucibus consectetur. Ut faucibus ultrices accumsan. Aenean leo neque, accumsan ac eleifend vel, pulvinar id urna. Phasellus non malesuada augue. Maecenas id egestas quam, at molestie tortor. Sed quis dictum eros.</p>', '', '', '11', 'Young Street', 'Toronto', 'Ontario', '', '', 36, 'http://www.cmsjunkie.com', '', 'JBD-5512312', '0010727321321', 'office@email.com', '0010269/220123', 1, '6', '/companies/4/cropped-1620394305.jpeg', '2015-12-25 06:37:45', '2021-05-07 13:43:13', 5, '43.64208175305137', '-79.3842687603319', '0', 0, '5.0', '0.0', 2, 4, 0, 0, '123123', 0, '', '', '', '', '', '', '', '', '', '23123213', '001072744333', 'Live your life at maximum.', 0, 0, '', '', '', '', '', '0000-00-00', '0000-00-00', NULL, '-11:00', '', '0', NULL, '', NULL, 1, NULL, 1, NULL, NULL, 0, 2, 0, 0),
(5, 'Yoga Club', 'yoga-club', 'AQUACON PROJECT', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc interdum mauris vitae urna ultrices, et fermentum magna convallis. Nullam quis vulputate magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc interdum mauris vitae urna ultrices, et fermentum magna convallis. Nullam quis vulputate magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nunc scelerisque enim ut magna vulputate feugiat. Suspendisse rutrum lectus et diam congue, sed pretium eros facilisis. Pellentesque pretium lectus orci, non accumsan velit vestibulum a. Fusce orci dui, tincidunt et tortor non, auctor rutrum mauris. Vestibulum sed ultricies enim, at ultrices quam.</p>\r\n<p>Quisque pellentesque libero eget dui elementum scelerisque. Pellentesque tempor arcu in hendrerit molestie. Phasellus euismod nisi in malesuada convallis. Praesent sapien neque, fermentum a laoreet eget, tempus ultricies nulla. Mauris mi tortor, maximus eu risus vitae, bibendum vestibulum leo. Nulla vitae efficitur lectus. Aenean aliquet massa magna. Nullam at dapibus mi. Vivamus massa nibh, venenatis mattis nibh pretium, pretium volutpat leo. Vestibulum eu sem elit. Duis consequat, magna id semper elementum, est nisi pharetra orci, eget molestie diam purus sed sem. Vestibulum est purus, sollicitudin eget lectus ut, molestie aliquam purus. Praesent suscipit vitae sem vel sodales.</p>', '', '', '44', 'Young Street', 'Toronto', 'Ontario', '', '', 36, 'http://www.cmsjunkie.com', '', 'YG-12312', '0727321321', 'office@site.com', '0269/220123', 1, '6', '/companies/5/cropped-1620394181.jpeg', '2015-12-21 15:30:40', '2021-05-07 13:30:24', 29, '43.650081332730466', '-79.37849521636963', '15', 0, '3.0', '0.0', 2, 9, 0, 0, '123', 0, '', '', '', '', '', '', '', '', '', '1312312', '', 'Get in harmony with your body and soul!', 0, 0, '', '', '', '', '', '0000-00-00', '0000-00-00', NULL, '-11:00', '', '0', NULL, '', NULL, 1, NULL, 1, NULL, NULL, 0, 3, 0, 0),
(7, 'Professional Photos', 'professional-photos', 'FINE JEWELERY', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc interdum mauris vitae urna ultrices, et fermentum magna convallis. Nullam quis vulputate magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc interdum mauris vitae urna ultrices, et fermentum magna convallis. Nullam quis vulputate magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nunc scelerisque enim ut magna vulputate feugiat. Suspendisse rutrum lectus et diam congue, sed pretium eros facilisis. Pellentesque pretium lectus orci, non accumsan velit vestibulum a. Fusce orci dui, tincidunt et tortor non, auctor rutrum mauris. Vestibulum sed ultricies enim, at ultrices quam.</p>\r\n<p>Quisque pellentesque libero eget dui elementum scelerisque. Pellentesque tempor arcu in hendrerit molestie. Phasellus euismod nisi in malesuada convallis. Praesent sapien neque, fermentum a laoreet eget, tempus ultricies nulla. Mauris mi tortor, maximus eu risus vitae, bibendum vestibulum leo. Nulla vitae efficitur lectus. Aenean aliquet massa magna. Nullam at dapibus mi. Vivamus massa nibh, venenatis mattis nibh pretium, pretium volutpat leo. Vestibulum eu sem elit. Duis consequat, magna id semper elementum, est nisi pharetra orci, eget molestie diam purus sed sem. Vestibulum est purus, sollicitudin eget lectus ut, molestie aliquam purus. Praesent suscipit vitae sem vel sodales.</p>', '', '', '33', 'Richmong', 'Toronto', 'Ontario', '', '', 36, 'http://www.cmsjunkie.com', 'keywords1', 'JBD-343243', '123123', 'office@shopping.com', '213123', 1, '6', '/companies/7/cropped-1620498752.jpeg', '2011-11-23 15:31:39', '2021-05-08 18:32:34', 24, '43.649677652720534', '-79.37798023223877', '30', 0, '4.3', '0.0', 2, 24, 0, 0, '123123', 0, 'http://www.facebook.com/cmsjunkie', 'http://www.twiter.com', 'http://www.googleplus.com', '', '', '', '', '', '', '23213', '', 'We save the special moments for eternity.', 0, 1, '', '', '', '', '', '0000-00-00', '0000-00-00', NULL, '-11:00', '', '0', NULL, '', NULL, 1, NULL, 1, NULL, NULL, 0, 4, 0, 0),
(8, 'Vintage photography', 'vintage-photography', 'Contruction Company', 'Quisque cursus nunc ut diam pulvinar luctus. Nulla facilisi. Donec porta lorem id diam malesuada nec pretium enim euismod. Donec massa augue, lobortis eu cursus in, tincidunt ut nunc.', '<p>Quisque cursus nunc ut diam pulvinar luctus. Nulla facilisi. Donec porta lorem id diam malesuada nec pretium enim euismod. Donec massa augue, lobortis eu cursus in, tincidunt ut nunc. Proin pellentesque, lorem porttitor commodo hendrerit, enim leo mattis risus, ac viverra ante tellus quis velit. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Morbi dignissim tristique sapien ut pretium. Duis sollicitudin dolor sed nisi venenatis quis fringilla diam suscipit. Sed convallis lectus non nibh suscipit ullamcorper. Fusce in magna ac lacus semper convallis. Morbi sagittis auctor massa vel consequat. Nulla fermentum, sapien a sagittis accumsan, tellus ipsum posuere tellus, a lacinia tortor lacus in nisl. Vestibulum posuere dictum ipsum ac viverra. Integer neque neque, blandit non adipiscing vel, auctor non odio. Maecenas quis nibh a diam eleifend rhoncus sed in turpis. Pellentesque mollis fermentum dolor et mollis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed ullamcorper ante ac nunc commodo vitae rutrum sem placerat. Morbi et nisi metus.</p>', '', '', '22', 'Lawrance', 'Toronto', 'Ontario', '', '', 36, 'http://google.com', '', 'JBD-343412', '0727321321', 'office@site.com', '0269/220123', 1, '6', '/companies/8/cropped-1620393641.jpeg', '2011-11-23 15:32:07', '2021-05-10 06:48:03', 24, '43.65057816594119', '-79.37493324279785', '0', 0, '4.7', '0.0', 2, 229, 0, 0, '12312', 0, 'http://www.facebook.com/cmsjunkie', 'http://www.twitter.com/cmsjunkie', 'http://www.google.com/cmsjunkie', '', '', '', '', '', '', '23123123', '', 'Good old day are coming back.', 0, 1, '', '', '', '', '/companies/8/cropped-1519401860.png', '0000-00-00', '0000-00-00', NULL, '-11:00', '', '0', NULL, '', NULL, 1, NULL, 1, NULL, NULL, 0, 5, 0, 0),
(9, 'Flower Shop', 'flower-shop', 'IT Services', 'Quisque cursus nunc ut diam pulvinar luctus. Nulla facilisi. Donec porta lorem id diam malesuada nec pretium enim euismod. Donec massa augue, lobortis eu cursus in, tincidunt ut nunc.', '<p>Quisque cursus nunc ut diam pulvinar luctus. Nulla facilisi. Donec porta lorem id diam malesuada nec pretium enim euismod. Donec massa augue, lobortis eu cursus in, tincidunt ut nunc. Proin pellentesque, lorem porttitor commodo hendrerit, enim leo mattis risus, ac viverra ante tellus quis velit. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Morbi dignissim tristique sapien ut pretium. Duis sollicitudin dolor sed nisi venenatis quis fringilla diam suscipit. Sed convallis lectus non nibh suscipit ullamcorper. Fusce in magna ac lacus semper convallis. Morbi sagittis auctor massa vel consequat. Nulla fermentum, sapien a sagittis accumsan, tellus ipsum posuere tellus, a lacinia tortor lacus in nisl. Vestibulum posuere dictum ipsum ac viverra. Integer neque neque, blandit non adipiscing vel, auctor non odio. Maecenas quis nibh a diam eleifend rhoncus sed in turpis. Pellentesque mollis fermentum dolor et mollis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed ullamcorper ante ac nunc commodo vitae rutrum sem placerat. Morbi et nisi metus.</p>', '', '', '32', 'Queen Street', 'Toronto', 'Ontario', '', '', 36, 'http://google.com', '', '3424234221212', '0727321321', 'office@company.com', '0010269/220123', 1, '5', '/companies/9/cropped-1620393424.jpeg', '2011-11-30 20:24:29', '2021-05-07 13:18:01', 11, '43.650391853968806', '-79.38038349151611', '20', 0, '1.5', '0.0', 2, 16, 0, 0, '123123', 0, '', '', '', '', '', '', '', '', '', '123213123', '', 'One flow for one happy person.', 0, 0, '', '', '', '', '', '0000-00-00', '0000-00-00', NULL, '-11:00', '', '0', NULL, '', NULL, 1, NULL, 1, NULL, NULL, 0, 6, 0, 0),
(12, 'Tea Shop', 'tea-shop', 'Almedia', 'Quisque cursus nunc ut diam pulvinar luctus. Nulla facilisi. Donec porta lorem id diam malesuada nec pretium enim euismod. Donec massa augue, lobortis eu cursus in, tincidunt ut nunc.', '<p>Quisque cursus nunc ut diam pulvinar luctus. Nulla facilisi. Donec porta lorem id diam malesuada nec pretium enim euismod. Donec massa augue, lobortis eu cursus in, tincidunt ut nunc. Proin pellentesque, lorem porttitor commodo hendrerit, enim leo mattis risus, ac viverra ante tellus quis velit. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Morbi dignissim tristique sapien ut pretium. Duis sollicitudin dolor sed nisi venenatis quis fringilla diam suscipit. Sed convallis lectus non nibh suscipit ullamcorper. Fusce in magna ac lacus semper convallis. Morbi sagittis auctor massa vel consequat. Nulla fermentum, sapien a sagittis accumsan, tellus ipsum posuere tellus, a lacinia tortor lacus in nisl. Vestibulum posuere dictum ipsum ac viverra. Integer neque neque, blandit non adipiscing vel, auctor non odio. Maecenas quis nibh a diam eleifend rhoncus sed in turpis. Pellentesque mollis fermentum dolor et mollis. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Sed ullamcorper ante ac nunc commodo vitae rutrum sem placerat. Morbi et nisi metus.</p>', '', '', '74444', 'Peg Keller Rd', 'Abita Springs', 'Louisiana', '', '', 226, 'http://www.cmsjunkie.com', '', 'RT545412SD', '001010727321321', 'directory@director.com', '', 1, '1', '/companies/12/cropped-1620392304.jpeg', '2011-12-01 21:32:19', '2021-05-07 12:59:43', 29, '43.65538688599313', '-79.35828778892756', '20', 0, '4.0', '0.0', 2, 97, 0, 0, '123123123', 0, 'http://https://www.facebook.com/cmsjunkie', 'http://https://twitter.com/cmsjunkie', 'http://https://plus.google.com/100376620356699373069/posts', '', '', '', '', '', '', '70420', '', 'Enjoy our best tea for a great day!', 0, 0, '', '', '', '', '', '0000-00-00', '0000-00-00', NULL, '-11:00', '', '0', NULL, '', NULL, 1, NULL, 1, NULL, NULL, 0, 7, 0, 0),
(29, 'Yacht Club', 'yacht-club', NULL, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc interdum mauris vitae urna ultrices, et fermentum magna convallis. Nullam quis vulputate magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc interdum mauris vitae urna ultrices, et fermentum magna convallis. Nullam quis vulputate magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nunc scelerisque enim ut magna vulputate feugiat. Suspendisse rutrum lectus et diam congue, sed pretium eros facilisis. Pellentesque pretium lectus orci, non accumsan velit vestibulum a. Fusce orci dui, tincidunt et tortor non, auctor rutrum mauris. Vestibulum sed ultricies enim, at ultrices quam.</p>\r\n<p>Quisque pellentesque libero eget dui elementum scelerisque. Pellentesque tempor arcu in hendrerit molestie. Phasellus euismod nisi in malesuada convallis. Praesent sapien neque, fermentum a laoreet eget, tempus ultricies nulla. Mauris mi tortor, maximus eu risus vitae, bibendum vestibulum leo. Nulla vitae efficitur lectus. Aenean aliquet massa magna. Nullam at dapibus mi. Vivamus massa nibh, venenatis mattis nibh pretium, pretium volutpat leo. Vestibulum eu sem elit. Duis consequat, magna id semper elementum, est nisi pharetra orci, eget molestie diam purus sed sem. Vestibulum est purus, sollicitudin eget lectus ut, molestie aliquam purus. Praesent suscipit vitae sem vel sodales.</p>', '', '', '77877', 'Mosby Creek Rd', 'Cottage Grove', 'Oregon', '', '', 226, '', '', '', '+1 232 883 9932', 'office@site.com', '', 1, '6', '/companies/29/cropped-1620391845.jpeg', '2015-12-20 04:44:58', '2021-05-07 12:52:57', 5, '43.77616', '-123.00627400000002', '0', 0, '0.0', '0.0', 2, 6, 0, 0, NULL, 0, 'http://www.facebook.com/cmsjunkie', 'http://www.twiter.com', 'http://www.googleplus.com', '', '', '', '', '', '', '97424', '+1 555 883 9932', 'We provide any yacht you want.', 0, 0, '', '', '', '', '', '0000-00-00', '0000-00-00', NULL, '-11:00', '', '0', NULL, '', NULL, 1, NULL, 1, NULL, NULL, 0, 8, 0, 0),
(30, 'Real Property', 'real-property', NULL, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc interdum mauris vitae urna ultrices, et fermentum magna convallis. Nullam quis vulputate magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc interdum mauris vitae urna ultrices, et fermentum magna convallis. Nullam quis vulputate magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nunc scelerisque enim ut magna vulputate feugiat. Suspendisse rutrum lectus et diam congue, sed pretium eros facilisis. Pellentesque pretium lectus orci, non accumsan velit vestibulum a. Fusce orci dui, tincidunt et tortor non, auctor rutrum mauris. Vestibulum sed ultricies enim, at ultrices quam.</p>\r\n<p>Quisque pellentesque libero eget dui elementum scelerisque. Pellentesque tempor arcu in hendrerit molestie. Phasellus euismod nisi in malesuada convallis. Praesent sapien neque, fermentum a laoreet eget, tempus ultricies nulla. Mauris mi tortor, maximus eu risus vitae, bibendum vestibulum leo. Nulla vitae efficitur lectus. Aenean aliquet massa magna. Nullam at dapibus mi. Vivamus massa nibh, venenatis mattis nibh pretium, pretium volutpat leo. Vestibulum eu sem elit. Duis consequat, magna id semper elementum, est nisi pharetra orci, eget molestie diam purus sed sem. Vestibulum est purus, sollicitudin eget lectus ut, molestie aliquam purus. Praesent suscipit vitae sem vel sodales.</p>', '', '', '1123', 'New York Ave', 'New York', 'New York', '', '', 226, '', '', '', '+1 232 883 9932', 'office@site.com', '', 1, '6', '/companies/30/cropped-1620391738.jpeg', '2016-01-20 05:12:27', '2021-05-07 12:49:23', 79, '40.645796', '-73.94583599999999', '0', 0, '0.0', '0.0', 2, 6, 0, 0, NULL, 0, 'http://www.facebook.com/cmsjunkie', 'http://www.twiter.com', 'http://www.googleplus.com', '', '', '', '', '', '', '11203', '+1 555 883 9932', 'We can sell it for you', 0, 0, '', '', '', '', '', '0000-00-00', '0000-00-00', NULL, '-11:00', '', '0', NULL, '', NULL, 1, NULL, 1, NULL, NULL, 0, 9, 0, 0),
(31, 'Restaurant One', 'restaurant-one', NULL, 'Quisque pellentesque libero eget dui elementum scelerisque. Pellentesque tempor arcu in hendrerit molestie. Phasellus euismod nisi in malesuada convallis. Praesent sapien neque, fermentum a laoreet eget, tempus ultricies nulla.', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc interdum mauris vitae urna ultrices, et fermentum magna convallis. Nullam quis vulputate magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nunc scelerisque enim ut magna vulputate feugiat. Suspendisse rutrum lectus et diam congue, sed pretium eros facilisis. Pellentesque pretium lectus orci, non accumsan velit vestibulum a. Fusce orci dui, tincidunt et tortor non, auctor rutrum mauris. Vestibulum sed ultricies enim, at ultrices quam.</p>\r\n<p>Quisque pellentesque libero eget dui elementum scelerisque. Pellentesque tempor arcu in hendrerit molestie. Phasellus euismod nisi in malesuada convallis. Praesent sapien neque, fermentum a laoreet eget, tempus ultricies nulla. Mauris mi tortor, maximus eu risus vitae, bibendum vestibulum leo. Nulla vitae efficitur lectus. Aenean aliquet massa magna. Nullam at dapibus mi. Vivamus massa nibh, venenatis mattis nibh pretium, pretium volutpat leo. Vestibulum eu sem elit. Duis consequat, magna id semper elementum, est nisi pharetra orci, eget molestie diam purus sed sem. Vestibulum est purus, sollicitudin eget lectus ut, molestie aliquam purus. Praesent suscipit vitae sem vel sodales.</p>', '', '', '12', 'New Hartford St', 'Wolcott', 'New York', '', '', 226, '', '', '', '+1 232 883 9932', 'office@site.com', '', 1, '1', '/companies/31/cropped-1620395170.jpeg', '2016-01-20 06:30:06', '2021-05-08 18:30:55', 75, '43.2157525', '-76.81465800000001', '0', 0, '0.0', '0.0', 2, 24, 0, 0, NULL, 0, '', '', '', '', '', '', '', '', '', '14590', '+1 555 883 9932', 'The food taste like never before.', 0, 0, '', '', '', '', '', '0000-00-00', '0000-00-00', NULL, '-11:00', '', '0', NULL, '', NULL, 1, NULL, 1, NULL, NULL, 0, 10, 0, 0),
(32, 'Fashion Inc.', 'fashion-inc', NULL, 'Donec eleifend purus nulla, non vehicula nisi dictum quis. Maecenas in odio purus. Etiam vulputate nisi eget pharetra tincidunt. Morbi et eros consectetur, ultricies ligula quis, ullamcorper neque. Donec pellentesque felis vel luctus tempus. Curabitu', '<p>Donec eleifend purus nulla, non vehicula nisi dictum quis. Maecenas in odio purus. Etiam vulputate nisi eget pharetra tincidunt. Morbi et eros consectetur, ultricies ligula quis, ullamcorper neque. Donec pellentesque felis vel luctus tempus. Curabitur blandit dui purus, non viverra magna consequat vitae. Nunc volutpat malesuada orci vitae varius.</p>\r\n<p>Suspendisse accumsan nunc non dictum bibendum. Sed suscipit id ipsum ut tincidunt. Vivamus condimentum diam at condimentum scelerisque. Etiam vulputate pellentesque maximus. Curabitur tincidunt nibh et nisl porttitor, eget ultrices turpis maximus. Fusce molestie elit eget felis cursus volutpat. Nam tincidunt lacus nec massa sagittis, eu dapibus purus bibendum. Ut hendrerit, felis nec congue posuere, lorem urna eleifend est, ac venenatis quam augue a arcu. Nullam sit amet finibus diam. Aenean placerat gravida mi at eleifend. Sed felis nulla, tempus ac vulputate vitae, condimentum vel nunc. Nam egestas, nunc sit amet tempor pellentesque, sapien justo aliquam tortor, at posuere elit purus eget orci. Aliquam hendrerit enim turpis, vitae ultrices libero accumsan nec. Pellentesque placerat volutpat fermentum. Sed tempor volutpat massa a auctor.</p>', '', '', '1', 'Rue Sherbrooke Est', 'Montréal', 'Québec', '', '', 36, '', '', '', '+1 555 888 9932', 'office@site.com', '', 1, '2', '/companies/32/cropped-1620390716.jpeg', '2015-12-21 18:36:50', '2021-05-07 12:48:03', 8, '45.5125554', '-73.56943790000003', '0', 0, '0.0', '0.0', 2, 12, 0, 0, NULL, 0, 'http://www.facebook.com/cmsjunkie', 'http://www.twiter.com', 'http://www.googleplus.com', '', '', '', '', '', '', 'H2X 3V8', '+1 555 883 9932', 'Fashion is art!', 0, 0, '', '', '', '', '', '0000-00-00', '0000-00-00', NULL, '-11:00', '', '0', NULL, '', NULL, 1, NULL, 1, NULL, NULL, 0, 11, 0, 0),
(33, 'Amusement Park', 'amusement-park', NULL, 'Donec eleifend purus nulla, non vehicula nisi dictum quis. Maecenas in odio purus. Etiam vulputate nisi eget pharetra tincidunt. Morbi et eros consectetur, ultricies ligula quis, ullamcorper neque. Donec pellentesque felis vel luctus tempus.', '<p>Donec eleifend purus nulla, non vehicula nisi dictum quis. Maecenas in odio purus. Etiam vulputate nisi eget pharetra tincidunt. Morbi et eros consectetur, ultricies ligula quis, ullamcorper neque. Donec pellentesque felis vel luctus tempus. Curabitur blandit dui purus, non viverra magna consequat vitae. Nunc volutpat malesuada orci vitae varius.</p>\r\n<p>Suspendisse accumsan nunc non dictum bibendum. Sed suscipit id ipsum ut tincidunt. Vivamus condimentum diam at condimentum scelerisque. Etiam vulputate pellentesque maximus. Curabitur tincidunt nibh et nisl porttitor, eget ultrices turpis maximus. Fusce molestie elit eget felis cursus volutpat. Nam tincidunt lacus nec massa sagittis, eu dapibus purus bibendum. Ut hendrerit, felis nec congue posuere, lorem urna eleifend est, ac venenatis quam augue a arcu. Nullam sit amet finibus diam. Aenean placerat gravida mi at eleifend. Sed felis nulla, tempus ac vulputate vitae, condimentum vel nunc. Nam egestas, nunc sit amet tempor pellentesque, sapien justo aliquam tortor, at posuere elit purus eget orci. Aliquam hendrerit enim turpis, vitae ultrices libero accumsan nec. Pellentesque placerat volutpat fermentum. Sed tempor volutpat massa a auctor.</p>', '', '', '12', 'Hopkins Ave', 'Jersey City', 'New Jersey', '', '', 226, '', '', '', '+1 444 777 9999', 'office@site.com', '', 1, '6', '/companies/33/cropped-1620390936.jpeg', '2016-01-22 18:41:43', '2022-05-25 16:02:33', 3, '40.7343489', '-74.05115409999996', '0', 0, '0.0', '0.0', 2, 9, 0, 0, NULL, 0, '', '', '', '', '', '', '', '', '', '07306', '+1 555 883 9932', 'Our main concern is your entertainment', 0, 0, '', '', '', '', '/companies/33/cropped-1519402034.png', '0000-00-00', '0000-00-00', NULL, '-11:00', '', '0', NULL, '', NULL, 1, NULL, 1, NULL, NULL, 0, 12, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_activity_city`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_activity_city`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_activity_city` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) DEFAULT NULL,
  `city_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `IND_UNQ` (`company_id`,`city_id`),
  KEY `idx_company` (`company_id`),
  KEY `idx_city` (`city_id`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_activity_city`
--

INSERT INTO `#__jbusinessdirectory_company_activity_city` (`id`, `company_id`, `city_id`) VALUES
(24, 1, -1),
(27, 4, -1),
(23, 8, -1),
(26, 9, -1),
(25, 12, -1);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_activity_region`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_activity_region`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_activity_region` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) DEFAULT NULL,
  `region_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `IND_UNQ` (`company_id`,`region_id`),
  KEY `idx_company` (`company_id`),
  KEY `idx_city` (`region_id`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_announcements`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_announcements`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_announcements` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `call_to_action` int(11) NOT NULL,
  `company_id` int(11) NOT NULL,
  `title` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `icon` varchar(50) DEFAULT NULL,
  `button_text` varchar(255) DEFAULT NULL,
  `button_link` varchar(255) DEFAULT NULL,
  `status` tinyint(4) DEFAULT '1',
  `expiration_date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_company_id` (`company_id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_announcements`
--

INSERT INTO `#__jbusinessdirectory_company_announcements` (`id`, `call_to_action`, `company_id`, `title`, `description`, `icon`, `button_text`, `button_link`, `status`, `expiration_date`) VALUES
(1, 1, 8, 'New course available!', 'We are proud to announce launch of new brCras eget lorem libero. Nulla facilisi. Aliquam ac volutpat erat. Etiam vulputate pellentesque maximus. Nunc id metus nunc. anch', 'la la-bullhorn', 'Join now', 'https://www.cmsjunkie.com/j-businessdirectory', 1, '0000-00-00'),
(2, 3, 8, 'Free photo session!', 'Etiam vulputate pellentesque maximus. Nunc id metus nunc. Cras eget lorem libero. Nulla facilisi. Aliquam ac volutpat erat. ', 'la la-calendar-check-o', 'Book now!', 'https://www.cmsjunkie.com/j-businessdirectory', 1, '0000-00-00'),
(3, 4, 8, 'Save 40% on our personal photo session', 'Donec porta lorem id diam malesuada nec pretium enim euismod. Donec massa augue, lobortis eu cursus in, tincidunt ut nunc. ', 'la la-cart-plus', 'Buy now!', 'https://www.cmsjunkie.com/j-businessdirectory', 1, '0000-00-00'),
(4, 1, 31, 'All locations are open now!', 'Nunc tempus leo in arcu mattis lobortis. Fusce ut sollicitudin nulla. Lorem ipsum dolor sit amet, consectetur adipiscing elit.  ', 'la la-bullhorn', 'Book a table!', 'https://www.cmsjunkie.com/j-businessdirectory', 1, '0000-00-00');

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_articles`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_articles`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_articles` (
  `article_id` int(11) NOT NULL,
  `company_id` int(11) NOT NULL,
  PRIMARY KEY (`article_id`),
  KEY `idx_company` (`company_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_attachments`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_attachments`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` tinyint(4) DEFAULT NULL,
  `object_id` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `path` varchar(155) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `ordering` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_type` (`type`),
  KEY `idx_object` (`object_id`),
  KEY `idx_status` (`status`),
  KEY `idx_order` (`ordering`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_attachments`
--

INSERT INTO `#__jbusinessdirectory_company_attachments` (`id`, `type`, `object_id`, `name`, `path`, `status`, `ordering`) VALUES
(22, 2, 13, 'Treatment instructions', '/offers/13/SPA_Woman_Face_1280_770_d-1426864490.jpg', 1, 0),
(27, 1, 12, 'Healthcare catalog', '/companies/12/natural-health-1426863987.jpg', 1, 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_attributes`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_attributes`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_attributes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `attribute_id` int(11) NOT NULL,
  `value` varchar(250) DEFAULT NULL,
  `option_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `company_UNIQUE` (`company_id`,`attribute_id`,`value`),
  KEY `idx_company_id` (`company_id`),
  KEY `idx_attribute_id` (`attribute_id`),
  KEY `idx_option_id` (`option_id`)
) ENGINE=MyISAM AUTO_INCREMENT=129 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_attributes`
--

INSERT INTO `#__jbusinessdirectory_company_attributes` (`id`, `company_id`, `attribute_id`, `value`, `option_id`) VALUES
(128, 33, 11, '58', NULL),
(127, 33, 11, '57', NULL),
(126, 33, 11, '56', NULL),
(125, 33, 11, '55', NULL),
(124, 33, 11, '54', NULL),
(123, 33, 10, '53', NULL),
(122, 33, 10, '52', NULL),
(121, 33, 10, '51', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_category`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_category`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_category` (
  `companyId` int(11) NOT NULL,
  `categoryId` int(11) NOT NULL,
  PRIMARY KEY (`companyId`,`categoryId`),
  KEY `idx_category` (`companyId`,`categoryId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_category`
--

INSERT INTO `#__jbusinessdirectory_company_category` (`companyId`, `categoryId`) VALUES
(1, 8),
(1, 35),
(4, 5),
(4, 60),
(5, 29),
(5, 42),
(5, 60),
(6, 5),
(6, 17),
(7, 13),
(7, 24),
(8, 13),
(8, 24),
(9, 11),
(9, 46),
(12, 29),
(12, 41),
(12, 42),
(20, 290),
(20, 292),
(29, 5),
(29, 60),
(29, 63),
(30, 79),
(31, 75),
(31, 77),
(31, 78),
(32, 8),
(32, 35),
(32, 38),
(33, 3);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_claim`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_claim`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_claim` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `companyId` int(11) DEFAULT NULL,
  `firstName` varchar(55) DEFAULT NULL,
  `lastName` varchar(55) DEFAULT NULL,
  `function` varchar(45) DEFAULT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `email` varchar(65) DEFAULT NULL,
  `status` int(3) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_companyId` (`companyId`),
  KEY `idx_status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=78 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_contact`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_contact`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_contact` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `companyId` int(11) NOT NULL,
  `contact_name` varchar(50) DEFAULT NULL,
  `contact_function` varchar(50) DEFAULT NULL,
  `contact_department` varchar(100) DEFAULT NULL,
  `contact_email` varchar(60) DEFAULT NULL,
  `contact_phone` varchar(20) DEFAULT NULL,
  `contact_fax` varchar(20) DEFAULT NULL,
  PRIMARY KEY (`id`,`companyId`),
  KEY `R_13` (`companyId`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_contact`
--

INSERT INTO `#__jbusinessdirectory_company_contact` (`id`, `companyId`, `contact_name`, `contact_function`, `contact_department`, `contact_email`, `contact_phone`, `contact_fax`) VALUES
(3, 12, 'Joanne Smith', NULL, '', 'joaan@joann.com', '+1 323 999 672', '+1 323 231 754'),
(4, 9, 'John rice', NULL, '', 'john@organic.co', '+1 221 359 888', ''),
(6, 7, 'John Doe', NULL, '', 'john@john.com', '01 232 495 999', ''),
(8, 29, 'John Smith', NULL, '', 'john@smith.com', '+1 221 359 888', ''),
(10, 31, 'Chef Michael', NULL, '', 'joaan@joann.com', '', ''),
(12, 33, 'Brian Lindow', NULL, '', 'office@site.com', '+1 323 999 672', '');

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_editors`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_editors`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_editors` (
  `company_id` int(11) NOT NULL,
  `editor_id` int(11) NOT NULL,
  PRIMARY KEY (`company_id`,`editor_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_events`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_events`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_events` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) DEFAULT NULL,
  `name` varchar(110) DEFAULT NULL,
  `alias` varchar(100) DEFAULT NULL,
  `short_description` varchar(245) DEFAULT NULL,
  `description` text,
  `meta_title` varchar(100) DEFAULT NULL,
  `meta_description` text,
  `meta_keywords` text,
  `price` varchar(100) DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `address` varchar(50) DEFAULT NULL,
  `street_number` varchar(20) DEFAULT NULL,
  `city` varchar(45) DEFAULT NULL,
  `county` varchar(45) DEFAULT NULL,
  `province` varchar(60) DEFAULT NULL,
  `area` varchar(60) DEFAULT NULL,
  `location` varchar(45) DEFAULT NULL,
  `latitude` varchar(45) DEFAULT NULL,
  `longitude` varchar(45) DEFAULT NULL,
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `view_count` int(11) NOT NULL DEFAULT '0',
  `approved` tinyint(1) NOT NULL DEFAULT '0',
  `state` tinyint(1) DEFAULT NULL,
  `recurring_id` int(11) DEFAULT NULL,
  `contact_phone` varchar(20) DEFAULT NULL,
  `contact_email` varchar(60) DEFAULT NULL,
  `doors_open_time` time DEFAULT NULL,
  `booking_open_date` date DEFAULT NULL,
  `booking_close_date` date DEFAULT NULL,
  `booking_open_time` time DEFAULT NULL,
  `booking_close_time` time DEFAULT NULL,
  `show_start_time` tinyint(1) NOT NULL DEFAULT '0',
  `show_end_time` tinyint(1) NOT NULL DEFAULT '0',
  `show_end_date` tinyint(1) NOT NULL DEFAULT '0',
  `show_doors_open_time` tinyint(1) NOT NULL DEFAULT '0',
  `currency_id` int(11) NOT NULL,
  `total_tickets` int(11) DEFAULT NULL,
  `expiration_email_date` datetime DEFAULT NULL,
  `main_subcategory` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `enable_subscription` tinyint(1) NOT NULL DEFAULT '0',
  `postalCode` varchar(55) DEFAULT NULL,
  `countryId` int(11) DEFAULT NULL,
  `time_zone` varchar(15) DEFAULT NULL,
  `recurring_info` varchar(255) DEFAULT NULL,
  `attendance_mode` tinyint(4) DEFAULT NULL,
  `attendance_url` varchar(245) DEFAULT NULL,
  `min_age` tinyint(4) DEFAULT NULL,
  `max_age` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_company` (`company_id`),
  KEY `idx_name` (`name`),
  KEY `idx_alias` (`alias`),
  KEY `idx_countryId` (`countryId`),
  KEY `idx_created` (`created`),
  KEY `idx_recurring_id` (`recurring_id`),
  KEY `idx_expiration_email_date` (`expiration_email_date`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_search` (`start_date`,`end_time`,`end_date`,`state`,`approved`,`start_time`),
  KEY `idx_type` (`type`),
  KEY `idx_featured` (`featured`),
  KEY `idx_currency` (`currency_id`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_events`
--

INSERT INTO `#__jbusinessdirectory_company_events` (`id`, `company_id`, `name`, `alias`, `short_description`, `description`, `meta_title`, `meta_description`, `meta_keywords`, `price`, `type`, `start_date`, `start_time`, `end_date`, `end_time`, `address`, `street_number`, `city`, `county`, `province`, `area`, `location`, `latitude`, `longitude`, `featured`, `created`, `view_count`, `approved`, `state`, `recurring_id`, `contact_phone`, `contact_email`, `doors_open_time`, `booking_open_date`, `booking_close_date`, `booking_open_time`, `booking_close_time`, `show_start_time`, `show_end_time`, `show_end_date`, `show_doors_open_time`, `currency_id`, `total_tickets`, `expiration_email_date`, `main_subcategory`, `user_id`, `enable_subscription`, `postalCode`, `countryId`, `time_zone`, `recurring_info`, `attendance_mode`, `attendance_url`, `min_age`, `max_age`) VALUES
(9, 33, 'Celebration Party', 'celebration-party', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla accumsan enim dignissim consectetur viverra. Vestibulum a erat vitae quam pellentesque varius vel at ipsum. Pellentesque ultricies.', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla accumsan enim dignissim consectetur viverra. Vestibulum a erat vitae quam pellentesque varius vel at ipsum. Pellentesque ultricies porttitor bibendum. Donec et justo quis tortor egestas rhoncus hendrerit ac massa. Sed tempus iaculis mi at sollicitudin. Etiam a ligula eget magna condimentum consectetur non pulvinar purus. Phasellus quis lobortis mauris. Nullam eleifend iaculis sem, nec hendrerit quam molestie vitae. Cras condimentum, augue at pretium pellentesque, ipsum arcu ullamcorper erat, eu laoreet libero erat id erat. Vestibulum ut dolor commodo, condimentum purus in, egestas purus. In hac habitasse platea dictumst. Nam rutrum sapien quam, in viverra libero interdum a. Vivamus sollicitudin dolor eget tincidunt faucibus. Cras pretium justo neque, quis imperdiet nulla vehicula a. Nulla facilisi. Aliquam justo ligula, fringilla vel orci in, imperdiet aliquam elit. Vivamus ac lorem blandit, tempor felis eget, placerat lectus.</p>', '', '', '', '0', 4, '2021-08-14', '15:00:00', '2024-11-22', '19:00:00', ' Scarborough Heights Boulevard', NULL, 'Toronto', 'Ontario', NULL, NULL, 'Toronto, Canada', '43.72347870000001', '-79.22839210000001', 0, '2021-05-31 22:21:20', 1, 1, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(10, 12, 'Bike Adventure', 'bike-adventure', 'Nulla consectetur magna et cursus sagittis. Quisque ac consectetur elit. Ut volutpat tellus non orci fermentum, sit amet tincidunt quam scelerisque. Integer eleifend congue eros.', '<p>Nulla consectetur magna et cursus sagittis. Quisque ac consectetur elit. Ut volutpat tellus non orci fermentum, sit amet tincidunt quam scelerisque. Integer eleifend congue eros pellentesque pharetra. Integer sed diam lectus. Donec ultricies, arcu a vulputate fringilla, nisi quam vestibulum libero, faucibus bibendum nunc justo sed ante. Etiam luctus quis nisl nec ornare. Fusce urna leo, tincidunt at commodo non, vestibulum et erat. In faucibus posuere purus, at egestas dolor dictum ac. Maecenas volutpat lectus eget purus hendrerit, sit amet hendrerit diam mattis. Nulla imperdiet metus ac metus molestie, sed imperdiet leo eleifend. Fusce non tellus porta risus convallis vehicula. Donec quis convallis ligula.</p>', '', '', '', '0', 5, '2021-09-21', '17:00:00', '2024-11-21', '20:00:00', ' Gamble Avenue', NULL, 'Toronto', 'Ontario', NULL, NULL, 'Gamble Avenue, Toronto, Canada', '43.6903736', '-79.34918140000002', 0, '2021-05-31 22:21:20', 6, 1, 1, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, 0, 0, 0, 0, NULL, NULL, NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL),
(11, 1, 'Violin concert', 'violin-concert', 'Nulla sagittis pretium sagittis. Aliquam tincidunt sodales dui, a facilisis nisi sollicitudin quis. Sed nec mattis augue. Sed hendrerit odio non mauris fermentum semper.', '<p>Nulla sagittis pretium sagittis. Aliquam tincidunt sodales dui, a facilisis nisi sollicitudin quis. Sed nec mattis augue. Sed hendrerit odio non mauris fermentum semper. Praesent vehicula nec libero a imperdiet. Proin posuere nibh libero, ac euismod nulla tincidunt in. Mauris est nunc, fringilla ac facilisis a, ornare a leo. Nam lobortis tortor fringilla, lobortis nisl sit amet, cursus dolor. In at lectus massa. Integer ut nulla dapibus, volutpat nisi vitae, laoreet tellus. Quisque hendrerit blandit leo at dapibus.</p>', '', '', '', '0', 5, '2021-11-22', '15:00:00', '2024-11-24', '12:00:00', '#24 St. John', '11', 'New York', 'New York', '', '', 'Gamble Avenue, Toronto, Canada', '40.72644570551446', '-74.11376953125', 1, '2021-05-31 22:21:20', 5, 1, 1, 0, '+110 889 33212', 'covert@atrium.com', '00:00:00', NULL, NULL, '00:00:00', '00:00:00', 0, 0, 0, 0, 2, NULL, NULL, 209, 0, 0, '9988', 226, '-11:00', NULL, 0, '', 0, 0),
(12, 8, 'Photography Course', 'photography-course', 'Suspendisse accumsan nunc non dictum bibendum. Sed suscipit id ipsum ut tincidunt. Vivamus condimentum diam at condimentum scelerisque. Etiam vulputate pellentesque maximus.', '<p>Suspendisse accumsan nunc non dictum bibendum. Sed suscipit id ipsum ut tincidunt. Vivamus condimentum diam at condimentum scelerisque. Etiam vulputate pellentesque maximus. Curabitur tincidunt nibh et nisl porttitor, eget ultrices turpis maximus. Fusce molestie elit eget felis cursus volutpat. Nam tincidunt lacus nec massa sagittis, eu dapibus purus bibendum. Ut hendrerit, felis nec congue posuere, lorem urna eleifend est, ac venenatis quam augue a arcu. Nullam sit amet finibus diam. Aenean placerat gravida mi at eleifend. Sed felis nulla, tempus ac vulputate vitae, condimentum vel nunc. Nam egestas, nunc sit amet tempor pellentesque, sapien justo aliquam tortor, at posuere elit purus eget orci. Aliquam hendrerit enim turpis, vitae ultrices libero accumsan nec. Pellentesque placerat volutpat fermentum. Sed tempor volutpat massa a auctor.</p>', '', '', '', '0', 3, '2021-09-23', '10:00:00', '2024-09-23', '19:30:00', '29895 Minnesota 34', '555', 'Detroit Lakes', 'Minnesota', '', '', 'London, UK', '46.828117', '-95.77565600000003', 0, '2021-05-31 22:21:20', 29, 1, 1, 0, '999 231 3231', 'contact@photography.com', '00:00:00', NULL, NULL, '00:00:00', '00:00:00', 0, 0, 0, 0, 2, NULL, NULL, 192, 0, 0, '9988', 226, '-11:00', NULL, 0, '', 0, 0),
(13, 32, 'Fashion Presentation', 'fashion-presentation', 'Suspendisse accumsan nunc non dictum bibendum. Sed suscipit id ipsum ut tincidunt. Vivamus condimentum diam at condimentum scelerisque. Etiam vulputate pellentesque maximus.', '<p>Suspendisse accumsan nunc non dictum bibendum. Sed suscipit id ipsum ut tincidunt. Vivamus condimentum diam at condimentum scelerisque. Etiam vulputate pellentesque maximus. Curabitur tincidunt nibh et nisl porttitor, eget ultrices turpis maximus. Fusce molestie elit eget felis cursus volutpat. Nam tincidunt lacus nec massa sagittis, eu dapibus purus bibendum. Ut hendrerit, felis nec congue posuere, lorem urna eleifend est, ac venenatis quam augue a arcu. Nullam sit amet finibus diam. Aenean placerat gravida mi at eleifend. Sed felis nulla, tempus ac vulputate vitae, condimentum vel nunc. Nam egestas, nunc sit amet tempor pellentesque, sapien justo aliquam tortor, at posuere elit purus eget orci. Aliquam hendrerit enim turpis, vitae ultrices libero accumsan nec. Pellentesque placerat volutpat fermentum. Sed tempor volutpat massa a auctor.</p>', '', '', '', '0', 5, '2021-12-17', '17:00:00', '2024-12-23', '19:30:00', '9291 Lee Highway', '12313', 'Warrenton', 'Virginia', '', '', 'Paris, France', '38.694513', '-77.89013299999999', 0, '2021-05-31 22:21:20', 5, 1, 1, 0, '+110 889 33212', 'info@fashion.com', '17:30:00', NULL, NULL, '00:00:00', '00:00:00', 1, 1, 1, 1, 2, NULL, NULL, 174, 0, 0, '553123', 36, '-11:00', NULL, 0, '', 0, 0),
(14, 31, 'Wine testing', 'wine-testing', 'Cras eget lorem libero. Nulla facilisi. Aliquam ac volutpat erat. Etiam vulputate pellentesque maximus. Nunc id metus nunc. Phasellus finibus ante et finibus viverra. Sed nec mattis augue.', '<p>Aliquam dignissim sagittis urna eu ultrices. Curabitur hendrerit mi leo, sed tincidunt libero venenatis eu. Curabitur non feugiat diam. Proin pharetra, leo ut pellentesque dignissim, orci libero tempus odio, congue volutpat arcu eros consectetur tortor. Cras eget volutpat felis. Ut lobortis lectus eget ligula condimentum hendrerit. Curabitur et justo nunc. Duis malesuada, est vel pellentesque viverra, nulla lorem ornare dui, eget elementum sapien elit et sapien. Nulla placerat laoreet arcu, eu ullamcorper massa viverra quis. Cras quis faucibus leo, ut iaculis sem. Cras et egestas odio, quis mollis mi. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus</p>', '', '', '', '0', 5, '2022-01-29', '02:00:00', '2024-09-23', '02:00:00', '#34 west street', '12', 'New York', 'New York', '', '', 'Burgundy, France', '40.759078', '-73.986201', 0, '2021-05-31 22:21:20', 2, 1, 1, 0, '+110 889 33212', 'taste@wine.com', '00:00:00', NULL, NULL, '00:00:00', '00:00:00', 0, 0, 0, 0, 2, NULL, NULL, 211, 0, 0, '99955', 226, '-11:00', NULL, 0, '', 0, 0),
(15, 30, 'Design Trends', 'design-trends', 'Mauris quis finibus tellus, eget dignissim tellus. Cras eget lorem libero. Nulla facilisi. Aliquam ac volutpat erat. Nunc id metus nunc. Phasellus finibus ante et finibus viverra.', '<p>Mauris quis finibus tellus, eget dignissim tellus. Cras eget lorem libero. Nulla facilisi. Aliquam ac volutpat erat. Nunc id metus nunc. Phasellus finibus ante et finibus viverra. Mauris scelerisque dignissim mauris, sit amet congue nisi sagittis vel. Etiam lacinia sapien in nulla ultricies eleifend. Aliquam feugiat vitae magna id aliquet. Nam sem ligula, sollicitudin in placerat quis, scelerisque elementum tortor. Aenean imperdiet dictum lorem. Praesent sit amet arcu id mi hendrerit scelerisque. Integer tincidunt massa eget lectus laoreet porttitor. Fusce quis luctus orci.</p>', '', '', '', '25', 5, '2021-12-11', '11:00:00', '2024-12-23', '18:30:00', '7777 Hollywood Boulevard', '12', 'Los Angeles', 'California', '', 'Broad', 'New York, US', '34.10199989999999', '-118.35907500000002', 1, '2021-05-31 22:21:20', 6, 1, 1, 0, '(999) 23545', 'support@cmsjunkie.com', '07:00:00', '2021-05-11', '2021-12-19', '00:00:00', '00:00:00', 1, 1, 0, 1, 143, 50, NULL, 215, 0, 1, '88998', 226, '-11:00', NULL, 0, '', 0, 0),
(16, 31, 'Fine dining', 'fine-dining', 'Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nunc scelerisque enim ut magna vulputate feugiat. Suspendisse rutrum lectus et diam congue, sed pretium eros facilisis. Pellentesque pretium lectus orci', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc interdum mauris vitae urna ultrices, et fermentum magna convallis. Nullam quis vulputate magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nunc scelerisque enim ut magna vulputate feugiat. Suspendisse rutrum lectus et diam congue, sed pretium eros facilisis. Pellentesque pretium lectus orci, non accumsan velit vestibulum a. Fusce orci dui, tincidunt et tortor non, auctor rutrum mauris.</p>\r\n<p>Vestibulum sed ultricies enim, at ultrices quam. Quisque pellentesque libero eget dui elementum scelerisque. Pellentesque tempor arcu in hendrerit molestie. Phasellus euismod nisi in malesuada convallis. Praesent sapien neque, fermentum a laoreet eget, tempus ultricies nulla. Mauris mi tortor, maximus eu risus vitae, bibendum vestibulum leo. Nulla vitae efficitur lectus.</p>\r\n<p>Aenean aliquet massa magna. Nullam at dapibus mi. Vivamus massa nibh, venenatis mattis nibh pretium, pretium volutpat leo. Vestibulum eu sem elit. Duis consequat, magna id semper elementum, est nisi pharetra orci, eget molestie diam purus sed sem. Vestibulum est purus, sollicitudin eget lectus ut, molestie aliquam purus</p>', '', '', '', '0', 4, '2021-11-10', '18:00:00', '2024-11-15', '08:30:00', 'Bay Street', '777', 'Toronto', 'Toronto', 'Ontario', '', '', '43.68132914600822', '-79.21665394309316', 0, '2021-05-09 23:22:30', 0, 1, 1, 0, '+110 889 33212', 'taste@wine.com', '18:00:00', NULL, NULL, '00:00:00', '00:00:00', 0, 0, 0, 0, 143, 0, NULL, 211, 0, 0, '5585', 36, '-11:00', NULL, 0, '', 0, 0),
(17, 33, 'Great time with friends', 'great-time-with-friends', 'Sed suscipit id ipsum ut tincidunt. Vivamus condimentum diam at condimentum scelerisque. Etiam vulputate pellentesque maximus. Curabitur tincidunt nibh et nisl porttitor, eget ultrices turpis maximus.', '<p>Donec eleifend purus nulla, non vehicula nisi dictum quis. Maecenas in odio purus. Etiam vulputate nisi eget pharetra tincidunt. Morbi et eros consectetur, ultricies ligula quis, ullamcorper neque. Donec pellentesque felis vel luctus tempus. Curabitur blandit dui purus, non viverra magna consequat vitae. Nunc volutpat malesuada orci vitae varius.</p>\r\n<p>Suspendisse accumsan nunc non dictum bibendum. Sed suscipit id ipsum ut tincidunt. Vivamus condimentum diam at condimentum scelerisque. Etiam vulputate pellentesque maximus. Curabitur tincidunt nibh et nisl porttitor, eget ultrices turpis maximus. Fusce molestie elit eget felis cursus volutpat.</p>\r\n<p>Nam tincidunt lacus nec massa sagittis, eu dapibus purus bibendum. Ut hendrerit, felis nec congue posuere, lorem urna eleifend est, ac venenatis quam augue a arcu.</p>', '', '', '', '30', 4, '2022-09-10', '12:00:00', '2024-10-20', '20:00:00', 'Park Avenue', '1122', 'York', 'New York', '', '', '', '40.71080107753515', '-73.99564506594854', 0, '2021-05-09 23:44:29', 1, 1, 1, 0, '+110 889 33212', 'adventure@park.com', '00:00:00', NULL, NULL, '00:00:00', '00:00:00', 0, 0, 0, 0, 143, 0, NULL, 197, 0, 0, '88778', 226, '-11:00', NULL, 0, '', 5, 16);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_event_appointments`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_event_appointments`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_event_appointments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(45) DEFAULT NULL,
  `last_name` varchar(45) DEFAULT NULL,
  `company_name` varchar(45) DEFAULT NULL,
  `email` varchar(45) DEFAULT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `time` time DEFAULT NULL,
  `remarks` varchar(300) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `event_id` int(11) NOT NULL,
  `company_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_company` (`company_id`),
  KEY `idx_event` (`event_id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_status` (`status`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_event_associated_items`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_event_associated_items`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_event_associated_items` (
  `event_id` int(11) NOT NULL,
  `company_id` int(11) NOT NULL,
  PRIMARY KEY (`event_id`,`company_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_event_associated_items`
--

INSERT INTO `#__jbusinessdirectory_company_event_associated_items` (`event_id`, `company_id`) VALUES
(11, 7),
(11, 8),
(11, 9),
(11, 32),
(12, 1),
(12, 7),
(12, 8),
(12, 9),
(13, 1),
(13, 7),
(13, 8),
(13, 32);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_event_bookings`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_event_bookings`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_event_bookings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_id` int(11) NOT NULL,
  `first_name` varchar(45) DEFAULT NULL,
  `last_name` varchar(45) DEFAULT NULL,
  `address` varchar(55) DEFAULT NULL,
  `email` varchar(45) DEFAULT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `postal_code` varchar(45) DEFAULT NULL,
  `city` varchar(45) DEFAULT NULL,
  `region` varchar(45) DEFAULT NULL,
  `amount` decimal(12,2) DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `paid_at` datetime DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `initial_amount` decimal(12,2) DEFAULT NULL,
  `vat_amount` decimal(12,2) DEFAULT NULL,
  `vat` decimal(12,2) DEFAULT NULL,
  `country_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_event` (`event_id`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_event_booking_tickets`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_event_booking_tickets`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_event_booking_tickets` (
  `booking_id` int(11) NOT NULL,
  `ticket_id` int(11) NOT NULL,
  `ticket_quantity` int(11) DEFAULT NULL,
  PRIMARY KEY (`booking_id`,`ticket_id`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_event_category`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_event_category`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_event_category` (
  `eventId` int(11) NOT NULL,
  `categoryId` int(11) NOT NULL,
  PRIMARY KEY (`eventId`,`categoryId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_event_category`
--

INSERT INTO `#__jbusinessdirectory_company_event_category` (`eventId`, `categoryId`) VALUES
(9, 206),
(10, 171),
(10, 199),
(11, 209),
(12, 192),
(13, 174),
(14, 211),
(15, 215),
(16, 211),
(16, 212),
(16, 213),
(17, 197);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_event_pictures`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_event_pictures`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_event_pictures` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `eventId` int(10) NOT NULL DEFAULT '0',
  `picture_info` varchar(255) DEFAULT NULL,
  `picture_path` varchar(255) DEFAULT NULL,
  `picture_enable` tinyint(1) NOT NULL DEFAULT '1',
  `picture_title` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_event` (`eventId`),
  KEY `idx_status` (`picture_enable`)
) ENGINE=MyISAM AUTO_INCREMENT=154 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_event_pictures`
--

INSERT INTO `#__jbusinessdirectory_company_event_pictures` (`id`, `eventId`, `picture_info`, `picture_path`, `picture_enable`, `picture_title`) VALUES
(126, 14, '', '/events/14/image1-1427103268.jpg', 1, ''),
(122, 11, '', '/events/11/image2.jpg', 1, ''),
(125, 14, '', '/events/14/image3-1427103263.jpg', 1, ''),
(141, 16, '', '/events/16/fine_dining_1.jpg', 1, ''),
(124, 14, '', '/events/14/image1.jpg', 1, ''),
(117, 13, '', '/events/13/fashion_4.jpg', 1, ''),
(116, 13, '', '/events/13/image6.jpg', 1, ''),
(115, 13, '', '/events/13/fashion_2.jpg', 1, ''),
(80, 9, '', '/events/9/image5.jpg', 1, ''),
(79, 9, '', '/events/9/image3.jpg', 1, ''),
(78, 9, '', '/events/9/image4.jpg', 1, ''),
(140, 16, '', '/events/16/fine_dining_2.jpg', 1, ''),
(114, 13, '', '/events/13/fashion_1.jpg', 1, ''),
(77, 10, '', '/events/10/image2.jpeg', 1, ''),
(76, 10, '', '/events/10/image3.jpg', 1, ''),
(75, 10, '', '/events/10/image1.jpg', 1, ''),
(121, 11, '', '/events/11/iamge3.jpg', 1, ''),
(120, 11, '', '/events/11/image1.jpg', 1, ''),
(119, 11, '', '/events/11/image4.jpg', 1, ''),
(151, 15, '', '/events/15/image1-1427103376.jpeg', 1, ''),
(123, 14, '', '/events/14/wine.jpg', 1, ''),
(150, 15, '', '/events/15/interior.jpg', 1, ''),
(118, 13, '', '/events/13/fashion_3.jpg', 1, ''),
(139, 16, '', '/events/16/fine_dining_3.jpg', 1, ''),
(145, 17, '', '/events/17/image1.jpg', 1, ''),
(147, 12, '', '/events/12/photography_course.jpg', 1, ''),
(144, 17, '', '/events/17/park_1.jpg', 1, ''),
(146, 17, '', '/events/17/image3.jpg', 1, ''),
(148, 12, '', '/events/12/camera.jpg', 1, ''),
(149, 12, '', '/events/12/image2.jpg', 1, ''),
(152, 15, '', '/events/15/w1-1427103368.jpg', 1, ''),
(153, 15, '', '/events/15/image3-1427103371.jpg', 1, '');

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_event_tickets`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_event_tickets`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_event_tickets` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `event_id` int(11) NOT NULL,
  `name` varchar(255) DEFAULT NULL,
  `description` text,
  `price` decimal(12,2) DEFAULT NULL,
  `published` tinyint(4) NOT NULL DEFAULT '1',
  `min_booking` int(11) DEFAULT NULL,
  `max_booking` int(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `ordering` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_event_id` (`event_id`),
  KEY `idx_published` (`published`)
) ENGINE=MyISAM AUTO_INCREMENT=31 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_event_tickets`
--

INSERT INTO `#__jbusinessdirectory_company_event_tickets` (`id`, `event_id`, `name`, `description`, `price`, `published`, `min_booking`, `max_booking`, `quantity`, `ordering`) VALUES
(28, 15, 'Children ticket', 'Tickets for childer  0 -12 years', '10.00', 1, 1, 10, 100, 1),
(29, 15, 'Adult Tickets', 'Tickets for adults 12+ years', '45.00', 1, 1, 10, 100, 2),
(30, 15, 'Premium tickets', 'Premium place tickets', '100.00', 1, 1, 5, 15, 3);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_event_types`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_event_types`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_event_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `ordering` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_event_types`
--

INSERT INTO `#__jbusinessdirectory_company_event_types` (`id`, `name`, `ordering`) VALUES
(1, 'Seminar', 1),
(2, 'Training', 2),
(3, 'Workshop', 3),
(4, 'Party', 4),
(5, 'Presentation', 5);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_locations`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_locations`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(80) DEFAULT NULL,
  `company_id` int(11) DEFAULT NULL,
  `street_number` varchar(20) DEFAULT NULL,
  `address` varchar(100) DEFAULT NULL,
  `city` varchar(60) DEFAULT NULL,
  `county` varchar(60) DEFAULT NULL,
  `postalCode` varchar(45) DEFAULT NULL,
  `countryId` int(11) DEFAULT NULL,
  `latitude` varchar(45) DEFAULT NULL,
  `longitude` varchar(45) DEFAULT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `province` varchar(60) DEFAULT NULL,
  `area` varchar(60) DEFAULT NULL,
  `identifier` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_country` (`countryId`),
  KEY `idx_company` (`company_id`),
  KEY `idx_identifier` (`identifier`),
  KEY `idx_city` (`city`),
  KEY `idx_county` (`county`),
  KEY `idx_province` (`province`),
  KEY `idx_area` (`area`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_marketing_email_sent`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_marketing_email_sent`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_marketing_email_sent` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `email_type` int(11) DEFAULT NULL,
  `number_email_sent` int(11) DEFAULT NULL,
  `sending_date` datetime DEFAULT NULL,
  `failed_sent` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_members`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_members`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `name` varchar(50) DEFAULT NULL,
  `title` varchar(50) DEFAULT NULL,
  `type` int(11) NOT NULL DEFAULT '0',
  `description` varchar(350) DEFAULT NULL,
  `image` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_company` (`company_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_membership`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_membership`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_membership` (
  `company_id` int(11) NOT NULL,
  `membership_id` int(11) NOT NULL,
  PRIMARY KEY (`company_id`,`membership_id`),
  KEY `idx_category` (`company_id`,`membership_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_offers`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_offers`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_offers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `companyId` int(11) NOT NULL,
  `currencyId` int(11) NOT NULL,
  `subject` varchar(110) DEFAULT NULL,
  `description` text,
  `meta_title` varchar(100) DEFAULT NULL,
  `meta_description` text,
  `meta_keywords` text,
  `price` decimal(12,2) DEFAULT NULL,
  `specialPrice` decimal(12,2) DEFAULT NULL,
  `price_base` decimal(12,2) DEFAULT NULL,
  `price_base_unit` varchar(45) DEFAULT NULL,
  `special_price_base` decimal(12,2) DEFAULT NULL,
  `special_price_base_unit` varchar(45) DEFAULT NULL,
  `total_coupons` int(11) NOT NULL DEFAULT '0',
  `startDate` date DEFAULT NULL,
  `endDate` date DEFAULT NULL,
  `state` tinyint(1) NOT NULL DEFAULT '1',
  `approved` tinyint(1) NOT NULL DEFAULT '0',
  `offerOfTheDay` tinyint(1) NOT NULL DEFAULT '0',
  `viewCount` int(10) DEFAULT '0',
  `alias` varchar(100) DEFAULT NULL,
  `address` varchar(45) DEFAULT NULL,
  `street_number` varchar(20) DEFAULT NULL,
  `city` varchar(45) DEFAULT NULL,
  `short_description` varchar(255) DEFAULT NULL,
  `county` varchar(45) DEFAULT NULL,
  `province` varchar(60) DEFAULT NULL,
  `area` varchar(60) DEFAULT NULL,
  `publish_start_date` date DEFAULT NULL,
  `publish_end_date` date DEFAULT NULL,
  `view_type` tinyint(2) NOT NULL DEFAULT '1',
  `url` varchar(145) DEFAULT NULL,
  `article_id` int(11) DEFAULT NULL,
  `latitude` varchar(45) DEFAULT NULL,
  `longitude` varchar(45) DEFAULT NULL,
  `featured` tinyint(1) NOT NULL DEFAULT '0',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `show_time` tinyint(1) DEFAULT '0',
  `publish_start_time` time DEFAULT NULL,
  `publish_end_time` time DEFAULT NULL,
  `expiration_email_date` datetime DEFAULT NULL,
  `main_subcategory` int(11) DEFAULT NULL,
  `enable_offer_selling` tinyint(1) DEFAULT '1',
  `min_purchase` int(11) DEFAULT NULL,
  `max_purchase` int(11) DEFAULT NULL,
  `quantity` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `postalCode` varchar(55) DEFAULT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `countryId` int(11) DEFAULT NULL,
  `price_text` varchar(100) DEFAULT NULL,
  `offer_type` int(11) DEFAULT NULL,
  `time_zone` varchar(15) DEFAULT NULL,
  `item_type` tinyint(1) NOT NULL DEFAULT '1',
  `notify_offer_quantity` int(11) DEFAULT NULL,
  `use_stock_price` tinyint(1) DEFAULT NULL,
  `contact_email` varchar(100) DEFAULT NULL,
  `add_to_price_list` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_alias` (`alias`),
  KEY `idx_company` (`companyId`),
  KEY `idx_country` (`countryId`),
  KEY `idx_approved` (`approved`),
  KEY `idx_type` (`type`),
  KEY `idx_featured` (`featured`),
  KEY `idx_latitude` (`latitude`),
  KEY `idx_longitude` (`longitude`),
  KEY `idx_price` (`price`),
  KEY `idx_specialPrice` (`specialPrice`),
  KEY `idx_subject` (`subject`),
  KEY `idx_city` (`city`),
  KEY `idx_county` (`county`),
  KEY `idx_area` (`area`),
  KEY `idx_province` (`province`),
  KEY `idx_short_description` (`short_description`(100)),
  KEY `idx_address` (`address`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_expiration_email_date` (`expiration_email_date`),
  KEY `idx_search` (`state`,`endDate`,`startDate`,`publish_end_date`,`publish_start_date`),
  KEY `idx_publish_time` (`publish_start_time`,`publish_end_time`),
  KEY `idx_offer_type` (`offer_type`)
) ENGINE=MyISAM AUTO_INCREMENT=24 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_offers`
--

INSERT INTO `#__jbusinessdirectory_company_offers` (`id`, `companyId`, `currencyId`, `subject`, `description`, `meta_title`, `meta_description`, `meta_keywords`, `price`, `specialPrice`, `price_base`, `price_base_unit`, `special_price_base`, `special_price_base_unit`, `total_coupons`, `startDate`, `endDate`, `state`, `approved`, `offerOfTheDay`, `viewCount`, `alias`, `address`, `street_number`, `city`, `short_description`, `county`, `province`, `area`, `publish_start_date`, `publish_end_date`, `view_type`, `url`, `article_id`, `latitude`, `longitude`, `featured`, `created`, `show_time`, `publish_start_time`, `publish_end_time`, `expiration_email_date`, `main_subcategory`, `enable_offer_selling`, `min_purchase`, `max_purchase`, `quantity`, `user_id`, `postalCode`, `type`, `countryId`, `price_text`, `offer_type`, `time_zone`, `item_type`, `notify_offer_quantity`, `use_stock_price`, `contact_email`, `add_to_price_list`) VALUES
(3, 12, 0, 'Garden arrangements', '<p>Etiam eget urna est. Nullam turpis magna, pharetra id venenatis id, adipiscing at velit. In lobortis ornare congue. Sed vitae neque lacus, et rutrum lorem. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Pellentesque quis rhoncus felis. Sed adipiscing tellus laoreet neque adipiscing ac euismod felis gravida. Aenean fermentum, nulla non adipiscing tristique, lacus justo ornare nunc, eu aliquam nunc massa non justo. Sed at sapien vitae eros luctus condimentum non at libero. Morbi id arcu nec mi suscipit molestie. Integer ullamcorper suscipit erat, quis convallis quam interdum convallis. Sed lectus justo, vehicula et euismod rhoncus, tempus vel magna. Pellentesque laoreet, odio id iaculis bibendum, erat quam mollis urna, ac pretium neque mi vitae nisl. Fusce euismod bibendum risus vel suscipit. Suspendisse sapien tortor, vehicula sed lobortis tempus, pellentesque ut lectus.</p>', '', '', '', '120.00', '90.00', NULL, NULL, NULL, NULL, 0, '2022-07-01', '2024-12-10', 1, 1, 1, 16, 'garden-arrangements', '7777 Forest Blvd', NULL, 'Dallas', 'Etiam eget urna est. Nullam turpis magna, pharetra id venenatis id, adipiscing at velit. In lobortis ornare congue. Sed vitae neque lacus, et rutrum lorem. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae;', 'Texas', NULL, NULL, NULL, NULL, 1, '', 0, '32.9113547', '-96.77428509999999', 0, '2015-03-19 11:04:23', 0, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 0),
(13, 5, 0, 'Yoga meditation day', '<p>Quisque cursus nunc ut diam pulvinar luctus. Nulla facilisi. Donec porta lorem id diam malesuada nec pretium enim euismod. Donec massa augue, lobortis eu cursus in, tincidunt ut nunc. Proin pellentesque, lorem porttitor commodo hendrerit, enim leo mattis risus, ac viverra ante tellus quis velit. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Morbi dignissim tristique sapien ut pretium. Duis sollicitudin dolor sed nisi venenatis quis fringilla diam suscipit. Sed convallis lectus non nibh suscipit ullamcorper. Fusce in magna ac lacus semper convallis. Morbi sagittis auctor massa vel consequat. Nulla fermentum, sapien a sagittis accumsan, tellus ipsum posuere tellus, a lacinia tortor lacus in nisl. Vestibulum posuere dictum ipsum ac viverra. Integer neque neque, blandit non adipiscing vel, auctor non odio. Maecenas quis nibh a diam eleifend rhoncus sed in turpis. Pellentesque mollis fermentum dolor et mollis. Cum sociis natoque penatibus et mag</p>', '', '', '', '69.99', '49.99', NULL, NULL, NULL, NULL, 0, '2022-06-03', '2024-01-04', 1, 1, 1, 27, 'yoga-meditation-day', 'Country Hills Blvd NW', NULL, 'Beaumont', 'Quisque cursus nunc ut diam pulvinar luctus. Nulla facilisi. Donec porta lorem id diam malesuada nec pretium enim euismod. Donec massa augue, lobortis eu cursus in, tincidunt ut nunc', 'Texas', NULL, NULL, NULL, NULL, 1, '', 0, '43.70957890823799', '-79.50366217643023', 0, '2015-03-19 11:04:23', 0, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 0),
(14, 8, 0, 'Camera time', '<p>Duis faucibus odio quis sapien imperdiet, nec congue turpis pellentesque. Integer mi turpis, eleifend et mollis eu, dapibus quis elit. Pellentesque at turpis urna. Sed scelerisque Diam scelerisque fermentum finibus. Mauris elementum euismod erat sed condimentum. Nulla imperdiet mattis massa, at fermentum erat tristique ac. Praesent eget velit maximus, blandit nisi at, porta ligula. Etiam quis libero nisl. Vestibulum quis ornare dui. Suspendisse quis lobortis nunc. Pellentesque quis pharetra metus. Phasellus vulputate orci in pharetra feugiat. Etiam vehicula lacus augue, et lacinia turpis mollis id. Phasellus sed feugiat nunc, sed pharetra risus. Etiam eleifend quis lectus et gravida. Nunc pretium nisi id mi maximus mollis. Aliquam tempus dictum mi. Donec cursus pharetra neque, at gravida dolor vestibulum sit amet. Donec quam urna, molestie pharetra venenatis in, tincidunt quis elit. Praesent pharetra eget metus vitae vestibulum. Mauris gravida turpis lorem, aliquam semper justo auc.</p>', '', '', '', '88.00', '55.00', NULL, NULL, NULL, NULL, 20, '2022-05-25', '2024-09-25', 1, 1, 0, 12, 'camera-time', 'Chopin Ave', NULL, 'Toronto', 'Diam scelerisque fermentum finibus. Mauris elementum euismod erat sed condimentum. Nulla imperdiet mattis massa, at fermentum erat tristique ac. Praesent eget velit maximus, blandit nisi at, porta ligula.', 'Ontario', NULL, NULL, NULL, NULL, 1, '', 0, '43.737594787503966', '-79.27854752537314', 0, '2015-03-19 11:04:23', 0, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 0),
(15, 1, 0, 'Book now and get 20 % off', '<p>Morbi porta luctus enim at scelerisque. Cras imperdiet nibh eget commodo blandit. Aliquam nec commodo lectus. Donec pellentesque, massa quis porta aliquet, massa metus accumsan metus, nec dignissim tortor mi eu erat. Phasellus pulvinar metus a tortor eleifend, a hendrerit tortor rutrum. Aliquam in tellus gravida, varius sem quis, interdum elit. Pellentesque nec egestas augue. Donec ullamcorper ante eu libero hendrerit, vel tempus dolor dapibus. Quisque finibus nisi eu sem venenatis porta. Praesent tempor nisi urna. Integer convallis dolor id ullamcorper consectetur. Morbi sodales mi et orci sollicitudin, sit amet pretium ante vulputate. Nullam ultrices vehicula urna in condimentum. Nulla lacus tortor, lobortis pulvinar turpis vitae, hendrerit gravida enim. Vestibulum eros magna, elementum ut pulvinar eget, placerat et augue. Vestibulum eget sapien vitae dui facilisis maximus a vel ligula. Nunc urna tortor, lobortis eu interdum vitae, mattis sit amet libero. Phasellus quis dapibus arcu, vulputate hendrerit est. Ut mattis bibendum gravida. Ut molestie ornare sapien nec dictum.</p>', '', '', '', '90.00', '70.00', NULL, NULL, NULL, NULL, 0, '2022-05-26', '2024-12-31', 1, 1, 0, 2, 'book-now-and-get-20-off', 'Chopin Ave', NULL, 'Toronto', 'Morbi porta luctus enim at scelerisque. Cras imperdiet nibh eget commodo blandit. Aliquam nec commodo lectus. Donec pellentesque, massa quis porta aliquet, massa metus accumsan metus, nec dignissim tortor mi eu erat. Phasellus pulvinar metus a torto', 'Ontario', NULL, NULL, NULL, NULL, 1, '', 0, '43.737032009283475', '-79.27838659283225', 0, '2016-01-19 11:04:23', 0, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 0),
(16, 29, 0, 'Yacht Final Sale', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed egestas maximus arcu a posuere. Phasellus eget tellus ac purus vulputate auctor. Donec nec semper elit, quis iaculis purus. Praesent vitae facilisis enim. Vestibulum laoreet tristique velit quis porttitor. Nam venenatis vestibulum est ut aliquam. Vivamus placerat sollicitudin est ut aliquet. Fusce imperdiet auctor felis, ut egestas sem condimentum sed. Pellentesque porta sit amet justo non imperdiet. Mauris leo lorem, ultricies eu consectetur eu, laoreet nec tortor. In hac habitasse platea dictumst. Donec facilisis nulla vitae est vulputate feugiat. Nam consequat orci elit, quis condimentum massa aliquet id. Sed tortor est, dictum ac viverra a, aliquam vel lectus. Ut non ipsum sodales, cursus neque id, sollicitudin nunc. Duis vitae placerat lacus. Vestibulum sit amet neque congue, euismod diam id, sagittis felis. Aenean fringilla tempor velit sit amet pretium. Praesent sollicitudin libero in quam semper, ac vestibulum libero tempus. Integer euismod ipsum et varius mollis.</p>', '', '', '', '80000.00', '65000.00', NULL, NULL, NULL, NULL, 0, '2022-06-26', '2024-09-26', 1, 1, 0, 5, 'yacht-final-sale', '130 Yorkland Boulevard', NULL, 'Beaumont', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed egestas maximus arcu a posuere. Phasellus eget tellus ac purus vulputate auctor. Donec nec semper elit, quis iaculis purus.', 'Texas', NULL, NULL, NULL, NULL, 1, '', 0, '29.874468564024614', '-94.1099853347987', 0, '2015-03-19 11:04:23', 0, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 0),
(17, 30, 0, 'Travel to Rome', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc interdum mauris vitae urna ultrices, et fermentum magna convallis. Nullam quis vulputate magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nunc scelerisque enim ut magna vulputate feugiat. Suspendisse rutrum lectus et diam congue, sed pretium eros facilisis. Pellentesque pretium lectus orci, non accumsan velit vestibulum a. Fusce orci dui, tincidunt et tortor non, auctor rutrum mauris. Vestibulum sed ultricies enim, at ultrices quam. Quisque pellentesque libero eget dui elementum scelerisque. Pellentesque tempor arcu in hendrerit molestie. Phasellus euismod nisi in malesuada convallis. Praesent sapien neque, fermentum a laoreet eget, tempus ultricies nulla. Mauris mi tortor, maximus eu risus vitae, bibendum vestibulum leo. Nulla vitae efficitur lectus. Aenean aliquet massa magna. Nullam at dapibus mi. Vivamus massa nibh, venenatis mattis nibh pretium, pretium volutpat leo. Vestibulum eu sem elit. Duis consequat, magna id semper elementum, est nisi pharetra orci, eget molestie diam purus sed sem. Vestibulum est purus, sollicitudin eget lectus ut, molestie aliquam purus. P</p>', '', '', '', '1100.00', '890.00', NULL, NULL, NULL, NULL, 10, '2022-03-20', '2024-10-20', 1, 1, 0, 1, 'travel-to-rome', '24 Viale Leonardo da Vinci', NULL, 'Rome', ' Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc interdum mauris vitae urna ultrices, et fermentum magna convallis. Nullam quis vulputate magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.', 'Lazio', NULL, NULL, NULL, NULL, 1, '', 0, '41.8546831', '12.48038459999998', 0, '2015-12-19 14:12:33', 0, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 0),
(18, 31, 0, 'Chinese night', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc interdum mauris vitae urna ultrices, et fermentum magna convallis. Nullam quis vulputate magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nunc scelerisque enim ut magna vulputate feugiat. Suspendisse rutrum lectus et diam congue, sed pretium eros facilisis. Pellentesque pretium lectus orci, non accumsan velit vestibulum a. Fusce orci dui, tincidunt et tortor non, auctor rutrum mauris. Vestibulum sed ultricies enim, at ultrices quam. Quisque pellentesque libero eget dui elementum scelerisque. Pellentesque tempor arcu in hendrerit molestie. Phasellus euismod nisi in malesuada convallis. Praesent sapien neque, fermentum a laoreet eget, tempus ultricies nulla. Mauris mi tortor, maximus eu risus vitae, bibendum vestibulum leo. Nulla vitae efficitur lectus. Aenean aliquet massa magna. Nullam at dapibus mi. Vivamus massa nibh, venenatis mattis nibh pretium, pretium volutpat leo. Vestibulum eu sem elit. Duis consequat, magna id semper elementum, est nisi pharetra orci, eget molestie diam purus sed sem. Vestibulum est purus, sollicitudin eget lectus ut, molestie aliquam purus. P</p>', '', '', '', '95.00', '75.00', NULL, NULL, NULL, NULL, 0, '2022-03-20', '2024-12-20', 1, 1, 0, 5, 'chinese-night', 'Coon Creek Rd', NULL, 'Armada', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc interdum mauris vitae urna ultrices, et fermentum magna convallis. Nullam quis vulputate magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.', 'Michigan', NULL, NULL, NULL, NULL, 1, '', 0, '42.870074', '-82.92174699999998', 0, '2015-12-19 16:01:35', 0, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 0),
(19, 7, 0, 'Photograpy course', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc interdum mauris vitae urna ultrices, et fermentum magna convallis. Nullam quis vulputate magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nunc scelerisque enim ut magna vulputate feugiat. Suspendisse rutrum lectus et diam congue, sed pretium eros facilisis. Pellentesque pretium lectus orci, non accumsan velit vestibulum a. Fusce orci dui, tincidunt et tortor non, auctor rutrum mauris. Vestibulum sed ultricies enim, at ultrices quam. Quisque pellentesque libero eget dui elementum scelerisque. Pellentesque tempor arcu in hendrerit molestie. Phasellus euismod nisi in malesuada convallis. Praesent sapien neque, fermentum a laoreet eget, tempus ultricies nulla. Mauris mi tortor, maximus eu risus vitae, bibendum vestibulum leo. Nulla vitae efficitur lectus. Aenean aliquet massa magna. Nullam at dapibus mi. Vivamus massa nibh, venenatis mattis nibh pretium, pretium volutpat leo. Vestibulum eu sem elit. Duis consequat, magna id semper elementum, est nisi pharetra orci, eget molestie diam purus sed sem. Vestibulum est purus, sollicitudin eget lectus ut, molestie aliquam purus.</p>', '', '', '', '100.00', '80.00', NULL, NULL, NULL, NULL, 50, '2022-03-20', '2024-12-20', 1, 1, 0, 1, 'photograpy-course', 'Mont Steet', NULL, 'Loretto', ' Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc interdum mauris vitae urna ultrices, et fermentum magna convallis. Nullam quis vulputate magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.', 'Minnesota', NULL, NULL, NULL, NULL, 1, '', 0, '45.11', '-93.67000000000002', 0, '2016-01-19 16:46:55', 0, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 0),
(20, 9, 0, 'Flower bucket', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc interdum mauris vitae urna ultrices, et fermentum magna convallis. Nullam quis vulputate magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Nunc scelerisque enim ut magna vulputate feugiat. Suspendisse rutrum lectus et diam congue, sed pretium eros facilisis. Pellentesque pretium lectus orci, non accumsan velit vestibulum a. Fusce orci dui, tincidunt et tortor non, auctor rutrum mauris. Vestibulum sed ultricies enim, at ultrices quam. Quisque pellentesque libero eget dui elementum scelerisque. Pellentesque tempor arcu in hendrerit molestie. Phasellus euismod nisi in malesuada convallis. Praesent sapien neque, fermentum a laoreet eget, tempus ultricies nulla. Mauris mi tortor, maximus eu risus vitae, bibendum vestibulum leo. Nulla vitae efficitur lectus. Aenean aliquet massa magna. Nullam at dapibus mi. Vivamus massa nibh, venenatis mattis nibh pretium, pretium volutpat leo. Vestibulum eu sem elit. Duis consequat, magna id semper elementum, est nisi pharetra orci, eget molestie diam purus sed sem. Vestibulum est purus, sollicitudin eget lectus ut, molestie aliquam purus.</p>', '', '', '', '55.00', '45.00', NULL, NULL, NULL, NULL, 30, '2022-03-20', '2024-03-20', 1, 1, 0, 7, 'real-estate-offer', 'U.S. 101', NULL, 'Florence', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc interdum mauris vitae urna ultrices, et fermentum magna convallis. Nullam quis vulputate magna. Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos.', 'Oregon', NULL, NULL, NULL, NULL, 1, '', 0, '44.244779', '-124.11095399999999', 1, '2015-03-19 17:02:25', 0, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 0),
(21, 33, 143, 'Roller Coaster', '<p>Donec eleifend purus nulla, non vehicula nisi dictum quis. Maecenas in odio purus. Etiam vulputate nisi eget pharetra tincidunt. Morbi et eros consectetur, ultricies ligula quis, ullamcorper neque. Donec pellentesque felis vel luctus tempus. Curabitur blandit dui purus, non viverra magna consequat vitae. Nunc volutpat malesuada orci vitae varius. Suspendisse accumsan nunc non dictum bibendum. Sed suscipit id ipsum ut tincidunt. Vivamus condimentum diam at condimentum scelerisque. Etiam vulputate pellentesque maximus. Curabitur tincidunt nibh et nisl porttitor, eget ultrices turpis maximus. Fusce molestie elit eget felis cursus volutpat. Nam tincidunt lacus nec massa sagittis, eu dapibus purus bibendum. Ut hendrerit, felis nec congue posuere, lorem urna eleifend est, ac venenatis quam augue a arcu. Nullam sit amet finibus diam. Aenean placerat gravida mi at eleifend. Sed felis nulla, tempus ac vulputate vitae, condimentum vel nunc. Nam egestas, nunc sit amet tempor pellentesque, sapien justo aliquam tortor, at posuere elit purus eget orci. Aliquam hendrerit enim turpis, vitae ultrices libero accumsan nec.</p>', '', '', '', '50.00', '30.00', '0.00', '', '0.00', '', 10, '2022-03-23', '2024-03-23', 1, 1, 0, 5, 'roller-coaster', 'Hopkins Ave', '222', 'Jersey City', 'Donec eleifend purus nulla, non vehicula nisi dictum quis. Maecenas in odio purus. Etiam vulputate nisi eget pharetra tincidunt. Morbi et eros consectetur, ultricies ligula quis, ullamcorper neque. Donec pellentesque felis vel luctus tempus.', 'New Jersey', '', '', NULL, NULL, 1, '', 0, '40.7367335', '-74.05566350000004', 1, '2015-12-22 07:01:16', 0, '00:00:00', '00:00:00', NULL, 121, 1, 0, 0, 0, 0, '99322', 1, 226, '', NULL, '-11:00', 1, NULL, NULL, '', 0),
(22, 8, 143, 'Modern Photo course ', '<p>Duis faucibus odio quis sapien imperdiet, nec congue turpis pellentesque. Integer mi turpis, eleifend et mollis eu, dapibus quis elit. Pellentesque at turpis urna. Sed scelerisque Diam scelerisque fermentum finibus. Mauris elementum euismod erat sed condimentum. Nulla imperdiet mattis massa, at fermentum erat tristique ac. Praesent eget velit maximus, blandit nisi at, porta ligula. Etiam quis libero nisl. Vestibulum quis ornare dui. Suspendisse quis lobortis nunc. Pellentesque quis pharetra metus. Phasellus vulputate orci in pharetra feugiat. Etiam vehicula lacus augue, et lacinia turpis mollis id. Phasellus sed feugiat nunc, sed pharetra risus. Etiam eleifend quis lectus et gravida. Nunc pretium nisi id mi maximus mollis. Aliquam tempus dictum mi. Donec cursus pharetra neque, at gravida dolor vestibulum sit amet. Donec quam urna, molestie pharetra venenatis in, tincidunt quis elit. Praesent pharetra eget metus vitae vestibulum. Mauris gravida turpis lorem, aliquam semper justo auc.</p>', '', '', '', '125.00', '65.00', '0.00', '0', '0.00', '0', 60, '2022-02-01', '2024-02-23', 1, 1, 0, 9, 'modern-photo-course', 'Elizabeth Street', '200', 'Toronto', 'Diam scelerisque fermentum finibus. Mauris elementum euismod erat sed condimentum. Nulla imperdiet mattis massa, at fermentum erat tristique ac. Praesent eget velit maximus, blandit nisi at, porta ligula.', 'Ontario', 'Toronto Division', '', NULL, NULL, 1, '', 0, '43.6590522', '-79.38796100000002', 0, '2018-02-23 03:36:24', 0, '00:00:00', '00:00:00', NULL, 124, 1, NULL, NULL, NULL, 0, 'M5G 2C4', 1, NULL, NULL, NULL, NULL, 1, NULL, NULL, NULL, 0),
(23, 8, 143, 'Photography Basics Course', '<p>Duis faucibus odio quis sapien imperdiet, nec congue turpis pellentesque. Integer mi turpis, eleifend et mollis eu, dapibus quis elit. Pellentesque at turpis urna. Sed scelerisque Diam scelerisque fermentum finibus. Mauris elementum euismod erat sed condimentum. Nulla imperdiet mattis massa, at fermentum erat tristique ac. Praesent eget velit maximus, blandit nisi at, porta ligula. Etiam quis libero nisl. Vestibulum quis ornare dui. Suspendisse quis lobortis nunc. Pellentesque quis pharetra metus. Phasellus vulputate orci in pharetra feugiat. Etiam vehicula lacus augue, et lacinia turpis mollis id. Phasellus sed feugiat nunc, sed pharetra risus. Etiam eleifend quis lectus et gravida. Nunc pretium nisi id mi maximus mollis. Aliquam tempus dictum mi. Donec cursus pharetra neque, at gravida dolor vestibulum sit amet. Donec quam urna, molestie pharetra venenatis in, tincidunt quis elit. Praesent pharetra eget metus vitae vestibulum. Mauris gravida turpis lorem, aliquam semper justo auc.</p>', '', '', '', '180.00', '120.00', '0.00', '0', '0.00', '0', 20, '2022-02-23', '2024-02-23', 1, 1, 0, 20, 'photography-basics-course', 'Lawrence Avenue West', '22', 'Toronto', 'Diam scelerisque fermentum finibus. Mauris elementum euismod erat sed condimentum. Nulla imperdiet mattis massa, at fermentum erat tristique ac. Praesent eget velit maximus, blandit nisi at, porta ligula.', 'Ontario', 'Toronto Division', '', NULL, NULL, 1, '', 0, '43.7112087', '-79.46759759999998', 0, '2018-02-23 03:41:07', 0, '00:00:00', '00:00:00', NULL, 124, 1, 0, 0, 0, 0, '23123123', 1, 226, '', NULL, '-11:00', 1, NULL, NULL, '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_offer_category`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_offer_category`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_offer_category` (
  `offerId` int(11) NOT NULL,
  `categoryId` int(11) NOT NULL,
  PRIMARY KEY (`offerId`,`categoryId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_offer_category`
--

INSERT INTO `#__jbusinessdirectory_company_offer_category` (`offerId`, `categoryId`) VALUES
(3, 93),
(3, 109),
(13, 140),
(14, 115),
(15, 99),
(16, 103),
(17, 147),
(18, 86),
(18, 88),
(19, 115),
(19, 124),
(20, 147),
(21, 121),
(21, 142),
(22, 116),
(22, 124),
(23, 116),
(23, 124);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_offer_coupons`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_offer_coupons`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_offer_coupons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) DEFAULT NULL,
  `offer_id` int(11) DEFAULT NULL,
  `code` varchar(50) DEFAULT NULL,
  `generated_time` datetime DEFAULT NULL,
  `order_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_offer_id` (`offer_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_offer_coupons`
--

INSERT INTO `#__jbusinessdirectory_company_offer_coupons` (`id`, `user_id`, `offer_id`, `code`, `generated_time`, `order_id`) VALUES
(1, 936, 17, 'EGF-0001', '2019-11-29 13:33:23', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_offer_orders`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_offer_orders`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_offer_orders` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `first_name` varchar(45) DEFAULT NULL,
  `last_name` varchar(45) DEFAULT NULL,
  `address` varchar(55) DEFAULT NULL,
  `email` varchar(45) DEFAULT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `postal_code` varchar(45) DEFAULT NULL,
  `city` varchar(45) DEFAULT NULL,
  `region` varchar(45) DEFAULT NULL,
  `amount` decimal(12,2) DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `user_id` int(11) DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `token` varchar(255) DEFAULT NULL,
  `tracking_link` varchar(255) DEFAULT NULL,
  `shipping` decimal(12,2) DEFAULT NULL,
  `initial_amount` decimal(12,2) DEFAULT NULL,
  `shipping_method` int(11) DEFAULT NULL,
  `vat_amount` decimal(12,2) DEFAULT NULL,
  `vat` decimal(12,2) DEFAULT NULL,
  `country_id` int(11) DEFAULT NULL,
  `currency_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_user` (`user_id`),
  KEY `idx_status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_offer_order_products`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_offer_order_products`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_offer_order_products` (
  `order_id` int(11) NOT NULL,
  `offer_id` int(11) NOT NULL,
  `quantity` int(11) DEFAULT NULL,
  `price` decimal(12,2) DEFAULT NULL,
  `currencyId` int(11) NOT NULL,
  `combination_ids` varchar(255) DEFAULT NULL,
  `combination_values` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`order_id`,`offer_id`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_offer_pictures`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_offer_pictures`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_offer_pictures` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `offerId` int(10) NOT NULL DEFAULT '0',
  `picture_info` varchar(255) DEFAULT NULL,
  `picture_path` varchar(255) DEFAULT NULL,
  `picture_enable` tinyint(1) NOT NULL DEFAULT '1',
  `picture_title` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_offer` (`offerId`),
  KEY `idx_status` (`picture_enable`)
) ENGINE=MyISAM AUTO_INCREMENT=246 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_offer_pictures`
--

INSERT INTO `#__jbusinessdirectory_company_offer_pictures` (`id`, `offerId`, `picture_info`, `picture_path`, `picture_enable`, `picture_title`) VALUES
(187, 19, '', '/offers/19/image4.jpg', 1, ''),
(188, 19, '', '/offers/19/image8.jpg', 1, ''),
(189, 19, '', '/offers/19/image12.jpg', 1, ''),
(150, 15, '', '/offers/15/image4.jpg', 1, ''),
(154, 14, '', '/offers/14/image2.jpg', 1, ''),
(155, 14, '', '/offers/14/image5.jpg', 1, ''),
(153, 14, '', '/offers/14/image8.jpg', 1, ''),
(145, 18, '', '/offers/18/image3.jpg', 1, ''),
(183, 3, '', '/offers/3/image2.jpg', 1, ''),
(144, 18, '', '/offers/18/image1.jpg', 1, ''),
(186, 19, '', '/offers/19/image9.jpg', 1, ''),
(185, 13, '', '/offers/13/image1.png', 1, ''),
(184, 13, '', '/offers/13/image4.jpg', 1, ''),
(143, 18, '', '/offers/18/image2.jpg', 1, ''),
(152, 15, '', '/offers/15/image5.jpg', 1, ''),
(149, 16, '', '/offers/16/image1.jpg', 1, ''),
(151, 15, '', '/offers/15/image6.jpg', 1, ''),
(174, 17, '', '/offers/17/image8.jpg', 1, ''),
(173, 17, '', '/offers/17/image1.jpg', 1, ''),
(172, 17, '', '/offers/17/image4.jpg', 1, ''),
(138, 20, '', '/offers/20/image1.jpg', 1, ''),
(136, 20, '', '/offers/20/image9.jpg', 1, ''),
(137, 20, '', '/offers/20/iamge10.jpg', 1, ''),
(243, 23, '', '/offers/23/stockphoto102338735.jpg', 1, ''),
(240, 22, '', '/offers/22/image11.jpg', 1, ''),
(239, 22, '', '/offers/22/image5.jpg', 1, ''),
(238, 22, '', '/offers/22/blogimage4.jpg', 1, ''),
(241, 21, '', '/offers/21/image14.jpg', 1, ''),
(242, 21, '', '/offers/21/image1.jpg', 1, ''),
(244, 23, '', '/offers/23/blogimage7.jpg', 1, ''),
(245, 23, '', '/offers/23/womensbanner.jpg', 1, '');

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_offer_types`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_offer_types`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_offer_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `ordering` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_pictures`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_pictures`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_pictures` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `companyId` int(10) NOT NULL DEFAULT '0',
  `picture_info` varchar(255) DEFAULT NULL,
  `picture_path` varchar(255) DEFAULT NULL,
  `picture_enable` tinyint(1) NOT NULL DEFAULT '1',
  `picture_title` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_companyId` (`companyId`),
  KEY `idx_picture_enable` (`picture_enable`)
) ENGINE=MyISAM AUTO_INCREMENT=1058 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_pictures`
--

INSERT INTO `#__jbusinessdirectory_company_pictures` (`id`, `companyId`, `picture_info`, `picture_path`, `picture_enable`, `picture_title`) VALUES
(1009, 1, '', '/companies/1/image2-1426883853.jpg', 1, ''),
(1000, 7, '', '/companies/7/image11.jpg', 1, ''),
(1008, 1, '', '/companies/1/image1-1426883851.jpg', 1, ''),
(1029, 8, '', '/companies/8/image8.jpg', 1, ''),
(692, 30, '', '/companies/30/image1.jpg', 1, ''),
(704, 29, '', '/companies/29/15413.jpg', 1, ''),
(703, 29, '', '/companies/29/image2.jpg', 1, ''),
(702, 29, '', '/companies/29/image3.jpg', 1, ''),
(782, 9, '', '/companies/9/image7.jpeg', 1, ''),
(999, 7, '', '/companies/7/image6.jpg', 1, ''),
(701, 29, '', '/companies/29/image1.jpg', 1, ''),
(691, 30, '', '/companies/30/image6.jpg', 1, ''),
(690, 30, '', '/companies/30/image11.jpg', 1, ''),
(689, 30, '', '/companies/30/image7.jpg', 1, ''),
(723, 12, '', '/companies/12/image2.jpg', 1, ''),
(722, 12, '', '/companies/12/iamge4.jpg', 1, ''),
(721, 12, '', '/companies/12/image1.jpg', 1, ''),
(720, 12, '', '/companies/12/iamge3.jpg', 1, ''),
(851, 4, '', '/companies/4/image3.jpg', 1, ''),
(850, 4, '', '/companies/4/iamge5.jpg', 1, ''),
(849, 4, '', '/companies/4/image4.jpg', 1, ''),
(806, 5, '', '/companies/5/iamge3.jpg', 1, ''),
(805, 5, '', '/companies/5/iamge2.jpg', 1, ''),
(804, 5, '', '/companies/5/image4.jpg', 1, ''),
(848, 4, '', '/companies/4/image1.jpg', 1, ''),
(847, 4, '', '/companies/4/image2.jpg', 1, ''),
(781, 9, '', '/companies/9/image1.jpg', 1, ''),
(780, 9, '', '/companies/9/image9.jpg', 1, ''),
(779, 9, '', '/companies/9/image2.jpg', 1, ''),
(778, 9, '', '/companies/9/iamge10.jpg', 1, ''),
(1028, 8, '', '/companies/8/image7.jpg', 1, ''),
(1027, 8, '', '/companies/8/image2.jpg', 1, ''),
(1026, 8, '', '/companies/8/image1.jpg', 1, ''),
(1011, 1, '', '/companies/1/image4-1426883859.jpg', 1, ''),
(1010, 1, '', '/companies/1/image3-1426883856.jpg', 1, ''),
(995, 31, '', '/companies/31/image3-1426883370.jpg', 1, ''),
(994, 31, '', '/companies/31/image1-1426883363.jpg', 1, ''),
(688, 30, '', '/companies/30/image5.jpg', 1, ''),
(993, 31, '', '/companies/31/image9.jpg', 1, ''),
(682, 32, '', '/companies/32/image4.jpg', 1, ''),
(681, 32, '', '/companies/32/image6.jpg', 1, ''),
(680, 32, '', '/companies/32/image2.jpg', 1, ''),
(679, 32, '', '/companies/32/image1.jpg', 1, ''),
(678, 32, '', '/companies/32/image5.jpg', 1, ''),
(677, 32, '', '/companies/32/image7.jpg', 1, ''),
(998, 7, '', '/companies/7/image2.jpg', 1, ''),
(997, 7, '', '/companies/7/iamge5.jpg', 1, ''),
(996, 7, '', '/companies/7/image8.jpg', 1, ''),
(1007, 1, '', '/companies/1/image5-1426883862.jpg', 1, ''),
(1001, 7, '', '/companies/7/image4.jpg', 1, ''),
(1025, 8, '', '/companies/8/image5.jpg', 1, ''),
(1024, 8, '', '/companies/8/image11.jpg', 1, ''),
(1057, 33, '', '/companies/33/image4.jpg', 1, ''),
(1056, 33, '', '/companies/33/image3.jpg', 1, ''),
(1055, 33, '', '/companies/33/image2.jpg', 1, ''),
(1054, 33, '', '/companies/33/image1.jpg', 1, '');

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_pictures_extra`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_pictures_extra`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_pictures_extra` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `companyId` int(10) NOT NULL DEFAULT '0',
  `image_info` varchar(255) DEFAULT NULL,
  `image_path` varchar(255) DEFAULT NULL,
  `image_enable` tinyint(1) NOT NULL DEFAULT '1',
  `image_title` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_companyId` (`companyId`),
  KEY `idx_image_enable` (`image_enable`)
) ENGINE=MyISAM AUTO_INCREMENT=1030 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_product_merchants`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_product_merchants`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_product_merchants` (
  `product_id` int(11) NOT NULL,
  `company_id` int(11) NOT NULL,
  PRIMARY KEY (`product_id`,`company_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_projects`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_projects`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_projects` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `company_id` int(11) NOT NULL,
  `description` text,
  `status` tinyint(4) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_companyId` (`company_id`),
  KEY `idx_status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_projects`
--

INSERT INTO `#__jbusinessdirectory_company_projects` (`id`, `name`, `company_id`, `description`, `status`) VALUES
(1, 'Landscapes', 8, 'Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Morbi dignissim tristique sapien ut pretium.', 1),
(2, 'Birds', 8, 'Donec massa augue, lobortis eu cursus in, tincidunt ut nunc. Proin pellentesque, lorem porttitor commodo hendrerit, enim leo mattis risus, ac viverra ante tellus quis velit. ', 1),
(3, 'Portrait', 8, 'Class aptent taciti sociosqu ad litora torquent per conubia nostra, per inceptos himenaeos. Morbi dignissim tristique sapien ut pretium.', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_projects_pictures`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_projects_pictures`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_projects_pictures` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `projectId` int(11) NOT NULL DEFAULT '0',
  `picture_info` varchar(255) DEFAULT NULL,
  `picture_path` varchar(255) DEFAULT NULL,
  `picture_enable` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_projectId` (`projectId`),
  KEY `idx_status` (`picture_enable`)
) ENGINE=MyISAM AUTO_INCREMENT=78 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_projects_pictures`
--

INSERT INTO `#__jbusinessdirectory_company_projects_pictures` (`id`, `projectId`, `picture_info`, `picture_path`, `picture_enable`) VALUES
(68, 2, '', '/project/2/birds_3.jpg', 1),
(67, 2, '', '/project/2/birds_2.jpg', 1),
(66, 2, '', '/project/2/birds_1.jpg', 1),
(70, 1, '', '/project/1/landscape_2.jpg', 1),
(69, 1, '', '/project/1/landscape_3.jpg', 1),
(71, 1, '', '/project/1/landscape_1.jpg', 1),
(75, 3, '', '/project/3/portrait_1.jpg', 1),
(76, 3, '', '/project/3/portrait_3.jpg', 1),
(77, 3, '', '/project/3/portrait_2.jpg', 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_providers`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_providers`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_providers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `description` text,
  `email` varchar(45) DEFAULT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `max_clients` int(11) DEFAULT NULL,
  `availability` varchar(255) DEFAULT NULL,
  `published` tinyint(4) NOT NULL DEFAULT '1',
  `company_id` int(11) NOT NULL,
  `image` varchar(255) DEFAULT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `istart_date` date DEFAULT NULL,
  `iend_date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_company_id` (`company_id`),
  KEY `idx_published` (`published`),
  KEY `idx_availability` (`availability`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_providers`
--

INSERT INTO `#__jbusinessdirectory_company_providers` (`id`, `name`, `description`, `email`, `phone`, `max_clients`, `availability`, `published`, `company_id`, `image`, `type`, `istart_date`, `iend_date`) VALUES
(1, 'John Alister', '', 'john@alister.com', '(999)7723-321', 10, ',', 1, 8, '/service_providers/cropped-1620646520.jpeg', 1, '0000-00-00', '0000-00-00'),
(2, 'Anne Smith', '', 'anne@smith.com', '(999)7723-321', 10, ',', 1, 8, '/service_providers/cropped-1620646504.jpeg', 1, '0000-00-00', '0000-00-00'),
(3, 'Max Glonn', '', 'max@glonn.com', '(999)7723-321', 10, ',', 1, 8, '/service_providers/cropped-1620646484.jpeg', 1, '0000-00-00', '0000-00-00');

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_provider_hours`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_provider_hours`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_provider_hours` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `weekday` tinyint(1) DEFAULT NULL,
  `start_hour` time DEFAULT NULL,
  `end_hour` time DEFAULT NULL,
  `type` tinyint(1) DEFAULT NULL,
  `status` tinyint(1) DEFAULT '1',
  `item_type` tinyint(1) DEFAULT '0',
  `provider_id` int(11) NOT NULL,
  `date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_provider_id` (`provider_id`),
  KEY `idx_item_type` (`item_type`),
  KEY `idx_type` (`type`),
  KEY `idx_status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=71 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_provider_hours`
--

INSERT INTO `#__jbusinessdirectory_company_provider_hours` (`id`, `weekday`, `start_hour`, `end_hour`, `type`, `status`, `item_type`, `provider_id`, `date`) VALUES
(1, 1, '08:00:00', '20:00:00', 0, 1, 1, 8, NULL),
(2, 2, '08:00:00', '20:00:00', 0, 1, 1, 8, NULL),
(3, 3, '08:00:00', '20:00:00', 0, 1, 1, 8, NULL),
(4, 4, '08:00:00', '20:00:00', 0, 1, 1, 8, NULL),
(5, 5, '08:00:00', '20:00:00', 0, 1, 1, 8, NULL),
(6, 6, '08:00:00', '17:00:00', 0, 1, 1, 8, NULL),
(7, 7, '00:00:00', '00:00:00', 0, 0, 1, 8, NULL),
(15, 1, '10:00:00', '17:00:00', 0, 1, 1, 32, NULL),
(16, 2, '10:00:00', '17:00:00', 0, 1, 1, 32, NULL),
(17, 3, '10:00:00', '17:00:00', 0, 1, 1, 32, NULL),
(18, 4, '10:00:00', '17:00:00', 0, 1, 1, 32, NULL),
(19, 5, '10:00:00', '17:00:00', 0, 1, 1, 32, NULL),
(20, 6, '10:00:00', '13:00:00', 0, 1, 1, 32, NULL),
(21, 7, '00:00:00', '00:00:00', 0, 0, 1, 32, NULL),
(22, 1, '06:00:00', '08:30:00', 0, 1, 1, 7, NULL),
(23, 2, '24:00:00', '24:00:00', 0, 0, 1, 7, NULL),
(24, 3, '24:00:00', '24:00:00', 0, 0, 1, 7, NULL),
(25, 4, '07:00:00', '21:30:00', 0, 1, 1, 7, NULL),
(26, 5, '06:00:00', '22:00:00', 0, 1, 1, 7, NULL),
(27, 6, '24:00:00', '24:00:00', 0, 0, 1, 7, NULL),
(28, 7, '24:00:00', '24:00:00', 0, 0, 1, 7, NULL),
(29, 1, '10:00:00', '17:00:00', 0, 1, 1, 5, NULL),
(30, 2, '10:00:00', '17:00:00', 0, 1, 1, 5, NULL),
(31, 3, '10:00:00', '17:00:00', 0, 1, 1, 5, NULL),
(32, 4, '10:00:00', '17:00:00', 0, 1, 1, 5, NULL),
(33, 5, '10:00:00', '17:00:00', 0, 1, 1, 5, NULL),
(34, 6, '10:00:00', '17:00:00', 0, 1, 1, 5, NULL),
(35, 7, '00:00:00', '00:00:00', 0, 1, 1, 5, NULL),
(36, 1, '06:30:00', '07:00:00', 0, 1, 1, 35, NULL),
(37, 2, '00:00:00', '00:00:00', 0, 0, 1, 35, NULL),
(38, 3, '00:00:00', '00:00:00', 0, 0, 1, 35, NULL),
(39, 4, '00:00:00', '00:00:00', 0, 0, 1, 35, NULL),
(40, 5, '00:00:00', '00:00:00', 0, 0, 1, 35, NULL),
(41, 6, '00:00:00', '00:00:00', 0, 0, 1, 35, NULL),
(42, 7, '00:00:00', '00:00:00', 0, 0, 1, 35, NULL),
(43, 1, '06:00:00', '07:30:00', 0, 1, 1, 37, NULL),
(44, 2, '00:00:00', '00:00:00', 0, 0, 1, 37, NULL),
(45, 3, '00:00:00', '00:00:00', 0, 0, 1, 37, NULL),
(46, 4, '00:00:00', '00:00:00', 0, 0, 1, 37, NULL),
(47, 5, '00:00:00', '00:00:00', 0, 0, 1, 37, NULL),
(48, 6, '00:00:00', '00:00:00', 0, 0, 1, 37, NULL),
(49, 7, '00:00:00', '00:00:00', 0, 0, 1, 37, NULL),
(50, 1, '08:00:00', '20:00:00', 0, 1, 0, 1, NULL),
(51, 2, '08:00:00', '20:00:00', 0, 1, 0, 1, NULL),
(52, 3, '08:00:00', '20:00:00', 0, 1, 0, 1, NULL),
(53, 4, '08:00:00', '20:00:00', 0, 1, 0, 1, NULL),
(54, 5, '08:00:00', '20:00:00', 0, 1, 0, 1, NULL),
(55, 6, '08:00:00', '12:00:00', 0, 1, 0, 1, NULL),
(56, 7, '12:00:00', '12:00:00', 0, 0, 0, 1, NULL),
(57, 1, '08:00:00', '17:00:00', 0, 1, 0, 2, NULL),
(58, 2, '08:00:00', '17:00:00', 0, 1, 0, 2, NULL),
(59, 3, '08:00:00', '17:00:00', 0, 1, 0, 2, NULL),
(60, 4, '08:00:00', '17:00:00', 0, 1, 0, 2, NULL),
(61, 5, '08:00:00', '17:00:00', 0, 1, 0, 2, NULL),
(62, 6, '08:00:00', '14:00:00', 0, 1, 0, 2, NULL),
(63, 7, '12:00:00', '12:00:00', 0, 0, 0, 2, NULL),
(64, 1, '08:00:00', '18:00:00', 0, 1, 0, 3, NULL),
(65, 2, '08:00:00', '18:00:00', 0, 1, 0, 3, NULL),
(66, 3, '08:00:00', '18:00:00', 0, 1, 0, 3, NULL),
(67, 4, '08:00:00', '18:00:00', 0, 1, 0, 3, NULL),
(68, 5, '08:00:00', '18:00:00', 0, 1, 0, 3, NULL),
(69, 6, '08:00:00', '13:00:00', 0, 1, 0, 3, NULL),
(70, 7, '12:00:00', '12:00:00', 0, 0, 0, 3, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_provider_services`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_provider_services`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_provider_services` (
  `provider_id` int(11) NOT NULL,
  `service_id` int(11) NOT NULL,
  PRIMARY KEY (`provider_id`,`service_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_provider_services`
--

INSERT INTO `#__jbusinessdirectory_company_provider_services` (`provider_id`, `service_id`) VALUES
(1, 1),
(1, 2),
(1, 3),
(2, 1),
(2, 2),
(2, 3),
(3, 1),
(3, 2),
(3, 3);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_ratings`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_ratings`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_ratings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `companyId` int(11) NOT NULL,
  `rating` decimal(2,1) NOT NULL DEFAULT '0.0',
  `ipAddress` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_company` (`companyId`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_ratings`
--

INSERT INTO `#__jbusinessdirectory_company_ratings` (`id`, `companyId`, `rating`, `ipAddress`) VALUES
(1, 8, '4.0', '5.15.238.52'),
(2, 12, '4.0', '5.15.238.52'),
(3, 5, '3.0', '5.15.238.52'),
(4, 4, '5.0', '5.15.238.52'),
(5, 1, '3.0', '5.15.238.52'),
(6, 7, '3.5', '5.15.238.52'),
(7, 9, '1.5', '5.15.238.52'),
(8, 8, '5.0', '127.0.0.1'),
(9, 1, '5.0', '127.0.0.1'),
(10, 7, '5.0', '127.0.0.1');

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_registered`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_registered`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_registered` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `joined_company_id` int(11) NOT NULL,
  `approved` tinyint(2) NOT NULL DEFAULT '0',
  `user_id` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_company` (`company_id`),
  KEY `idx_join_company` (`joined_company_id`),
  KEY `idx_user` (`user_id`),
  KEY `idx_approved` (`approved`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_related`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_related`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_related` (
  `company_id` int(11) NOT NULL,
  `related_company_id` int(11) NOT NULL,
  PRIMARY KEY (`company_id`,`related_company_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_related`
--

INSERT INTO `#__jbusinessdirectory_company_related` (`company_id`, `related_company_id`) VALUES
(8, 1),
(8, 7),
(8, 32);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_requests`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_requests`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_requests` (
  `company_id` int(11) NOT NULL,
  `quote_id` int(11) NOT NULL,
  `status` tinyint(1) DEFAULT '0',
  PRIMARY KEY (`company_id`,`quote_id`),
  KEY `idx_company_quote` (`company_id`,`quote_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_reviews`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_reviews`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_reviews` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `subject` varchar(255) DEFAULT NULL,
  `description` text,
  `userId` int(11) NOT NULL,
  `email` varchar(55) DEFAULT NULL,
  `likeCount` smallint(6) DEFAULT '0',
  `dislikeCount` smallint(6) DEFAULT '0',
  `loveCount` smallint(6) DEFAULT '0',
  `state` tinyint(4) NOT NULL DEFAULT '1',
  `itemId` int(11) NOT NULL,
  `creationDate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `aproved` tinyint(1) NOT NULL DEFAULT '0',
  `ipAddress` varchar(45) DEFAULT NULL,
  `abuseReported` tinyint(1) NOT NULL DEFAULT '0',
  `rating` decimal(2,1) NOT NULL DEFAULT '0.0',
  `approved` tinyint(1) NOT NULL DEFAULT '0',
  `review_type` tinyint(1) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_userId` (`userId`),
  KEY `idx_aproved` (`aproved`),
  KEY `idx_approved` (`approved`),
  KEY `idx_review_type` (`review_type`),
  KEY `idx_item_id` (`itemId`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_reviews`
--

INSERT INTO `#__jbusinessdirectory_company_reviews` (`id`, `name`, `subject`, `description`, `userId`, `email`, `likeCount`, `dislikeCount`, `loveCount`, `state`, `itemId`, `creationDate`, `aproved`, `ipAddress`, `abuseReported`, `rating`, `approved`, `review_type`) VALUES
(8, 'Kelly', 'The best experience ever', 'Ut scelerisque eget mi eget porttitor. Nunc risus enim, volutpat et tempor eu, pretium et est. Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam turpis nisl, laoreet varius mauris ac, porta pulvinar felis. Vestibulum placerat, velit eleifend facilisis cursus, turpis nisl ullamcorper eros, eu tristique est nisl a dui. Vestibulum elementum diam sed iaculis porttitor.', 439, NULL, 0, 0, 0, 1, 12, '2015-03-24 03:03:37', 0, '127.0.0.1', 0, '4.2', 2, 1),
(9, 'Sam', 'A happy customer', 'Sed non risus erat. Cras ac dapibus augue. Pellentesque non purus at massa viverra tempus vel vestibulum elit. Quisque in libero in diam consectetur convallis at sed dolor. Nunc finibus arcu sed maximus lacinia. Vestibulum et eleifend lectus, ut laoreet elit. ', 439, NULL, 0, 0, 0, 1, 12, '2015-03-24 03:09:42', 0, '127.0.0.1', 0, '4.7', 2, 1),
(4, 'Loren Jonson', 'Love the products', 'I had such a good experience on this store.', 0, NULL, 0, 0, 0, 1, 9, '2015-03-20 08:09:48', 0, '127.0.0.1', 0, '5.0', 2, 1),
(5, 'John', 'This is what I was looking for', 'Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Cras interdum ut ante non porta. Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien.', 439, NULL, 0, 0, 0, 1, 8, '2015-03-24 01:59:05', 0, '127.0.0.1', 0, '5.0', 2, 1),
(6, 'Michael', 'Greate store', 'Praesent id leo ex. Donec condimentum tincidunt metus at auctor. Nulla facilisis orci vitae ipsum volutpat pharetra. Proin eleifend lobortis nunc, in fringilla justo. Ut sollicitudin lacinia ex eget dapibus. Cras pharetra diam eu malesuada sagittis. Mauris eget ligula gravida, imperdiet ligula a, dictum ex. ', 439, NULL, 0, 0, 0, 1, 29, '2015-03-24 02:49:41', 0, '127.0.0.1', 0, '4.3', 2, 1),
(7, 'Kevin', 'The best experience ever', 'Pellentesque convallis est vel velit luctus, in consequat tortor rutrum. In lectus quam, tempor eu diam efficitur, fringilla aliquet sapien. Praesent quis tellus id enim imperdiet tempor. Vestibulum ante ipsum primis in faucibus orci luctus et ultrices posuere cubilia Curae; Cras interdum ut ante non porta. ', 439, NULL, 0, 0, 0, 1, 8, '2015-03-24 02:58:42', 0, '127.0.0.1', 0, '4.8', 2, 1),
(10, 'John', 'Great food, great service', 'Maecenas convallis malesuada iaculis. Nullam non maximus velit, id molestie est. Pellentesque lobortis sodales tortor. Proin non sollicitudin felis, aliquam ornare massa. Fusce vel turpis est. Nam tempus turpis at orci rutrum tincidunt quis ac odio. Maecenas nec molestie arcu. Suspendisse potenti. Donec gravida diam urna, rutrum malesuada nisi tempor in. Vivamus vel ligula sed ante mattis venenatis. Cras ultricies ornare elit nec blandit. Morbi convallis tellus laoreet, egestas sapien non, condimentum ante. Donec egestas scelerisque est ut aliquam. Nam vulputate felis eu massa imperdiet facilisis. Interdum et malesuada fames ac ante ipsum primis in faucibus. ', 439, NULL, 0, 0, 0, 1, 31, '2015-03-24 06:16:10', 0, '127.0.0.1', 0, '3.8', 2, 1),
(11, 'John McColin', 'Great experience', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Eu tincidunt tortor aliquam nulla facilisi. Urna nunc id cursus metus. Integer eget aliquet nibh praesent tristique magna sit. Sed euismod nisi porta lorem. ', 0, 'john@gmail.com', 0, 0, 0, 1, 8, '2018-02-26 02:14:32', 0, '::1', 0, '5.0', 2, 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_reviews_criteria`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_reviews_criteria`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_reviews_criteria` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(77) DEFAULT NULL,
  `ordering` tinyint(4) NOT NULL DEFAULT '0',
  `published` tinyint(4) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_published` (`published`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_reviews_criteria`
--

INSERT INTO `#__jbusinessdirectory_company_reviews_criteria` (`id`, `name`, `ordering`, `published`) VALUES
(1, 'Service', 1, NULL),
(2, 'Quality', 2, NULL),
(3, 'Staff', 3, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_reviews_criteria_category`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_reviews_criteria_category`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_reviews_criteria_category` (
  `criteriaId` int(11) NOT NULL,
  `categoryId` int(11) NOT NULL,
  PRIMARY KEY (`criteriaId`,`categoryId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_reviews_criteria_category`
--

INSERT INTO `#__jbusinessdirectory_company_reviews_criteria_category` (`criteriaId`, `categoryId`) VALUES
(1, -1),
(2, -1),
(3, -1);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_reviews_question`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_reviews_question`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_reviews_question` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `type` int(11) DEFAULT NULL,
  `ordering` tinyint(4) NOT NULL DEFAULT '0',
  `published` tinyint(4) NOT NULL DEFAULT '1',
  `is_mandatory` int(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_published` (`published`),
  KEY `idx_type` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_reviews_question_answer`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_reviews_question_answer`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_reviews_question_answer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `review_id` int(11) DEFAULT NULL,
  `question_id` int(11) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `answer` varchar(455) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_review_id` (`review_id`),
  KEY `idx_question_id` (`question_id`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_reviews_user_criteria`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_reviews_user_criteria`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_reviews_user_criteria` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `review_id` int(11) DEFAULT NULL,
  `criteria_id` int(11) DEFAULT NULL,
  `score` decimal(2,1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_review_id` (`review_id`),
  KEY `idx_criteria_id` (`criteria_id`)
) ENGINE=MyISAM AUTO_INCREMENT=52 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_reviews_user_criteria`
--

INSERT INTO `#__jbusinessdirectory_company_reviews_user_criteria` (`id`, `review_id`, `criteria_id`, `score`) VALUES
(28, 3, 1, '5.0'),
(29, 3, 2, '4.0'),
(30, 3, 3, '5.0'),
(31, 4, 1, '5.0'),
(32, 4, 2, '5.0'),
(33, 4, 3, '5.0'),
(34, 5, 1, '5.0'),
(35, 5, 2, '5.0'),
(36, 5, 3, '5.0'),
(37, 6, 1, '4.0'),
(38, 6, 2, '4.0'),
(39, 6, 3, '5.0'),
(40, 7, 1, '5.0'),
(41, 7, 2, '5.0'),
(42, 7, 3, '5.0'),
(43, 8, 1, '4.0'),
(44, 8, 2, '5.0'),
(45, 8, 3, '4.0'),
(46, 9, 1, '5.0'),
(47, 9, 2, '5.0'),
(48, 9, 3, '5.0'),
(49, 10, 1, '4.0'),
(50, 10, 2, '4.0'),
(51, 10, 3, '4.0');

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_review_abuses`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_review_abuses`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_review_abuses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reviewId` int(11) NOT NULL,
  `email` varchar(45) DEFAULT NULL,
  `description` text,
  `state` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_reviewId` (`reviewId`),
  KEY `idx_state` (`state`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_review_responses`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_review_responses`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_review_responses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `state` tinyint(4) NOT NULL DEFAULT '0',
  `reviewId` int(11) NOT NULL,
  `firstName` varchar(45) DEFAULT NULL,
  `lastName` varchar(45) DEFAULT NULL,
  `response` text,
  `email` varchar(45) DEFAULT NULL,
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_review` (`reviewId`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_services`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_services`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_services` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `description` text,
  `duration` int(11) DEFAULT NULL,
  `show_duration` tinyint(1) NOT NULL DEFAULT '0',
  `price` decimal(12,2) DEFAULT NULL,
  `currency_id` int(10) NOT NULL,
  `max_booking` int(11) DEFAULT NULL,
  `published` tinyint(4) NOT NULL DEFAULT '1',
  `company_id` int(11) NOT NULL,
  `attendance_mode` tinyint(1) DEFAULT NULL,
  `type` tinyint(1) NOT NULL DEFAULT '1',
  `istart_date` date DEFAULT NULL,
  `iend_date` date DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_published` (`published`),
  KEY `idx_show_duration` (`show_duration`),
  KEY `idx_company_id` (`company_id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_services`
--

INSERT INTO `#__jbusinessdirectory_company_services` (`id`, `name`, `description`, `duration`, `show_duration`, `price`, `currency_id`, `max_booking`, `published`, `company_id`, `attendance_mode`, `type`, `istart_date`, `iend_date`) VALUES
(1, 'Photography course', '', 60, 1, '20.00', 143, 10, 1, 8, NULL, 1, NULL, NULL),
(2, 'Photo Session', '', 120, 1, '70.00', 143, 2, 1, 8, NULL, 1, NULL, NULL),
(3, 'Nature photography', '', 180, 1, '120.00', 143, 15, 1, 8, NULL, 1, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_services_list`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_services_list`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_services_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `companyId` int(11) NOT NULL,
  `service_section` varchar(100) DEFAULT NULL,
  `service_name` varchar(100) DEFAULT NULL,
  `service_description` text,
  `service_price` decimal(12,2) DEFAULT NULL,
  `service_image` varchar(250) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_companyId` (`companyId`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_services_list`
--

INSERT INTO `#__jbusinessdirectory_company_services_list` (`id`, `companyId`, `service_section`, `service_name`, `service_description`, `service_price`, `service_image`) VALUES
(1, 31, '', 'Chinese Noodels', 'Vivamus condimentum diam at condimentum scelerisque.', '10.00', '/pricelist/31/cropped-1620634013.jpeg'),
(2, 31, '', 'Steak', 'Quisque pellentesque libero eget dui elementum scelerisque. ', '30.00', '/pricelist/31/cropped-1620634032.jpeg'),
(3, 31, '', 'Soup', 'Praesent sapien neque, fermentum a laoreet eget, tempus ultricies nulla. ', '10.00', '/pricelist/31/cropped-1620634040.jpeg'),
(4, 31, '', 'Desert', 'Fraesent sapien neque, a laoreet eget, tempus ultricies nulla. ', '12.00', '/pricelist/31/cropped-1620634053.jpeg');

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_service_bookings`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_service_bookings`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_service_bookings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `service_id` int(11) NOT NULL,
  `provider_id` int(11) NOT NULL,
  `date` date DEFAULT NULL,
  `time` time DEFAULT NULL,
  `first_name` varchar(45) DEFAULT NULL,
  `last_name` varchar(45) DEFAULT NULL,
  `address` varchar(55) DEFAULT NULL,
  `email` varchar(45) DEFAULT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `postal_code` varchar(45) DEFAULT NULL,
  `city` varchar(45) DEFAULT NULL,
  `region` varchar(45) DEFAULT NULL,
  `amount` decimal(12,2) DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `paid_at` datetime DEFAULT NULL,
  `status` tinyint(4) DEFAULT NULL,
  `user_id` int(11) DEFAULT NULL,
  `url` varchar(245) DEFAULT NULL,
  `country_id` int(11) DEFAULT NULL,
  `currency_id` int(11) DEFAULT NULL,
  `initial_amount` decimal(12,2) DEFAULT NULL,
  `vat_amount` decimal(12,2) DEFAULT NULL,
  `vat` decimal(12,2) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_service_id` (`service_id`),
  KEY `idx_provider_id` (`provider_id`),
  KEY `idx_status` (`status`),
  KEY `idx_user_id` (`user_id`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_service_bookings`
--

INSERT INTO `#__jbusinessdirectory_company_service_bookings` (`id`, `service_id`, `provider_id`, `date`, `time`, `first_name`, `last_name`, `address`, `email`, `phone`, `postal_code`, `city`, `region`, `amount`, `created`, `paid_at`, `status`, `user_id`, `url`, `country_id`, `currency_id`, `initial_amount`, `vat_amount`, `vat`) VALUES
(28, 3, 1, '2019-12-30', '08:00:00', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2020-01-03 08:09:31', NULL, NULL, 0, NULL, NULL, NULL, NULL, NULL, NULL);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_sounds`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_sounds`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_sounds` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) DEFAULT NULL,
  `url` varchar(450) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_company_id` (`company_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_testimonials`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_testimonials`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_testimonials` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `companyId` int(11) NOT NULL,
  `testimonial_title` varchar(50) DEFAULT NULL,
  `testimonial_name` varchar(50) DEFAULT NULL,
  `testimonial_description` varchar(450) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_companyId` (`companyId`)
) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_testimonials`
--

INSERT INTO `#__jbusinessdirectory_company_testimonials` (`id`, `companyId`, `testimonial_title`, `testimonial_name`, `testimonial_description`) VALUES
(6, 8, 'Great experience', 'John Doe', 'Quisque cursus nunc ut diam pulvinar luctus. Nulla facilisi. Donec porta lorem id diam malesuada nec pretium enim euismod. Donec massa augue, lobortis eu cursus in, tincidunt ut nunc.'),
(7, 33, '', '', ''),
(8, 32, '', '', ''),
(9, 8, 'Wonderfull services', 'Clara ', 'Donec massa augue, lobortis eu cursus in, tincidunt ut nunc. Quisque cursus nunc ut diam pulvinar luctus. Nulla facilisi. Donec porta lorem id diam malesuada nec pretium enim euismod. '),
(10, 7, '', '', ''),
(11, 30, '', '', ''),
(12, 29, '', '', ''),
(13, 12, '', '', ''),
(22, 9, '', '', ''),
(25, 5, '', '', ''),
(26, 4, '', '', ''),
(32, 1, '', '', ''),
(34, 31, '', '', '');

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_types`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_types`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) DEFAULT NULL,
  `ordering` tinyint(4) NOT NULL DEFAULT '0',
  `only_for_admin` tinyint(1) NOT NULL DEFAULT '0',
  `company_view` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_only_for_admin` (`only_for_admin`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_types`
--

INSERT INTO `#__jbusinessdirectory_company_types` (`id`, `name`, `ordering`, `only_for_admin`, `company_view`) VALUES
(1, 'Manufacturer/producer', 1, 0, 0),
(2, 'Distributor ', 2, 0, 0),
(4, 'Wholesaler ', 3, 0, 0),
(5, 'Retailer', 4, 0, 0),
(6, 'Service Provider', 5, 0, 0),
(7, 'Subcontractor', 6, 0, 0),
(8, 'Agent/Representative', 7, 0, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_videos`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_videos`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_videos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `companyId` int(11) DEFAULT NULL,
  `url` varchar(245) DEFAULT NULL,
  `title` varchar(245) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_companyId` (`companyId`)
) ENGINE=MyISAM AUTO_INCREMENT=126 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_company_videos`
--

INSERT INTO `#__jbusinessdirectory_company_videos` (`id`, `companyId`, `url`, `title`) VALUES
(65, 8, 'https://youtu.be/oO7Bh3q-Xm4', NULL),
(64, 8, 'https://youtu.be/jAk_xhs0Rcw', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_company_zipcodes`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_company_zipcodes`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_company_zipcodes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `company_id` int(11) NOT NULL,
  `zip_code` varchar(10) DEFAULT NULL,
  `latitude` varchar(45) DEFAULT NULL,
  `longitude` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `company_id` (`company_id`),
  KEY `latitude` (`latitude`),
  KEY `longitude` (`longitude`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_conferences`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_conferences`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_conferences` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(125) DEFAULT NULL,
  `alias` varchar(125) DEFAULT NULL,
  `short_description` varchar(255) DEFAULT NULL,
  `description` text,
  `place` varchar(255) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `end_date` date DEFAULT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `registration_link` varchar(255) DEFAULT NULL,
  `viewCount` int(11) NOT NULL DEFAULT '0',
  `featured` tinyint(1) DEFAULT NULL,
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_featured` (`featured`),
  KEY `idx_published` (`published`),
  KEY `search` (`start_date`,`end_date`,`alias`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_conferences`
--

INSERT INTO `#__jbusinessdirectory_conferences` (`id`, `name`, `alias`, `short_description`, `description`, `place`, `start_date`, `end_date`, `logo`, `registration_link`, `viewCount`, `featured`, `published`, `created`) VALUES
(2, 'Music Conference', 'music-conference', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium ', '<p>Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt.Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt.</p>', 'London', '2019-12-05', '2022-12-09', '/conferences/cropped-1620648515.jpeg', 'http://www.cmsjunkie.com', 14, NULL, 1, '2022-04-13 11:56:32'),
(3, 'Technology Conference', 'technology-conference', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Perturbationes autem nulla naturae vi commoventur, omniaque ea sunt opiniones ac iudicia levitatis. Utinam quidem dicerent alium alio beatiorem! Iam ruinas videres.', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Perturbationes autem nulla naturae vi commoventur, omniaque ea sunt opiniones ac iudicia levitatis. Utinam quidem dicerent alium alio beatiorem! Iam ruinas videres. Quodsi ipsam honestatem undique pertectam atque absolutam. Quid, de quo nulla dissensio est? Tum Quintus: Est plane, Piso, ut dicis, inquit.</p>\r\n<p>Nobis Heracleotes ille Dionysius flagitiose descivisse videtur a Stoicis propter oculorum dolorem. Maximas vero virtutes iacere omnis necesse est voluptate dominante. <i>Inde sermone vario sex illa a Dipylo stadia confecimus.</i> Bonum incolumis acies: misera caecitas. Qui non moveatur et offensione turpitudinis et comprobatione honestatis? Tubulo putas dicere? <a href=\"http://loripsum.net/\" target=\"_blank\" rel=\"noopener noreferrer\">Huius ego nunc auctoritatem sequens idem faciam.</a> Quis hoc dicit? Sint ista Graecorum; <a href=\"http://loripsum.net/\" target=\"_blank\" rel=\"noopener noreferrer\">Praeclare hoc quidem.</a> An nisi populari fama? Hoc est non modo cor non habere, sed ne palatum quidem.</p>\r\n<p>Duo Reges: constructio interrete. <b>Urgent tamen et nihil remittunt.</b> Si enim ita est, vide ne facinus facias, cum mori suadeas. <a href=\"http://loripsum.net/\" target=\"_blank\" rel=\"noopener noreferrer\">Addidisti ad extremum etiam indoctum fuisse.</a> Quis non odit sordidos, vanos, leves, futtiles? De vacuitate doloris eadem sententia erit. Quia dolori non voluptas contraria est, sed doloris privatio. <mark>Si quidem, inquit, tollerem, sed relinquo.</mark> Iam id ipsum absurdum, maximum malum neglegi.</p>', 'Rome', '2019-11-05', '2022-11-09', '/conferences/cropped-1620648159.jpeg', 'http://www.cmsjunkie.com', 4, NULL, 1, '2022-04-13 11:56:32'),
(4, 'Invest in you!', 'human-rights-conferenc', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc haec primum fortasse audientis servire debemus.', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. <a href=\"http://loripsum.net/\" target=\"_blank\" rel=\"noopener noreferrer\">Quid enim est a Chrysippo praetermissum in Stoicis?</a> Et nunc quidem quod eam tuetur, ut de vite potissimum loquar, est id extrinsecus; <mark>Bonum patria: miserum exilium.</mark> <a href=\"http://loripsum.net/\" target=\"_blank\" rel=\"noopener noreferrer\">Duo Reges: constructio interrete.</a> <a href=\"http://loripsum.net/\" target=\"_blank\" rel=\"noopener noreferrer\">Velut ego nunc moveor.</a> Si sapiens, ne tum quidem miser, cum ab Oroete, praetore Darei, in crucem actus est. Praeclare hoc quidem. Si longus, levis. Et quidem, inquit, vehementer errat;</p>\r\n<p>Duarum enim vitarum nobis erunt instituta capienda. <a href=\"http://loripsum.net/\" target=\"_blank\" rel=\"noopener noreferrer\">Vide, quaeso, rectumne sit.</a> <a href=\"http://loripsum.net/\" target=\"_blank\" rel=\"noopener noreferrer\">An haec ab eo non dicuntur?</a> Nec vero alia sunt quaerenda contra Carneadeam illam sententiam. Idem etiam dolorem saepe perpetiuntur, ne, si id non faciant, incidant in maiorem. <a href=\"http://loripsum.net/\" target=\"_blank\" rel=\"noopener noreferrer\">Videamus animi partes, quarum est conspectus illustrior;</a> Qualem igitur hominem natura inchoavit? Si stante, hoc natura videlicet vult, salvam esse se, quod concedimus;</p>\r\n<p>Non quaeritur autem quid naturae tuae consentaneum sit, sed quid disciplinae. Non dolere, inquam, istud quam vim habeat postea videro; Paria sunt igitur. <b>Nullus est igitur cuiusquam dies natalis.</b> Traditur, inquit, ab Epicuro ratio neglegendi doloris. Conferam tecum, quam cuique verso rem subicias; Ergo instituto veterum, quo etiam Stoici utuntur, hinc capiamus exordium. De vacuitate doloris eadem sententia erit. <i>Sed haec quidem liberius ab eo dicuntur et saepius.</i> Quamquam te quidem video minime esse deterritum.</p>', 'New York', '2019-10-13', '2022-10-15', '/conferences/cropped-1620648432.jpeg', 'http://www.cmsjunkie.com', 7, NULL, 1, '2022-04-13 11:56:32');

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_conference_sessions`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_conference_sessions`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_conference_sessions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `alias` varchar(255) DEFAULT NULL,
  `date` date DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `end_time` time DEFAULT NULL,
  `locationId` int(11) DEFAULT NULL,
  `sessiontypeId` int(11) DEFAULT NULL,
  `sessionlevelId` int(11) DEFAULT NULL,
  `short_description` varchar(355) DEFAULT NULL,
  `description` text,
  `viewCount` int(11) NOT NULL DEFAULT '0',
  `published` tinyint(1) DEFAULT '1',
  `conferenceId` int(11) DEFAULT NULL,
  `video` varchar(255) DEFAULT NULL,
  `color` varchar(10) DEFAULT NULL,
  `register_url` varchar(245) DEFAULT NULL,
  `time_zone` varchar(45) DEFAULT NULL,
  `session_url` varchar(245) DEFAULT NULL,
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_published` (`published`),
  KEY `idx_name` (`name`),
  KEY `idx_short_description` (`short_description`(100)),
  KEY `conference` (`conferenceId`),
  KEY `idx_sessiontypeId` (`sessiontypeId`),
  KEY `idx_sessionlevelId` (`sessionlevelId`),
  KEY `idx_alias` (`alias`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_conference_sessions`
--

INSERT INTO `#__jbusinessdirectory_conference_sessions` (`id`, `name`, `alias`, `date`, `start_time`, `end_time`, `locationId`, `sessiontypeId`, `sessionlevelId`, `short_description`, `description`, `viewCount`, `published`, `conferenceId`, `video`, `color`, `register_url`, `time_zone`, `session_url`, `created`) VALUES
(7, 'Electric City Music Conference', 'electric-city-music-conference', '2019-02-07', '11:00:00', '12:30:00', 2, 4, 2, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duae sunt enim res quoque, ne tu verba solum putes.', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duae sunt enim res quoque, ne tu verba solum putes. Videamus animi partes, quarum est conspectus illustrior; Sed vobis voluptatum perceptarum recordatio vitam beatam facit, et quidem corpore perceptarum. Tum Piso: Quoniam igitur aliquid omnes, quid Lucius noster? Quod quidem nobis non saepe contingit. Cave putes quicquam esse verius.</p>\r\n<p>Sed ad haec, nisi molestum est, habeo quae velim. Duo Reges: constructio interrete. Quam nemo umquam voluptatem appellavit, appellat; Qui autem de summo bono dissentit de tota philosophiae ratione dissentit.</p>\r\n<p>Tum, Quintus et Pomponius cum idem se velle dixissent, Piso exorsus est. Recte, inquit, intellegis. Quae sunt igitur communia vobis cum antiquis, iis sic utamur quasi concessis; Quamquam te quidem video minime esse deterritum. Unum nescio, quo modo possit, si luxuriosus sit, finitas cupiditates habere. Hosne igitur laudas et hanc eorum, inquam, sententiam sequi nos censes oportere?</p>', 14, 1, 2, '<iframe width=854 height=480 src=https://www.youtube.com/embed/Z6-DFMc10J8 frameborder=0 allow=accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture allowfullscreen></iframe>', '', NULL, NULL, NULL, '2022-04-13 11:56:32'),
(8, 'IoT Tech Expo Global', 'iot-tech-expo-global', '2019-03-07', '15:30:00', '18:30:00', 2, 5, 3, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duae sunt enim res quoque, ne tu verba solum putes.', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duae sunt enim res quoque, ne tu verba solum putes. Videamus animi partes, quarum est conspectus illustrior; Sed vobis voluptatum perceptarum recordatio vitam beatam facit, et quidem corpore perceptarum. Tum Piso: Quoniam igitur aliquid omnes, quid Lucius noster? Quod quidem nobis non saepe contingit. Cave putes quicquam esse verius.</p>\r\n<p>Sed ad haec, nisi molestum est, habeo quae velim. Duo Reges: constructio interrete. Quam nemo umquam voluptatem appellavit, appellat; Qui autem de summo bono dissentit de tota philosophiae ratione dissentit.</p>\r\n<p>Tum, Quintus et Pomponius cum idem se velle dixissent, Piso exorsus est. Recte, inquit, intellegis. Quae sunt igitur communia vobis cum antiquis, iis sic utamur quasi concessis; Quamquam te quidem video minime esse deterritum. Unum nescio, quo modo possit, si luxuriosus sit, finitas cupiditates habere. Hosne igitur laudas et hanc eorum, inquam, sententiam sequi nos censes oportere?</p>', 1, 1, 3, '<iframe width=854 height=480 src=https://www.youtube.com/embed/3mk64j0_9cI frameborder=0 allow=accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture allowfullscreen></iframe>', '', NULL, NULL, NULL, '2022-04-13 11:56:32'),
(9, 'Annual Winter Music Conference', 'annual-winter-music-conference', '2019-12-12', '16:30:00', '19:00:00', 4, 4, 4, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quid ad utilitatem tantae pecuniae.', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quid ad utilitatem tantae pecuniae? Utrum igitur tibi litteram videor an totas paginas commovere? Qui enim existimabit posse se miserum esse beatus non erit. Hoc non est positum in nostra actione. Tanta vis admonitionis inest in locis; Hoc non est positum in nostra actione. Duo Reges: constructio interrete. Nec tamen ille erat sapiens quis enim hoc aut quando aut ubi aut unde? Quae tamen a te agetur non melior, quam illae sunt, quas interdum optines.</p>\r\n<p>Tertium autem omnibus aut maximis rebus iis, quae secundum naturam sint, fruentem vivere. Est tamen ea secundum naturam multoque nos ad se expetendam magis hortatur quam superiora omnia. Quaero igitur, quo modo hae tantae commendationes a natura profectae subito a sapientia relictae sint. <b>Tum ille: Ain tandem?</b> Id Sextilius factum negabat. Paulum, cum regem Persem captum adduceret, eodem flumine invectio? <i>Negare non possum.</i> An me, inquam, nisi te audire vellem, censes haec dicturum fuisse?</p>\r\n<p>Cave putes quicquam esse verius. Quodsi ipsam honestatem undique pertectam atque absolutam. Virtutis, magnitudinis animi, patientiae, fortitudinis fomentis dolor mitigari solet. Primum in nostrane potestate est, quid meminerimus? <a href=\"http://loripsum.net/\" target=\"_blank\" rel=\"noopener noreferrer\">Hoc Hieronymus summum bonum esse dixit.</a> <a href=\"http://loripsum.net/\" target=\"_blank\" rel=\"noopener noreferrer\">Paria sunt igitur.</a> <b>Ita fit cum gravior, tum etiam splendidior oratio.</b> Atqui reperies, inquit, in hoc quidem pertinacem; <mark>Ergo illi intellegunt quid Epicurus dicat, ego non intellego?</mark></p>', 1, 1, 2, '<iframe width=901 height=507 src=https://www.youtube.com/embed/hXI14GlaUjA frameborder=0 allow=accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture allowfullscreen></iframe>', '', NULL, NULL, NULL, '2022-04-13 11:56:32'),
(10, 'Millennium Music Conference', 'millennium-music-conference', '2019-04-12', '11:00:00', '23:00:00', 4, 5, 4, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quid ad utilitatem tantae pecuniae', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quid ad utilitatem tantae pecuniae? Utrum igitur tibi litteram videor an totas paginas commovere? Qui enim existimabit posse se miserum esse beatus non erit. Hoc non est positum in nostra actione. Tanta vis admonitionis inest in locis; Hoc non est positum in nostra actione. Duo Reges: constructio interrete. Nec tamen ille erat sapiens quis enim hoc aut quando aut ubi aut unde? Quae tamen a te agetur non melior, quam illae sunt, quas interdum optines.</p>\r\n<p>Tertium autem omnibus aut maximis rebus iis, quae secundum naturam sint, fruentem vivere. Est tamen ea secundum naturam multoque nos ad se expetendam magis hortatur quam superiora omnia. Quaero igitur, quo modo hae tantae commendationes a natura profectae subito a sapientia relictae sint. <b>Tum ille: Ain tandem?</b> Id Sextilius factum negabat. Paulum, cum regem Persem captum adduceret, eodem flumine invectio? <i>Negare non possum.</i> An me, inquam, nisi te audire vellem, censes haec dicturum fuisse?</p>\r\n<p>Cave putes quicquam esse verius. Quodsi ipsam honestatem undique pertectam atque absolutam. Virtutis, magnitudinis animi, patientiae, fortitudinis fomentis dolor mitigari solet. Primum in nostrane potestate est, quid meminerimus? <a href=\"http://loripsum.net/\" target=\"_blank\" rel=\"noopener noreferrer\">Hoc Hieronymus summum bonum esse dixit.</a> <a href=\"http://loripsum.net/\" target=\"_blank\" rel=\"noopener noreferrer\">Paria sunt igitur.</a> <b>Ita fit cum gravior, tum etiam splendidior oratio.</b> Atqui reperies, inquit, in hoc quidem pertinacem; <mark>Ergo illi intellegunt quid Epicurus dicat, ego non intellego?</mark></p>', 1, 1, 2, '<iframe width=901 height=507 src=https://www.youtube.com/embed/ayoHz82K41Q frameborder=0 allow=accelerometer; autoplay; encrypted-media; gyroscope; picture-in-picture allowfullscreen></iframe>', '', '', '-11:00', '', '2022-04-13 11:56:32'),
(11, 'Summit For Human Rights And Democracy', 'summit-for-human-rights-and-democracy', '2019-03-12', '17:00:00', '19:00:00', 3, 5, 2, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quid ad utilitatem tantae pecuniae', '<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quid ad utilitatem tantae pecuniae? Utrum igitur tibi litteram videor an totas paginas commovere? Qui enim existimabit posse se miserum esse beatus non erit. Hoc non est positum in nostra actione. Tanta vis admonitionis inest in locis; Hoc non est positum in nostra actione. Duo Reges: constructio interrete. Nec tamen ille erat sapiens quis enim hoc aut quando aut ubi aut unde? Quae tamen a te agetur non melior, quam illae sunt, quas interdum optines.</p>\r\n<p>Tertium autem omnibus aut maximis rebus iis, quae secundum naturam sint, fruentem vivere. Est tamen ea secundum naturam multoque nos ad se expetendam magis hortatur quam superiora omnia. Quaero igitur, quo modo hae tantae commendationes a natura profectae subito a sapientia relictae sint. <b>Tum ille: Ain tandem?</b> Id Sextilius factum negabat. Paulum, cum regem Persem captum adduceret, eodem flumine invectio? <i>Negare non possum.</i> An me, inquam, nisi te audire vellem, censes haec dicturum fuisse?</p>\r\n<p>Cave putes quicquam esse verius. Quodsi ipsam honestatem undique pertectam atque absolutam. Virtutis, magnitudinis animi, patientiae, fortitudinis fomentis dolor mitigari solet. Primum in nostrane potestate est, quid meminerimus? <a href=\"http://loripsum.net/\" target=\"_blank\" rel=\"noopener noreferrer\">Hoc Hieronymus summum bonum esse dixit.</a> <a href=\"http://loripsum.net/\" target=\"_blank\" rel=\"noopener noreferrer\">Paria sunt igitur.</a> <b>Ita fit cum gravior, tum etiam splendidior oratio.</b> Atqui reperies, inquit, in hoc quidem pertinacem; <mark>Ergo illi intellegunt quid Epicurus dicat, ego non intellego?</mark></p>', 14, 1, 4, '', '', NULL, NULL, NULL, '2022-04-13 11:56:32');

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_conference_session_attachments`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_conference_session_attachments`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_conference_session_attachments` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` tinyint(4) DEFAULT NULL,
  `object_id` int(11) DEFAULT NULL,
  `name` varchar(100) DEFAULT NULL,
  `path` varchar(155) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  `ordering` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_type` (`type`),
  KEY `idx_object` (`object_id`),
  KEY `idx_status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_conference_session_attachments`
--

INSERT INTO `#__jbusinessdirectory_conference_session_attachments` (`id`, `type`, `object_id`, `name`, `path`, `status`, `ordering`) VALUES
(34, 4, 7, 'musicbusiness-1549374419.jpg', '/sessions/0/musicbusiness-1549374419.jpg', 1, 0),
(33, 4, 8, 'ISTQB Agile Tester Extension', '/sessions/0/ISTQBAgileTesterExtension-1549374765.pdf', 1, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_conference_session_categories`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_conference_session_categories`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_conference_session_categories` (
  `sessionId` int(11) NOT NULL,
  `categoryId` int(11) NOT NULL,
  PRIMARY KEY (`sessionId`,`categoryId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_conference_session_categories`
--

INSERT INTO `#__jbusinessdirectory_conference_session_categories` (`sessionId`, `categoryId`) VALUES
(7, 218),
(8, 217),
(9, 218),
(11, 219);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_conference_session_companies`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_conference_session_companies`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_conference_session_companies` (
  `sessionId` int(11) NOT NULL,
  `companyId` int(11) NOT NULL,
  PRIMARY KEY (`sessionId`,`companyId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_conference_session_companies`
--

INSERT INTO `#__jbusinessdirectory_conference_session_companies` (`sessionId`, `companyId`) VALUES
(7, 1),
(7, 7),
(7, 31),
(8, 1),
(9, 1),
(9, 7),
(10, 1),
(11, 8);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_conference_session_levels`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_conference_session_levels`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_conference_session_levels` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_conference_session_levels`
--

INSERT INTO `#__jbusinessdirectory_conference_session_levels` (`id`, `name`) VALUES
(2, 'First'),
(3, 'Third'),
(4, 'Advanced');

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_conference_session_locations`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_conference_session_locations`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_conference_session_locations` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `location` varchar(255) DEFAULT NULL,
  `position` varchar(255) DEFAULT NULL,
  `capacity` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_conference_session_locations`
--

INSERT INTO `#__jbusinessdirectory_conference_session_locations` (`id`, `name`, `location`, `position`, `capacity`) VALUES
(2, 'Rome', 'Italy', '', 0),
(3, 'London', 'United Kingdom', '', 0),
(4, 'New York', 'United States', '', 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_conference_session_registers`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_conference_session_registers`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_conference_session_registers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `session_id` int(11) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `status` int(11) DEFAULT NULL,
  `last_updated` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `joined` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_unique` (`user_id`,`session_id`),
  KEY `idx_status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_conference_session_speakers`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_conference_session_speakers`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_conference_session_speakers` (
  `sessionId` int(11) NOT NULL,
  `speakerId` int(11) NOT NULL,
  `speaker_order` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`sessionId`,`speakerId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_conference_session_speakers`
--

INSERT INTO `#__jbusinessdirectory_conference_session_speakers` (`sessionId`, `speakerId`, `speaker_order`) VALUES
(7, 3, 0),
(7, 6, 0),
(8, 4, 0),
(9, 6, 0),
(10, 3, 0),
(10, 6, 1),
(11, 5, 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_conference_session_types`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_conference_session_types`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_conference_session_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `clickCount` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_conference_session_types`
--

INSERT INTO `#__jbusinessdirectory_conference_session_types` (`id`, `name`, `clickCount`) VALUES
(4, 'Opera Room', 1),
(5, 'University Open Session', 0);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_conference_speakers`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_conference_speakers`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_conference_speakers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(75) DEFAULT NULL,
  `alias` varchar(125) DEFAULT NULL,
  `title` varchar(255) DEFAULT NULL,
  `company_name` varchar(55) DEFAULT NULL,
  `company_logo` varchar(255) DEFAULT NULL,
  `countryId` int(11) DEFAULT NULL,
  `speaker_language` varchar(100) DEFAULT NULL,
  `biography` text,
  `sessionId` int(11) DEFAULT NULL,
  `photo` varchar(255) DEFAULT NULL,
  `speakertypeId` int(11) DEFAULT NULL,
  `featured` tinyint(1) DEFAULT NULL,
  `email` varchar(45) DEFAULT NULL,
  `phone` varchar(45) DEFAULT NULL,
  `facebook` varchar(100) DEFAULT NULL,
  `twitter` varchar(100) DEFAULT NULL,
  `googlep` varchar(100) DEFAULT NULL,
  `linkedin` varchar(100) DEFAULT NULL,
  `short_biography` text,
  `additional_info_link` varchar(100) DEFAULT NULL,
  `viewCount` int(11) NOT NULL DEFAULT '0',
  `published` tinyint(1) NOT NULL DEFAULT '1',
  `created` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  KEY `idx_published` (`published`),
  KEY `idx_speakertypeId` (`speakertypeId`),
  KEY `idx_name` (`name`),
  KEY `idx_title` (`title`),
  KEY `idx_company_name` (`company_name`),
  KEY `idx_phone` (`phone`),
  KEY `idx_countryId` (`countryId`),
  KEY `idx_alias` (`alias`),
  KEY `idx_session` (`sessionId`),
  KEY `idx_featured` (`featured`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_conference_speakers`
--

INSERT INTO `#__jbusinessdirectory_conference_speakers` (`id`, `name`, `alias`, `title`, `company_name`, `company_logo`, `countryId`, `speaker_language`, `biography`, `sessionId`, `photo`, `speakertypeId`, `featured`, `email`, `phone`, `facebook`, `twitter`, `googlep`, `linkedin`, `short_biography`, `additional_info_link`, `viewCount`, `published`, `created`) VALUES
(3, 'John Smith', 'john-smith', 'Musician', 'Music Business Workshop', '/speakers/company_1.jpg', 224, NULL, 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate eget, arcu. In enim justo, rhoncus ut, imperdiet a, venenatis vitae, justo. Nullam dictum felis eu pede mollis pretium. Integer tincidunt.', NULL, '/speakers/cropped-1620648707.jpeg', 2, NULL, 'office@site.com', '675411232', 'http://www.facebook.com/', 'http://www.twitter.com/', '', 'http://www.linkedin.com/', 'Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Aenean commodo ligula eget dolor. Aenean massa. Cum sociis natoque penatibus et magnis dis parturient montes, nascetur ridiculus mus. Donec quam felis, ultricies nec, pellentesque eu, pretium quis, sem. Nulla consequat massa quis enim. Donec pede justo, fringilla vel, aliquet nec, vulputate ', '', 5, 1, '2022-04-13 11:56:33'),
(4, 'Stacey Harington', 'stacey-harington', 'CEO', 'Intelligent Solutions', '/speakers/company_2.png', 226, NULL, 'Vivamus in mollis augue. Vestibulum ex metus, bibendum porttitor tempus non, feugiat non turpis. Nam arcu augue, sollicitudin id arcu ac, auctor porta ipsum. Donec ut imperdiet leo, et feugiat ante. Quisque tristique vehicula ipsum eget lobortis. Nam scelerisque, lectus sit amet accumsan suscipit, massa urna pellentesque purus, in blandit tellus tortor sit amet ante. Ut ornare est ac nunc semper feugiat. Curabitur cursus tempor lacinia. Pellentesque interdum blandit velit. Mauris ac ornare libero. Duis efficitur pretium tortor, ac blandit purus imperdiet eu. Aliquam sagittis mi hendrerit risus convallis imperdiet. Nunc eu lacus et lacus fringilla commodo ac et lectus.', NULL, '/speakers/cropped-1620648687.jpeg', 3, NULL, 'office@site.com', '675411232', 'http://www.facebook.com', 'http://www.twitter.com/', '', 'http://www.linkedin.com', 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Perturbationes autem nulla naturae vi commoventur, omniaque ea sunt opiniones ac iudicia levitatis. Utinam quidem dicerent alium alio beatiorem! Iam ruinas videres. Quodsi ipsam honestatem undique pertectam atque absolutam. Quid, de quo nulla dissensio est? Tum Quintus: Est plane, Piso, ut', '', 3, 1, '2022-04-13 11:56:33'),
(5, 'Linda Hart', 'linda-hart', 'Project Manager at Human Rights women and child welfare', 'Human Rights Council', '', 226, NULL, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc haec primum fortasse audientis servire debemus. Non minor, inquit, voluptas percipitur ex vilissimis rebus quam ex pretiosissimis. Cum autem in quo sapienter dicimus, id a primo rectissime dicitur. ALIO MODO. Duo Reges: constructio interrete. Nam et a te perfici istam disputationem volo, nec tua mihi oratio longa videri potest. Egone non intellego, quid sit don Graece, Latine voluptas? Omnes enim iucundum motum, quo sensus hilaretur.', NULL, '/speakers/cropped-1620648631.jpeg', 3, NULL, 'office@site.com', '675411232', 'http://www.facebook.com', 'http://www.twitter.com/', '', 'http://www.linkedin.com', '', '', 11, 1, '2022-04-13 11:56:33'),
(6, 'Brian Lindow', 'brian-lindow', 'Piainst', 'Opera Room Theater', '/speakers/company_4.jpg', 226, NULL, 'Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nunc haec primum fortasse audientis servire debemus. Non minor, inquit, voluptas percipitur ex vilissimis rebus quam ex pretiosissimis. Cum autem in quo sapienter dicimus, id a primo rectissime dicitur. ALIO MODO. Duo Reges: constructio interrete. Nam et a te perfici istam disputationem volo, nec tua mihi oratio longa videri potest. Egone non intellego, quid sit don Graece, Latine voluptas? Omnes enim iucundum motum, quo sensus hilaretur.', NULL, '/speakers/cropped-1620648615.jpeg', 2, NULL, 'office@site.com', '6754112324', 'http://www.facebook.com', 'http://www.facebook.com', '', 'http://www.linkedin.com', '', '', 6, 1, '2022-04-13 11:56:33');

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_conference_speaker_types`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_conference_speaker_types`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_conference_speaker_types` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `color` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_conference_speaker_types`
--

INSERT INTO `#__jbusinessdirectory_conference_speaker_types` (`id`, `name`, `color`) VALUES
(2, 'Moderator', ''),
(3, 'Keynote Speaker', '');

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_countries`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_countries`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_countries` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `country_name` char(255) DEFAULT NULL,
  `country_code` varchar(4) DEFAULT NULL,
  `country_currency` char(255) DEFAULT NULL,
  `country_currency_short` char(50) DEFAULT NULL,
  `logo` varchar(100) DEFAULT NULL,
  `description` varchar(245) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `idx_code` (`country_code`),
  KEY `idx_name` (`country_name`)
) ENGINE=MyISAM AUTO_INCREMENT=255 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_countries`
--

INSERT INTO `#__jbusinessdirectory_countries` (`id`, `country_name`, `country_code`, `country_currency`, `country_currency_short`, `logo`, `description`) VALUES
(1, 'Andorra', 'AD', 'Euro', 'EUR', '/flags/andorra.png', NULL),
(2, 'United Arab Emirates', 'AE', 'UAE Dirham', 'AED', '/flags/united-arab-emirates.png', NULL),
(3, 'Afghanistan', 'AF', 'Afghani', 'AFA', '/flags/afghanistan.png', NULL),
(4, 'Antigua and Barbuda', 'AG', 'East Caribbean Dollar', 'XCD', '/flags/antigua-and-barbuda.png', NULL),
(5, 'Anguilla', 'AI', 'East Caribbean Dollar', 'XCD', '/flags/anguilla.png', NULL),
(6, 'Albania', 'AL', 'Lek', 'ALL', '/flags/albania.png', NULL),
(7, 'Armenia', 'AM', 'Armenian Dram', 'AMD', '/flags/armenia.png', NULL),
(8, 'Netherlands Antilles', 'AN', 'Netherlands Antillean guilder', 'ANG', '/flags/netherlands-antilles.png', NULL),
(9, 'Angola', 'AO', 'Kwanza', 'AOA', '/flags/angola.png', NULL),
(11, 'Argentina', 'AR', 'Argentine Peso', 'ARS', '/flags/argentina.png', NULL),
(12, 'American Samoa', 'AS', 'US Dollar', 'USD', '/flags/american-samoa.png', NULL),
(13, 'Austria', 'AT', 'Euro', 'EUR', '/flags/austria.png', NULL),
(14, 'Australia', 'AU', 'Australian dollar', 'AUD', '/flags/australia.png', NULL),
(15, 'Aruba', 'AW', 'Aruban Guilder', 'AWG', '/flags/aruba.png', NULL),
(16, 'Azerbaijan', 'AZ', 'Azerbaijani Manat', 'AZM', '/flags/azerbaijan.png', NULL),
(17, 'Bosnia and Herzegovina', 'BA', 'Convertible Marka', 'BAM', '/flags/bosnia-and-herzegovina.png', NULL),
(18, 'Barbados', 'BB', 'Barbados Dollar', 'BBD', '/flags/barbados.png', NULL),
(19, 'Bangladesh', 'BD', 'Taka', 'BDT', '/flags/bangladesh.png', NULL),
(20, 'Belgium', 'BE', 'Euro', 'EUR', '/flags/belgium.png', NULL),
(21, 'Burkina Faso', 'BF', 'CFA Franc BCEAO', 'XOF', '/flags/burkina-faso.png', NULL),
(22, 'Bulgaria', 'BG', 'Lev', 'BGL', '/flags/bulgaria.png', NULL),
(23, 'Bahrain', 'BH', 'Bahraini Dinar', 'BHD', '/flags/bahrain.png', NULL),
(24, 'Burundi', 'BI', 'Burundi Franc', 'BIF', '/flags/burundi.png', NULL),
(25, 'Benin', 'BJ', 'CFA Franc BCEAO', 'XOF', '/flags/benin.png', NULL),
(26, 'Bermuda', 'BM', 'Bermudian Dollar', 'BMD', '/flags/bermuda.png', NULL),
(27, 'Brunei Darussalam', 'BN', 'Brunei Dollar', 'BND', '/flags/brunei-darussalam.png', NULL),
(28, 'Bolivia', 'BO', 'Boliviano', 'BOB', '/flags/bolivia.png', NULL),
(29, 'Brazil', 'BR', 'Brazilian Real', 'BRL', '/flags/brazil.png', NULL),
(30, 'The Bahamas', 'BS', 'Bahamian Dollar', 'BSD', '/flags/the-bahamas.png', NULL),
(31, 'Bhutan', 'BT', 'Ngultrum', 'BTN', '/flags/bhutan.png', NULL),
(32, 'Bouvet Island', 'BV', 'Norwegian Krone', 'NOK', '/flags/bouvet-island.png', NULL),
(33, 'Botswana', 'BW', 'Pula', 'BWP', '/flags/botswana.png', NULL),
(34, 'Belarus', 'BY', 'Belarussian Ruble', 'BYN', '/flags/belarus.png', NULL),
(35, 'Belize', 'BZ', 'Belize Dollar', 'BZD', '/flags/belize.png', NULL),
(36, 'Canada', 'CA', 'Canadian Dollar', 'CAD', '/flags/canada.png', NULL),
(37, 'Cocos (Keeling) Islands', 'CC', 'Australian Dollar', 'AUD', '/flags/cocos-(keeling)-islands.png', NULL),
(39, 'Central African Republic', 'CF', 'CFA Franc BEAC', 'XAF', '/flags/central-african-republic.png', NULL),
(41, 'Switzerland', 'CH', 'Swiss Franc', 'CHF', '/flags/switzerland.png', NULL),
(42, 'Cote d\'Ivoire', 'CI', 'CFA Franc BCEAO', 'XOF', '/flags/cote-d\'ivoire.png', NULL),
(43, 'Cook Islands', 'CK', 'New Zealand Dollar', 'NZD', '/flags/cook-islands.png', NULL),
(44, 'Chile', 'CL', 'Chilean Peso', 'CLP', '/flags/chile.png', NULL),
(45, 'Cameroon', 'CM', 'CFA Franc BEAC', 'XAF', '/flags/cameroon.png', NULL),
(46, 'China', 'CN', 'Yuan Renminbi', 'CNY', '/flags/china.png', NULL),
(47, 'Colombia', 'CO', 'Colombian Peso', 'COP', '/flags/colombia.png', NULL),
(48, 'Costa Rica', 'CR', 'Costa Rican Colon', 'CRC', '/flags/costa-rica.png', NULL),
(49, 'Cuba', 'CU', 'Cuban Peso', 'CUP', '/flags/cuba.png', NULL),
(50, 'Cape Verde', 'CV', 'Cape Verdean Escudo', 'CVE', '/flags/cape-verde.png', NULL),
(51, 'Christmas Island', 'CX', 'Australian Dollar', 'AUD', '/flags/christmas-island.png', NULL),
(52, 'Cyprus', 'CY', 'Cyprus Pound', 'CYP', '/flags/cyprus.png', NULL),
(53, 'Czech Republic', 'CZ', 'Czech Koruna', 'CZK', '/flags/czech-republic.png', NULL),
(54, 'Germany', 'DE', 'Euro', 'EUR', '/flags/germany.png', NULL),
(55, 'Djibouti', 'DJ', 'Djibouti Franc', 'DJF', '/flags/djibouti.png', NULL),
(56, 'Denmark', 'DK', 'Danish Krone', 'DKK', '/flags/denmark.png', NULL),
(57, 'Dominica', 'DM', 'East Caribbean Dollar', 'XCD', '/flags/dominica.png', NULL),
(58, 'Dominican Republic', 'DO', 'Dominican Peso', 'DOP', '/flags/dominican-republic.png', NULL),
(59, 'Algeria', 'DZ', 'Algerian Dinar', 'DZD', '/flags/algeria.png', NULL),
(60, 'Ecuador', 'EC', 'US dollar', 'USD', '/flags/ecuador.png', NULL),
(61, 'Estonia', 'EE', 'Kroon', 'EEK', '/flags/estonia.png', NULL),
(62, 'Egypt', 'EG', 'Egyptian Pound', 'EGP', '/flags/egypt.png', NULL),
(63, 'Western Sahara', 'EH', 'Moroccan Dirham', 'MAD', '/flags/western-sahara.png', NULL),
(64, 'Eritrea', 'ER', 'Nakfa', 'ERN', '/flags/eritrea.png', NULL),
(65, 'Spain', 'ES', 'Euro', 'EUR', '/flags/spain.png', NULL),
(66, 'Ethiopia', 'ET', 'Ethiopian Birr', 'ETB', '/flags/ethiopia.png', NULL),
(67, 'Finland', 'FI', 'Euro', 'EUR', '/flags/finland.png', NULL),
(68, 'Fiji', 'FJ', 'Fijian Dollar', 'FJD', '/flags/fiji.png', NULL),
(69, 'Falkland Islands (Islas Malvinas)', 'FK', 'Falkland Islands Pound', 'FKP', '/flags/falkland-islands-(islas-malvinas).png', NULL),
(71, 'Faroe Islands', 'FO', 'Danish Krone', 'DKK', '/flags/faroe-islands.png', NULL),
(72, 'France', 'FR', 'Euro', 'EUR', '/flags/france.png', NULL),
(74, 'Gabon', 'GA', 'CFA Franc BEAC', 'XAF', '/flags/gabon.png', NULL),
(75, 'Grenada', 'GD', 'East Caribbean Dollar', 'XCD', '/flags/grenada.png', NULL),
(76, 'Georgia', 'GE', 'Lari', 'GEL', '/flags/georgia.png', NULL),
(77, 'French Guiana', 'GF', 'Euro', 'EUR', '/flags/french-guiana.png', NULL),
(78, 'Guernsey', 'GG', 'Pound Sterling', 'GBP', '/flags/guernsey.png', NULL),
(79, 'Ghana', 'GH', 'Cedi', 'GHC', '/flags/ghana.png', NULL),
(80, 'Gibraltar', 'GI', 'Gibraltar Pound', 'GIP', '/flags/gibraltar.png', NULL),
(81, 'Greenland', 'GL', 'Danish Krone', 'DKK', '/flags/greenland.png', NULL),
(82, 'The Gambia', 'GM', 'Dalasi', 'GMD', '/flags/the-gambia.png', NULL),
(83, 'Guinea', 'GN', 'Guinean Franc', 'GNF', '/flags/guinea.png', NULL),
(84, 'Guadeloupe', 'GP', 'Euro', 'EUR', '/flags/guadeloupe.png', NULL),
(85, 'Equatorial Guinea', 'GQ', 'CFA Franc BEAC', 'XAF', '/flags/equatorial-guinea.png', NULL),
(86, 'Greece', 'GR', 'Euro', 'EUR', '/flags/greece.png', NULL),
(87, 'South Georgia and the South Sandwich Islands', 'GS', 'Pound Sterling', 'GBP', '/flags/south-georgia-and-the-south-sandwich-islands.png', NULL),
(88, 'Guatemala', 'GT', 'Quetzal', 'GTQ', '/flags/guatemala.png', NULL),
(89, 'Guam', 'GU', 'US Dollar', 'USD', '/flags/guam.png', NULL),
(90, 'Guinea-Bissau', 'GW', 'CFA Franc BCEAO', 'XOF', '/flags/guinea-bissau.png', NULL),
(91, 'Guyana', 'GY', 'Guyana Dollar', 'GYD', '/flags/guyana.png', NULL),
(92, 'Hong Kong (SAR)', 'HK', 'Hong Kong Dollar', 'HKD', '/flags/hong-kong-(sar).png', NULL),
(93, 'Heard Island and McDonald Islands', 'HM', 'Australian Dollar', 'AUD', '/flags/heard-island-and-mcdonald-islands.png', NULL),
(94, 'Honduras', 'HN', 'Lempira', 'HNL', '/flags/honduras.png', NULL),
(95, 'Croatia', 'HR', 'Kuna', 'HRK', '/flags/croatia.png', NULL),
(96, 'Haiti', 'HT', 'Gourde', 'HTG', '/flags/haiti.png', NULL),
(97, 'Hungary', 'HU', 'Forint', 'HUF', '/flags/hungary.png', NULL),
(98, 'Indonesia', 'ID', 'Rupiah', 'IDR', '/flags/indonesia.png', NULL),
(99, 'Ireland', 'IE', 'Euro', 'EUR', '/flags/ireland.png', NULL),
(100, 'Israel', 'IL', 'New Israeli Sheqel', 'ILS', '/flags/israel.png', NULL),
(102, 'India', 'IN', 'Indian Rupee', 'INR', '/flags/india.png', NULL),
(103, 'British Indian Ocean Territory', 'IO', 'US Dollar', 'USD', '/flags/british-indian-ocean-territory.png', NULL),
(104, 'Iraq', 'IQ', 'Iraqi Dinar', 'IQD', '/flags/iraq.png', NULL),
(105, 'Iran', 'IR', 'Iranian Rial', 'IRR', '/flags/iran.png', NULL),
(106, 'Iceland', 'IS', 'Iceland Krona', 'ISK', '/flags/iceland.png', NULL),
(107, 'Italy', 'IT', 'Euro', 'EUR', '/flags/italy.png', NULL),
(108, 'Jersey', 'JE', 'Pound Sterling', 'GBP', '/flags/jersey.png', NULL),
(109, 'Jamaica', 'JM', 'Jamaican dollar', 'JMD', '/flags/jamaica.png', NULL),
(110, 'Jordan', 'JO', 'Jordanian Dinar', 'JOD', '/flags/jordan.png', NULL),
(111, 'Japan', 'JP', 'Yen', 'JPY', '/flags/japan.png', NULL),
(112, 'Kenya', 'KE', 'Kenyan shilling', 'KES', '/flags/kenya.png', NULL),
(113, 'Kyrgyzstan', 'KG', 'Som', 'KGS', '/flags/kyrgyzstan.png', NULL),
(114, 'Cambodia', 'KH', 'Riel', 'KHR', '/flags/cambodia.png', NULL),
(115, 'Kiribati', 'KI', 'Australian dollar', 'AUD', '/flags/kiribati.png', NULL),
(116, 'Comoros', 'KM', 'Comoro Franc', 'KMF', '/flags/comoros.png', NULL),
(117, 'Saint Kitts and Nevis', 'KN', 'East Caribbean Dollar', 'XCD', '/flags/saint-kitts-and-nevis.png', NULL),
(118, 'Korea North', 'KP', 'North Korean Won', 'KPW', '/flags/korea-north.png', NULL),
(119, 'Korea South', 'KR', 'Won', 'KRW', '/flags/korea-south.png', NULL),
(120, 'Kuwait', 'KW', 'Kuwaiti Dinar', 'KWD', '/flags/kuwait.png', NULL),
(121, 'Cayman Islands', 'KY', 'Cayman Islands Dollar', 'KYD', '/flags/cayman-islands.png', NULL),
(122, 'Kazakhstan', 'KZ', 'Tenge', 'KZT', '/flags/kazakhstan.png', NULL),
(123, 'Laos', 'LA', 'Kip', 'LAK', '/flags/laos.png', NULL),
(124, 'Lebanon', 'LB', 'Lebanese Pound', 'LBP', '/flags/lebanon.png', NULL),
(125, 'Saint Lucia', 'LC', 'East Caribbean Dollar', 'XCD', '/flags/saint-lucia.png', NULL),
(126, 'Liechtenstein', 'LI', 'Swiss Franc', 'CHF', '/flags/liechtenstein.png', NULL),
(127, 'Sri Lanka', 'LK', 'Sri Lanka Rupee', 'LKR', '/flags/sri-lanka.png', NULL),
(128, 'Liberia', 'LR', 'Liberian Dollar', 'LRD', '/flags/liberia.png', NULL),
(129, 'Lesotho', 'LS', 'Loti', 'LSL', '/flags/lesotho.png', NULL),
(130, 'Lithuania', 'LT', 'Lithuanian Litas', 'LTL', '/flags/lithuania.png', NULL),
(131, 'Luxembourg', 'LU', 'Euro', 'EUR', '/flags/luxembourg.png', NULL),
(132, 'Latvia', 'LV', 'Latvian Lats', 'LVL', '/flags/latvia.png', NULL),
(133, 'Libya', 'LY', 'Libyan Dinar', 'LYD', '/flags/libya.png', NULL),
(134, 'Morocco', 'MA', 'Moroccan Dirham', 'MAD', '/flags/morocco.png', NULL),
(135, 'Monaco', 'MC', 'Euro', 'EUR', '/flags/monaco.png', NULL),
(136, 'Moldova', 'MD', 'Moldovan Leu', 'MDL', '/flags/moldova.png', NULL),
(137, 'Madagascar', 'MG', 'Malagasy Franc', 'MGF', '/flags/madagascar.png', NULL),
(138, 'Marshall Islands', 'MH', 'US dollar', 'USD', '/flags/marshall-islands.png', NULL),
(140, 'Mali', 'ML', 'CFA Franc BCEAO', 'XOF', '/flags/mali.png', NULL),
(141, 'Burma', 'MM', 'kyat', 'MMK', '/flags/burma.png', NULL),
(142, 'Mongolia', 'MN', 'Tugrik', 'MNT', '/flags/mongolia.png', NULL),
(143, 'Macao', 'MO', 'Pataca', 'MOP', '/flags/macao.png', NULL),
(144, 'Northern Mariana Islands', 'MP', 'US Dollar', 'USD', '/flags/northern-mariana-islands.png', NULL),
(145, 'Martinique', 'MQ', 'Euro', 'EUR', '/flags/martinique.png', NULL),
(146, 'Mauritania', 'MR', 'Ouguiya', 'MRO', '/flags/mauritania.png', NULL),
(147, 'Montserrat', 'MS', 'East Caribbean Dollar', 'XCD', '/flags/montserrat.png', NULL),
(148, 'Malta', 'MT', 'Maltese Lira', 'MTL', '/flags/malta.png', NULL),
(149, 'Mauritius', 'MU', 'Mauritius Rupee', 'MUR', '/flags/mauritius.png', NULL),
(150, 'Maldives', 'MV', 'Rufiyaa', 'MVR', '/flags/maldives.png', NULL),
(151, 'Malawi', 'MW', 'Kwacha', 'MWK', '/flags/malawi.png', NULL),
(152, 'Mexico', 'MX', 'Mexican Peso', 'MXN', '/flags/mexico.png', NULL),
(153, 'Malaysia', 'MY', 'Malaysian Ringgit', 'MYR', '/flags/malaysia.png', NULL),
(154, 'Mozambique', 'MZ', 'Metical', 'MZM', '/flags/mozambique.png', NULL),
(155, 'Namibia', 'NA', 'Namibian Dollar', 'NAD', '/flags/namibia.png', NULL),
(156, 'New Caledonia', 'NC', 'CFP Franc', 'XPF', '/flags/new-caledonia.png', NULL),
(157, 'Niger', 'NE', 'CFA Franc BCEAO', 'XOF', '/flags/niger.png', NULL),
(158, 'Norfolk Island', 'NF', 'Australian Dollar', 'AUD', '/flags/norfolk-island.png', NULL),
(159, 'Nigeria', 'NG', 'Naira', 'NGN', '/flags/nigeria.png', NULL),
(160, 'Nicaragua', 'NI', 'Cordoba Oro', 'NIO', '/flags/nicaragua.png', NULL),
(161, 'Netherlands', 'NL', 'Euro', 'EUR', '/flags/netherlands.png', NULL),
(162, 'Norway', 'NO', 'Norwegian Krone', 'NOK', '/flags/norway.png', NULL),
(163, 'Nepal', 'NP', 'Nepalese Rupee', 'NPR', '/flags/nepal.png', NULL),
(164, 'Nauru', 'NR', 'Australian Dollar', 'AUD', '/flags/nauru.png', NULL),
(165, 'Niue', 'NU', 'New Zealand Dollar', 'NZD', '/flags/niue.png', NULL),
(166, 'New Zealand', 'NZ', 'New Zealand Dollar', 'NZD', '/flags/new-zealand.png', NULL),
(167, 'Oman', 'OM', 'Rial Omani', 'OMR', '/flags/oman.png', NULL),
(168, 'Panama', 'PA', 'balboa', 'PAB', '/flags/panama.png', NULL),
(169, 'Peru', 'PE', 'Nuevo Sol', 'PEN', '/flags/peru.png', NULL),
(170, 'French Polynesia', 'PF', 'CFP Franc', 'XPF', '/flags/french-polynesia.png', NULL),
(171, 'Papua New Guinea', 'PG', 'Kina', 'PGK', '/flags/papua-new-guinea.png', NULL),
(172, 'Philippines', 'PH', 'Philippine Peso', 'PHP', '/flags/philippines.png', NULL),
(173, 'Pakistan', 'PK', 'Pakistan Rupee', 'PKR', '/flags/pakistan.png', NULL),
(174, 'Poland', 'PL', 'Zloty', 'PLN', '/flags/poland.png', NULL),
(175, 'Saint Pierre and Miquelon', 'PM', 'Euro', 'EUR', '/flags/saint-pierre-and-miquelon.png', NULL),
(176, 'Pitcairn Islands', 'PN', 'New Zealand Dollar', 'NZD', '/flags/pitcairn-islands.png', NULL),
(177, 'Puerto Rico', 'PR', 'US dollar', 'USD', '/flags/puerto-rico.png', NULL),
(179, 'Portugal', 'PT', 'Euro', 'EUR', '/flags/portugal.png', NULL),
(180, 'Palau', 'PW', 'US dollar', 'USD', '/flags/palau.png', NULL),
(181, 'Paraguay', 'PY', 'Guarani', 'PYG', '/flags/paraguay.png', NULL),
(182, 'Qatar', 'QA', 'Qatari Rial', 'QAR', '/flags/qatar.png', NULL),
(184, 'Romania', 'RO', 'Leu', 'RON', '/flags/romania.png', NULL),
(185, 'Russia', 'RU', 'Russian Ruble', 'RUB', '/flags/russia.png', NULL),
(186, 'Rwanda', 'RW', 'Rwanda Franc', 'RWF', '/flags/rwanda.png', NULL),
(187, 'Saudi Arabia', 'SA', 'Saudi Riyal', 'SAR', '/flags/saudi-arabia.png', NULL),
(188, 'Solomon Islands', 'SB', 'Solomon Islands Dollar', 'SBD', '/flags/solomon-islands.png', NULL),
(189, 'Seychelles', 'SC', 'Seychelles Rupee', 'SCR', '/flags/seychelles.png', NULL),
(190, 'Sudan', 'SD', 'Sudanese Dinar', 'SDD', '/flags/sudan.png', NULL),
(191, 'Sweden', 'SE', 'Swedish Krona', 'SEK', '/flags/sweden.png', NULL),
(192, 'Singapore', 'SG', 'Singapore Dollar', 'SGD', '/flags/singapore.png', NULL),
(193, 'Saint Helena', 'SH', 'Saint Helenian Pound', 'SHP', '/flags/saint-helena.png', NULL),
(194, 'Slovenia', 'SI', 'Tolar', 'SIT', '/flags/slovenia.png', NULL),
(195, 'Svalbard', 'SJ', 'Norwegian Krone', 'NOK', '/flags/svalbard.png', NULL),
(196, 'Slovakia', 'SK', 'Slovak Koruna', 'SKK', '/flags/slovakia.png', NULL),
(197, 'Sierra Leone', 'SL', 'Leone', 'SLL', '/flags/sierra-leone.png', NULL),
(198, 'San Marino', 'SM', 'Euro', 'EUR', '/flags/san-marino.png', NULL),
(199, 'Senegal', 'SN', 'CFA Franc BCEAO', 'XOF', '/flags/senegal.png', NULL),
(200, 'Somalia', 'SO', 'Somali Shilling', 'SOS', '/flags/somalia.png', NULL),
(201, 'Suriname', 'SR', 'Suriname Guilder', 'SRG', '/flags/suriname.png', NULL),
(203, 'El Salvador', 'SV', 'El Salvador Colon', 'SVC', '/flags/el-salvador.png', NULL),
(204, 'Syria', 'SY', 'Syrian Pound', 'SYP', '/flags/syria.png', NULL),
(205, 'Swaziland', 'SZ', 'Lilangeni', 'SZL', '/flags/swaziland.png', NULL),
(206, 'Turks and Caicos Islands', 'TC', 'US Dollar', 'USD', '/flags/turks-and-caicos-islands.png', NULL),
(207, 'Chad', 'TD', 'CFA Franc BEAC', 'XAF', '/flags/chad.png', NULL),
(208, 'French Southern and Antarctic Lands', 'TF', 'Euro', 'EUR', '/flags/french-southern-and-antarctic-lands.png', NULL),
(209, 'Togo', 'TG', 'CFA Franc BCEAO', 'XOF', '/flags/togo.png', NULL),
(210, 'Thailand', 'TH', 'Baht', 'THB', '/flags/thailand.png', NULL),
(211, 'Tajikistan', 'TJ', 'Somoni', 'TJS', '/flags/tajikistan.png', NULL),
(212, 'Tokelau', 'TK', 'New Zealand Dollar', 'NZD', '/flags/tokelau.png', NULL),
(213, 'Turkmenistan', 'TM', 'Manat', 'TMM', '/flags/turkmenistan.png', NULL),
(214, 'Tunisia', 'TN', 'Tunisian Dinar', 'TND', '/flags/tunisia.png', NULL),
(215, 'Tonga', 'TO', 'Pa\'anga', 'TOP', '/flags/tonga.png', NULL),
(216, 'East Timor', 'TL', 'Timor Escudo', 'TPE', '/flags/east-timor.png', NULL),
(217, 'Turkey', 'TR', 'Turkish Lira', 'TRL', '/flags/turkey.png', NULL),
(218, 'Trinidad and Tobago', 'TT', 'Trinidad and Tobago Dollar', 'TTD', '/flags/trinidad-and-tobago.png', NULL),
(219, 'Tuvalu', 'TV', 'Australian Dollar', 'AUD', '/flags/tuvalu.png', NULL),
(220, 'Taiwan', 'TW', 'New Taiwan Dollar', 'TWD', '/flags/taiwan.png', NULL),
(221, 'Tanzania', 'TZ', 'Tanzanian Shilling', 'TZS', '/flags/tanzania.png', NULL),
(222, 'Ukraine', 'UA', 'Hryvnia', 'UAH', '/flags/ukraine.png', NULL),
(223, 'Uganda', 'UG', 'Uganda Shilling', 'UGX', '/flags/uganda.png', NULL),
(224, 'United Kingdom', 'GB', 'Pound Sterling', 'GBP', '/flags/united-kingdom.png', NULL),
(225, 'United States Minor Outlying Islands', 'UM', 'US Dollar', 'USD', '/flags/united-states-minor-outlying-islands.png', NULL),
(226, 'United States', 'US', 'US Dollar', 'USD', '/flags/united-states.png', NULL),
(227, 'Uruguay', 'UY', 'Peso Uruguayo', 'UYU', '/flags/uruguay.png', NULL),
(228, 'Uzbekistan', 'UZ', 'Uzbekistan Sum', 'UZS', '/flags/uzbekistan.png', NULL),
(229, 'Holy See (Vatican City)', 'VA', 'Euro', 'EUR', '/flags/holy-see-(vatican-city).png', NULL),
(230, 'Saint Vincent and the Grenadines', 'VC', 'East Caribbean Dollar', 'XCD', '/flags/saint-vincent-and-the-grenadines.png', NULL),
(231, 'Venezuela', 'VE', 'Bolivar', 'VEB', '/flags/venezuela.png', NULL),
(232, 'British Virgin Islands', 'VG', 'US dollar', 'USD', '/flags/british-virgin-islands.png', NULL),
(233, 'Virgin Islands', 'VI', 'US Dollar', 'USD', '/flags/virgin-islands.png', NULL),
(234, 'Vietnam', 'VN', 'Dong', 'VND', '/flags/vietnam.png', NULL),
(235, 'Vanuatu', 'VU', 'Vatu', 'VUV', '/flags/vanuatu.png', NULL),
(236, 'Wallis and Futuna', 'WF', 'CFP Franc', 'XPF', '/flags/wallis-and-futuna.png', NULL),
(237, 'Samoa', 'WS', 'Tala', 'WST', '/flags/samoa.png', NULL),
(238, 'Yemen', 'YE', 'Yemeni Rial', 'YER', '/flags/yemen.png', NULL),
(239, 'Mayotte', 'YT', 'Euro', 'EUR', '/flags/mayotte.png', NULL),
(244, 'DR Congo', 'CD', 'Congolese Franc', 'CDF', '/flags/congo-(democratic).png', NULL),
(241, 'South Africa', 'ZA', 'Rand', 'ZAR', '/flags/south-africa.png', NULL),
(242, 'Zambia', 'ZM', 'Kwacha', 'ZMK', '/flags/zambia.png', NULL),
(243, 'Zimbabwe', 'ZW', 'Zimbabwe Dollar', 'ZWD', '/flags/zimbabwe.png', NULL),
(245, 'Republic of the Congo', 'CG', 'Congolese Franc', 'CDF', '/flags/congo-(republic).png', NULL),
(246, 'Curacao', 'CW', 'Netherlands Antillean guilder', 'ANG', '/flags/curacao.png', NULL),
(247, 'Micronesia', 'FM', 'US Dollar', 'USD', '/flags/micronesia-(federated).png', NULL),
(248, 'Montenegro', 'ME', 'Euro', 'EUR', '/flags/montenegro.png', NULL),
(249, 'North Macedonia', 'MK', 'Denar', 'MKD', '/flags/macedonia.png', NULL),
(250, 'Myanmar', 'MM', 'Kyat', 'MMK', '/flags/myanmar.png', NULL),
(251, 'Palestine', 'PS', 'New Israeli Sheqel', 'ISL', '/flags/palestine.png', NULL),
(252, 'Serbia', 'RS', 'Serbian Dinar', 'RSD', '/flags/serbia.png', NULL),
(253, 'South Sudan', 'SS', 'South Sudanese pound', 'SSP', '/flags/south-sudan.png', NULL),
(254, 'Sao Tome and Principe', 'ST', 'Dobra', 'STN', '/flags/sao-tome-and-principe.png', NULL);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_currencies`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_currencies`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_currencies` (
  `currency_id` int(10) NOT NULL AUTO_INCREMENT,
  `currency_name` char(10) DEFAULT NULL,
  `currency_description` varchar(70) DEFAULT NULL,
  `currency_symbol` varchar(10) DEFAULT NULL,
  PRIMARY KEY (`currency_id`)
) ENGINE=MyISAM AUTO_INCREMENT=171 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_currencies`
--

INSERT INTO `#__jbusinessdirectory_currencies` (`currency_id`, `currency_name`, `currency_description`, `currency_symbol`) VALUES
(2, 'AED', 'UAE Dirham', '#'),
(3, 'AFN', 'Afghani', '?'),
(4, 'ALL', 'Lek', 'Lek'),
(5, 'AMD', 'Armenian Dram', '#'),
(6, 'ANG', 'Netherlands Antillian Guilder', 'f'),
(7, 'AOA', 'Kwanza', '#'),
(8, 'ARS', 'Argentine Peso', '$'),
(9, 'AUD', 'Australian Dollar', '$'),
(10, 'AWG', 'Aruban Guilder', 'f'),
(11, 'AZN', 'Azerbaijanian Manat', '???'),
(12, 'BAM', 'Convertible Marks', 'KM'),
(13, 'BBD', 'Barbados Dollar', '$'),
(14, 'BDT', 'Taka', '#'),
(15, 'BGN', 'Bulgarian Lev', '??'),
(16, 'BHD', 'Bahraini Dinar', '#'),
(17, 'BIF', 'Burundi Franc', '#'),
(18, 'BMD', 'Bermudian Dollar (customarily known as Bermuda Dollar)', '$'),
(19, 'BND', 'Brunei Dollar', '$'),
(20, 'BOB BOV', 'Boliviano Mvdol', '$b'),
(21, 'BRL', 'Brazilian Real', 'R$'),
(22, 'BSD', 'Bahamian Dollar', '$'),
(23, 'BWP', 'Pula', 'P'),
(24, 'BYN', 'Belarussian Ruble', 'p.'),
(25, 'BZD', 'Belize Dollar', 'BZ$'),
(26, 'CAD', 'Canadian Dollar', '$'),
(27, 'CDF', 'Congolese Franc', '#'),
(28, 'CHF', 'Swiss Franc', 'CHF'),
(29, 'CLP CLF', 'Chilean Peso Unidades de fomento', '$'),
(30, 'CNY', 'Yuan Renminbi', 'Y'),
(31, 'COP COU', 'Colombian Peso Unidad de Valor Real', '$'),
(32, 'CRC', 'Costa Rican Colon', '?'),
(33, 'CUP CUC', 'Cuban Peso Peso Convertible', '?'),
(34, 'CVE', 'Cape Verde Escudo', '#'),
(35, 'CZK', 'Czech Koruna', 'Kč'),
(36, 'DJF', 'Djibouti Franc', '#'),
(37, 'DKK', 'Danish Krone', 'kr'),
(38, 'DOP', 'Dominican Peso', 'RD$'),
(39, 'DZD', 'Algerian Dinar', '#'),
(40, 'EEK', 'Kroon', '#'),
(41, 'EGP', 'Egyptian Pound', 'E£'),
(42, 'ERN', 'Nakfa', '#'),
(43, 'ETB', 'Ethiopian Birr', '#'),
(44, 'EUR', 'Euro', '€'),
(45, 'FJD', 'Fiji Dollar', '$'),
(46, 'FKP', 'Falkland Islands Pound', '£'),
(47, 'GBP', 'Pound Sterling', '£'),
(48, 'GEL', 'Lari', '#'),
(49, 'GHS', 'Cedi', '#'),
(50, 'GIP', 'Gibraltar Pound', '£'),
(51, 'GMD', 'Dalasi', '#'),
(52, 'GNF', 'Guinea Franc', '#'),
(53, 'GTQ', 'Quetzal', 'Q'),
(54, 'GYD', 'Guyana Dollar', '$'),
(55, 'HKD', 'Hong Kong Dollar', '$'),
(56, 'HNL', 'Lempira', 'L'),
(57, 'HRK', 'Croatian Kuna', 'kn'),
(58, 'HTG USD', 'Gourde US Dollar', '$'),
(59, 'HUF', 'Forint', 'Ft'),
(60, 'IDR', 'Rupiah', 'Rp'),
(61, 'ILS', 'New Israeli Sheqel', '?'),
(62, 'INR', 'Indian Rupee', '#'),
(63, 'INR BTN', 'Indian Rupee Ngultrum', '#'),
(64, 'IQD', 'Iraqi Dinar', '#'),
(65, 'IRR', 'Iranian Rial', '?'),
(66, 'ISK', 'Iceland Krona', 'kr'),
(67, 'JMD', 'Jamaican Dollar', 'J$'),
(68, 'JOD', 'Jordanian Dinar', '#'),
(69, 'JPY', 'Yen', 'Y'),
(70, 'KES', 'Kenyan Shilling', '#'),
(71, 'KGS', 'Som', '??'),
(72, 'KHR', 'Riel', '?'),
(73, 'KMF', 'Comoro Franc', '#'),
(74, 'KPW', 'North Korean Won', '?'),
(75, 'KRW', 'Won', '?'),
(76, 'KWD', 'Kuwaiti Dinar', '#'),
(77, 'KYD', 'Cayman Islands Dollar', '$'),
(78, 'KZT', 'Tenge', '??'),
(79, 'LAK', 'Kip', '?'),
(80, 'LBP', 'Lebanese Pound', 'L'),
(81, 'LKR', 'Sri Lanka Rupee', '?'),
(82, 'LRD', 'Liberian Dollar', '$'),
(83, 'LTL', 'Lithuanian Litas', 'Lt'),
(84, 'LVL', 'Latvian Lats', 'Ls'),
(85, 'LYD', 'Libyan Dinar', '#'),
(86, 'MAD', 'Moroccan Dirham', '#'),
(87, 'MDL', 'Moldovan Leu', '#'),
(88, 'MGA', 'Malagasy Ariary', '#'),
(89, 'MKD', 'Denar', '???'),
(90, 'MMK', 'Kyat', '#'),
(91, 'MNT', 'Tugrik', '?'),
(92, 'MOP', 'Pataca', '#'),
(93, 'MRO', 'Ouguiya', '#'),
(94, 'MUR', 'Mauritius Rupee', '?'),
(95, 'MVR', 'Rufiyaa', '#'),
(96, 'MWK', 'Kwacha', '#'),
(97, 'MXN MXV', 'Mexican Peso Mexican Unidad de Inversion (UDI)', '$'),
(98, 'MYR', 'Malaysian Ringgit', 'RM'),
(99, 'MZN', 'Metical', 'MT'),
(100, 'NGN', 'Naira', '?'),
(101, 'NIO', 'Cordoba Oro', 'C$'),
(102, 'NOK', 'Norwegian Krone', 'kr'),
(103, 'NPR', 'Nepalese Rupee', '?'),
(104, 'NZD', 'New Zealand Dollar', '$'),
(105, 'OMR', 'Rial Omani', '?'),
(106, 'PAB USD', 'Balboa US Dollar', 'B/.'),
(107, 'PEN', 'Nuevo Sol', 'S/.'),
(108, 'PGK', 'Kina', '#'),
(109, 'PHP', 'Philippine Peso', 'Php'),
(110, 'PKR', 'Pakistan Rupee', '?'),
(111, 'PLN', 'Zloty', 'zł'),
(112, 'PYG', 'Guarani', 'Gs'),
(113, 'QAR', 'Qatari Rial', '?'),
(114, 'RON', 'New Leu', 'lei'),
(115, 'RSD', 'Serbian Dinar', '???.'),
(116, 'RUB', 'Russian Ruble', '???'),
(117, 'RWF', 'Rwanda Franc', '#'),
(118, 'SAR', 'Saudi Riyal', '?'),
(119, 'SBD', 'Solomon Islands Dollar', '$'),
(120, 'SCR', 'Seychelles Rupee', '?'),
(121, 'SDG', 'Sudanese Pound', '#'),
(122, 'SEK', 'Swedish Krona', 'kr'),
(123, 'SGD', 'Singapore Dollar', '$'),
(124, 'SHP', 'Saint Helena Pound', 'L'),
(125, 'SLL', 'Leone', '#'),
(126, 'SOS', 'Somali Shilling', 'S'),
(127, 'SRD', 'Surinam Dollar', '$'),
(128, 'STD', 'Dobra', '#'),
(129, 'SVC USD', 'El Salvador Colon US Dollar', '$'),
(130, 'SYP', 'Syrian Pound', 'L'),
(131, 'SZL', 'Lilangeni', '#'),
(132, 'THB', 'Baht', '?'),
(133, 'TJS', 'Somoni', '#'),
(134, 'TMT', 'Manat', '#'),
(135, 'TND', 'Tunisian Dinar', '#'),
(136, 'TOP', 'Pa\'anga', '#'),
(137, 'TRY', 'Turkish Lira', 'TL'),
(138, 'TTD', 'Trinidad and Tobago Dollar', 'TT$'),
(139, 'TWD', 'New Taiwan Dollar', 'NT$'),
(140, 'TZS', 'Tanzanian Shilling', '#'),
(141, 'UAH', 'Hryvnia', '?'),
(142, 'UGX', 'Uganda Shilling', '#'),
(143, 'USD', 'US Dollar', '$'),
(144, 'UYU UYI', 'Peso Uruguayo Uruguay Peso en Unidades Indexadas', '$U'),
(145, 'UZS', 'Uzbekistan Sum', '??'),
(146, 'VEF', 'Bolivar Fuerte', 'Bs'),
(147, 'VND', 'Dong', '?'),
(148, 'VUV', 'Vatu', '#'),
(149, 'WST', 'Tala', '#'),
(150, 'XAF', 'CFA Franc BEAC', '#'),
(151, 'XAG', 'Silver', '#'),
(152, 'XAU', 'Gold', '#'),
(153, 'XBA', 'Bond Markets Units European Composite Unit (EURCO)', '#'),
(154, 'XBB', 'European Monetary Unit (E.M.U.-6)', '#'),
(155, 'XBC', 'European Unit of Account 9(E.U.A.-9)', '#'),
(156, 'XBD', 'European Unit of Account 17(E.U.A.-17)', '#'),
(157, 'XCD', 'East Caribbean Dollar', '$'),
(158, 'XDR', 'SDR', '#'),
(159, 'XFU', 'UIC-Franc', '#'),
(160, 'XOF', 'CFA Franc BCEAO', '#'),
(161, 'XPD', 'Palladium', '#'),
(162, 'XPF', 'CFP Franc', '#'),
(163, 'XPT', 'Platinum', '#'),
(164, 'XTS', 'Codes specifically reserved for testing purposes', '#'),
(165, 'YER', 'Yemeni Rial', '?'),
(166, 'ZAR', 'Rand', 'R'),
(167, 'ZAR LSL', 'Rand Loti', '#'),
(168, 'ZAR NAD', 'Rand Namibia Dollar', '#'),
(169, 'ZMK', 'Zambian Kwacha', '#'),
(170, 'ZWL', 'Zimbabwe Dollar', '#');

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_date_formats`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_date_formats`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_date_formats` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(45) DEFAULT NULL,
  `dateFormat` varchar(45) DEFAULT NULL,
  `calendarFormat` varchar(45) DEFAULT NULL,
  `defaultDateValue` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_date_formats`
--

INSERT INTO `#__jbusinessdirectory_date_formats` (`id`, `name`, `dateFormat`, `calendarFormat`, `defaultDateValue`) VALUES
(1, 'y-m-d', 'Y-m-d', '%Y-%m-%d', '0000-00-00'),
(2, 'd-m-y', 'd-m-Y', '%d-%m-%Y', '00-00-0000'),
(3, 'm/d/y', 'm/d/Y', '%m/%d/%Y', '00-00-0000');

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_default_attributes`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_default_attributes`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_default_attributes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(55) DEFAULT NULL,
  `listing_config` tinyint(1) DEFAULT NULL,
  `offer_config` tinyint(1) DEFAULT NULL,
  `event_config` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=68 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_default_attributes`
--

INSERT INTO `#__jbusinessdirectory_default_attributes` (`id`, `name`, `listing_config`, `offer_config`, `event_config`) VALUES
(2, 'comercial_name', 3, -1, -1),
(3, 'tax_code', 3, -1, -1),
(4, 'registration_code', 3, -1, -1),
(5, 'website', 2, -1, -1),
(6, 'type', 1, 2, 2),
(7, 'slogan', 2, -1, -1),
(8, 'description', 1, 1, 1),
(9, 'keywords', 2, -1, -1),
(10, 'category', 1, 1, 1),
(11, 'logo', 1, -1, -1),
(12, 'street_number', 1, 1, 1),
(13, 'address', 1, 1, 1),
(14, 'city', 1, 1, 1),
(15, 'region', 1, 1, 1),
(16, 'country', 1, 1, 1),
(17, 'postal_code', 1, 1, 1),
(18, 'map', 1, 1, 1),
(20, 'phone', 1, -1, 1),
(21, 'mobile_phone', 2, -1, -1),
(22, 'fax', 3, -1, -1),
(23, 'email', 1, -1, 1),
(24, 'pictures', 2, 2, 2),
(25, 'video', 2, 2, 2),
(26, 'social_networks', 2, -1, -1),
(27, 'short_description', 2, 2, 2),
(28, 'contact_person', 2, -1, -1),
(29, 'attachments', 2, 2, 2),
(30, 'custom_tab', 2, -1, -1),
(31, 'cover_image', 2, -1, -1),
(32, 'opening_hours', 2, -1, -1),
(33, 'metadata_information', 2, 2, 2),
(34, 'publish_dates', 3, -1, -1),
(35, 'province', 2, 2, 2),
(36, 'area', 2, 2, 2),
(37, 'sounds', 2, 2, -1),
(38, 'establishment_year', 2, -1, -1),
(39, 'employees', 2, -1, -1),
(40, 'services_list', 2, -1, -1),
(41, 'testimonials', 2, -1, -1),
(42, 'ad_images', 3, -1, -1),
(43, 'price_text', -1, 2, -1),
(44, 'related_listing', 2, -1, -1),
(45, 'radius', 2, -1, -1),
(46, 'associated_listings', -1, -1, 2),
(47, 'age', -1, -1, 2),
(48, 'attendance', -1, -1, 2),
(49, 'coupons', -1, 2, -1),
(50, 'zip_codes', 3, -1, -1),
(51, 'business_team', 2, -1, -1),
(52, 'price', -1, -1, 2),
(53, 'enable_subscription', -1, -1, 2),
(54, 'total_tickets', -1, -1, 2),
(55, 'time_zone', -1, -1, 2),
(56, 'booking_dates', -1, -1, 2),
(57, 'address_autocomplete', 2, -1, -1),
(58, 'publish_only_city', 3, -1, -1),
(59, 'facebook', 2, -1, -1),
(60, 'twitter', 2, -1, -1),
(61, 'linkedin', 2, -1, -1),
(62, 'skype', 2, -1, -1),
(63, 'instagram', 2, -1, -1),
(64, 'pinterest', 2, -1, -1),
(65, 'whatsapp', 2, -1, -1),
(66, 'youtube', 2, -1, -1),
(67, 'custom_gallery', 3, -1, -1);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_directory_apps`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_directory_apps`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_directory_apps` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `app_name` varchar(255) DEFAULT NULL,
  `description` text,
  `icon` varchar(50) DEFAULT '',
  `store_link` varchar(255) DEFAULT '',
  `doc_link` varchar(255) DEFAULT '',
  `version` varchar(50) DEFAULT NULL,
  `required_version` varchar(50) DEFAULT NULL,
  `type` tinyint(4) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_type` (`type`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_directory_apps`
--

INSERT INTO `#__jbusinessdirectory_directory_apps` (`id`, `name`, `app_name`, `description`, `icon`, `store_link`, `doc_link`, `version`, `required_version`, `type`) VALUES
(1, 'JBD Appointments', 'JBD Appointments', 'Allows the possibility to define business services and book them online', 'directoryApps/service_booking.png', 'https://www.cmsjunkie.com/joomla-business-directory/jbd-appointments', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-appointments', NULL, '2.3.0', 1),
(2, 'JBD Event Bookings', 'JBD Event Bookings', 'Allows the possibility to create and book tickets for events', 'directoryApps/event_ticket_reservation.png', 'https://www.cmsjunkie.com/joomla-business-directory/jbd-event-booking', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#event-booking', NULL, '2.2.0', 1),
(3, 'JBD Event Appointments', 'JBD Event Appointments', 'Allows the possibility to define event appointments and book them online', 'directoryApps/event_appointment.png', 'https://www.cmsjunkie.com/joomla-business-directory/jbd-event-appointments', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#event-appointment', NULL, '1.2.1', 1),
(4, 'JBD Recurring Events', 'JBD Recurring Events', 'Allows the possibility to have recurring events', 'directoryApps/recurring_events.png', 'https://www.cmsjunkie.com/joomla-business-directory/jbd-recurring-events', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-recurring-events', NULL, '1.3.0', 1),
(5, 'JBD Sell Offers', 'JBD Sell Offers', 'Allows the possibility to sell offers online', 'directoryApps/offer_selling.png', 'https://www.cmsjunkie.com/joomla-business-directory/jbd-sell-offers', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#offer-selling', NULL, '2.2.0', 1),
(6, 'JBD Conference', 'JBD Conference', 'Adds the possibility of creating conferences, sessions and speakers', 'directoryApps/conference.png', 'https://www.cmsjunkie.com/joomla-business-directory/jbd-conference', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-conference', NULL, '2.1.1', 1),
(7, 'JBD Paypal Subscriptions', 'JBD PayPal Subscriptions', 'Provides the possibility of having PayPal subscriptions', 'directoryApps/paypal.png', 'https://www.cmsjunkie.com/joomla-business-directory/jbd-paypal-subscriptions', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-paypal-subscriptions', NULL, '2.1.0', 1),
(8, 'JBD Stripe', 'JBD Stripe', 'Provides the possibility to receive payments using Stripe payment gateway', 'directoryApps/stripe.png', 'https://www.cmsjunkie.com/joomla-business-directory/jbd-stripe', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-stripe', NULL, '1.3.0', 1),
(9, 'JBD Stripe Subscriptions', 'JBD Stripe Subscriptions', 'Enables the receiving of a recurring payment through Stripe Subscriptions', 'directoryApps/stripe_subscription.png', 'https://www.cmsjunkie.com/joomla-business-directory/jbd-stripe-subscriptions', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-stripe-subscription', NULL, '2.1.0', 1),
(10, 'J-CategoryBanners', 'J-CategoryBanners', 'Links Joomla banners with directory categories', 'directoryApps/j_category_banners.png', 'https://www.cmsjunkie.com/joomla-business-directory/j-categorybanners', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#j-categorybanners', NULL, '1.1.0', 2),
(11, 'J-BusinessDirectory Content', 'J-BusinessDirectory Content', 'Allows the site administrator and the business owners to create articles that will be associated with business listings', 'directoryApps/jbd_content_plugin.png', 'https://www.cmsjunkie.com/joomla-business-directory/jbd-content-plugin', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#j-businessdirectory-content-plugin', NULL, '2.0.0', 2),
(12, 'JBD Payfast Subscriptions', 'JBD Payfast Subscriptions', 'Provides the possibility of having Payfast recurring payments.', 'directoryApps/payfastsubscription.png', 'https://www.cmsjunkie.com/joomla-business-directory/jbd-payfast-subscriptions', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-payfast-subscription', NULL, '1.2.0', 1),
(13, 'J-BusinessDirectory Maps', 'J-BusinessDirectory Maps', 'Joomla map module that displays business listing on a map', 'directoryApps/jbd_maps.png', 'https://www.cmsjunkie.com/j-businessdirectory-map-module', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-maps', NULL, '1.1.0', 2),
(14, 'JBusinessDirectory - Locations', 'JBusinessDirectory - Locations', 'Joomla module that allows you to provide some quick links for your visitors, for the regions and the cities of your directory.', 'directoryApps/jbd_locations.png', 'https://www.cmsjunkie.com/j-businessdirectory-locations-module', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-locations', NULL, '1.1.0', 2),
(15, 'JBusinessDirectory - Reviews', 'JBusinessDirectory - Reviews', 'Display reviews based on the selected criterias and options', 'directoryApps/jbd_reviews.png', 'https://www.cmsjunkie.com/j-businessdirectory-reviews', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-reviews', NULL, '1.1.0', 2),
(16, 'Smart Search - Offers Finder', 'Smart Search - Offers Finder', 'Smart Search - finder plugin for indexing offers of J-BusinessDirectory extension.', 'directoryApps/jbd_finder_offers.png', 'https://www.cmsjunkie.com/j-businessdirectory-offer-finder-plugin', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-finder-offers', NULL, '1.1.0', 2),
(17, 'Smart Search - Events Finder', 'Smart Search - Events Finder', 'Smart Search - finder plugin for indexing events of J-BusinessDirectory extension', 'directoryApps/jbd_finder_events.png', 'https://www.cmsjunkie.com/j-businessdirectory-events-finder-plugin', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-finder-events', NULL, '1.1.0', 2),
(18, 'Smart Search - Business Listings Finder', 'Smart Search - Business Listings Finder', 'Smart Search - finder plugin for indexing busines listings of J-BusinessDirectory extension', 'directoryApps/jbd_finder_listings.png', 'https://www.cmsjunkie.com/j-businessdirectory-listing-finder-plugin', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-finder-listings', NULL, '1.1.0', 2),
(19, 'JBusinessDirectory Offer Search', 'JBusinessDirectory Offer Search', 'Joomla! plugin which allows you to search for J-BusinessDirectory offers and categories with the Joomla Search component.', 'directoryApps/jbd_search_offers.png', 'https://www.cmsjunkie.com/j-businessdirectory-offers-search-plugin', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-search-offers', NULL, '1.1.0', 2),
(20, 'JBusinessDirectory Event Search', 'JBusinessDirectory Event Search', 'Joomla! plugin which allows you to search for J-BusinessDirectory events and categories with the Joomla Search component.', 'directoryApps/jbd_search_events.png', 'https://www.cmsjunkie.com/j-businessdirectory-events-search-plugin', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-search-events', NULL, '1.1.0', 2),
(21, 'JBusinessDirectory Listing Search', 'Search - Business Listings', 'Joomla! plugin which allows you to search for J-BusinessDirectory listings and categories with the Joomla Search component.', 'directoryApps/jbd_search_listings.png', 'https://www.cmsjunkie.com/j-businessdirectory-listing-search-plugin', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-search-listings', NULL, '1.1.0', 2),
(22, 'JBD Campaigns', 'JBD Campaigns', 'Allows the possibility to create paid campaigns for businesses', 'directoryApps/jbd_campaigns.png', 'https://www.cmsjunkie.com/joomla-business-directory/jbd-campaigns', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-campaigns', NULL, '1.3.2', 1),
(23, 'JBD Authorize', 'JBD Authorize', 'Provides the possibility to receive payments using the Authorize.net payment gateway.', 'directoryApps/jbd_authorize.png', 'https://www.cmsjunkie.com/joomla-business-directory/jbd-authorize', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-authorize', NULL, NULL, 1),
(24, 'JBD Authorize Subscriptions', 'JBD Authorize Subscriptions', 'Provides the possibility to receive recurring payments using the Authorize.net payment gateway.', 'directoryApps/jbd_authorize_subscriptions.png', 'https://www.cmsjunkie.com/joomla-business-directory/jbd-authorize-subscription', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-authorize-subscription', NULL, NULL, 1),
(25, 'JBD Quote Requests', 'JBD Quote Requests', 'Allows users to request quotes about different categories to business owners', 'directoryApps/jbd_quote_requests.png', 'https://www.cmsjunkie.com/joomla-business-directory/jbd-quote-requests', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-quote-requests', NULL, '1.5.3', 1),
(26, 'JBD Mercado Pago', 'JBD Mercado Pago', 'JBD Mercado Pago payment methdo', 'directoryApps/jbd_mercado_pago.png', 'https://www.cmsjunkie.com/joomla-business-directory/jbd-mercado-pago', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-mercado-pago', NULL, '1.0.0', 1),
(28, 'JBD Trips', 'JBD Trips', 'JBD Trips application', 'directoryApps/jbd_trips.png', 'https://www.cmsjunkie.com/joomla-business-directory/jbd-trips', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-trips', NULL, '1.0.0', 1),
(27, 'JBD Trips', 'JBD Trips', 'JBD Trips application', 'directoryApps/jbd_trips.png', 'https://www.cmsjunkie.com/joomla-business-directory/jbd-trips', 'https://www.cmsjunkie.com/docs/jbusinessdirectory/directoryapps.html#jbd-trips', NULL, NULL, 1);

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_discounts`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_discounts`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_discounts` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `name` char(255) DEFAULT NULL,
  `start_date` date NOT NULL,
  `end_date` date NOT NULL,
  `value` decimal(6,2) NOT NULL DEFAULT '0.00',
  `percent` tinyint(1) NOT NULL DEFAULT '0',
  `price_type` tinyint(1) NOT NULL DEFAULT '1',
  `package_ids` varchar(255) DEFAULT NULL,
  `code` varchar(50) NOT NULL DEFAULT '0',
  `state` tinyint(1) NOT NULL DEFAULT '1',
  `uses_per_coupon` int(11) DEFAULT NULL,
  `coupon_used` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_code` (`code`),
  KEY `idx_state` (`state`),
  KEY `idx_date` (`end_date`,`start_date`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

-- --------------------------------------------------------

--
-- Table structure for table `#__jbusinessdirectory_emails`
--

DROP TABLE IF EXISTS `#__jbusinessdirectory_emails`;
CREATE TABLE IF NOT EXISTS `#__jbusinessdirectory_emails` (
  `email_id` int(10) NOT NULL AUTO_INCREMENT,
  `email_subject` char(255) DEFAULT NULL,
  `email_name` char(255) DEFAULT NULL,
  `email_type` varchar(255) DEFAULT NULL,
  `email_content` blob NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `send_to_admin` tinyint(1) DEFAULT '1',
  PRIMARY KEY (`email_id`),
  KEY `idx_type` (`email_type`),
  KEY `idx_status` (`status`)
) ENGINE=MyISAM AUTO_INCREMENT=65 DEFAULT CHARSET=utf8;

--
-- Dumping data for table `#__jbusinessdirectory_emails`
--

INSERT INTO `#__jbusinessdirectory_emails` (`email_id`, `email_subject`, `email_name`, `email_type`, `email_content`, `status`, `send_to_admin`) VALUES
(2, 'A new review has been posted for your business listing', 'Review Email', 'Review Email', 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, 1, 1),
(3, 'Your review has received a response', 'Review Response Email', 'Review Response Email', 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, 1, 1),
(4, 'Payment Receipt from [company_name]', 'Order E-mail', 'Order Email', 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