<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMS Junkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

?>

<div id="videos-list-view" class="videos-list-view">
    <div class="row">
	    <?php foreach ($this->videos as $video) {?>
            <div class="col-md-4 mt-3">
                <a class="card-video" href="<?php echo JBusinessUtil::getVideoLink($video) ?>">
                    <div class="card-video-wrap">
                        <!--video class="video" src="<?php echo $video->url ?>" type="video/mp4" poster="<?php echo !empty($video->thumbnail) ? BD_PICTURES_PATH.$video->thumbnail  : BD_PICTURES_PATH.'/video_default.jpg' ?>" ></video -->
                        <img src="<?php echo !empty($video->thumbnail) ? BD_PICTURES_PATH.$video->thumbnail  : BD_PICTURES_PATH.'/video_default.jpg' ?>" />
                        <div class="play-pause">
                            <i class="la la-play"></i>
                        </div>
                    </div>
                    <div class="card-video-title">
                        <div class="video-btn video-category" style="color: <?php echo $video->cat_color?>; background:<?php echo JBusinessUtil::convertHexToRGB($video->cat_color,".2")?>">
                            <?php echo $video->mainSubcategoryName ?>
                        </div>
                        <div class="video-duration d-flex justify-content-around">
                            <i class="icon time"></i>
                            <div class="video-duration-time"><?php echo $video->duration ." ". JText::_("LNG_MIN")?> </div>
                        </div>
                    </div>

                    <div class="card-video-text">
                        <?php echo $video->name ?>
                    </div>
                </a>
            </div>
	    <?php } ?>
    </div>
</div>
