<?php // no direct access
/**
 * @copyright	Copyright (C) 2008-2009 CMSJunkie. All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.module.helper');
// this is where you want to load your module position
$modules = JModuleHelper::getModules("video-listings");


$base_url = ( isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']=='on' ? 'https' : 'http' ) . '://' .  $_SERVER['HTTP_HOST'];
$url = $base_url . $_SERVER["REQUEST_URI"];
$config = JBusinessUtil::getSiteConfig();

$appSettings = JBusinessUtil::getApplicationSettings();

$title = stripslashes($this->video->name)." | ".$config->sitename;
if(!empty($this->video->meta_title)){
    $title = stripslashes($this->video->meta_title)." | ".$config->sitename;
}

$description = $appSettings->meta_description;
if(!empty($this->video->description)){
    $description = htmlspecialchars(strip_tags($this->video->description), ENT_QUOTES);
}else if(!empty($this->video->transcript)){
    $description = htmlspecialchars(JBusinessUtil::truncate(strip_tags($this->video->transcript),150), ENT_QUOTES);
}
if(!empty($this->video->meta_description)){
    $description = $this->video->meta_description;
}

$keywords = $appSettings->meta_keywords;
if(!empty($this->video->meta_keywords)){
    $keywords = $this->video->meta_keywords;
}

$picturePath = "";
if(!empty($this->video->thumbnail)){
    $picturePath = $this->video->thumbnail;
}
    
JBusinessUtil::setMetaData($title, $description, $keywords, false);
JBusinessUtil::setFacebookMetaData($title, $description, $picturePath, $url);

$videoUrl = JBusinessUtil::getVideoLink($this->video);
JBusinessUtil::setCanonicalURL($videoUrl);


?>

<div id="jbd-container" class="jbd-container">
	<div class="video-details">
		<div class="video-wrap ibg">
			<iframe src="<?php echo $this->video->url ?>" frameborder="0" allow="accelerometer; autoplay; clipboard-write; encrypted-media; gyroscope; picture-in-picture" allowfullscreen></iframe>
		</div>

		<div class="video-title">
			<?php echo $this->video->name ?>
		</div>

		<?php if(!empty( $this->video->description) && false){ ?>
			<div class="video-content">
				<?php echo $this->video->description ?>
			</div>
		<?php } ?>
		
		<?php if(!empty($this->video->transcript)) { ?>
			<div class="video-content">
				<div class="video-box" >
					<span ><?php echo JText::_("LNG_VIDEO_TRANSCRIPT"); ?></span>
					<span class="accordion-plus"></span>
				</div>
				<div class="video-description" style="display: none">
					<p>
						<?php echo $this->video->transcript ?>
					</p> 
				</div>
			</div>
		<?php } ?>
	</div>

	<?php if(!empty($modules)) { ?>
		<div class="video-listings">
			<?php
				foreach($modules as $module) {
					echo JModuleHelper::renderModule($module);
				} 
			?>
		</div>
	<?php } ?>

	<?php if(!empty($this->relatedVideos)){ ?>
		<div class="related-videos videos-list-view">
			<div class="row">
				<div class="col-12">
					<h3><?php echo JText::_("LNG_RELATED_VIDEOS") ?></h3>
				</div>
			</div>
			<div id="related-videos">
				<?php require_once "default_related.php"; ?>
			</div>
			
			<?php if(count($this->relatedVideos)==7){ ?>
				<div id="load-more-btn" class="row">
					<div class="col-12 text-center mt-4">
						<button type="button" class="btn btn-outline-primary p-3" onclick="jbdVideos.loadMore()" /><?php echo JText::_("LNG_LOAD_MORE")?></button>
					</div>
				</div>
				<input type="hidden" id="start" value="6"/>
				<input type="hidden" id="main-catetegory" value="<?php echo $this->video->main_subcategory?>"/>
				<input type="hidden" id="video-id" value="<?php echo $this->video->id ?>"/>
			<?php } ?>
		</div>
	<?php } ?>
</div>


<script>

jQuery(".video-box").on("click", function() {
	jQuery(this).siblings(".video-description").toggle(300);
	jQuery(this).children(".accordion-plus").toggleClass('without-before-element'); 
})

</script>
				
