<?php // no direct accesss
/**
* @copyright	Copyright (C) 2008-2009 CMSJunkie. All rights reserved.
* 
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
* See the GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

defined('_JEXEC') or die('Restricted access');
$user = JBusinessUtil::getUser();
$menuItemId = JBusinessUtil::getActiveMenuItem();
$orderId = $this->state->get("payment.orderId");

$ssl = 0;
if ($this->appSettings->enable_https_payment) {
	$ssl = 1;
}

if ($user->id == 0) {
    $app = JFactory::getApplication();
    $return = 'index.php?option=com_jbusinessdirectory&view=billingoverview';
    $app->redirect(JBusinessUtil::getLoginUrl($return, false));
}

if (empty($this->order) || $this->order->company_id != -1 && $this->order->company->userId != $user->id) {
    $app = JFactory::getApplication();
    $app->redirect('index.php?option=com_jbusinessdirectory&view=billingoverview');
}

?>
<div id="payment-details" class="jbd-container listing-payment-container">

	<div class="page-header">
		<h1> <?php echo JText::_('LNG_PAYMENT_DETAILS');?></h2>
		<p><?php echo JText::_('LNG_PAYMENT_DETAILS_TXT');?></p>
	</div>
	
	<form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=payment', false, $ssl); ?>" method="post" name="discount-form" id="discount-form" >
		<div class="row justify-content-center mb-3">
			<div class="col-md-5 ">
				<div class="jitem-card card-plain card-round horizontal ">
					<?php echo OrderService::getOrderSummary($this->order); ?>
				</div>
			</div>

			<div class="col-md-4">
				<div class="jitem-card card-plain card-round horizontal">
					<?php echo OrderService::getOrderBillingDetailsSummary($this->order); ?>
					<div class="billing-item">
						<a class="mt-2" href="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=billingdetails&layout=edit' . $menuItemId . '&orderId=' . $orderId ) ?>"><?php echo JText::_("LNG_BILLING_DETAILS_EDIT") ?></a>
					</div>
				</div>
			</div>
        </div>

		<?php if ($this->appSettings->show_apply_discount){ ?>
			<div class="row justify-content-center">
				<div class="col-12 col-md-6 mb-3">
						<div class="discount-container">
							<div class="discount-title"><?php echo JText::_('LNG_DISCOUNT_TXT');?></div>
							<div class="input-group">
								<input type="text" size="40" placeholder="<?php echo JText::_('LNG_COUPON');?>" style="max-width: 75%" value="<?php echo !empty($this->order->discount)?$this->order->discount->code:"" ?>" name="discount_code" id="discount_code" class="form-control">
								
								<button type="submit" class="btn btn-success">
									<span class="ui-button-text"><?php echo JText::_("LNG_APPLY")?></span>
								</button>
							</div>
					</div>
				</div>
			</div>
		<?php } ?>
		
		<input type="hidden" name="orderId" value="<?php echo $this->state->get("payment.orderId")?>" /> 
		<input type="hidden" name="task" value="payment.applyDiscount" />  
		<input type="hidden" name="option" value="<?php echo JBusinessUtil::getComponentName()?>" /> 
	</form>

	<div class="payment-container text-center">
		<form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=payment&layout=redirect', false, $ssl); ?>" method="post" name="payment-form" id="payment-form" >
			<?php if (!empty($orderId)) { ?>
				<div class="row justify-content-center">
					<div class="col-md-8 col-lg-7">
						<div class="payment-methods">
							<div class="payment-title"><?php echo JText::_("LNG_PAYMENT_METHODS")?></div>
							<?php if ($this->order->amount > 0 || ($this->order->package->expiration_type == 4 && $this->order->package->price > 0)) { ?>
								<div class="methods-title">
									<?php foreach ($this->paymentMethods as $method) { ?>
										<label class="payment-method">
											<span class=""><input id="p_method_<?php echo $method->type ?>" value="<?php echo $method->type ?>" type="radio" name="payment_method" onclick="switchMethod('<?php echo $method->type ?>')" class="radio validate[required]" /></span>
											<img class="payment-icon" src="<?php echo BD_ASSETS_FOLDER_PATH."images/payment/".strtolower($method->type).'.gif' ?>"  />
											<span><?php echo $method->name ?> </span>
									</label>
									<?php } ?>
								</div>
								<div class="method-descriptions">
									<?php foreach ($this->paymentMethods as $method) { ?>
										<?php if ($html = $method->getPaymentProcessorHtml($this->order)) { ?>
											<div class="method-description payment_form_<?php echo $method->type ?>">
												<?php echo $html; ?>
											</div>
										<?php } ?>
									<?php } ?>
								</div>
							<?php } else {?>
								<div><?php echo JText::_("LNG_NO_PAYMENT_INFO_REQUIRED")?></div><br/><br/>
							<?php } ?>
						</div>
					</div>
				</div>
			<?php } ?>
			
			<input type="hidden" name="orderId" value="<?php echo $this->state->get("payment.orderId")?>" /> 
			<input type="hidden" name="companyId" value="<?php echo $this->companyId?>" /> 
			<input type="hidden" name="option" value="<?php echo JBusinessUtil::getComponentName()?>" /> 
			<input type="hidden" name="task" value="payment.processTransaction" />
			<input type="hidden" name="discount_code" value="<?php echo !empty ($this->order->discount) ? $this->order->discount->code : "" ?>" />
			
			<button type="submit" class="btn btn-success" id="payment-submit">
				<?php echo JText::_("LNG_CONTINUE")?> <i class="la la-angle-double-right"></i>
			</button>
		</form>
	</div>
</div>

<script>

	window.addEventListener('load', function(){
		jQuery("#payment-form").validationEngine('attach');
		jQuery(".payment-method").click(function(){
			jQuery(".payment-method").removeClass("active");
			jQuery(this).addClass("active");
		});
		
		<?php if(count($this->paymentMethods)==1){ ?>
			<?php $pMethod = reset($this->paymentMethods); ?>
			switchMethod("<?php echo $pMethod->type ?>");
		<?php } ?>

		jQuery("#payment-submit").click(function(){
			//jQuery(this).addClass('loader')
			//jQuery(this).attr('disabled','disabled');
		});
		

	});

	function switchMethod(method){
		jQuery(".method-description").hide();
		jQuery(".payment_form_"+method).show();
		jQuery("#payment_form_"+method).show();
		jQuery("#p_method_"+method).prop('checked', true);
		jQuery("#payment-submit").removeClass('loader');
		

		if (method == "stripeprocessor") {
			stripeProcessorHook();
		}

		if (method == "stripesubscriptions") {
			stripeSubscriptionsHook();
		}
		
		if (method == "mercadopagoprocessor") {
			mercadoPagoHook();
		}
	}

</script>