<?php 
$appSettings = JBusinessUtil::getApplicationSettings();

if (!isset($customAttributes)) {
    $customAttributes = $this->customAttributes;
}

if (!isset($packageFeatures)) {
    $packageFeatures = $this->packageFeatures;
}

//todo establish if this is needed anymore
if (!isset($packages) && isset($this->packages)) {
    $packages = $this->packages;
}

$price = $package->price + floatval($appSettings->vat)*$package->price/100;

$style="";
if(!empty($package->bg_color)){
    $style.="background:".$package->bg_color.";";
}
if(!empty($package->text_color)){
    $style.="color:".$package->text_color.";";
}
if(!empty($package->border_color)){
    $style.="border-color: ".$package->border_color.";";
}

if($package->popular){
    //$style.="transform: scaleY(1.1)";
}
?>

<?php if(!$package->show_disable_features){?>
<style>
	#jpackage-<?php echo $package->id  ?> .jpackage-feature-disabled{
		display:none;
	}
</style>
<?php } ?>

<div id="jpackage-<?php echo $package->id  ?>" class="jpackage <?php echo !empty($package->popular)?"jpackage-highlight":""?>" style="<?php echo $style ?>" onclick="javascript:selectPackage(<?php echo $package->id?>, <?php echo $package->package_type?>)">
	<div class="jpackage-wrap">
    	<div class="jpackage-title">
    		<p><?php echo $package->name ?> </p>
    	</div>
    	<div class="jpackage-desc">
    		<p><?php echo $package->description ?></p>
    	</div>
    	<div class="jpackage-price">
    		<div class="jpackage-price-text">
				<?php echo $package->price == 0 ? JText::_("LNG_FREE"):JBusinessUtil::getHtmlPriceFormat($package->price) ?>
				<div class="jpackage-price-duration"> / <?php echo JBusinessUtil::getPackageDuration($package) ?></div>
			</div>
    	</div>

		<?php if(!empty(JBusinessUtil::getTrialText($package))){ ?>
			<div>
				<div class="jpackage-trial-text">
					<?php echo JBusinessUtil::getTrialText($package) ?>
				</div>
			</div>
		<?php } ?>

		<p class="jpackage-price-description">
			<?php echo $package->price_description ?>
		</p>

		<?php if (!empty($package->show_features)){ ?>
			<div class="jpackage-features">
				<?php
					foreach ($packageFeatures as $key => $featureName) {
						$class = "-disabled";
						if (isset($package->features) && in_array($key, $package->features)) {
							$class = " contained-feature";
						}
		
						$max = "";
						if($key == 'image_upload') {
							if(!empty($package->max_pictures)){
								$max = $package->max_pictures;
							}
							$class = !empty($package->max_pictures)?$class:"-disabled";
							
						}
						if($key == 'videos') {
							if(!empty($package->max_videos)){
								$max = $package->max_videos;
							}
							$class = !empty($package->max_videos)?$class:"-disabled";
							
						}
						if($key == 'company_offers') {
							if(!empty($package->max_offers)){
								$max = $package->max_offers;
							}
						}
		
						if($key == 'company_events') {
							if(!empty($package->max_events)){
								$max = $package->max_events;
							}
						}
						
						if($key == 'secondary_locations') {
							if(!empty($package->max_locations)){
								$max = $package->max_locations;
							}

							$class = !empty($package->max_locations)?$class:"-disabled";
						}

						if($key == 'attachments') {
							if(!empty($package->max_attachments)){
								$max = $package->max_attachments;
							}
							$class = !empty($package->max_attachments)?$class:"-disabled";
							
						}
						if($key == 'multiple_categories') {
							if ($package->package_type == PACKAGE_TYPE_USER) {
								continue;
							} else {
								if(!empty($package->max_categories)){
									$max = $package->max_categories;
								}
								$class = !empty($package->max_categories)?$class:"-disabled";
							}
						} 

						if($key == 'trips') {
							if ($package->package_type == PACKAGE_TYPE_BUSINESS) {
								continue;
							} else {
								if(!empty($package->max_trips)){
									$max = $package->max_trips;
								}
								$class = !empty($package->max_trips)?$class:"-disabled";
							}
						} 

						if($class=="-disabled"){
							$max="";
						}
					?>
						<p class="jpackage-feature<?php echo $class?>">
							<?php echo $featureName; ?> <?php echo !empty($max)?JTEXT::_("LNG_UP_TO")." ".$max:"" ?>
						</p>
				<?php } ?>
				
				<?php
				if ($appSettings->display_attributes_packages) {
					foreach ($customAttributes as $customAttribute) {
						if ($customAttribute->show_in_front == 0 || $customAttribute->attribute_type != ATTRIBUTE_TYPE_BUSINESS) {
							continue;
						}
						$class = "-disabled";
						if (isset($package->features) && in_array($customAttribute->code, $package->features)) {
							$class = " contained-feature";
						}
						?>
						<p class="jpackage-feature<?php echo $class ?>">
							<?php echo $customAttribute->name ?>
						</p>
					<?php }
				}
				?>
				
				<?php foreach($package->features as $feature){
					$class="-disabled";
					if(!array_key_exists($feature, $packageFeatures)){
						$found = false;
						foreach($customAttributes as $cFeature){
							if($cFeature->code==$feature){
								$found = true;
								break;
							}
						}
						if(!$found && !empty($feature)){?>
							<p class="jpackage-feature">
								<?php echo $feature?>
							</p>
						<?php }
					}
					?>
					
				<?php } ?>
			</div>
		<?php } ?>

		<?php if (!empty($package->show_buttons)){ ?>
			<div class="jpackage-footer">
				<a href="javascript:selectPackage(<?php echo $package->id?>, <?php echo $package->package_type?>)" class="jpackage-footer-btn">
					<?php echo ($package->expiration_type == 4)? JBusinessUtil::getTrialText($package,false) :JText::_("LNG_CHOOSE")?>
				</a>
			</div>
		<?php } ?>
    </div>
</div>

