<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');

$appSettings = JBusinessUtil::getApplicationSettings();
?>

<!-- layout -->
<div id="layout" class="jbd-grid-container offers-grid-style-2" <?php echo !$this->appSettings->offers_view_mode?'style="display: none"':'' ?>>
	<div class="row" itemscope itemtype="http://schema.org/OfferCatalog">
    	<?php 
    	if(!empty($this->offers)){
    	    $index=0;
    		foreach($this->offers as $index=>$offer){
                $index++;
    		?>
    		<div class="col-lg-4 col-sm-6 col-12">
        		<div class="card place-card h-100" itemscope itemprop="itemListElement" itemtype="http://schema.org/Offer">
        			<div class="place-card-body">
        				<a href="<?php echo $offer->link ?>" itemprop="image" itemscope itemtype="http://schema.org/ImageObject"></a>
        				<?php if(!empty($offer->picture_path) ){?>
        					<img title="<?php echo $offer->picture_title ?>" alt="<?php echo $offer->picture_info ?>" src="<?php echo BD_PICTURES_PATH.$offer->picture_path ?>" itemprop="">
        				<?php }else{ ?>
        					<img title="<?php echo $this->escape($offer->subject)?>" alt="<?php echo $this->escape($offer->subject)?>" src="<?php echo BD_PICTURES_PATH.'/no_image.jpg' ?>" itemprop="">
        				<?php } ?>
        				
        				<?php if(!empty($offer->featured)){ ?>
    						<div class="featured-text">
    	                        <?php echo JText::_("LNG_FEATURED")?>
                            </div>
    		  	  		<?php } ?>
                    
        				<div class="card-hoverable">
        					 <?php if (!empty($offer->company_name)) { ?>
                                <div class="offer-company" itemprop="offeredBy" itemscope itemtype="http://schema.org/Organization">
                                    <span><i class="la la-lg la-building la-fw"></i> <span itemprop="name"><?php echo $this->escape($offer->company_name) ?></span></span>
                                </div>
                            <?php } ?>
                            <?php if (!JBusinessUtil::emptyDate($offer->startDate) || !JBusinessUtil::emptyDate($offer->endDate)) { ?>
                                <div class="offer-dates">
                                    <i class="la la-calendar la-fw"></i>
                                    <?php
                                        echo JBusinessUtil::getDateGeneralShortFormat($offer->startDate) . " - " . JBusinessUtil::getDateGeneralShortFormat($offer->endDate);
                                    ?>
                                </div>
                            <?php } ?>
    
                            <div class="offer-price">
                                <?php if (!empty($offer->price)) { ?>
                                    <span class="<?php echo $offer->specialPrice>0 ?"old-price":"" ?>"><?php echo JBusinessUtil::getPriceFormat($offer->price, $offer->currencyId) ?></span>
                                <?php } ?>
                                <?php if (!empty($offer->specialPrice)) { ?>
                                    <span class="price red"><?php echo JBusinessUtil::getPriceFormat($offer->specialPrice, $offer->currencyId); ?></span>
                                <?php } ?>
                                <?php if (!empty($offer->specialPrice) && !empty($offer->price) && $offer->specialPrice < $offer->price) { ?>
                                    <br/>
                                    <span class="price"><?php echo JText::_('LNG_DISCOUNT') ?></span>
                                    <span class="price red"><?php echo JBusinessUtil::getPriceDiscount($offer->specialPrice, $offer->price) ?>
                                        %</span>
                                <?php } ?>
                            </div>
        				</div>
        			</div>
        			<div class="place-card-info">
        				<div class="place-card-info-title">
                            <h3>
                                <a href="<?php echo $offer->link ?>"><span itemprop="name"><?php echo $this->escape($offer->subject)?></span></a>
                            </h3>
        					<?php $time = JBusinessUtil::getRemainingtime($offer->endDate, $offer->time_zone); ?>
        					<?php if(!empty($time)){?>
                				<div class="offer-dates">
                                    <span><?php echo $time ?></span>
                                </div>
                            <?php } ?>

                            <div class="offer-price">
                                <div>
                                    <?php if(!empty($offer->specialPrice)){?>
                                        <span class="price"><?php echo JBusinessUtil::getPriceFormat($offer->specialPrice, $offer->currencyId); ?></span>
                                    <?php }?>

                                    <?php if(!empty($offer->price) ){ ?>
                                        <span class="price <?php echo $offer->specialPrice>0 ?"old-price":"" ?>"><?php echo JBusinessUtil::getPriceFormat($offer->price, $offer->currencyId) ?></span>
                                        <?php if(!empty($offer->specialPrice) && !empty($offer->price) && $offer->specialPrice < $offer->price){ ?>
                                            <span class="discount">(-<?php echo JBusinessUtil::getPriceDiscount($offer->specialPrice, $offer->price) ?>%)</span>	
                                        <?php } ?>
                                    <?php } ?>
                                </div>
                                
                                <?php if ($this->defaultAttributes["price_text"]!=ATTRIBUTE_NOT_SHOW) { ?>
                                    <div class="price-text-list">
                                        <?php if (!empty($offer->price_text)) { ?>
                                            <span class="price-text"><?php echo $offer->price_text ?></span>
                                        <?php }elseif (empty($offer->price) && empty($offer->specialPrice) && ($appSettings->show_offer_free)){ ?>
                                            <span class="price-text"><?php echo JText::_('LNG_FREE') ?></span>
                                        <?php } ?>
                                    </div>
                                <?php } ?>
                                <?php //echo OfferSellingService::getAddToCartBtn($offer) ?>
                            </div>
        				</div>
        			</div>
                </div>
      		</div>
       	<?php } ?>
    <?php } ?>
	</div>
</div>	
