<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');
$appSettings = JBusinessUtil::getApplicationSettings();

JBusinessUtil::enqueueScript('libraries/jquery/jquery.opacityrollover.js');

JBusinessUtil::enqueueStyle('libraries/magnific-popup/magnific-popup.css');
JBusinessUtil::enqueueScript('libraries/magnific-popup/jquery.magnific-popup.min.js');
JBusinessUtil::loadJQueryUI();

if ($appSettings->enable_reviews) {
	JBusinessUtil::enqueueScript('libraries/dropzone/dropzone.js');
	JBusinessUtil::enqueueStyle('libraries/dropzone/dropzone.css');
}

if ($appSettings->enable_ratings) {
	JBusinessUtil::enqueueScript('libraries/star-rating/star-rating.js');
	JBusinessUtil::enqueueStyle('libraries/star-rating/star-rating.css');
}


// following translations will be used in js
JText::script('LNG_PLEASE_SELECT_QUANTITY');
JText::script('LNG_ADDING_PRODUCT_TO_SHOPPING_CART');
JText::script('LNG_BAD');
JText::script('LNG_POOR');
JText::script('LNG_REGULAR');
JText::script('LNG_GOOD');
JText::script('LNG_GORGEOUS');
JText::script('LNG_NOT_RATED_YET');
JText::script('LNG_IMAGE_SIZE_WARNING');


JBusinessUtil::includeValidation();

class JBusinessDirectoryViewOffer extends JViewLegacy {
	public function __construct() {
		parent::__construct();
	}
	
	public function display($tpl = null) {
		$this->appSettings = JBusinessUtil::getApplicationSettings();
		$this->defaultAttributes = JBusinessUtil::getAttributeConfiguration(DEFAULT_ATTRIBUTE_TYPE_OFFER);
		$this->offer = $this->get('Offer');

        $this->cart = OfferSellingService::getCartData();
        
        if (empty($this->offer) || (isset($this->offer->state) && !$this->offer->state)) {
            $tpl="inactive";
        }else {
            $this->offerAttributes = $this->get('OfferAttributes');
            $this->reviews = $this->get('Reviews');
            if (!empty($this->reviews)) {
                $this->offer->review_score = JBusinessUtil::getReviewsAverageScore($this->reviews);
            } else {
                $this->offer->review_score = 0;
            }
            $this->reviewsStatistics = JBusinessUtil::getReviewsStatistics($this->reviews);
            $this->videos = $this->defaultAttributes['video'] != ATTRIBUTE_NOT_SHOW ? $this->get('OfferVideos') : array();
            $this->videos = array_slice($this->videos, 0, $this->appSettings->max_video);

            if ($this->appSettings->enable_multilingual) {
                JBusinessDirectoryTranslations::updateEntityTranslation($this->appSettings, TERMS_CONDITIONS_TRANSLATION);
                JBusinessDirectoryTranslations::updateEntityTranslation($this->appSettings, CONTACT_TERMS_CONDITIONS_TRANSLATION);
                JBusinessDirectoryTranslations::updateEntityTranslation($this->appSettings, REVIEWS_TERMS_CONDITIONS_TRANSLATION);
                JBusinessDirectoryTranslations::updateEntityTranslation($this->appSettings, PRIVACY_POLICY_TRANSLATION);
            }

            $user = JBusinessUtil::getUser();
            $this->allowReviewResponse = false;
            if (!empty($user->id) && ($user->authorise('core.admin') || $user->id == $this->offer->user_id || $user->id == $this->offer->company->userId)) {
                $this->allowReviewResponse = true;
            }

            $jinput = JFactory::getApplication()->input;
            $layout = $jinput->getString('layout');
            if (!empty($layout)) {
                $tpl = $layout;
                if ($layout == 'default') {
                    $tpl = null;
                }
            }
        }
		
		parent::display($tpl);
	}
}
