<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');

$lang = JBusinessUtil::getLanguageTag();
$key  = JBusinessUtil::loadMapScripts();

/**
 * Data for the markers consisting of a name, a LatLng and a zIndex for
 * the order in which these markers should display on top of each
 * other.
 */

$marker = 0;
if (!empty($this->offer->categoryMarker)) {
	$marker = BD_PICTURES_PATH. $this->offer->categoryMarker;
} else if (!empty($this->offer->company->categoryMarker)) {
	$marker = BD_PICTURES_PATH. $this->offer->company->categoryMarker;
}

$db = JFactory::getDBO();
if (!empty($this->offer->company->phone)) {
	$contentPhone = '<div class="info-phone"><i class="la la-phone"></i> ' . htmlspecialchars($this->offer->company->phone, ENT_QUOTES) . '</div>';
} else {
	$contentPhone = '';
}

if ($this->offer->item_type == OFFER_TYPE_OFFER) {
	$contentString =
		'<div class="info-box">' .
		'<div class="title">' . htmlspecialchars($this->offer->subject) . '</div>' .
		'<div class="info-box-content">' .
		'<div class="address" itemtype="http://schema.org/PostalAddress" itemscope="" itemprop="address">' .
		JBusinessUtil::getAddressText($this->offer) . '</div>' . $contentPhone .
		'</div>' .
		'<div class="info-box-image">' .
		(!empty($this->offer->pictures[0]->picture_path) ? '<img src="' . BD_PICTURES_PATH . (htmlspecialchars($this->offer->pictures[0]->picture_path, ENT_QUOTES)) . '" alt="' . $db->escape($this->offer->subject, ENT_QUOTES) . '">' : "") .
		'</div>' .
		'</div>';

	$itemLocations = array();
	$tmp = array();
	if (!empty($this->offer->latitude) && !empty($this->offer->longitude)) {
		$tmp['latitude'] = $this->offer->latitude;
		$tmp['longitude'] = $this->offer->longitude;
		$tmp['marker'] = $marker;
		$tmp['content'] = $contentString;
	}
} else {
	$contentString =
		'<div class="info-box">' .
		'<div class="title">' . htmlspecialchars($this->offer->company->name) . '</div>' .
		'<div class="info-box-content">' .
		'<div class="address" itemtype="http://schema.org/PostalAddress" itemscope="" itemprop="address">' .
		htmlspecialchars(JBusinessUtil::getAddressText($this->offer->company), ENT_QUOTES) . '</div>' . $contentPhone .
		'</div>' .
		'<div class="info-box-image">' .
		(!empty($this->offer->company->pictures[0]->picture_path) ? '<img src="' . BD_PICTURES_PATH . (htmlspecialchars($this->offer->company->pictures[0]->picture_path, ENT_QUOTES)) . '" alt="' . $db->escape($this->offer->company->name, ENT_QUOTES) . '">' : "") .
		'</div>' .
		'</div>';

	$itemLocations = array();
	$tmp = array();
	if (!empty($this->offer->company->latitude) && !empty($this->offer->company->longitude)) {
		$tmp['latitude'] = $this->offer->company->latitude;
		$tmp['longitude'] = $this->offer->company->longitude;
		$tmp['marker'] = $marker;
		$tmp['content'] = $contentString;
	}
}

$itemLocations[] = $tmp;
if ($this->offer->item_type == OFFER_TYPE_PRODUCT) {
	foreach ($this->offer->merchants as $merchant) {
		if (!empty($merchant->latitude) && !empty($merchant->longitude)) {
			$contentString =
				'<div class="info-box">' .
				'<div class="title">' . htmlspecialchars($merchant->name) . '</div>' .
				'<div class="info-box-content">' .
				'<div class="address" itemtype="http://schema.org/PostalAddress" itemscope="" itemprop="address">' .
				htmlspecialchars(JBusinessUtil::getAddressText($merchant), ENT_QUOTES) . '</div>' .
				'</div>' .
				'<div class="info-box-image">' .
				(!empty($merchant->pictures[0]->picture_path) ? '<img src="' . BD_PICTURES_PATH . (htmlspecialchars($merchant->pictures[0]->picture_path, ENT_QUOTES)) . '" alt="' . $db->escape($merchant->name, ENT_QUOTES) . '">' : "") .
				'</div>' .
				'</div>';

			$marker = 0;
			if (!empty($this->offer->categoryMarker)) {
				$marker = BD_PICTURES_PATH . $this->offer->categoryMarker;
			} else if (!empty($merchant->categoryMarker)) {
				$marker = BD_PICTURES_PATH . $merchant->categoryMarker;
			}

			$tmp['latitude'] = $merchant->latitude;
			$tmp['longitude'] = $merchant->longitude;
			$tmp['marker'] = $marker;
			$tmp['content'] = $contentString;
			$itemLocations[] = $tmp;
		}
	}
}

$params = array();
$params['map_div'] = 'offer-map-2';
if ($this->offer->item_type == OFFER_TYPE_OFFER) {
	$params['map_longitude'] = $this->offer->longitude;
	$params['map_latitude'] = $this->offer->latitude;
	$params["map_height"]="255px";
}else{
	$params['map_longitude'] = $this->offer->company->longitude;
	$params['map_latitude'] = $this->offer->company->latitude;
	$params["map_height"]="355px";
}
$params["map_clustering"]   = 0;
$params["map_zoom"]= ( float ) $appSettings->map_zoom;

if ($appSettings->map_type == MAP_TYPE_BING) {
	$params["key"] = $key;
}
?>

<div id="offer-map-2" style="position:relative;">
</div>

<script>
    var map_instance_offer_details;

    function loadOfferDetailsViewMap() {
        map_instance_offer_details = JBDMapHelper.loadMapScript(
		    <?php echo json_encode($itemLocations) ?>,
		    <?php echo json_encode($params) ?>,
		    <?php echo $appSettings->map_type ?>
        );
    }
</script>

<?php echo JBusinessUtil::getMapGDPRModal(); ?>