<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');
$user = JBusinessUtil::getUser();

$session = JFactory::getSession();
$menuItem = "&Itemid=".$session->get("offersMenuItemId");
$referer= isset($_SERVER['HTTP_REFERER'])?$_SERVER['HTTP_REFERER']:"";

$couponUrl = JRoute::_('index.php?option=com_jbusinessdirectory&task=offer.generateCoupon&id='.$this->offer->id);
if($this->appSettings->enable_offer_selling && $this->offer->enable_offer_selling != OFFER_SELLING_COUPON && !empty((float)$this->offer->specialPrice) && !empty((float)$this->offer->price)){
	$couponUrl = "javascript:onclick=jbdOffers.addToCart(".$this->offer->id.",1)";
}
?>

<div id="jbd-container" class="jbd-container">
	<div id="offer-detail-1" class="offer-details offer-details-1"  itemscope itemtype="http://schema.org/Offer">
		<div class="row">
			<?php if(!empty($referer) && false){ ?>
				<div class="col-3">
	    			<a href="<?php echo $referer ?>"><?php echo JText::_("BACK") ?></a>
	    		</div>
	    	<?php }else{ ?>
	    		<div class="col-3">
	    			<a href="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=offers&reload=1'.$menuItem); ?>"><?php echo JText::_("BACK_TO_OFFERS") ?></a>
	    		</div>
			<?php } ?>
    		<div class="col-9 text-right header-icons">
    			<?php require_once JPATH_COMPONENT_SITE."/include/social_share.php" ?>
        		<a class="print-icon" rel="nofollow" href="javascript:jbdUtils.printItem('<?php echo JRoute::_("index.php?option=com_jbusinessdirectory&view=offer&tmpl=component&action=print&offerId=".$this->offer->id); ?>')"><i class="icon print-circle"></i></a>
        		<?php if($this->appSettings->enable_bookmarks && $this->offer->item_type == OFFER_TYPE_OFFER) { ?>
                    <?php if(!empty($this->offer->bookmark)){?>
                        <!-- Business Bookmarks -->
                        <a id="bookmark-<?php echo $this->offer->id ?>" href="javascript:jbdUtils.showUpdateBookmarkDialog(<?php echo $user->id==0?"1":"0"?>, <?php echo $this->offer->id ?>,<?php echo BOOKMARK_TYPE_OFFER ?>)"  title="<?php echo JText::_("LNG_UPDATE_BOOKMARK")?>" class="bookmark"><i class="la la-heart"></i></a>
                    <?php } else {?>
                        <a id="bookmark-<?php echo $this->offer->id ?>" href="javascript:jbdUtils.showAddBookmark(<?php echo $user->id==0?"1":"0"?>, <?php echo $this->offer->id ?>,<?php echo BOOKMARK_TYPE_OFFER ?>)" title="<?php echo JText::_("LNG_ADD_BOOKMARK")?>" class="bookmark"><i class="la la-heart-o"></i></a>
                    <?php } ?>
                <?php } ?>
    	     </div>
    	</div>
		<div class="row item-section">
			<?php if(!empty($this->offer->pictures)){?>
                <div class="col-lg-6">
                    <?php
                        $this->pictures = $this->offer->pictures;
                        require_once JPATH_COMPONENT_SITE.'/include/image_gallery.php';
                    ?>
                </div>
            <?php } ?>
    		<div class="col-lg-6">
    			<h1 itemprop="name"> <?php echo $this->escape($this->offer->subject)?></h1>
    			<span style="display:none;" itemprop="url"><?php echo JBusinessUtil::getOfferLink($this->offer->id, $this->offer->alias); ?></span>
    			<?php $address = JBusinessUtil::getAddressText($this->offer); ?>
                <?php if(!empty($address)) { ?>
                    <div class="offer-location" itemprop="location" itemscope itemtype="http://schema.org/Place">
                        <i class="icon map-marker"></i>&nbsp;<span itemprop="address"><?php echo $this->escape($address)?></span>
                        <?php if(isset($this->offer->latitude) && isset($this->offer->longitude)) {
                            $location = new stdClass;
                        	$location->latitude = $this->offer->latitude;
                        	$location->longitude = $this->offer->longitude;
                           ?>
                            <a target="_blank" href="<?php echo JBusinessUtil::getDirectionURL(null,$location) ?>"> - <?php echo JText::_("LNG_GET_MAP_DIRECTIONS")?></a>
                        <?php }?>
                    </div>
                <?php } ?>
                <br/>
                <div class="row align-items-center">
                	<div class="col-lg-5">
                		<dl class=price>
                    		<?php $priceClass = !empty($this->offer->specialPrice)?"price-old":""  ?>
                            <?php if(!empty($this->offer->specialPrice)){?>
                               <dt> 
                               		<?php echo JText::_("LNG_OLD_PRICE")?>: </dt>
                               		<dd> <span class="price-value <?php echo $priceClass ?>" <?php echo empty($this->offer->specialPrice)?'itemprop="price"':''?> > <?php echo JBusinessUtil::getPriceFormat($this->offer->price, $this->offer->currencyId) ?></span> 
                                        <?php if(!empty((int)$this->offer->price_base)){?>
                                                &nbsp;(<?php echo  JBusinessUtil::getPriceFormat($this->offer->price_base, $this->offer->currencyId)?>/<?php echo $this->offer->price_base_unit?>)
                                        <?php }?>
        	                        </dd>
    	                       </dt>
                            <?php } ?>
                        </dl>
                        <dl class=price>
            				<?php if(!empty($this->offer->specialPrice)){?>
                               	<dt><?php echo JText::_("LNG_PRICE")?>: </dt> 
                               	<dd>
                               	   <span class="price-value" itemprop="price"><?php echo JBusinessUtil::getPriceFormat($this->offer->specialPrice, $this->offer->currencyId)?></span>
                                   <?php if (!empty((int)$this->offer->special_price_base)) { ?>
                                        &nbsp;(<?php echo  JBusinessUtil::getPriceFormat($this->offer->special_price_base, $this->offer->currencyId)?>/<?php echo $this->offer->special_price_base_unit?>)
                                   <?php }?>
                               </dd>
                            <?php } ?>
                        </dl>
                    
                        <?php if ($this->defaultAttributes["price_text"]!=ATTRIBUTE_NOT_SHOW) { ?>
                            <?php if ($this->defaultAttributes["price_text"]!=ATTRIBUTE_NOT_SHOW) { ?>
                                <?php if (!empty($this->offer->price_text)) { ?>
                                    <div class="price-text"><?php echo $this->offer->price_text;?></div>
                                <?php }elseif (empty($this->offer->price) && empty($this->offer->specialPrice) && ($this->appSettings->show_offer_free)){ ?>
                                    <div><span class="free-text text-success p-2"><?php echo JText::_('LNG_FREE') ?></span></div>
                                <?php } ?>
                            <?php } ?>
                        <?php } ?>
                    </div>
                    
                    <?php if ($this->offer->item_type == OFFER_TYPE_OFFER && (!$this->appSettings->enable_offer_selling || $this->appSettings->enable_offer_selling && $this->offer->enable_offer_selling != OFFER_SELLING_REGULAR)){ ?>
                        <div class="col-lg">
                            <?php if(!empty($this->offer->specialPrice) && !empty($this->offer->price) && $this->offer->specialPrice < $this->offer->price){ ?>
                                <div class="jbtn-offer">
                                    <div class="jbtn-offer-info">
                                        <p><span> <?php echo JBusinessUtil::getPriceDiscount($this->offer->specialPrice, $this->offer->price) ?>% </span> <?php echo JText::_("LNG_OFF")?></p>
                                    </div>
                                    <?php if($this->appSettings->enable_offer_coupons) { ?>
                                        <?php if($this->offer->checkOffer) { ?>
                                            <div class="jbtn-offer-link">
                                                <div class="jbtn-offer-darken"></div>
                                                 <?php if($user->id !=0) { ?>
                                                    <a href="<?php echo $couponUrl ?>">
                                                        <?php echo JText::_("LNG_GENERATE_COUPON")?>
                                                    </a>
                                                 <?php } else { ?>
                                                    <a href="javascript:jbdUtils.showLoginNotice()">
                                                        <?php echo JText::_('LNG_GENERATE_COUPON')?>
                                                    </a>
                                                <?php } ?>
                                            </div>
                                        <?php } ?>
                                     <?php } ?>
                                </div>
                            <?php }else{ ?>
                                    <?php if($this->appSettings->enable_offer_coupons) { ?>
                                        <?php if($this->offer->checkOffer) { ?>
                                            <div class="jbtn-offer">
                                                <div class="jbtn-offer-info-sm">
                                                    <?php if($user->id !=0) { ?>
                                                        <a href="<?php echo $couponUrl ?>">
                                                            <?php echo JText::_("LNG_GENERATE_COUPON")?>
                                                        </a>
                                                    <?php } else { ?>
                                                        <a href="javascript:jbdUtils.showLoginNotice()">
                                                            <?php echo JText::_('LNG_GENERATE_COUPON')?>
                                                        </a>
                                                    <?php } ?>
                                                    <div class="jbtn-offer-darken"></div>
                                                </div>
                                            </div>
                                        <?php } ?>
                                    <?php } ?>
                             <?php } ?>
                        </div>
                    <?php } ?>
                </div>
                <div class="row">
                    <div class="col-lg">
                        <div class="offer-info">
                            <?php if (!empty($this->offer->show_time) && JBusinessUtil::getRemainingtime($this->offer->endDate, $this->offer->time_zone)!="") { ?>
                                <div class="offer-dates">
                                    <span ><i class="la la-clock-o"></i> <?php echo JBusinessUtil::getRemainingtime($this->offer->endDate, $this->offer->time_zone) ?></span>
                                </div>
                            <?php } ?> 
                    
                            <?php if ((!empty($this->offer->startDate) && $this->offer->startDate!="0000-00-00") || (!empty($this->offer->endDate) && $this->offer->endDate!="0000-00-00")) { ?>
                                <div class="offer-dates">
                                    <i class="icon calendar"></i>
                                    <?php
                                        echo  JBusinessUtil::getDateGeneralFormat($this->offer->startDate)." - ". JBusinessUtil::getDateGeneralFormat($this->offer->endDate);
                                    ?>
                                    <span style="display: none;" itemprop="validFrom"><?php echo JBusinessUtil::getDateGeneralFormat($this->offer->startDate)?></span>
                                    <span style="display: none;" itemprop="validThrough"><?php echo JBusinessUtil::getDateGeneralFormat($this->offer->endDate)?></span>
                                </div>
                            <?php } ?>
                            
                            <?php if ($this->appSettings->show_contact_form && $this->offer->item_type == OFFER_TYPE_OFFER) { ?>
                                <?php if(!empty($this->offer->company->phone) || !empty($this->offer->company->mobile)){?>
                                    <div>
                                        <?php if(!empty($this->offer->company->phone)){ ?>
                                        <i class="icon phone-o"></i> <a href="tel:<?php  echo $this->escape($this->offer->company->phone); ?>"><?php  echo $this->escape($this->offer->company->phone); ?></a> &nbsp;&nbsp;
                                        <?php } else if(!empty($this->offer->company->mobile)){ ?>
                                        <i class="icon mobile"></i> <a href="tel:<?php  echo $this->escape($this->offer->company->mobile); ?>"><?php  echo $this->escape($this->offer->company->mobile); ?></a>
                                        <?php } ?>
                                        </div>
                                <?php } ?>
                                <div itemprop="email" ><i class="icon envelope"></i><a href="javascript:jbdListings.contactCompany(<?php echo $showData ? 1 : 0 ?>)"> <?php echo JText::_('LNG_CONTACT'); ?></a> </div>
                            <?php } ?>
                            
                            <?php if(!empty($this->offer->offerType)){?>
                                <?php echo JText::_("LNG_TYPE")?>
                                <strong><?php echo $this->escape($this->offer->offerType)?></strong>
                            <?php } ?>
                        </div>
                	</div>
               </div>
        	</div>
    	</div>
   
    	<?php if ($this->appSettings->enable_offer_selling && $this->offer->enable_offer_selling == OFFER_SELLING_REGULAR && JBusinessUtil::checkDateInterval($this->offer->startDate, $this->offer->endDate) && $this->offer->quantity > 0
            && (isset($this->offer->companyPackage->features) && in_array(SELL_OFFERS,$this->offer->companyPackage->features) || !$this->appSettings->enable_packages)) { ?>
        	<div class="row item-section">
        		<div class="col-12">
            		<div class="jbtn-order">
            			<div class="jbtn-order-info">
                            <?php if (!empty($this->offer->sellingOptions)) {
	                            echo AttributeService::renderSellingAttributesFront($this->offer->sellingOptions, $this->offer->id, $this->offer->main_subcategory);
                            }else { ?>
                                <select  onchange="jbdOffers.checkAddToCartStatus()" name="quantity" id="quantity" class="select">
		                            <?php
                                        if ($this->offer->min_purchase > 0) {
                                            echo '<option value="0">0</option>';
                                        }

                                        $maximum = $this->offer->max_purchase;
                                        if ($this->offer->quantity < $this->offer->max_purchase) {
                                            $maximum = $this->offer->quantity;
                                        }
                                        $maximum = ($maximum < MAXIMUM_OFFER_QUANTITY_SELLING) ? $maximum : MAXIMUM_OFFER_QUANTITY_SELLING;
                                        for ($i = $this->offer->min_purchase; $i <= $maximum; $i++) {
                                            echo '<option value="' . $i . '">' . $i . '</option>';
                                        } 
                                    ?>
                                </select>
	                        <?php } ?>
	                        <p class="jbtn-order-info-text">
            				</p>
            			</div>
                        <input type="hidden" id="firstValue" value=""/>

            			<div class="jbtn-order-btn">
            				<a id="addToCartButton" href="javascript:onclick=jbdOffers.addToCart(<?php echo $this->offer->id; ?>)"><i class="icon cart white"></i> <?php echo JText::_('LNG_ADD_TO_CART'); ?></a>
            			</div>
                        <?php if(!empty($this->cart["items"]) && in_array($this->offer->id , array_column($this->cart["items"], 'id'))) {?>
                            <div class="jbtn-order-btn ml-5 btn-remove-cart">
                                <a id="removeFromCartButton" href="javascript:onclick=jbdOffers.removeFromCart('<?php echo $this->offer->id; ?>_')"><i class="icon cart white"></i> <?php echo JText::_('LNG_REMOVE_FROM_CART'); ?></a>
                            </div>
                        <?php } ?>
            		</div>
            	</div>
        	</div>
 		<?php } else if ($this->appSettings->enable_offer_selling && $this->offer->enable_offer_selling == OFFER_SELLING_REGULAR && JBusinessUtil::checkDateInterval($this->offer->startDate, $this->offer->endDate) && $this->offer->quantity == 0
            && (isset($this->offer->companyPackage->features) && in_array(SELL_OFFERS,$this->offer->companyPackage->features) || !$this->appSettings->enable_packages)) { ?>
            <div class="offer-quantity-info">
                <?php echo JText::_('LNG_OUT_OF_STOCK') ?>
            </div>
 		<?php } ?>

		<?php require_once 'offer_attributes.php'; ?>

        <div class="row item-section">
       		<div class="col">
                <?php if(!empty($this->offer->categories)){
                    foreach($this->offer->categories as $i=>$category){
                        ?>
                        <a href="<?php echo JBusinessUtil::getOfferCategoryLink($category[0], $category[2]) ?>"><?php echo $this->escape($category[1]) ?></a><?php echo $i<(count($this->offer->categories)-1)? ',&nbsp;':'' ?>
                        <?php
                    }
                } ?>
           </div>
        </div>
        
		<?php if ($this->appSettings->enable_attachments) { ?>
        	<?php if (!empty($this->offer->attachments)) { ?>                             
                <div class="row item-section">
                	<div class="col">
                        <div><strong><?php echo JText::_("LNG_ATTACHMENTS")?></strong></div>
                        <?php require "offer_attachments.php"?>
                        <div class="clear"></div>
                    </div>
				</div>
             <?php } ?>
        <?php } ?>
      
        <div class="row item-section">
        	<div class="col">
                <div itemprop="description">
                     <?php echo JHTML::_("content.prepare", $this->offer->description); ?>
                </div>
          	</div>
        </div>
           
        <?php if (!empty($this->videos)) { ?>
        	<div class="row item-section">
        		<div class="col">
            	    <?php require_once 'offer_videos.php';?>
            	</div>
        	</div>
        <?php } ?>
        

        <div class="row item-section business-details">
            <div class="col-md">
                <?php if(!empty($this->offer->company)){?>
	                <div class="offer-business" itemprop="offeredBy" itemscope itemtype="http://schema.org/Organization">
	                    <div class="business-head"><?php echo JText::_('LNG_COMPANY_DETAILS') ?></div>
	            	    <a class="business-name" <?php echo $newTab; ?> href="<?php echo JBusinessUtil::getCompanyLink($this->offer->company)?>"> <span itemprop="name"><?php echo $this->escape($this->offer->company->name)?></span></a>
	                    <?php if(!empty($this->offer->company->phone) || !empty($this->offer->company->mobile)){?>
	                            <div class="business-item" itemprop="telephone">
	                              <?php if(!empty($this->offer->company->phone)){ ?>
	                            	<i class="icon phone-o"></i> <a href="tel:<?php  echo $this->escape($this->offer->company->phone); ?>"><?php  echo $this->escape($this->offer->company->phone); ?></a> &nbsp;&nbsp;
	                              <?php }?> 
                                </div>  

                                <div class="business-item" itemprop="telephone"> 
	                              <?php if(!empty($this->offer->company->mobile)){ ?>
	                            	<i class="icon mobile"></i> <a href="tel:<?php  echo $this->escape($this->offer->company->mobile); ?>"><?php  echo $this->escape($this->offer->company->mobile); ?></a>
	                              <?php } ?>
	                            </div>
	                    <?php } ?>
	                    <?php if(!empty($this->offer->company->website)){?>
	                            <div class="business-item" itemprop="url">
	                            	<a target="_blank" itemprop="url" title="<?php echo $this->escape($this->offer->company->name)?> Website" onclick="jbdUtils.registerStatAction(<?php echo $this->offer->company->id ?>,<?php echo STATISTIC_ITEM_BUSINESS ?>,<?php echo STATISTIC_TYPE_WEBSITE_CLICK ?>)" href="<?php echo $this->escape($this->offer->company->website) ?>"><i class="icon link-square"></i> <?php echo JText::_('LNG_WEBSITE') ?></a>
	                            </div>
	                    <?php } ?>
	                </div>
	             <?php } ?>
            </div>
            <?php if ((!empty($this->offer->latitude) && !empty($this->offer->longitude)) || $this->offer->item_type == OFFER_TYPE_PRODUCT) { ?>
                <div class="col-md-8">
                    <div id="offer-map">
                        <?php require_once 'map.php';?>
                    </div>
                </div>
            <?php } ?>
        </div>
        
        <?php if ($this->appSettings->enable_reviews && $this->offer->item_type == OFFER_TYPE_OFFER) { ?>
            <div class="row item-section">
        		<div class="col">
                    <?php require_once 'offer_reviews.php';?>
                </div>
             </div>
        <?php } ?>
        
        <div id="offer-dialog" class="jbd-container" style="display: none">    
            <div class="jmodal-sm">
                <div class="jmodal-header">
                    <p class="jmodal-header-title"></p>
                    <a href="#close-modal" rel="modal:close" class="close-btn"><i class="la la-close "></i></a>
                </div>
                <div class="jmodal-body">
                    <div class="dialogContent">
                        <iframe id="offerIfr" height="500" src="about:blank">
                        </iframe>
                    </div>           
                </div>
            </div>        
        </div>
    </div>
    <?php require_once 'offer_util.php'; ?>
    <?php require_once JPATH_COMPONENT_SITE . '/include/bookmark_utils.php'; ?>
</div>