<?php
/**
 * @package    JBusinessDirectory
 * @subpackage  com_jbusinessdirectory
 *
 * @copyright   Copyright (C) 2007 - 2015 CMS Junkie. All rights reserved.
 * @license     GNU General Public License version 2 or later;
 */

defined('_JEXEC') or die('Restricted access');

/**
 * The HTML  View.
 */

JBusinessUtil::loadJQueryChosen();

JBusinessUtil::enqueueScript('libraries/dropzone/dropzone.js');

JBusinessUtil::enqueueStyle('libraries/dropzone/dropzone.css');
JBusinessUtil::enqueueStyle('libraries/dropzone/basic.css');

JBusinessUtil::loadJQueryUI();

JBusinessUtil::enqueueScript('libraries/chosen/ajax-chosen.min.js');


// following translations will be used in js
JText::script('LNG_IMAGE_SIZE_WARNING');

JBusinessUtil::includeValidation();

require_once HELPERS_PATH.'/helper.php';

class JBusinessDirectoryViewManageCompanyProject extends JViewLegacy {
	protected $item;
	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		$this->companies = JBusinessUtil::getCompaniesByUserId();
		$this->item	 = $this->get('Item');
		$this->state = $this->get('State');
		$this->translations = JBusinessDirectoryTranslations::getAllTranslations(PROJECT_DESCRIPTION_TRANSLATION, $this->item->id);
		$this->languages = JBusinessUtil::getLanguages();

		$this->appSettings = JBusinessUtil::getApplicationSettings();
		
		$user = JBusinessUtil::getUser();
		$this->companyOptions = JBusinessUtil::getCompaniesOptions($this->item->company_id, $user->id);

		$this->actions = JBusinessDirectoryHelper::getActions();

		parent::display($tpl);
	}
}
