<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');
$appSettings = JBusinessUtil::getApplicationSettings();
$menuItemId = JBusinessUtil::getActiveMenuItem();

JBusinessUtil::checkPermissions("directory.access.listing.pricelist", "managecompanypricelists");

$isProfile = true;

?>
<script>
	var isProfile = true;
</script>
<style>
#header-box, #control-panel-link{
	display: none;
}

.tooltip {
    border-style:none !important;
}

  .tooltip-inner {
        background-color: rgba(0,0,0,0.55);
        max-width:600px;
        padding:2px 2px;
        text-align:center;
        border-radius:4px;
    }
    
</style>

<?php
if(empty($this->items)){
    $actionURL = JRoute::_('index.php?option=com_jbusinessdirectory&task=managecompanypricelist.add');
    echo JBusinessUtil::getNewItemMessageBlock(JText::_("LNG_PRICE_LIST"),JText::_("LNG_PRICE_LISTS"),$actionURL);
    return;
}
?>

<div class="button-row  justify-content-end">
    <button type="submit" class="btn btn-success" onclick="jbdUtils.addDirPriceList()">
        <span class="ui-button-text"><i class="la la-plus-sign"></i> <?php echo JText::_("LNG_ADD_NEW")?></span>
    </button>
</div>

<form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=managecompanypricelists'.$menuItemId);?>" method="post" name="adminForm" id="adminForm">
	<div id="editcell">
		<table class="dir-panel-table responsive-simple">			
			<tbody>
				<?php
				$nrcrt=1;
				$i=0;
				if(!empty($this->items)){
					foreach($this->items as $item) { ?>
						<tr class="jtable-body-row row<?php echo $i % 2; ?>">
							<td class="jtable-body-row-data" align="left">
								<div class="item-name text-left">
									<div class="item-title">
										<a href='<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=managecompanypricelist.edit&'.JSession::getFormToken().'=1&id='. $item->companyId )?>'
											title="<?php echo JText::_('LNG_CLICK_TO_EDIT'); ?>">
											<strong><?php echo $item->companyName ?></strong>
										</a>
									</div>									
								</div>
							</td>
							<td class="jtable-body-row-data" data-title="<?php echo JText::_('LNG_SERVICES'); ?>" class="has-title">
								<div class="item-label">
									<?php echo JText::_('LNG_SERVICES'); ?>
								</div>                            
                                <?php
                                $services = explode(' - ',$item->services[0]);
                                $section = $services[1];
                                echo '<strong>'.$section.'</strong><br/>';
                                foreach ($item->services as $service){
                                    $service1 = explode(' - ',$service);
                                    if ($service1[1] != $section){
                                        echo '<strong>'.$service1[1].'</strong><br/>';
                                        $section = $service1[1];
                                    }
                                    echo $service1[2]. ' ' .JBusinessUtil::getPriceFormat($service1[3]).'<br/>';
                                }
                                ?>
							</td>
							<td class="jtable-body-row-data" align="right">
								<div class="item-actions">
									<a href='<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=managecompanypricelist.edit&'.JSession::getFormToken().'=1&id='. $item->companyId )?>'
										title="<?php echo JText::_('LNG_CLICK_TO_EDIT'); ?>" class="jtable-btn">
										<i class="la la-pencil"></i>
									</a>
									<a href="javascript:jbdUtils.deleteDirPriceList(<?php echo $item->companyId ?>)"
										title="<?php echo JText::_('LNG_CLICK_TO_DELETE'); ?>" class="jtable-btn">
										<i class="la la-trash"></i>
									</a>
								</div>
							</td>
						</tr>
					<?php
						$i++;
					} 
				}
			?>
			</tbody>
			<tfoot>
			</tfoot>
		</table>
        <div class="pagination" <?php echo $this->pagination->total==0 ? 'style="display:none"':''?>>
            <?php echo $this->pagination->getListFooter(); ?>
            <div class="clear"></div>
        </div>
	</div>
	<input type="hidden" name="option"	value="<?php echo JBusinessUtil::getComponentName()?>" />
	<input type="hidden" name="task" id="task" value="" /> 
	<input type="hidden" name="cid" id="id" value="" />
    <input type="hidden" name="delete_mode" id="delete_mode" value="" />
    <input type="hidden" name="view" id="view" value="managecompanypricelists" />

	<?php echo JHTML::_( 'form.token' ); ?> 
</form>
<div class="clear"></div>

