
<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');

JBusinessUtil::checkPermissions("directory.access.offercoupons", "managecompanyoffercoupons");
$isProfile = true;

?>
<script>
	var isProfile = true;
</script>
<style>
#header-box, #control-panel-link {
	display: none;
}
</style>

<?php
if(empty($this->items)){
    echo JBusinessUtil::getNoItemMessageBlock(JText::_("LNG_COUPON"),JText::_("LNG_COUPONS"));
    return;
}
?>

<form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=managecompanyoffercoupons');?>" method="post" name="adminForm" id="adminForm">
	<div id="editcell">
		<table class="dir-panel-table responsive-simple">
			<!-- <thead>
				<tr>
					<th align="center" width='25%'><?php echo JText::_('LNG_COUPON'); ?></th>
					<th class="hidden-xs hidden-phone" width="20%" align="center"><?php echo JText::_('LNG_OFFER'); ?></th>
					<th class="hidden-xs hidden-phone" width="15%" align="center"><?php echo JText::_('LNG_COMPANY'); ?></th>
					<th class="hidden-xs hidden-phone" width="20%" align="center"><?php echo JText::_('LNG_GENERATED_TIME'); ?></th>
					<th class="hidden-xs hidden-phone" width="15%" align="center"><?php echo JText::_('LNG_EXPIRATION_TIME'); ?></th>
					<th width='10%'><?php echo JText::_("LNG_PDF"); ?></th>
				</tr>
			</thead> -->
			<tbody>
				<?php 
				$nrcrt = 1;
				if(!empty($this->items)){
					foreach($this->items as $coupon) { ?>
						<tr class="jtable-body-row row<?php echo $nrcrt%2 ?>">
							<td class="jtable-body-row-data" align="left" nowrap="nowrap">
								<div class="item-name">
									<div class="item-title">
										<?php echo strtoupper($coupon->code); ?>
									</div>								
								</div>								
							</td>
							<td class="jtable-body-row-data">
								<div class="item-label"><?php echo JText::_("LNG_OFFER") ?></div>
								<div class="item-value"><?php echo $coupon->offer; ?></div>
                        	</td>	
							<td class="jtable-body-row-data">
								<div class="item-label"><?php echo JText::_("LNG_COMPANY") ?></div>
								<div class="item-value"><?php echo $coupon->company; ?></div>
                        	</td>
							<td class="jtable-body-row-data">
								<div class="item-label"><?php echo JText::_("LNG_GENERATED_TIME") ?></div>
								<div class="item-value"><?php echo JBusinessUtil::getDateGeneralShortFormat($coupon->generated_time); ?></div>
                        	</td>	
							<td class="jtable-body-row-data">
								<div class="item-label"><?php echo JText::_("LNG_EXPIRATION_TIME") ?></div>
								<div class="item-value"><?php echo JBusinessUtil::getDateGeneralShortFormat($coupon->expiration_time); ?></div>
                        	</td>	
							
							<td class="jtable-body-row-data">
								<div class="item-actions">
									<a href='<?php echo JRoute::_( 'index.php?option=com_jbusinessdirectory&task=managecompanyoffercoupon.show&id='. $coupon->id )?>'
										title="<?php echo JText::_('LNG_CLICK_TO_VIEW'); ?>" class="jtable-btn" 
										target="_blank">
										<i class="icon pdf-download"></i>
									</a>
									<a href="javascript:void(0);" onclick="jbdOffers.deleteCoupon(<?php echo $coupon->id ?>)" 
										title="<?php echo JText::_('LNG_CLICK_TO_DELETE'); ?>" class="jtable-btn">
										<i class="la la-trash"></i>
									</a>
								</div>
							</td>
						</tr>
				<?php } 
					}
				?>
			</tbody>
		</table>
        <?php
        if(!empty($this->items)){ ?>
        <div class="pagination" <?php echo $this->pagination->total==0 ? 'style="display:none"':''?>>
            <?php echo $this->pagination->getListFooter(); ?>
            <div class="clear"></div>
        </div>
        <?php } ?>
	</div>
	<input type="hidden" name="option" value="<?php echo JBusinessUtil::getComponentName()?>" />
	<input type="hidden" name="task" id="task" value="" /> 
	<input type="hidden" name="id" id="id" value="" />
	<input type="hidden" name="Itemid" id="Itemid" />
	<?php echo JHTML::_('form.token'); ?> 
</form>
<div class="clear"></div>