<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');

JBusinessUtil::checkPermissions("directory.access.articles", "managecompanyarticles");

JHtml::addIncludePath(JPATH_COMPONENT.'/helpers/html');
JHtml::_('behavior.multiselect');

$listOrder	= $this->escape($this->state->get('list.ordering'));
$listDirn	= $this->escape($this->state->get('list.direction'));

$return = base64_encode(('index.php?option=com_jbusinessdirectory&view=managecompanyarticles'));
?>

<style>
    .tooltip {
        border-style:none !important;
    }

    .tooltip-inner {
        background-color: rgba(0,0,0,0.55);
        max-width:600px;
        padding:2px 2px;
        text-align:center;
        border-radius:4px;
    }
</style>


<form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&view=managecompanyarticles');?>" method="post" name="adminForm" id="adminForm">
	<?php if(!empty($this->companies)){?>
		<div class="row ">
			<div class="col-md-9">
                <select name="business_id" id="business_id" class="left validate[required] mr-3 mb-2" >
                    <?php foreach($this->companies as $company){?>
                        <option value="<?php echo $company->id ?>"><?php echo $company->name ?></option>
                    <?php } ?>
                </select>
    		</div>
    		<div class="col-md-3">
                <button type="submit" class="btn btn-success" onclick="Joomla.submitform('managecompanyarticles.addNewArticle', document.getElementById('adminForm'));">
                    <span class="ui-button-text"><i class="la la-plus-sign"></i> <?php echo JText::_("LNG_ADD_NEW_ARTICLE")?></span>
                </button>
            </div>
        </div>
    <?php }else{ ?>
		<?php JFactory::getApplication()->enqueueMessage(JText::_('LNG_ARTICLE_CREATION_NOT_ALLOWED'),"notice"); ?>
	<?php } ?>
	<div class="clear"></div>

    <?php if(!empty($this->items)){ ?>
    	<table class="dir-panel-table responsive-simple" id="itemList">    		
    		<tbody>
    			<?php
    			$nrcrt = 1;
    			$i=0;
    			foreach( $this->items as $item) { ?>
    				<tr class="jtable-body-row row<?php echo $i % 2; ?>">
    					<td class="jtable-body-row-data" align="left">
							<div class="item-name text-left">
								<div class="item-title">
									<a href='<?php echo JRoute::_("index.php?option=com_content&task=article.edit&catid=$item->catid&a_id=$item->id&return=$return"); ?>'
										title="<?php echo JText::_('LNG_CLICK_TO_EDIT'); ?>"> 
										<strong><?php echo $item->title ?></strong>
									</a>
								</div>								
    						</div>
    					</td>
    					<td class="jtable-body-row-data">
							<div class="item-label"><?php echo JText::_("LNG_COMPANY") ?></div>
							<div class="item-value"><?php echo $item->company_name ?></div>	
    					</td>
						<td class="jtable-body-row-data" align="left">    						
							<div class="item-actions">
								<a href="<?php echo JRoute::_("index.php?option=com_content&task=article.edit&catid=$item->catid&a_id=$item->id&return=$return&Itemid=278"); ?>"
									title="<?php echo JText::_('LNG_CLICK_TO_EDIT'); ?>" class="jtable-btn">
									<i class="la la-pencil"></i>
								</a>
								<a target="_blank" href="<?php echo JRoute::_('index.php?option=com_content&view=article&id=' . $item->id.'&catid=' . $item->catid); ?>" 
									title="<?php echo JText::_('LNG_CLICK_TO_VIEW'); ?>" class="jtable-btn"> 
									<i class="la la-eye"></i>
								</a>
								<a href="javascript:deleteListingArticle(<?php echo $item->id ?>)" 
									title="<?php echo JText::_('LNG_CLICK_TO_DELETE'); ?>" class="jtable-btn">
									<i class="la la-trash"></i>
								</a>
							</div>
    					</td>
    				</tr>
    			<?php
    			$i++;
    			} ?>
    		</tbody>
    	</table>
    	<div class="pagination" <?php echo $this->pagination->total==0 ? 'style="display:none"':''?>>
    		<?php echo $this->pagination->getListFooter(); ?>
    		<div class="clear"></div>
    	</div>
    <?php } ?>
	<input type="hidden" name="option"	value="com_jbusinessdirectory" />
	<input type="hidden" name="task" id="task" value="" /> 
	<input type="hidden" name="companyId" value="" />
	<input type="hidden" id="article_id" name="article_id" value="" />
	<input type="hidden" id="cid" name="cid" value="" />
	<input type="hidden" name="boxchecked" value="0" />
	<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
	<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
	<?php echo JHTML::_('form.token'); ?> 
</form>

<script>
function deleteListingArticle(id) {
    if (confirm(Joomla.JText._('COM_JBUSINESS_DIRECTORY_ITEMS_CONFIRM_DELETE'))) {
        jQuery("#cid").val(id);
        jQuery("#task").val("managecompanyarticles.delete");
        jQuery("#adminForm").submit();
    }
}
</script>
