<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved. 
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');

$isProfile = true;
$showSteps =  JFactory::getApplication()->input->get("showSteps",false);

$menuItemId = JBusinessUtil::getActiveMenuItem();
if ($this->appSettings->allow_user_creation==0 && $this->appSettings->user_login_position == 1) {
	JBusinessUtil::checkPermissions("directory.access.listings", "managecompany");
}

if($this->item->approved == COMPANY_STATUS_CLAIMED){
	$app = JFactory::getApplication();
	$app->redirect(JRoute::_('index.php?option=com_jbusinessdirectory&view=managecompanies'));
}

?>

<div class="jbd-container jbd-front-end add-listing">
    <?php 
    if($showSteps) { ?>
    	<div id="process-container" class="process-container">
    		<ol class="process-steps">
    			<li class="is-complete inbox" data-step="1">
    				<p><?php echo JText::_("LNG_CHOOSE_PACKAGE")?></p>
    			</li>
    			<li class="is-complete user" data-step="2">
    				<p><?php echo JText::_("LNG_BASIC_INFO")?></p>
    			</li>
    			<li class="progress__last is-active file-text" data-step="3">
    				<p><?php echo JText::_("LNG_LISTING_INFO")?></p>
    			</li>
    		</ol>
    		<div class="clear"></div>
    	</div>
    	
    	<div class="row">
        	<div class="<?php echo empty($this->package)?"col-md-12": "col-md-9"?>">
        		<?php include(JPATH_COMPONENT_ADMINISTRATOR.DS.'views'.DS.'company'.DS.'tmpl'.DS.'edit.php'); ?>
        	</div>
    	
			<?php if(!empty($this->package)){?>
				<div class="col-md-3">
					<div class="featured-product-col" >
						<?php
							$package = $this->package;
							require  JPATH_COMPONENT_SITE."/views/packages/tmpl/default_package.php"
						?>
					</div>
				</div>
			<?php }?>
		</div>
    	
    <?php }else{ ?>
    	<?php include(JPATH_COMPONENT_ADMINISTRATOR.DS.'views'.DS.'company'.DS.'tmpl'.DS.'edit.php'); ?>
    <?php } ?>
</div>

<script>
	var isProfile = true;
</script>

<style>
#header-box, #control-panel-link{
	display: none;
}
</style>