<?php // no direct access
/**
 * @copyright	Copyright (C) 2008-2009 CMSJunkie. All rights reserved.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

defined('_JEXEC') or die('Restricted access');
$user = JBusinessUtil::getUser();
$menuItemId = JBusinessUtil::getActiveMenuItem();
?>
<style>
body{
    background-color: #fff;
	padding: 0!important;
	margin: 0;
}
</style>
<div id="order-content" class="order-content jbd-container container-fluid">
	<div class="printbutton">
		<a onclick="window.print()" href="javascript:void(0);"><i class="icon print-circle icon-25px"></i> <?php echo JText::_("LNG_PRINT")?></a>
	</div>
	<!-- Invoice Details Section -->
	<?php if(empty($this->item->company) && $this->item->company_id != -1){?>
		<div class="row">
			<div class="col-sm-12">
				<?php echo !empty($this->appSettings->logo)?"<img class='invoice-logo' src='".BD_PICTURES_PATH.$this->appSettings->logo."'/>":""; ?>
				<div><?php echo JText::_("LNG_BUSINESS_DELETED");?></div>				
			</div>
		</div>
		<?php return;?>
	<?php } ?>

	<!-- Header section -->
	<div class="row mx-0">
		<div class="col-sm-6 mx-0 px-0">
			<div class="text-left mb-4">
				<div class="order-identifier mt-3">				
					<?php echo "#". $this->appSettings->invoice_prefix.$this->item->id?>
				</div>
				<div class="ml-2">
					<?php echo !empty($this->item->billingDetails->company_name)?$this->item->billingDetails->company_name:$this->item->companyName?>			
				</div>
			</div>			
		
			<div class="text-left order-content">
				<div class="mb-4">
					<strong><?php echo JText::_('LNG_DATE'); ?>: </strong>
					<?php echo '<br />' . JBusinessUtil::getDateGeneralFormat($this->item->created) ?>
				</div>
				
				<strong><?php echo JText::_('LNG_ISSUED_TO'); ?>: </strong>
				<ul class="entity-details">
					<?php if(!empty($this->item->billingDetails->first_name) || !(empty($this->item->billingDetails->last_name))) {
						echo "<li>";
						echo $this->item->billingDetails->first_name . ' ' . $this->item->billingDetails->last_name . '<br/>';
						echo "</li>";
					} ?>

					<?php
						echo "<li>";
						echo !empty($this->item->billingDetails->company_name)?$this->item->billingDetails->company_name:$this->item->companyName.'<br/>';
						echo "</li>";
					?>

					<?php if(!empty($this->item->billingDetails->vat_details)){?>
						<li><?php echo $this->item->billingDetails->vat_details ?> </li>
					<?php } ?>

					<li>
						<?php if(!empty($this->item->billingDetails->address) || !empty($this->item->billingDetails->city) || !empty($this->item->billingDetails->country) || !empty($this->item->billingDetails->region)) {
							if (!empty(implode(", ", array_filter(array($this->item->billingDetails->address, $this->item->billingDetails->city))))) {
								echo implode(", ", array_filter(array($this->item->billingDetails->address, $this->item->billingDetails->city))) . '<br/>';
							}
							if (!empty(implode(", ", array_filter(array($this->item->billingDetails->region, $this->item->billingDetails->postal_code))))) {
								echo implode(", ", array_filter(array($this->item->billingDetails->region, $this->item->billingDetails->postal_code))) . '<br/>';
							}

							if (!empty($this->item->billingDetails->country)) {
								echo ((JBusinessUtil::getCountryName( $this->item->billingDetails->country)));
							}
						}
						else{
							echo JBusinessUtil::getAddressText($this->item->company);
						}
						?>
					</li>

					<li>
						<?php if(!empty($this->item->billingDetails->phone) || !empty($this->item->billingDetails->email))
							echo implode("<br/> ", array_filter(array($this->item->billingDetails->phone, $this->item->billingDetails->email))).'<br/>';
						else
							echo implode("<br/> ", array_filter(array($this->item->company->phone, $this->item->company->email)));
						?>
					</li>

					<?php if(!empty($this->item->company->taxCode)) {
						echo "<li>";
						echo $this->item->company->taxCode;
						echo "<li>";
					} ?>
				</ul>
			</div>
		</div>

		<div class="col-sm-6 mx-0 px-0">
			<div class="text-right">				
				<?php echo !empty($this->appSettings->logo)?"<img class='invoice-logo' src='".BD_PICTURES_PATH.$this->appSettings->logo."'/>":""; ?>
			</div>
			<?php if (!empty($this->appSettings->invoice_company_name) || !empty($this->appSettings->invoice_company_address) || !empty($this->appSettings->invoice_vat)
			|| !empty(implode(", ", array_filter(array($this->appSettings->invoice_company_phone, $this->appSettings->invoice_company_email))))){
			?>
			<div class="text-right mt-4 order-content">
				<ul class="entity-details">
					<?php
					if (!empty($this->appSettings->invoice_company_name)) {
						echo "<li>";
						echo "<strong>".$this->appSettings->invoice_company_name."</strong>";
						echo "</li>";
					}
					?>

					<?php
					if (!empty($this->appSettings->invoice_company_address)) {
						echo "<li>";
						echo $this->appSettings->invoice_company_address;
						echo "</li>";
					}
					?>

					<?php
					if (!empty(implode("<br/>", array_filter(array($this->appSettings->invoice_company_phone, $this->appSettings->invoice_company_email))))) {
						echo "<li>";
						echo implode("<br/>", array_filter(array($this->appSettings->invoice_company_phone, $this->appSettings->invoice_company_email)));
						echo "</li>";
					}
					?>

					<?php
					if (!empty($this->appSettings->invoice_vat)) {
						echo "<li>";
						echo $this->appSettings->invoice_vat;
						echo "</li>";
					}
					?>
				</ul>
			</div>
			<?php } ?>
		</div>
	</div>
	<!-- Product Description table section -->
	<table class="table responsive-simple-sm invoice-table">
		<thead>
			<tr>
				<th class="">
					<?php echo JText::_('LNG_PRODUCT_SERVICE'); ?>
				</th>
				<th class="">
					<?php echo JText::_('LNG_DESCRIPTION'); ?>
				</th>
				<th class="">
					<?php echo JText::_('LNG_QUANTITY'); ?>
				</th>
				<th class="">
					<?php echo JText::_('LNG_UNIT_PRICE'); ?>
				</th>
				<th class="text-right">
					<?php echo JText::_('LNG_TOTAL'); ?>
				</th>
			</tr>
		</thead>
		<tbody>
			<tr>
				<td data-title="<?php echo JText::_('LNG_PRODUCT_SERVICE'); ?>" class="has-title"><?php echo $this->item->service ?></td>
				<td data-title="<?php echo JText::_('LNG_DESCRIPTION'); ?>" class="has-title"><?php echo $this->item->description ?></td>
				<td data-title="<?php echo JText::_('LNG_QUANTITY'); ?>" class="has-title" >1</td>
				<td data-title="<?php echo JText::_('LNG_UNIT_PRICE'); ?>" class="has-title"><?php echo JBusinessUtil::getPriceFormat($this->item->initial_amount) ?></td>
				<td data-title="<?php echo JText::_('LNG_ITEM_TOTAL'); ?>" class="text-right has-title"><?php echo JBusinessUtil::getPriceFormat($this->item->initial_amount) ?></td>
			</tr>
			<?php
			if($this->item->discount_amount>0){
				echo '<tr>';
				echo '<td class="hidden-xs" colspan="3" style="border-bottom-width:0px;border-left-width:0px;border-top-width:0px;" />';
				echo '<td class="hidden-xs">'.JText::_("LNG_DISCOUNT").'</td>';
				echo '<td style="white-space:nowrap" data-title="'.JText::_('LNG_DISCOUNT').'"  class="text-right has-title" >'.JBusinessUtil::getPriceFormat($this->item->discount_amount).'</td>';
				echo '</tr>';
			}
			?>
			<tr>
				<td class="hidden-xs" colspan="3" style="border-bottom-width:0px;border-left-width:0px;" />
				<td class="hidden-xs"><b><?php echo JText::_('LNG_SUB_TOTAL'); ?></b></td>
				<td data-title="<?php echo JText::_('LNG_SUB_TOTAL'); ?>" class="text-right has-title" style="white-space:nowrap"><?php echo JBusinessUtil::getPriceFormat($this->item->initial_amount- $this->item->discount_amount) ?></td>
			</tr>
			
			<?php if(!empty($this->item->vat_amount) && $this->item->vat_amount>0){ ?>
				<tr>
					<td class="hidden-xs" colspan="3" style="border-bottom-width:0px;border-left-width:0px;border-top-width:0px;" />
					<td class="hidden-xs" ><b><?php echo JText::_('LNG_VAT'); ?> (<?php echo !empty($this->item->vat)?$this->item->vat:$this->appSettings->vat?>%)</b></td>
					<td data-title="<?php echo JText::_('LNG_VAT'); ?>" class="text-right has-title" style="white-space:nowrap" ><?php echo JBusinessUtil::getPriceFormat($this->item->vat_amount)?></td>
				</tr>
			<?php } ?>
			<?php if(!empty($this->item->taxes)) { ?>
				<?php foreach ($this->item->taxes as $tax) { ?>
					<tr>
						<td class="hidden-xs" colspan="3" style="border-bottom-width:0px;border-left-width:0px;border-top-width:0px;" />
						<td class=""><b><?php echo $tax->tax_name ?> <?php echo ($tax->tax_type == 2) ? "( " . $tax->tax_amount . " %)" : "" ?></b></td>
						<td class="text-right" style="white-space:nowrap" <?php echo $tax->tax_type==2?"(".$tax->tax_amount."%)":""?>"><?php echo JBusinessUtil::getPriceFormat($tax->tax_calc_amount) ?></td>
					</tr>
				<?php } ?>
			<?php } ?>
			<tr>
				<td class="hidden-xs" colspan="3" style="border-bottom-width:0px;border-left-width:0px;border-top-width:0px;" />
				<td class="hidden-xs"><b><?php echo JText::_('LNG_TOTAL') ?></b></td>
				<td  data-title="<?php echo JText::_('LNG_TOTAL'); ?>" class="text-right has-title" style="white-space:nowrap"><?php echo JBusinessUtil::getPriceFormat($this->item->amount)?></td>
			</tr>
		</tbody>
	</table>
	
	<?php if(!empty($this->appSettings->invoice_details)){ ?>
		<div class="">
			<div class="order-text">
				<?php echo $this->appSettings->invoice_details ?>
			</div>
		</div>
	<?php } ?>
	
	<div class="invoice-status-box">		
		<?php if($this->item->state == 0) { ?>
			<div class="">
				<strong><?php echo JText::_('LNG_NOT_PAID') ?></strong>
				<?php echo '<br/>' .  JText::_('LNG_PAY_INVOICE_DESC') ." ". JBusinessUtil::getDateGeneralFormat($this->item->created) ?>
			</div>
			<?php if ($user->id == $this->item->billingDetails->user_id) { ?>
				<div>
					<a target="_blank" href="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&task=billingdetails.checkBillingDetails&orderId='.$this->item->id.$menuItemId) ?>" class="btn btn-success align-middle"><?php echo JText::_('LNG_PAY'). " " . JBusinessUtil::getPriceFormat($this->item->amount) ?></a>
				</div>
			<?php  } ?>
		<?php  } else if ($this->item->state == 1) { ?>
			<div class="">
				<strong><?php echo JText::_('LNG_PAID') ?></strong>
				<?php echo '<br/>' .  JText::_('LNG_PAID_INVOICE_DESC') . " " . JBusinessUtil::getDateGeneralFormat($this->item->paid_at) ?>
			</div>
		<?php  } else if ($this->item->state == 2) {  ?>
			<div class="">
				<strong><?php echo JText::_('LNG_CANCELED') ?></strong>
				<?php echo '<br/>' .  JText::_('LNG_CANCELED_INVOICE_DESC') ?>
			</div>
		<?php  } ?>
	</div>
	<!-- Footer section -->
	<div class="text-right">
		<div class="order-footer">
			<?php  echo !empty($this->appSettings->invoice_company_name)?$this->appSettings->invoice_company_name.' | ':""; ?>
			<?php echo JText::_('LNG_INVOICE_FOR'); ?>
			<?php echo !empty($this->item->billingDetails->company_name)?$this->item->billingDetails->company_name:$this->item->companyName; ?>
		</div>
	</div>
</div>