<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

JBusinessUtil::loadJQueryChosen();

// following translations will be used in js
JText::script('LNG_SHOW_FILTER');
JText::script('LNG_DISTANCE');
JText::script('LNG_MILES');
JText::script('LNG_KM');
JText::script('LNG_CATEGORIES');
JText::script('LNG_MORE');
JText::script('LNG_LESS');
JText::script('LNG_TYPES');
JText::script('LNG_COUNTRIES');
JText::script('LNG_REGIONS');
JText::script('LNG_CITIES');
JText::script('LNG_AREA');
JText::script('LNG_PROVINCE');
JText::script('LNG_MONTHS');

class JBusinessDirectoryViewEvents extends JViewLegacy {
	public function __construct() {
		parent::__construct();
	}
	
	public function display($tpl = null) {
		$session = JFactory::getSession();
		$state = $this->get('State');
		$this->params = $state->get("parameters.menu");

		$this->events = $this->get('Items');
		//$this->assignRef('events', $events);
		$input = JFactory::getApplication()->input;
		$this->categoryId= $input->getInt('categoryId');
		//$this->assignRef('categoryId', $categoryId);

		$this->categoryOptions = JBusinessUtil::getCategoriesOptions(true, CATEGORY_TYPE_EVENT);
		$this->searchkeyword= $input->getString('searchkeyword');
		$this->appSettings =  JBusinessUtil::getApplicationSettings();
		$this->defaultAttributes = JBusinessUtil::getAttributeConfiguration(DEFAULT_ATTRIBUTE_TYPE_EVENT);
		$this->zipCode = $input->getString('zipcode');
        $this->age = $input->getInt('age', null);

        $this->startTime = $input->getString('start_time', null);
        $this->endTime = $input->getString('end_time', null);

		$this->location = $this->get("Location");
		$this->orderBy = $input->getString("orderBy", $this->appSettings->order_search_events);

		$this->categorySearch = $input->getInt('categorySearch', null);
		$this->citySearch = $input->getString('citySearch', null);
		$this->regionSearch = $input->getString('regionSearch', null);
		$this->provinceSearch = $input->getString('provinceSearch', null);
		$this->areaSearch = $input->getString('areaSearch', null);

		$this->typeSearch = $input->getInt('typeSearch', null);
		if (!empty($this->typeSearch)) {
			$this->typeSearchName = $this->get('Type')->name;
		}
		$this->startDate = $session->get('ev-startDate', null);
		$this->endDate = $session->get('ev-endDate', null);
		
		$this->dateRange = $input->getString('dateRange');
		if (!empty($this->dateRange)) {
			$this->dateRange = explode(':', $this->dateRange);
			if (count($this->dateRange) == 2) {
				$this->startDate = $this->dateRange[0];
				$this->endDate = $this->dateRange[1];
			}
		}
		
		$this->countrySearch = $input->get('countrySearch', null);
		$this->country = $this->get('Country');

		$this->customAtrributes = $session->get('customAtrributes');
		$this->customAtrributesValues = $this->get("CustomAttributeValues");

		$this->selectedParams = $this->get('SelectedParams');
		$this->type = $this->get("EventType");
		
		$this->categories = implode(";", $this->get("SelectedCategories"));
		if (!empty($this->categories)) {
			$this->categories.=";";
		}

		$this->selectedCategories = $this->get("SelectedCategories");

		if ($this->appSettings->enable_search_filter_events) {
			$this->searchFilter = $this->get('SeachFilter');
		}

		$session = JFactory::getSession();
		$this->radius= $session->get('ev-radius');
		$this->geoLatitude = $session->get('geo-latitude');
		
		$categoryId= $this->get('CategoryId');
		if (!empty($categoryId)) {
			$this->categoryId=$categoryId;
			$this->category = $this->get('Category');
		}
		
		$this->pagination = $this->get('Pagination');
		$this->sortByOptions = $this->get('SortByConfiguration');
		
		$this->filterMonths = $this->get("FilterMonths");

		parent::display($tpl);
	}
}
