<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');
?>

<div itemscope itemtype="http://schema.org/ItemList" class="event-list-style-3 list-style-8" <?php echo $this->appSettings->events_search_view?'style="display: none"':'' ?>>
    <?php
    if(isset($this->events) && count($this->events)>0){
        $itemCount = 0;
        foreach ($this->events as $event){ ?>
            <div class="result-item shadow-border <?php echo !empty($event->featured)==1?"featured":"" ?>">
                <div itemscope itemprop="itemListElement" itemtype="http://schema.org/ListItem">
                    <div itemscope itemprop="item" itemtype="http://schema.org/Event">
                        <div class="row">
                            <div class="col-md-3">
                                <div class="item-image-cover">
                                    <a href="<?php echo JBusinessUtil::getEventLink($event->id, $event->alias) ?>">
                                        <?php if(!empty($event->picture_path)){?>
                                            <img itemprop="image" title="<?php echo $this->escape($event->name) ?>" alt="<?php echo $this->escape($event->name) ?>" src="<?php echo BD_PICTURES_PATH.$event->picture_path?>" >
                                        <?php }else{?>
                                            <img itemprop="image"title="<?php echo $this->escape($event->name)?>" alt="<?php echo $this->escape($event->name)?>" src="<?php echo BD_PICTURES_PATH.'/no_image.jpg' ?>" >
                                        <?php } ?>
                                    </a>
                                </div>
                                <span style="display:none;" itemprop="url"><?php echo JBusinessUtil::getEventLink($event->id, $event->alias) ?></span>
                            </div>
                            <div class="col-md">
                                <div class="result-content">
                                    <h3 class="item-name" itemprop="name">
                                        <a title="<?php echo $this->escape($event->name)?>"	href="<?php echo JBusinessUtil::getEventLink($event->id, $event->alias) ?>"><span ><?php echo $this->escape($event->name)?></span></a>
                                    </h3>
                                    <?php if(!empty($event->company_name)){?>
                                        <div itemprop="" itemscope itemtype="http://schema.org/Organization">
                                            <span><i class="la la-building"></i><span itemprop="name"> <?php echo $this->escape($event->company_name) ?></span></span>
                                        </div>
                                    <?php } ?>

                                    <?php $address =JBusinessUtil::getShortAddress($event); ?>
                                    <?php if(!empty($address)){ ?>
                                        <div class="item-element item-address" itemprop="location" itemscope itemtype="https://schema.org/PostalAddress">
                                            <i class="la la-map-marker"></i> <?php echo $address ?>
                                            <?php if(!empty($event->latitude) && !empty($event->longitude)){?>
                                                - <a target="_blank" href="<?php echo JBusinessUtil::getDirectionURL($this->location, $event) ?>"><?php echo JText::_("LNG_GET_MAP_DIRECTIONS")?></a>
                                            <?php }?>
                                        </div>
                                    <?php } ?>

                                    <?php if(!empty($event->distance)){?>
                                        <div class="item-element">
                                            <?php echo JText::_("LNG_DISTANCE").": ".round($event->distance,1)." ". ($this->appSettings->metric==1?JText::_("LNG_MILES"):JText::_("LNG_KM")) ?>
                                        </div>
                                    <?php } ?>
                                    <?php if ($event->start_date != '0000-00-00'){ ?>
                                        <div class="item-element" itemprop="startDate" content="<?php echo JBusinessUtil::getDateISOFormat($event->start_date, $event->start_time) ?>">
                                            <i class="la la-calendar"></i>12
                                            <?php $dates = JBusinessUtil::getDateGeneralFormat($event->start_date).(!empty($event->start_date) && $event->start_date!=$event->end_date && $event->show_end_date?" - ".JBusinessUtil::getDateGeneralFormat($event->end_date):""); echo $dates; ?>
                                            <?php echo (empty($dates) || ($event->show_start_time==0  && $event->show_end_time==0))?"":"," ?>
                                            <?php echo ($event->show_start_time?JBusinessUtil::convertTimeToFormat($event->start_time):"")." ".(!empty($event->end_time)&&$event->show_end_time?JText::_("LNG_UNTIL"):"")." ".($event->show_end_time?JBusinessUtil::convertTimeToFormat($event->end_time):""); ?>
                                        </div>
                                    <?php } ?>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <?php if(!empty($event->eventType)){?>
                                    <div class="item-element">
                                        <?php echo JText::_("LNG_TYPE")?>: <strong><?php echo $this->escape($event->eventType)?></strong>
                                    </div>
                                <?php } ?>

                                <?php if(!empty($event->categories)){?>
                                    <div class="item-element">
                                        <div style="float:left"><?php echo JText::_('LNG_CATEGORIES')?>:&nbsp;</div>
                                        <ul class="horizontal-list">
                                            <?php foreach($event->categories as $i=>$category){ ?>
                                                <li> <a href="<?php echo JBusinessUtil::getEventCategoryLink($category[0], $category[2]) ?>"><?php echo $this->escape($category[1])?></a><?php echo $i<(count($event->categories)-1)? ',&nbsp;':'' ?></li>
                                            <?php } ?>
                                        </ul>
                                    </div>
                                <?php } ?>

                                <?php if(isset($event->featured) && $event->featured==1){ ?>
                                    <div class="featured-text">
                                        <?php echo JText::_("LNG_FEATURED")?>
                                    </div>
                                <?php } ?>
                            </div>
                        </div>
                    </div>
                    <div style="display:none;" itemprop="position"><?php echo $itemCount ?></div>
                </div>
            </div>
        <?php } ?>
        <?php
        $itemCount++;
    } ?>
</div>