<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');
?>

<div itemscope itemtype="http://schema.org/ItemList" class="event-list-style-2" <?php echo $this->appSettings->events_search_view?'style="display: none"':'' ?>>
	<div class="event-title-row row">
		<div class="col-12 col-lg-3"></div>
		<div class="col-12 col-lg-3"><h3><?php echo (JText::_('LNG_EVENT')) ?></h3></div>
		<div class="col-lg-3 d-none d-lg-block"><h3><?php echo (JText::_('LNG_WHERE')) ?></h3></div>
		<div class="col-lg-3 d-none d-lg-block"><h3><?php echo (JText::_('LNG_WHEN')) ?></h3></div>
	</div>
	<?php if(isset($this->events) && count($this->events)>0){ ?>
		<?php foreach ($this->events as $event){ ?>
			<div itemscope itemprop="itemListElement" itemtype="http://schema.org/ListItem">
                <div itemscope itemprop="item" itemtype="http://schema.org/Event">
					<div class="event-row row <?php echo !empty($event->featured)==1?"featured":"" ?>">
						<div class="event-detail col-lg-3 py-lg-0 pr-lg-0">
							<div class="event-image">
								<a href="<?php echo JBusinessUtil::getEventLink($event->id, $event->alias) ?>"></a>
								<?php if(isset($event->picture_path) && $event->picture_path!=''){?>
									<img itemprop="image" title="<?php echo $event->picture_title ?>" alt="<?php echo $event->picture_info ?>"  src="<?php echo BD_PICTURES_PATH.$event->picture_path?>" >
								<?php }else{?>
									<img itemprop="image" title="<?php echo $this->escape($event->name)?>" alt="<?php echo $this->escape($event->name)?>" src="<?php echo BD_PICTURES_PATH.'/no_image.jpg' ?>" >
								<?php } ?>
							</div>
						</div>
        				<div class="event-detail col-sm-12 col-lg-3">
							<div class="event-details-container">
								<h3 class="event-title">
									<a itemprop="name" title="<?php echo $this->escape($event->name)?>"	href="<?php echo JBusinessUtil::getEventLink($event->id, $event->alias) ?>"><span ><?php echo $this->escape($event->name)?></span></a>
								</h3>
								<span style="display:none;" itemprop="startDate"><?php echo JBusinessUtil::getDateISOFormat($event->start_date, $event->start_time) ?></span>
								<span style="display:none;" itemprop="endDate"><?php echo JBusinessUtil::getDateISOFormat($event->end_date) ?></span>
								<span style="display:none;" itemprop="url"><?php echo JBusinessUtil::getEventLink($event->id, $event->alias) ?></span>
								<span style="display:none;" itemprop="organizer" itemscope itemtype="http://schema.org/Organization"><span itemprop="name"><?php echo $event->companyName ?></span></span>

								<p><?php echo $event->short_description ?></p>
							</div>
        				</div>
                    	<div class="event-detail location col-sm-6 col-lg-3">
                    		<div class="event-venue">
								<?php $address =JBusinessUtil::getShortAddress($event); ?>
								<?php if(!empty($address)){ ?>
									<div class="event-icon">
										<i class="icon map-marker icon-28px"></i>
									</div>
									<div class="item-element item-address" itemprop="location" itemscope itemtype="https://schema.org/PostalAddress">
										<span> <?php echo $address ?></span>
										<?php if(!empty($event->latitude) && !empty($event->longitude)){?>
											<br/> <a target="_blank" href="<?php echo JBusinessUtil::getDirectionURL($this->location, $event) ?>"><?php echo JText::_("LNG_GET_MAP_DIRECTIONS")?></a>
										<?php }?>
									</div>
								<?php } ?>
								
								<?php if(!empty($event->distance)){?>
										<div class="item-element">
										<?php echo JText::_("LNG_DISTANCE").": ".round($event->distance,1)." ". ($this->appSettings->metric==1?JText::_("LNG_MILES"):JText::_("LNG_KM")) ?>
										</div>
								<?php } ?>
                    		</div>
                    	</div>
                    	<div class="event-detail date col-sm-6 col-lg-3">
                    		<div class="event-date">
								<?php if ($event->start_date != '0000-00-00'){ ?>
									<div class="event-icon">
										<i class="icon calendar icon-25px"></i>
									</div>
									
									<div class="item-element">
										<?php echo JBusinessUtil::getDateGeneralShortFormat($event->start_date)?> <?php echo $event->show_end_date && !empty($event->end_date)?" - ".JBusinessUtil::getShortWeekDate($event->end_date):"" ?>
									</div>
									
									<?php if($event->show_start_time && !empty($event->start_time)){?>
										<div class="event-icon">
											<i class="icon clock icon-25px"></i>
										</div>

										<div class="item-element">
											<?php echo ($event->show_start_time?JBusinessUtil::convertTimeToFormat($event->start_time):"")." ".(!empty($event->end_time)&&$event->show_end_time?" - ":"")." ".($event->show_end_time?JBusinessUtil::convertTimeToFormat($event->end_time):""); ?>
										</div>
									<?php } ?>
								<?php } ?>
                    		</div>
                    	</div>
                    </div>
				</div>
			</div>
      <?php } ?>
	<?php } ?>	
</div>