<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');
?>

<div itemscope itemtype="http://schema.org/ItemList" class="event-list-style-1" <?php echo $this->appSettings->events_search_view?'style="display: none"':'' ?>>
	<?php 
	   if(isset($this->events) && count($this->events)>0){
	        $itemCount = 0;
			foreach ($this->events as $event){ ?>
				<div class="result-item <?php echo !empty($event->featured)==1?"featured":"" ?>">
        			<div itemscope itemprop="itemListElement" itemtype="http://schema.org/ListItem">
                        <div itemscope itemprop="item" itemtype="http://schema.org/Event">
                            <div class="row">
								<div class="col-md-3">
									<div class="item-image-cover">
										<a href="<?php echo JBusinessUtil::getEventLink($event->id, $event->alias) ?>">
            								<?php if(isset($event->picture_path) && $event->picture_path!=''){?>
            									<img itemprop="image" title="<?php echo $event->picture_title ?>" alt="<?php echo $event->picture_info ?>" src="<?php echo BD_PICTURES_PATH.$event->picture_path?>" >
            								<?php }else{?>
            									<img itemprop="image" title="<?php echo $this->escape($event->name)?>" alt="<?php echo $this->escape($event->name)?>" src="<?php echo BD_PICTURES_PATH.'/no_image.jpg' ?>" >
            								<?php } ?>
            							</a>
										<?php if(isset($event->featured) && $event->featured==1){ ?>
											<div class="featured-text">
												<?php echo JText::_("LNG_FEATURED")?>
											</div>
										<?php } ?>
									</div>
                                    <span style="display:none;" itemprop="url"><?php echo JBusinessUtil::getEventLink($event->id, $event->alias) ?></span>
                                </div>
								<div class="col-md">
									<div class="result-content">
										<h3 class="item-name" itemprop="name">
											<a title="<?php echo $this->escape($event->name)?>"	href="<?php echo JBusinessUtil::getEventLink($event->id, $event->alias) ?>"><span ><?php echo $this->escape($event->name)?></span></a>
										</h3>
										<div class="row">
											<div class="col-lg-8">
												<?php $address =JBusinessUtil::getShortAddress($event); ?>
												<?php if(!empty($address)){ ?>
													<div class="item-element item-address" itemprop="location" itemscope itemtype="https://schema.org/PostalAddress">
														<i class="icon map-marker"></i> <?php echo $address ?>
														<?php if(!empty($event->latitude) && !empty($event->longitude)){?>
															- <a target="_blank" href="<?php echo JBusinessUtil::getDirectionURL($this->location, $event) ?>"><?php echo JText::_("LNG_GET_MAP_DIRECTIONS")?></a>
														<?php }?>
													</div>
												<?php } ?>

												<div class="item-element">
													<?php if(!empty($event->eventType)){?>
														<?php echo JText::_("LNG_TYPE")?>: <strong><?php echo $this->escape($event->eventType)?></strong>
													<?php } ?>
												</div>

											</div>
											<div class="col-lg-4">
												<?php if(!empty($event->company_name)){?>
													<div itemprop="" itemscope itemtype="http://schema.org/Organization">
														<span><i class="icon business"></i><span itemprop="name"> <?php echo $this->escape($event->company_name) ?></span></span>
													</div>
												<?php } ?>
												<?php if ($event->start_date != '0000-00-00'){ ?>
													<div class="item-element" itemprop="startDate" content="<?php echo JBusinessUtil::getDateISOFormat($event->start_date, $event->start_time) ?>">
													<i class="icon calendar"></i> <?php echo JBusinessUtil::getShortWeekDate($event->start_date) ?> <?php echo $event->show_end_date && !empty($event->end_date)?" - ".JBusinessUtil::getShortWeekDate($event->end_date):"" ?>
													</div>
													<?php if(!empty($event->show_start_time) && !empty($event->start_time)){ ?>
														<div class="item-element">
															<i class="icon clock"></i> <?php echo ($event->show_start_time?JBusinessUtil::convertTimeToFormat($event->start_time):"")." ".(!empty($event->end_time)&&$event->show_end_time?" - ":"")." ".($event->show_end_time?JBusinessUtil::convertTimeToFormat($event->end_time):""); ?>
														</div>
													<?php } ?>
												<?php } ?>

												<?php if(!empty($event->distance)){?>
													<div class="item-element">
														<?php echo JText::_("LNG_DISTANCE").": ".round($event->distance,1)." ". ($this->appSettings->metric==1?JText::_("LNG_MILES"):JText::_("LNG_KM")) ?>
													</div>
												<?php } ?>
											</div>
										</div>

										<div class="event-desciption" itemprop="description">
											<?php echo $event->short_description ?>
										</div>
									</div>
								</div>
							</div>
						</div>
                        <div style="display:none;" itemprop="position"><?php echo $itemCount ?></div>
                    </div>
				</div>
		<?php $itemCount++; } ?>
       <?php } ?>
</div>