<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');
?>

<div id="grid-layout" <?php echo !$this->appSettings->events_search_view?'style="display: none"':'' ?>>
    <div class="events-grid events-grid-style-1 jbd-grid-container">
        <?php $index = 0;?>
        <div class="row has-flex-columns">
            <?php if(!empty($this->events)){?>
           		<?php foreach ($this->events as $event) { ?>
            		<?php $index ++; ?>
            		<div class="col-lg-4 col-sm-6 col-12">
                		<div class="jitem-card jitem-date-right text-left">
                            <?php if (!JBusinessUtil::emptyDate($event->start_date)){ ?>
                                <div class="jitem-date-wrap  bg-dark">
                                    <p><?php echo JBusinessUtil::getWeekDay($event->start_date)?></p>
                                    <p><?php echo JBusinessUtil::getMonth($event->start_date) ?> <?php echo  JBusinessUtil::getDayOfMonth($event->start_date) ?></p>
                                </div>
                            <?php } ?>
                			<div class="jitem-img-wrap">
                				<a href="<?php echo JBusinessUtil::getEventLink($event->id, $event->alias) ?>"></a>
        						 <?php if(!empty($event->picture_path)) { ?>
        							<img src="<?php echo BD_PICTURES_PATH.$event->picture_path ?>" title="<?php echo $event->picture_title ?>" alt="<?php echo $event->picture_info ?>" >
        						<?php } else { ?>
        							<img src="<?php echo BD_PICTURES_PATH.'/no_image.jpg' ?>" alt="<?php echo $event->name ?>">
        						<?php } ?>
        						<?php if(!empty($event->featured)){ ?>
            						<div class="featured-text">
            	                        <?php echo JText::_("LNG_FEATURED")?>
                                    </div>
            		  	  		<?php } ?>
                    			<div class="card-hoverable">
									<a class="hoverable h-100 w-100" href="<?php echo JBusinessUtil::getEventLink($event->id, $event->alias) ?>"></a>
								</div>
                			</div>
                			<div class="jitem-body text-align-left">
                				<div class="jitem-body-content">
                    				<div class="jitem-title">
                    					<a class="item-name" href="<?php echo JBusinessUtil::getEventLink($event->id, $event->alias) ?>" >
                                        	<?php echo $event->name; ?>
                                    	</a>
                    				</div>
                    				<div class="jitem-desc">
                                        <?php if (!JBusinessUtil::emptyDate($event->start_date)){ ?>
                                            <div>
                                                <i class="icon calendar"></i> <?php echo JBusinessUtil::getShortWeekDate($event->start_date) ?> <?php echo $event->show_end_date && !empty($event->end_date)?" - ".JBusinessUtil::getShortWeekDate($event->end_date):"" ?>
                                            </div>
                                        <?php }?>
                    					<?php if($event->show_start_time && !empty($event->start_time)){?>
    										<div>
    											<i class="icon clock"></i> <?php echo ($event->show_start_time?JBusinessUtil::convertTimeToFormat($event->start_time):"")." ".(!empty($event->end_time)&&$event->show_end_time?"-":"")." ".($event->show_end_time?JBusinessUtil::convertTimeToFormat($event->end_time):""); ?>
    										</div>                				
        								<?php }?>
        								<?php  
                                            $address = JBusinessUtil::getShortAddress($event);
                                            if(!empty($address)) {
                                        ?>
                        						<div class="item-address mb-2">
                        							 <i class="icon map-marker"></i> <?php echo $address; ?>
                        						</div>
                                        <?php } ?>
                                        
                                        <?php if(!empty($event->company_name)){?>
                							<div>
                								<span><i class="icon business"></i><span> <?php echo $this->escape($event->company_name) ?></span></span>
                							</div>
            							<?php } ?>
                                        
                                                    				
                                    </div>
                    			</div>
                    		</div>
                		</div>
                	</div>
       			 <?php } ?>
           	 <?php } ?>
        </div>
    </div>
</div>