<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');

$lang = JBusinessUtil::getLanguageTag();
$key  = JBusinessUtil::loadMapScripts();

/**
 * Data for the markers consisting of a name, a LatLng and a zIndex for
 * the order in which these markers should display on top of each
 * other.
 */

$marker = 0;
if (!empty($this->event->categoryMarker)) {
	$marker = BD_PICTURES_PATH. $this->event->categoryMarker;
} else if (!empty($this->event->company->categoryMarker)) {
    $marker = BD_PICTURES_PATH. $this->event->company->categoryMarker;
}

$db = JFactory::getDBO();
if (!empty($this->event->contact_phone)) {
    $contentPhone = '<div class="info-phone"><i class="la la-phone"></i> '.htmlspecialchars($this->event->contact_phone, ENT_QUOTES).'</div>';
} else {
    $contentPhone = '';
}

$contentString =
    '<div class="info-box">'.
    '<div class="title">'.htmlspecialchars($this->event->name).'</div>'.
    '<div class="info-box-content">'.
    '<div class="address" itemtype="http://schema.org/PostalAddress" itemscope="" itemprop="address">'.
    JBusinessUtil::getAddressText($this->event).'</div>'.$contentPhone.
    '</div>'.
    '<div class="info-box-image">'.
    (!empty($this->event->pictures[0]->picture_path)?'<img src="'. BD_PICTURES_PATH.(htmlspecialchars($this->event->pictures[0]->picture_path, ENT_QUOTES)).'" alt="'.htmlspecialchars($this->event->name).'">':"").
    '</div>'.
    '</div>';

$itemLocations = array();
$tmp = array();
if(!empty($this->event->latitude) && !empty($this->event->longitude)){
    $tmp['latitude'] = $this->event->latitude;
    $tmp['longitude'] = $this->event->longitude;
    $tmp['marker'] = $marker;
    $tmp['content'] = $contentString;
}

$itemLocations[] = $tmp;
if(!empty($this->associatedCompanies)){
    foreach($this->associatedCompanies as $company){

        $contentString =
        '<div class="info-box">'.
        '<div class="title">'.htmlspecialchars($company->name).'</div>'.
        '<div class="info-box-content">'.
        '<div class="address" itemtype="http://schema.org/PostalAddress" itemscope="" itemprop="address">'.
        JBusinessUtil::getAddressText($company).'</div>'.
        '</div>'.
        '<div class="info-box-image">'.
        (!empty($company->logoLocation)?'<img src="'. BD_PICTURES_PATH.(htmlspecialchars($company->logoLocation, ENT_QUOTES)).'" alt="'.htmlspecialchars($company->name).'">':"").
        '</div>'.
        '</div>';

        $tmp = array();
        $tmp['latitude'] = $company->latitude;
        $tmp['longitude'] = $company->longitude;
        $tmp['marker'] = $marker;
        $tmp['content'] = $contentString;

        $itemLocations[] = $tmp;
    }
}

$params = array();
$params['map_div'] = 'event-map-2';
$params['map_longitude'] = $this->event->longitude;
$params['map_latitude'] = $this->event->latitude;

$params["map_height"]="255px";

if ($appSettings->map_type == MAP_TYPE_BING) {
	$params["key"] = $key;
}
?>


<div id="event-map-2" style="position:relative;">
</div>

<script>
    var map_instance_event_details;

    function loadEventDetailsViewMap() {
        map_instance_event_details = JBDMapHelper.loadMapScript(
	        <?php echo json_encode($itemLocations) ?>,
            <?php echo json_encode($params) ?>,
            <?php echo $appSettings->map_type ?>
        );
    }
</script>

<?php echo JBusinessUtil::getMapGDPRModal(); ?>