<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

$document = JFactory::getDocument();
$config = JBusinessUtil::getSiteConfig();
$user = JBusinessUtil::getUser();

$base_url = ( isset($_SERVER['HTTPS']) && $_SERVER['HTTPS']=='on' ? 'https' : 'http' ) . '://' .  $_SERVER['HTTP_HOST'];
$url = $base_url . $_SERVER["REQUEST_URI"];


$appSettings = JBusinessUtil::getApplicationSettings();

$showData = !($user->id==0 && $appSettings->show_details_user == 1);
$title = stripslashes($this->event->name)." | ".$config->sitename;

if(!empty($this->event->meta_title))
    $title = stripslashes($this->event->meta_title)." | ".$config->sitename;

$description = $appSettings->meta_description;
if(!empty($this->event->short_description)){
    $description = htmlspecialchars(strip_tags($this->event->short_description), ENT_QUOTES);
}else if(!empty($this->event->description)){
    $description = htmlspecialchars(JBusinessUtil::truncate(strip_tags($this->event->description),150,"..."), ENT_QUOTES);
}
if(!empty($this->event->meta_description))
    $description = $this->event->meta_description;

$keywords = $appSettings->meta_keywords;
if(!empty($this->event->meta_keywords))
    $keywords = $this->event->meta_keywords;

$picturePath = "";
if(!empty($this->event->pictures)){
    $picturePath = $this->event->pictures[0]->picture_path;
}

JBusinessUtil::setMetaData($title, $description, $keywords, false);
JBusinessUtil::setFacebookMetaData($title, $description, $picturePath, $url);
    
$menuItemId = JBusinessUtil::getActiveMenuItem();

$eventUrl = JBusinessUtil::getEventLink($this->event->id, $this->event->alias);
JBusinessUtil::setCanonicalURL($eventUrl);
?>
