<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */

defined('_JEXEC') or die('Restricted access');
?>

<?php
if(!empty($this->eventAttributes)) {
    $attributes = JBusinessUtil::arrangeAttributesByGroup($this->eventAttributes);
    $ungrouped = array();

    if(count($attributes) > 1) { ?>
        <div class='attribute-groups-container'>
            <?php foreach($attributes as $group => $values) { ?>
                <?php if($group != 'ungrouped') {
                    $renderedContent = AttributeService::renderAttributesFront($values, false, array());
                    if(!empty($renderedContent)) { ?>
                        <div class='attribute-group'>
                            <h4><?php echo $group ?></h4>
                            <hr/>
                            <?php
                            echo $renderedContent;
                            ?>
                        </div>
                    <?php } ?>
                <?php } else {
                    $ungrouped = $values;
                } ?>
            <?php } ?>
        </div>
        <?php
        $renderedContent = AttributeService::renderAttributesFront($ungrouped, false, array());
        echo $renderedContent;
    }
    else {?>
        <div class="custom-attributes">
            <?php
            $renderedContent = AttributeService::renderAttributesFront($attributes['ungrouped'], false, array());
            echo $renderedContent;
            ?>
        </div>
        <?php
    }
}
?>