<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');
?>

<div class="row">
    <?php
    if(!empty($this->associatedCompanies)){
        $index = 0;
        foreach ($this->associatedCompanies as $company){
            $index++;
            ?>
            <div class="col-md-4"> 
                <div class="jitem-card">
                    <div class="jitem-img-wrap min-height-sm">
                        <a href="<?php echo JBusinessUtil::getCompanyLink($company) ?>" <?php echo $this->newTab; ?>></a>
                        <?php if(!empty($company->logoLocation) ){?>
                            <img title="<?php echo $this->escape($company->name)?>" alt="<?php echo $this->escape($company->name)?>" src="<?php echo BD_PICTURES_PATH.$company->logoLocation ?>" >
                        <?php }else{ ?>
                            <img title="<?php echo $this->escape($company->name) ?>" alt="<?php echo $this->escape($company->name)?>" src="<?php echo BD_PICTURES_PATH.'/no_image.jpg' ?>" >
                        <?php } ?>
                    </div>      
                    <div class="jitem-body">
                   		<div class="jitem-body-content">
                            <div class="jitem-title">
                            	<a <?php echo $this->newTab; ?> href="<?php echo JBusinessUtil::getCompanyLink($company) ?>"><span ><?php echo $company->name?></span></a>
                            </div>
                            <div class="jitem-desc text-small">
                            	<p><i class="la la-map-marker"></i><?php echo JBusinessUtil::getShortAddress($company) ?></p>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
  	  <?php } ?> 
    <?php } ?>
   
</div>



