<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved. 
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');
?>

<div class='video-container row videos-list-view'>
	<?php 
	if(!empty($this->videos)){
		foreach( $this->videos as $video ){
			if(!empty($video->url))	{
			    ?>
    			<div class="col-md-4">
    				<a class="card-video" href="<?php echo $this->escape($video->url) ?>">
						<div class="card-video-wrap">
							<img src="<?php echo !empty($video->videoThumbnail) ? $video->videoThumbnail  : BD_PICTURES_PATH.'/video_default.jpg' ?>" />
							<div class="play-pause">
								<i class="la la-play"></i>
							</div>
						</div>
						<div class="card-video-title">
							<?php echo $video->title ?>
                        </div>
    				</a>
    			</div>
			<?php }
		}
	} else {
		echo JText::_("LNG_NO_COMPANY_VIDEO");
	} ?>
	<div class="clear"></div>
</div>

<script type="text/javascript">
	window.addEventListener('load', function() {
		jQuery('.card-video').magnificPopup({
			disableOn: 200,
			type: 'iframe',
			mainClass: 'mfp-fade',
			removalDelay: 160,
			preloader: false,
			fixedContentPos: false,
			mainClass: 'mfp-fade'
		});
	});
</script>