<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 
defined('_JEXEC') or die('Restricted access');
?>

<div class="business-hours">
	<fieldset class="fieldset-business_hours">
		<div>
			<strong><i class="icon clock"></i> <?php echo JText::_('LNG_OPENING_HOURS')?></strong>
            <?php if($this->company->opening_status == COMPANY_OPEN_BY_TIMETABLE){ ?>
                <div class="small right"><?php echo JText::_('LNG_GMT')." ".$this->company->time_zone  ;  ?></div>
			    <?php $dayNames = array(JText::_("MONDAY"),JText::_("TUESDAY"),JText::_("WEDNESDAY"),JText::_("THURSDAY"),JText::_("FRIDAY"),JText::_("SATURDAY"),JText::_("SUNDAY")) ?>
                <?php 
                foreach($this->company->business_hours as $index => $day) { ?>
                    <div class="business-hour" itemprop="openingHours">
                        <div class="day"><?php echo $day->name ?></div>
                        <div class="business-hour-time">
                            <?php if ($day->workHours['status']) { ?>
                                <div class="business-hours-wrap">
                                    <span class="start">
                                        <?php echo JBusinessUtil::convertTimeToFormat($day->workHours["start_time"]) ?>
                                    </span>
                                    <?php if(isset($day->breakHours)) { ?>
                                            <span class="end">
                                                - <?php echo JBusinessUtil::convertTimeToFormat($day->breakHours["start_time"][0]) ?>
                                            </span>
                                        </div>
                                        <div class="business-hours-wrap">
                                            <span class="start">
                                                <?php echo JBusinessUtil::convertTimeToFormat($day->breakHours["end_time"][0]) ?>
                                            </span>
                                    <?php } ?>
                                    <span class="end">
                                        - <?php echo JBusinessUtil::convertTimeToFormat($day->workHours['end_time']) ?>
                                    </span>
                                </div>
                            <?php } else { ?>
                                <span class="end"><?php echo JText::_('LNG_CLOSED'); ?></span>
                            <?php } ?>
                        </div>
                    </div>
                <?php } ?>
                
            <?php } else {
                switch($this->company->opening_status){
                    case COMPANY_ALWAYS_OPEN:
                        $status = JText::_('LNG_ALWAYS_OPEN');
                        $class = 'text-success';
                        break;
                    case COMPANY_TEMP_CLOSED:
                        $status = JText::_('LNG_TEMPORARILY_CLOSED');
                        $class = 'text-danger';
                        break;
                    case COMPANY_OPEN_BY_APPOINTMENT:
                        $status = JText::_('LNG_OPEN_BY_APPOINTMENT');
                        $class = 'text-danger';
                        break;
                    case COMPANY_SEASON_CLOSED:
                        $status = JText::_('LNG_COMPANY_SEASON_CLOSED');
                        $class = 'text-danger';
                        break;
                    case COMPANY_PERMANENTLY_CLOSED:
                        $status = JText::_('LNG_PERMANENTLY_CLOSED');
                        $class = 'text-danger';
                        break;
                }
                echo '<div class="font-weight-bold my-2 '.$class.'">'.$status.'</div>';
             }?>
		</div>

		<?php if(!empty($this->company->notes_hours)){ ?>
			<div style="display: block" class="business-notes"><?php echo $this->escape($this->company->notes_hours) ?></div>
		<?php } ?>
	</fieldset>
</div>
