<?php 
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */ 

defined('_JEXEC' ) or die('Restricted access' );

require_once 'header.php';
require_once BD_CLASSES_PATH.'/attributes/attributeservice.php';
$address = JBusinessUtil::getAddressText($this->company); 
?>
<?php
    require_once 'breadcrumbs.php';
?>

<div id="listing-style-1" class="listing-style-1" itemscope itemtype="http://schema.org/LocalBusiness">
	<div class="row">
		<div class="col-12">
			<div class="listing-header">
    			<div class="row">
                	<div class="col-md-7">
                    	<h1 itemprop="name">
                    		<?php  echo isset($this->company->name)?$this->company->name:"" ; ?> 
                    		<?php if($this->company->userId!=0 && $appSettings->show_claimed){ ?>
                    			<span class="claimed"><i class="la la-check"></i> <?php echo JText::_("LNG_CLAIMED")?></span>
							<?php } ?>
							<?php if ($this->company->recommended && $appSettings->show_recommended) { ?>
                    			<span class="recommended"><i class="la la-star"></i> <?php echo JText::_("LNG_RECOMMENDED")?></span>
                    		<?php } ?>

                    	</h1>
                    	<div class="company-info-review">
                				<!-- Business Ratings -->
                             <?php  if ($appSettings->enable_packages && $appSettings->enable_reviews && isset($this->package->features) && in_array(REVIEWS,$this->package->features) || !$appSettings->enable_packages 
					                    && $appSettings->enable_reviews ) {  ?>
                				<div class="company-info-rating" <?php echo !$appSettings->enable_ratings? 'style="display:none"':'' ?>>
                                    <?php if(!empty($this->reviews) > 0) { ?>
                                        <span style="display:none" itemprop="aggregateRating" itemscope itemtype="http://schema.org/AggregateRating">
                                            <span>
                                                 <span itemprop="itemReviewed" itemscope itemtype="http://schema.org/LocalBusiness">
                                                     <span itemprop="name"><?php echo $this->company->name?></span>
                                                     <span itemprop="image"><?php echo BD_PICTURES_PATH.$this->company->logoLocation ?></span>
                                                     <span itemprop="address"><?php echo $address ?></span>
                                                     <span itemprop="telephone"><?php echo $this->company->phone ?></span>
                                                 </span>
                                                <span itemprop="ratingValue"><?php echo $this->company->review_score?></span>  <span itemprop="worstRating">0</span><span itemprop="bestRating">5</span>
                                            </span>
                                            <span itemprop="ratingCount"><?php echo count($this->totalReviews)?></span>
                                        </span>
                                    <?php } ?>
                
                					<div class="rating">
                						<span class="user-rating-avg" id="rating-average" title="<?php echo $company->review_score?>" alt="<?php echo $company->id?>" style="display: block;"></span>
                					</div>
                				</div>
                			<?php } ?>
                			 <?php  if ($appSettings->enable_packages && $appSettings->enable_reviews && isset($this->package->features) && in_array(REVIEWS,$this->package->features) || !$appSettings->enable_packages 
					                    && $appSettings->enable_reviews ) {  ?>
                                <div class="review-count">
                                    <?php if(count($this->totalReviews)){ ?>
                                        <a href="javascript:void(0)" onclick="jQuery('#dir-tab-3').click()"><?php echo count($this->totalReviews)?> <?php echo JText::_('LNG_REVIEWS') ?></a>
                                        &nbsp;|&nbsp;
                                        <a href="javascript:void(0)" onclick="jbdReviews.addNewReviewOnTabs(<?php echo ($appSettings->enable_reviews_users && $user->id ==0) ?"1":"0"?>)"> <?php echo JText::_('LNG_WRITE_REVIEW') ?></a>
                                    <?php } else{ ?>
                                        <a href="javascript:void(0)" onclick="jbdReviews.addNewReviewOnTabs(<?php echo ($appSettings->enable_reviews_users && $user->id ==0) ?"1":"0"?>)" ><?php echo JText::_('LNG_BE_THE_FIRST_TO_REVIEW') ?></a>
                                    <?php }?>
                                </div>
                            <?php } ?>
                		</div>
                    	<?php if(!empty($this->company->slogan)){?>
                    		<div class="business-slogan"><?php echo  $this->company->slogan ?> </div>
                    	<?php }?>
                	</div>
                	<div class="col-md-5 text-right header-icons">	
                    	<?php require_once JPATH_COMPONENT_SITE."/include/social_share.php"?>
                        <div class="dir-print">
                            <a rel="nofollow" href="javascript:jbdUtils.printItem('<?php echo JRoute::_("index.php?option=com_jbusinessdirectory&view=companies&tmpl=component&layout=print&companyId=".$this->company->id); ?>')"><i class="icon print-circle"></i></a>
	                        <?php if($appSettings->show_contact_cards){?>
                                <a rel="nofollow" href="<?php echo JRoute::_("index.php?option=com_jbusinessdirectory&task=companies.generateQrCode&itemId=".$this->company->id); ?>"><i class="la la-qrcode"></i> <?php echo JText::_("LNG_QR_CODE")?></a>
                            
                                <a rel="nofollow" href="<?php echo JRoute::_("index.php?option=com_jbusinessdirectory&task=companies.generateVCard&itemId=".$this->company->id); ?>"><i class="icon message"></i> <?php echo JText::_("LNG_VCARD")?></a>
    	                    <?php } ?>
						</div>
                	</div>
               	</div>
           	</div>
        </div>
    </div>
    <div class="row">
    	<div id="company-info" class="dir-company-info col-lg-4">
    		<?php if(isset($this->package->features) && in_array(SHOW_COMPANY_LOGO,$this->package->features) || !$appSettings->enable_packages){ ?>
                <span itemprop="image" style="display:none;"><?php echo (!empty($this->company->logoLocation)) ? BD_PICTURES_PATH.$this->company->logoLocation : BD_ASSETS_FOLDER_PATH."no_image.jpg" ?></span>
    
                <div class="company-image" itemprop="logo" itemscope itemtype="http://schema.org/ImageObject">
        			<?php if(!empty($this->company->logoLocation)){?>
        				<img title="<?php echo $this->escape($this->company->name) ?>" alt="<?php echo $this->escape($this->company->name) ?>" src="<?php echo BD_PICTURES_PATH.$this->company->logoLocation ?>" itemprop="contentUrl">
        			<?php }else{ ?>
        				<img title="<?php echo $this->escape($this->company->name) ?>" alt="<?php echo $this->escape($this->company->name) ?>" src="<?php echo BD_PICTURES_PATH.'/no_image.jpg' ?>" itemprop="contentUrl">
        			<?php } ?>
    				<?php if($this->appSettings->enable_bookmarks) { ?>
    					<div id="bookmark-container">
                            <?php if(!empty($company->bookmark)) { ?>
                                <a id="bookmark-<?php echo $company->id ?>" href="javascript:jbdUtils.showUpdateBookmarkDialog(<?php echo $user->id==0?"1":"0"?>,<?php echo $company->id ?>,<?php echo BOOKMARK_TYPE_BUSINESS ?>)"  title="<?php echo JText::_("LNG_UPDATE_BOOKMARK")?>" class="bookmark"><i class="la la-heart"></i> </a>
                            <?php } else {?>
                                <a id="bookmark-<?php echo $company->id ?>" href="javascript:jbdUtils.showAddBookmark(<?php echo $user->id==0?"1":"0"?>,<?php echo $company->id ?>,<?php echo BOOKMARK_TYPE_BUSINESS ?>)" title="<?php echo JText::_("LNG_ADD_BOOKMARK")?>" class="bookmark"><i class="la la-heart-o"></i> </span></a>
                            <?php } ?>
                        </div>
    				<?php } ?>
    			
    				<?php
    				if($appSettings->show_open_status && $this->company->enableWorkingStatus && (!$appSettings->enable_packages || isset($this->package->features) && in_array(OPENING_HOURS,$this->package->features) && $this->company->enableWorkingStatus)) {
    					if ($this->company->workingStatus) {?>
    						<div class="ribbon-open"><span><?php echo JText::_("LNG_OPEN")?></span></div>
    					<?php } else{ ?>
    						<div class="ribbon-close"><span><?php echo JText::_("LNG_CLOSED")?></span></div>
    					<?php } ?>
    				<?php } ?>
    			</div>
    		<?php } ?>
    		<div class="d-flex flex-column">
    			<div class="listing-info""> 
        			<div>		
        				<div id="company-info-details" class="company-info-details">
        					<ul class="company-contact">
        						<li>
                                    <?php if($showData && !empty($address)) { ?>
        							<span itemprop="address">
        								<i class="icon map-marker"></i> <?php echo $this->escape($address) ?>
        							</span>
                                    <?php } ?>
        						</li>
        						<li>
        							<?php if($showData && (isset($this->package->features) && in_array(PHONE, $this->package->features) || !$appSettings->enable_packages )) { ?>
                                        <?php if(!empty($this->company->phone)) { ?>
                                            <div>
                                                <span class="phone" itemprop="telephone">
                                                    <i class="icon phone-o"></i> <a href="tel:<?php echo $this->escape($this->company->phone); ?>"><?php echo $this->escape($this->company->phone); ?></a>
                                                </span>
                                            </div>
                                        <?php } ?>
    
                						
                                        <?php if($showData && !empty($this->company->mobile)) { ?>
                                            <div>
                                                <span class="phone" itemprop="telephone">
                                                    <i class="icon mobile"></i> <a href="tel:<?php echo $this->escape($this->company->mobile); ?>"><?php echo $this->escape($this->company->mobile); ?></a>
                                                </span>
                                            </div>
                                        <?php } ?>
    
                                        <?php if($showData && !empty($this->company->fax)) {?>
                                            <div>
                                                <span class="faxNumber">
                                                    <i class="la la-fax la-fw"></i> <?php echo $this->escape($this->company->fax) ?>
                                                </span>
                                            </div>
                                        <?php } ?>
                                    <?php } ?>
        						</li>
        						<li>
        							<?php if(!empty($this->company->email) && $showData && $appSettings->show_email){?>
            							<div>
                        					<span itemprop="email">
                        						<i class="icon envelope"></i> <a href="mailto:<?php echo $this->escape($this->company->email) ?>"><?php echo $this->escape($this->company->email) ?></a>
                        					</span>
                       					</div>
            						<?php } ?>
        						</li>
        						<li>
        							<?php if($showData && (isset($this->package->features) && in_array(WEBSITE_ADDRESS,$this->package->features) || !$appSettings->enable_packages) && !empty($this->company->website)){
        								if ($appSettings->enable_link_following){
        								$followLink = (isset($this->package->features) && in_array(LINK_FOLLOW,$this->package->features) && $appSettings->enable_packages)?'rel="follow noopener"' : 'rel="nofollow noopener"';
        								}else{
        									$followLink ='rel="noopener"';
        								}?>
        								<span>
        									<i class="icon link-square"></i> <a target="_blank" <?php echo $followLink ?> itemprop="url" title="<?php echo $this->escape($this->company->name) ?> Website" target="_blank" onclick="jbdUtils.registerStatAction(<?php echo $company->id ?>,<?php echo STATISTIC_ITEM_BUSINESS ?>,<?php echo STATISTIC_TYPE_WEBSITE_CLICK ?>)" href="<?php echo $this->escape($company->website) ?>"> <?php echo $company->website ?></a>
        								</span>
        							<?php } else { ?>
                                        <span style="display:none;" itemprop="url">
                                            <?php echo JBusinessUtil::getCompanyLink($this->company); ?>
                                        </span>
                                    <?php } ?>
        						</li>
                                <li>
                                    <?php if(!empty($appSettings->content_responsible)){?>
                                        <span>
        									<i class="icon info-circle"></i> <a href="javascript:void(0)" id="content-responsible-link"><?php echo JText::_('LNG_CONTENT_RESPONSIBLE_PERSON')?></a>
        								</span>
                                        <div id="content_responsible_text" style="display: none;">
                                            <?php echo JHTML::_("content.prepare", $appSettings->content_responsible); ?>
                                        </div>
                                    <?php } ?>
                                </li>
        					</ul>
        					<div class="clear" ></div>
        					
        					<?php if(!empty($this->company->categoriesDetails)){?>
					            <dt><?php echo JText::_('LNG_CATEGORIES')?>:</dt>
					            <dd>
					                <?php require_once 'listing_categories.php';?>
					            </dd>
							<?php } ?>
        					
        					<?php if($showData && (isset($this->package->features) && in_array(CONTACT_FORM, $this->package->features) || !$appSettings->enable_packages)) { ?>
    							<?php if(!empty($this->companyContacts) && (!empty($this->companyContacts[0]->contact_name) || !empty($this->companyContacts[0]->contact_phone) )) { ?>
    								<strong><?php echo count($this->companyContacts)>1?JText::_('LNG_CONTACT_PERSONS'):JText::_('LNG_CONTACT_PERSON'); ?></strong>
    								<ul>
    									<li>
    										
    										<?php require_once 'contact_details.php'; ?>
    									</li>
    								</ul>
    							<?php } ?>
    						<?php } ?>
    						
    						<div class="contact-actions">
        						
                                
                                <?php if($appSettings->enable_reporting){?>
                    				<div>
                    					 <a href="javascript:jbdListings.showReportAbuse()"><i class="la la-flag"></i> <?php echo JText::_('LNG_REPORT_LISTING'); ?></a>
                    				</div>
                    			<?php } ?>
                                
								<div class="contact-listing text-center">
									<?php if($showData && (isset($this->package->features) && in_array(CONTACT_FORM, $this->package->features) || !$appSettings->enable_packages)
										&& !empty($this->company->email) && $appSettings->enable_request_quote) { ?>
											<a class="btn btn-primary" href="javascript:jbdListings.showQuoteCompany('<?php echo $this->company->id?>','<?php echo $showData?"1":"0"?>')">
												<i class="la la-edit"></i> <?php echo JText::_("LNG_QUOTE")?>
											</a>
									<?php } ?>

									<?php if((isset($this->package->features) && in_array(CONTACT_FORM,$this->package->features) || !$appSettings->enable_packages) && !empty($this->company->email) && $appSettings->show_contact_form){ ?>
										<button type="button" class="btn btn-primary" onclick="jbdListings.contactCompany(<?php echo $showData?"1":"0"?>)">
											<i class="la la-envelope"></i> <?php echo JText::_("LNG_CONTACT_COMPANY")?>
										</button>
									<?php } ?>
								</div>

                                <div class="contact-listing">
								    <?php if($this->showListLinkButton && $appSettings->enable_linked_listings) { ?>
                                        <button class="btn btn-outline w-100" onclick="jbdListings.joinListing(<?php echo count($this->joinedCompanies); ?>,<?php echo $this->company->id ?>,<?php echo ($user->id == 0)?0:1 ?>,<?php echo count($this->userCompanies)<2?false:true; ?>)">
                                            <i class="la la-user"></i>
										    <?php  echo JText::_('LNG_JOIN_LEAVE'); ?>
                                        </button>
								    <?php } ?>
                                </div>
            					
        					</div>
        					
        					<?php if($showData && (isset($this->package->features) && in_array(SOCIAL_NETWORKS, $this->package->features) || !$appSettings->enable_packages)
                                && ((!empty($this->company->linkedin) || !empty($this->company->youtube) ||!empty($this->company->facebook) || !empty($this->company->twitter)
                                    || !empty($this->company->linkedin) || !empty($this->company->skype)|| !empty($this->company->instagram) || !empty($this->company->pinterest) || !empty($this->company->whatsapp)))) {
                                require_once 'listing_social_networks.php';
                                }
                            ?>
        				</div>
        			</div>
    			</div>
    			<?php if((isset($this->package->features) && in_array(OPENING_HOURS,$this->package->features) || !$appSettings->enable_packages)
    					&& (!empty($this->company->business_hours) && $this->company->enableWorkingStatus) || $this->company->opening_status != COMPANY_OPEN_BY_TIMETABLE){ ?>
    					<?php require_once 'listing_hours.php'; ?>
    			<?php } ?>
    			
    			<?php if((!isset($this->company->userId) || $this->company->userId == 0) && $appSettings->claim_business) { ?>
                    <div class="claim-listing-wrapper">
                        <div class="claim-listing-content">
                            <h4 class="claim-listing-title"><?php echo JText::_("LNG_IS_YOUR_BUSINESS") ?></h4>
                            <p class="claim-listing-description"><?php echo JText::_("LNG_CLAIM_BENEFIT") ?></p>
                        </div>
                       <a class="round-border-buton" href="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&task=businessuser.checkUser&claim_listing_id='.$this->company->id) ?>"><?php echo JText::_('LNG_CLAIM_COMPANY')?></a>
                    </div>
                <?php  } ?>
    		</div>
    	</div>
    	<div id="tab-panel" class="dir-tab-panel col-lg-8">
    		<div id="tabs" class="clearfix">
    			<ul class="tab-list">
    				<?php
    					$tabs = array();
    				    if (isset($this->package->features) && in_array(DESCRIPTION,$this->package->features) || !$appSettings->enable_packages) {
    					    $tabs[1] = JText::_('LNG_DETAILS');
    				    }
    					if($showData && (isset($this->package->features) && in_array(GOOGLE_MAP,$this->package->features) || !$appSettings->enable_packages )
    							&& !empty($this->company->latitude) && !empty($this->company->longitude)){ 
    						$tabs[2]=JText::_('LNG_MAP');
    					}
						if ($appSettings->enable_packages && $appSettings->enable_reviews && isset($this->package->features) && in_array(REVIEWS,$this->package->features) || !$appSettings->enable_packages 
							&& $appSettings->enable_reviews ) { 
    						$tabs[3]=JText::_('LNG_REVIEWS');
    					}
    					if((isset($this->package->features) && in_array(IMAGE_UPLOAD,$this->package->features) || !$appSettings->enable_packages)
    							&& !empty($this->pictures)){
    						$tabs[4]=JText::_('LNG_GALLERY');
    					}
    					if((isset($this->package->features) && in_array(VIDEOS,$this->package->features) || !$appSettings->enable_packages)
    							&& isset($this->videos) && count($this->videos)>0){
    						$tabs[5]=JText::_('LNG_VIDEOS');
    					}
    					if((isset($this->package->features) && in_array(COMPANY_OFFERS,$this->package->features) || !$appSettings->enable_packages)
    							&& isset($this->offers) && count($this->offers) && $appSettings->enable_offers){
    						$tabs[6]=JText::_('LNG_OFFERS');
    					}
    					
    					if((isset($this->package->features) && in_array(COMPANY_EVENTS,$this->package->features) || !$appSettings->enable_packages)
    							&& isset($this->events) && count($this->events) && $appSettings->enable_events){
    						$tabs[7]=JText::_('LNG_EVENTS');
    					}
    					
    					if(!empty($this->company->locations) && $appSettings->show_secondary_locations == 1 
    							&& (isset($this->package->features) && in_array(SECONDARY_LOCATIONS, $this->package->features) || !$appSettings->enable_packages)){ 
    						$tabs[8]=JText::_('LNG_COMPANY_LOCATIONS');
    					}
    					
    					if((isset($this->package->features) && in_array(CUSTOM_TAB,$this->package->features) || !$appSettings->enable_packages)
    					   && !empty($this->company->custom_tab_name)){
    						$tabs[10]=$this->company->custom_tab_name;
    					}
    					
    					if((isset($this->package->features) && in_array(COMPANY_SERVICES,$this->package->features) || !$appSettings->enable_packages)
    						&& isset($this->services) && count($this->services) && $appSettings->enable_services){
    						$tabs[13]=JText::_('LNG_SERVICES');
    					}
    
    					if((isset($this->package->features) && in_array(SOUNDS_FEATURE,$this->package->features) || !$appSettings->enable_packages)
    							&& !empty($this->sounds)) { 
    						$tabs[14]=JText::_('LNG_SOUNDS');
    					}
    
                        if((isset($this->package->features) && in_array(SERVICES_LIST,$this->package->features) || !$appSettings->enable_packages)
                                && !empty($this->services_list) && count($this->services_list) && $appSettings->enable_price_list){
                            $tabs[15]=JText::_('LNG_PRICE_LIST');
                        }
    
                        if((isset($this->package->features) && in_array(TESTIMONIALS,$this->package->features) || !$appSettings->enable_packages)
                            && count($this->companyTestimonials)){
                                $tabs[16]=JText::_('LNG_TESTIMONIALS');
                        }
                                                
                        if((isset($this->package->features) && in_array(PROJECTS,$this->package->features) || !$appSettings->enable_packages) 
							&& !empty($this->companyProjects)){
                            	$tabs[17]=JText::_('LNG_PROJECTS');
                        }

                        if((isset($this->package->features) && in_array(MEMBERSHIPS,$this->package->features) || !$appSettings->enable_packages) && !empty($this->memberships)){
                            $tabs[18]=JText::_('LNG_MEMBERSHIPS');
                        }

                        if((isset($this->package->features) && in_array(PRODUCTS,$this->package->features) || !$appSettings->enable_packages)
	                        && isset($this->productCategories) && count($this->productCategories)){
                            $tabs[19]=JText::_('LNG_PRODUCTS');
                        }
                        
                        if ((isset ( $this->package->features ) && in_array ( ANNOUNCEMENTS, $this->package->features ) || ! $appSettings->enable_packages) && ! empty ( $this->companyAnnouncements ) && count ( $this->companyAnnouncements ) && $appSettings->enable_announcements) {
                        	$tabs [20] = JText::_ ( 'LNG_ANNOUNCEMENTS' );
                        }

                        if (!empty($this->associatedCompanies) && $appSettings->enable_linked_listings) {
                            $tabs [21] = JText::_ ( 'LNG_LINKED_COMPANIES' );
                        }

                        if(!empty($this->companyArticles) && file_exists(JPATH_SITE.'/plugins/content/business/business.php')) { 
                        	$tabs [22] = JText::_ ( 'LNG_LISTING_ARTICLES' );
						}
						
                        if((!empty($this->teamMembers['leadership']) || !empty($this->teamMembers['team'])) && (isset($this->package->features)
                                && in_array(TEAM_FEATURE, $this->package->features) || !$appSettings->enable_packages) ){
							$tabs [23] = JText::_ ( 'LNG_TEAM' );
						}
						
						 if (isset($this->offers) && count($this->offers) && in_array("1", array_column($this->offers, "add_to_price_list")) && $appSettings->enable_offers && $appSettings->show_offer_price_list) { 
							$tabs [24] = JText::_ ( 'LNG_OFFERS_PRICE_LIST' );
						}
                        
    					foreach($tabs as $key=>$tab){
    					?>
    						<li class="dir-dir-tabs-options"><span id="dir-tab-<?php echo $key?>" onclick="jbdListings.showDirTab('#tabs-<?php echo $key?>')" class="track-business-details"><?php echo $tab?></span></li>
    					<?php } ?>
    			</ul>
    
    			<?php if (isset($this->package->features) && in_array(DESCRIPTION,$this->package->features) || !$appSettings->enable_packages){ ?>
    				<div id="tabs-1" class="dir-tab ui-tabs-panel">
    					<?php require_once 'details.php'; ?>
    				</div>
    			<?php } ?>
    
    			<?php if((isset($this->package->features) && in_array(GOOGLE_MAP,$this->package->features) || !$appSettings->enable_packages )
    							&& isset($this->company->latitude) && isset($this->company->longitude)){
    			?>
    			<div id="tabs-2" class="dir-tab ui-tabs-panel">
    				<?php
    					if(!empty($this->company->latitude) && !empty($this->company->longitude))
    						require_once 'map.php';
    					else
    						echo JText::_("LNG_NO_MAP_COORDINATES_DEFINED");
    				?>
    			</div>
    			<?php } ?>
    
    			<?php  if ($appSettings->enable_packages && $appSettings->enable_reviews && isset($this->package->features) && in_array(REVIEWS,$this->package->features) || !$appSettings->enable_packages 
					            && $appSettings->enable_reviews ) {  ?>
    				<div id="tabs-3" class="dir-tab ui-tabs-panel">
    					<?php require_once 'listing_reviews.php'; ?>
						<?php if(!$appSettings->enable_reviews_users || !$user->id ==0) { ?>
							<?php require_once 'default_addreview.php'; ?>
						<?php } ?>
    				</div>
    			<?php }?>
    			<?php
    				if((isset($this->package->features) && in_array(IMAGE_UPLOAD,$this->package->features) || !$appSettings->enable_packages)
    					&& !empty($this->pictures)){
    			?>
    			<div id="tabs-4" class="dir-tab ui-tabs-panel">
    				<?php require_once JPATH_COMPONENT_SITE.'/include/image_gallery.php'; ?>
    
    			</div>
    			<?php } ?>
    
    			<?php
    				if((isset($this->package->features) && in_array(VIDEOS,$this->package->features) || !$appSettings->enable_packages)
    					&& isset($this->videos) && count($this->videos)>0){
    			?>
    			<div id="tabs-5" class="dir-tab ui-tabs-panel">
    				<?php require_once 'listing_videos.php'; ?>
    			</div>
    			<?php } ?>
    
    			<?php
    				if((isset($this->package->features) && in_array(COMPANY_OFFERS,$this->package->features) || !$appSettings->enable_packages)
    					&& isset($this->offers) && count($this->offers) && $appSettings->enable_offers){
    			?>
    			<div id="tabs-6" class="dir-tab ui-tabs-panel" itemprop="hasOfferCatalog" itemscope itemtype="http://schema.org/OfferCatalog">
    				<?php require_once 'listing_offers.php'; ?>
    			</div>
    			<?php } ?>
    
    			<?php
    				if((isset($this->package->features) && in_array(COMPANY_EVENTS,$this->package->features) || !$appSettings->enable_packages)
    					&& isset($this->events) && count($this->events) && $appSettings->enable_events){
    			?>
					<div id="tabs-7" class="dir-tab ui-tabs-panel">
						<?php require_once 'listing_events.php'; ?>

						<?php if(!empty($this->associatedEvents) && $appSettings->enable_events){ ?>
							<div class="associated-events pt-3">
								<?php echo JText::_('LNG_ASSOCIATED_EVENTS') ?>
								<?php require_once 'listing_associated_events.php'; ?>
							</div>
						<?php } ?>
					</div>
    			<?php } ?>
    
    			<?php if(!empty($this->company->locations) && $appSettings->show_secondary_locations == 1 
    					&& (isset($this->package->features) && in_array(SECONDARY_LOCATIONS, $this->package->features) || !$appSettings->enable_packages)){ ?>
    				<div id="tabs-8" class="dir-tab ui-tabs-panel">
    					<?php require_once 'locations.php'; ?>
    				</div>
    			<?php } ?>
    
    			<?php if((isset($this->package->features) && in_array(CUSTOM_TAB,$this->package->features) || !$appSettings->enable_packages)
    					   && !empty($this->company->custom_tab_name)){ ?>
    				<div id="tabs-10" class="dir-tab ui-tabs-panel">
    					<?php echo JHTML::_("content.prepare",$this->company->custom_tab_content); ?>
    				</div>
    			<?php } ?>
    		
    			<?php
    			if((isset($this->package->features) && in_array(COMPANY_SERVICES,$this->package->features) || !$appSettings->enable_packages)
    				&& isset($this->services) && count($this->services) && $appSettings->enable_services){
    				?>
    				<div id="tabs-13" class="dir-tab ui-tabs-panel">
    					<?php require_once 'listing_services.php';?>
    				</div>
    			<?php } ?>
    			
    			<?php if((isset($this->package->features) && in_array(SOUNDS_FEATURE,$this->package->features) || !$appSettings->enable_packages)
    							&& !empty($this->sounds)) { ?>
    				<div id="tabs-14" class="dir-tab ui-tabs-panel">
    					<?php require_once 'listing_sounds.php'; ?>
    				</div>
    			<?php } ?>
				
                <?php
                if((isset($this->package->features) && in_array(SERVICES_LIST,$this->package->features) || !$appSettings->enable_packages)
                        && !empty($this->services_list) && $appSettings->enable_price_list){
                    ?>
                    <div id="tabs-15" class="dir-tab ui-tabs-panel">
                        <?php require_once 'listing_price_list.php';?>
                    </div>
                <?php } ?>
               
                <?php
                if((isset($this->package->features) && in_array(TESTIMONIALS,$this->package->features) || !$appSettings->enable_packages)
                        && !empty($this->companyTestimonials)){
                    ?>
                    <div id="tabs-16" class="dir-tab ui-tabs-panel" >
                        <?php require_once 'listing_testimonials.php';?>
                    </div>
                <?php } ?>
    
                <?php if((isset($this->package->features) && in_array(PROJECTS,$this->package->features) || !$appSettings->enable_packages) 
						&& !empty($this->companyProjects)){?>
                    <div id="tabs-17" class="dir-tab ui-tabs-panel" >
                        <?php require_once 'listing_projects.php';?>
                    </div>
                <?php } ?>

                <?php if((isset($this->package->features) && in_array(MEMBERSHIPS,$this->package->features) || !$appSettings->enable_packages) && !empty($this->memberships)) { ?>
                    <div id="tabs-18" class="dir-tab ui-tabs-panel" >
                        <?php require_once 'listing_memberships.php';?>
                    </div>
                <?php } ?>

                <!-- Listing Products -->
                <?php if((isset($this->package->features) && in_array(PRODUCTS,$this->package->features) || !$appSettings->enable_packages)
                    && isset($this->productCategories) && count($this->productCategories)) { ?>
                    <div id="tabs-19" class="dir-tab ui-tabs-panel" >
                        <?php require_once 'listing_product_categories.php';?>
                    </div>
                <?php } ?>
                
                <?php if((isset($this->package->features) && in_array(ANNOUNCEMENTS,$this->package->features) || !$appSettings->enable_packages)
	                && !empty($this->companyAnnouncements) && count($this->companyAnnouncements) && $appSettings->enable_announcements){
	                ?>
		                <div id="tabs-20" class="dir-tab ui-tabs-panel" >
		                    <?php require_once 'listing_announcements.php';?>
		                </div>
	            <?php } ?>

			    <?php if(!empty($this->associatedCompanies) && $appSettings->enable_linked_listings){
				    ?>
                    <div id="tabs-21" class="dir-tab ui-tabs-panel" >
					    <?php require_once 'listing_associated_companies.php';?>
                    </div>
			    <?php } ?>
			    
			    <?php if(!empty($this->companyArticles) && file_exists(JPATH_SITE.'/plugins/content/business/business.php')) { ?>
                    <div id="tabs-22" class="dir-tab ui-tabs-panel">
					    <?php require 'listing_articles.php'; ?>
                    </div>
				<?php } ?>
				
				<?php if((!empty($this->teamMembers['leadership']) || !empty($this->teamMembers['team'])) && (isset($this->package->features)
                	    && in_array(TEAM_FEATURE, $this->package->features) || !$appSettings->enable_packages) ){
				?>
				 	<div id="tabs-23" class="dir-tab ui-tabs-panel">
					   <?php require_once 'listing_team.php'; ?>
				 	</div>
				<?php } ?>
				
				<?php if (isset($this->offers) && count($this->offers)  && in_array("1", array_column($this->offers, "add_to_price_list")) && $appSettings->enable_offers && $appSettings->show_offer_price_list) { ?>
				 	<div id="tabs-24" class="dir-tab ui-tabs-panel">						 
					 	<?php if($appSettings->offer_price_list_view_style == 1) {
								require_once 'listing_offers_price_list_style_2.php';
							} else {
								require_once 'listing_offers_price_list.php';
							}
						?>    
				 	</div>
			    <?php } ?>
    	</div>
	</div>
</div >
<div class="clear"></div>

<form name="tabsForm" action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory'.$menuItemId) ?>" id="tabsForm" method="post">
 	 <input type="hidden" name="option"	value="<?php echo JBusinessUtil::getComponentName()?>" />
	 <input type="hidden" name="task" value="companies.displayCompany" /> 
	 <input type="hidden" name="tabId" id="tabId" value="<?php echo $this->tabId?>" /> 
	 <input type="hidden" name="view" value="companies" /> 
	 <input type="hidden" name="layout2" id="layout2" value="" /> 
	 <input type="hidden" name="companyId" value="<?php echo $this->company->id?>" />
	 <input type="hidden" name="controller"	value="companies" />
</form>
</div>

<?php
jimport('joomla.application.module.helper');
// this is where you want to load your module position
$modules = JModuleHelper::getModules('dir-listing');

if(isset($modules) && count($modules)>0){
    $fullWidth = false; ?>
    <div class="dir-company-module">
        <?php foreach($modules as $module) {
            echo JModuleHelper::renderModule($module, array("style"=>"xhtml"));
        } ?>
    </div>
<?php }
?>

<script>
window.addEventListener('load', function(){
    jbdListings.initTabs(<?php echo $this->tabId ?>);
});
</script>

<?php require_once 'listing_util.php'; ?>