<?php 
/**
* @copyright	Copyright (C) 2008-2009 CMSJunkie. All rights reserved.
* 
* This program is free software: you can redistribute it and/or modify
* it under the terms of the GNU General Public License as published by
* the Free Software Foundation
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  
* See the GNU General Public License for more details.
* You should have received a copy of the GNU General Public License
* along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

defined('_JEXEC') or die('Restricted access');
JHtml::_('behavior.keepalive');

$language = JFactory::getLanguage();
$language->load('com_users');

$showOnlyLogin = JFactory::getApplication()->input->get('showOnlyLogin');
?>

<div class="jbd-container jbd-edit-container">
    <?php if(!empty($this->filter_package)){?>
        <div id="process-container" class="process-container">
        	<ol class="process-steps">
        		<li class="is-complete inbox" data-step="1">
        			<p><?php echo JText::_("LNG_CHOOSE_PACKAGE")?></p>
        		</li>
        		<li class="is-active user" data-step="2">
        			<p><?php echo JText::_("LNG_BASIC_INFO")?></p>
        		</li>
        		<li class="progress__last file-text" data-step="3">
        			<p><?php echo JText::_("LNG_LISTING_INFO")?></p>
        		</li>
        	</ol>
        	<div class="clear"></div>
        </div>
    <?php } ?>	
    
    <div id="user-details" class="user-details">
    	<div class="row">
        	<?php if(!empty($this->package)){?>
            	<div class="col-md-3">
            		<div class="featured-product-col" >
            			<?php
            				$package = $this->package;
            				require  JPATH_COMPONENT_SITE."/views/packages/tmpl/default_package.php"
            			?>
            		</div>
            	</div>
        	<?php }?>
        
        	<?php
        		$usersConfig = JComponentHelper::getParams('com_users');
        		if ($usersConfig->get('allowUserRegistration') && empty($showOnlyLogin)){ ?>
        		<div class="col-md">
        			<form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&task=businessuser.addUser'); ?>" method="post" name="registration-form" id="registration-form" >
        				<fieldset>
        					<h3><?php echo JText::_("LNG_USER_REGISTRATION_DETAILS")?></h3>
        					<p>
        						<?php echo JText::_("LNG_USER_REGISTRATION_DETAILS_TXT")?>
        					</p>
        					<div class="form-group">
        						<label for="username"><?php echo JText::_('LNG_NAME') ?></label>
        						<div class="outer_input">
        							<input type="text" name="name" id="name" size="50" class="form-control validate[required]">
        						</div>
        					</div>
        					<div class="form-group">
        						<label for="username"><?php echo JText::_('LNG_USERNAME') ?></label>
        						<div class="outer_input">
        							<input type="text" name="username" id="username" size="50" onkeyup="jbdUtils.checkUserByUsername('username')" class="form-control validate[required]">        						
									<p class="usernameWarning" style="color:red"><p>
								</div>
        					</div>
        					<div class="form-group">
        						<label for="email"><?php echo JText::_('LNG_EMAIL') ?></label>
        						<div class="outer_input">
        							<input type="text" name="email" id="email" size="50" onkeyup="jbdUtils.checkUserByEmail('email')" class="form-control validate[required,custom[email]]">
								    <p class="emailWarning" style="color:red"><p>
        						</div>
        					</div>
        					<div class="form-group">
        						<label for="password"><?php echo JText::_('LNG_PASSWORD') ?></label>
        						<div class="outer_input">
        							<input type="password" name="password" id="password" size="50" class="form-control validate[required,minSize[6]]">
        						</div>
        					</div>
        					<?php if($this->appSettings->captcha){?>
        						<div class="form-group">
        							<?php 
        							$namespace="jbusinessdirectory.contact";
        							$class=" required";
        							
        							$captcha = JCaptcha::getInstance("recaptcha");
        																
        							if(!empty($captcha)){	
        								echo $captcha->display("captcha", "captcha-div-registration", $class);
        							}
        							?>
        						</div>
        					<?php } ?>
        					
        					<div class="control-group">
            					<div class="form-group py-2">
									<?php echo JBusinessUtil::renderTermsAndConditions(); ?>
        						</div>		
        					</div>	
        							
        					<div class="control-group">
            					<div class="form-group">
            						<div class="controls">
            							<button class="btn btn-success" type="submit"><?php echo JText::_('LNG_CREATE_ACCOUNT') ?></button>
            						</div>
            					</div>		
        					</div>
                            <input type="hidden" name="serviceType" id="serviceType" value="<?php echo $this->serviceType ?>" />
                            <input type="hidden" name="filter_package" id="filter_package" value="<?php echo $this->filter_package ?>" />
                            <input type="hidden" name="packageType" id="packageType" value="<?php echo !empty($this->package)?$this->package->package_type:"" ?>" />
        					<input type="hidden" name="claim_listing_id" id="claim_listing_id" value="<?php echo $this->claimListing ?>" />
							<input type="hidden" name="orderId" id="orderId" value="<?php echo $this->orderId ?>" />
        					<?php echo JHtml::_('form.token'); ?>
        				</fieldset>
        			</form>
        		</div>
        	<?php } ?>
        	<div class="col-md offset-md-1">
        		<div class="">
        			<h3><?php echo JText::_("LNG_ALREADY_HAVE_ACCOUNT")?></h3>
        			<p>
        				<?php echo JText::_("LNG_ALREADY_HAVE_ACCOUNT_TXT")?>
        			</p>
        			
        			<form action="<?php echo JRoute::_('index.php?option=com_jbusinessdirectory&task=businessuser.loginUser'); ?>" method="post" id="form-login" name="login-form">
        				<fieldset>
            				<div class="control-group">
            					<div class="form-group">
            						<label for="username"><?php echo JText::_('LNG_USERNAME') ?></label>
            						<div class="outer_input">
            							<input type="text" name="username" id="username" size="50" class="form-control validate[required]">
            						</div>
            					</div>
            					<div class="form-group">
            						<label for="password"><?php echo JText::_('LNG_PASSWORD') ?></label>
            						<div class="outer_input">
            							<input type="password" name="password" id="password" size="50" class="form-control validate[required]">
            						</div>
            					</div>
        					</div>						
        					<div class="control-group">
        						<div class="controls">
        							<button class="btn btn-success" type="submit"><?php echo JText::_('LNG_LOG_IN') ?></button>
        						</div>
        					</div>		
        					
        					<div class="control-group">
        						<?php if($this->appSettings->social_profile) : ?>
									<div>
										<a href="<?php echo JRoute::_('index.php?option=com_users&view=registration'); ?>">
											<?php echo JText::_('COM_USERS_LOGIN_REGISTER'); ?>
										</a>
									</div>
								<?php endif; ?>
        						<div>
        							<a href="<?php echo JRoute::_('index.php?option=com_users&view=reset'); ?>">
        							<?php echo JText::_('COM_USERS_LOGIN_RESET'); ?></a>
        						</div>
        						<div>
        							<a href="<?php echo JRoute::_('index.php?option=com_users&view=remind'); ?>">
        							<?php echo JText::_('COM_USERS_LOGIN_REMIND'); ?></a>
    							</div>
        					</div>
        				</fieldset>
        				<input type="hidden" name="filter_package" id="filter_package" value="<?php echo $this->filter_package ?>" />
                        <input type="hidden" name="claim_listing_id" id="claim_listing_id" value="<?php echo $this->claimListing ?>" />
						<input type="hidden" name="packageType" id="packageType" value="<?php echo !empty($this->package)?$this->package->package_type:"" ?>" />
                        <input type="hidden" name="serviceType" id="serviceType" value="<?php echo $this->serviceType ?>" />
						<input type="hidden" name="orderId" id="orderId" value="<?php echo $this->orderId ?>" />
        				<?php echo JHtml::_('form.token'); ?>
        			</form>
        		</div>
        	</div>
        </div>
    </div>
</div>
	
<script>

window.addEventListener('load', function(){
	jQuery("#registration-form").validationEngine('attach');
	jQuery("#form-login").validationEngine('attach');
});
</script>