<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');

jimport('joomla.application.component.modelitem');
JTable::addIncludePath(DS.'components'.DS.'com_jbusinessdirectory'.DS.'tables');
require_once HELPERS_PATH.'/helper.php';

class JBusinessDirectoryModelPackages extends JModelLegacy {
	public function __construct() {
		parent::__construct();
		$this->appSettings = JBusinessUtil::getApplicationSettings();
	}

	/**
	 * Get available packages with included features.
	 * @return array
	 */
	public function getPackages() {
		$user = JBusinessUtil::getUser();
		$groups = $user->get('groups');
		$packageTable = JTable::getInstance("Package", "JTable");
		$packages = $packageTable->getPackages(false);
		
		$jinput = JFactory::getApplication()->input;
		$menuPackages =  $jinput->get('menupackages', null);
		$packageType =  $jinput->get('packageType', 1);
		
		foreach ($packages as $index => $package) {
			if (!empty($menuPackages) && !in_array($package->id, $menuPackages)) {
				unset($packages[$index]);
				continue;
			}

			if (!empty($packageType) && $package->package_type != $packageType) {
				unset($packages[$index]);
				continue;
			}
				
			$package->features = explode("#", $package->featuresS);
			$package->features[]= "multiple_categories";
			$packageUsergroup = explode(',', $package->package_usergroup);
			$intersect = array_intersect($groups, $packageUsergroup);
			if (empty($intersect) && !in_array('8', $groups) && !in_array('1', $packageUsergroup)) {
				//8 is the id of super user, he has the right to show all the packages, '1' is id for public usergroup
				unset($packages[$index]);
			}
		}
				
		if ($this->appSettings->enable_multilingual) {
			JBusinessDirectoryTranslations::updatePackagesTranslation($packages);
		}

		if (empty($packages)) {
			JFactory::getApplication()->enqueueMessage(JText::_('LNG_NO_ACTIVE_PACKAGE'), 'warning');
		}
		
		return $packages;
	}
}
?>

