<?php
/**
 * @package    JBusinessDirectory
 *
 * @author CMSJunkie http://www.cmsjunkie.com
 * @copyright  Copyright (C) 2007 - 2021 CMSJunkie. All rights reserved.
 * @license   https://www.gnu.org/licenses/agpl-3.0.en.html
 */
defined('_JEXEC') or die('Restricted access');
jimport('joomla.application.component.modelitem');

JTable::addIncludePath(DS . 'components' . 'com_jbusinessdirectory' . DS . 'tables');

class JBusinessDirectoryModelInvoice extends JModelItem {
	public function __construct() {
		parent::__construct();
		
		$this->appSettings = JBusinessUtil::getApplicationSettings();
	}

	public function getItem($pk = NULL) {		
		return $this->getInvoice();
	}

	public function getInvoice() {
		$orderId = JFactory::getApplication()->input->getInt("invoiceId");
		
		$model = JModelLegacy::getInstance('Orders', 'JBusinessDirectoryModel', array('ignore_request' => true));
		$order = $model->getOrder($orderId);
		
		$attributeConfig = JBusinessUtil::getAttributeConfiguration(DEFAULT_ATTRIBUTE_TYPE_LISTING);
		$order->company = JBusinessUtil::updateItemDefaultAtrributes($order->company, $attributeConfig);
		
		return $order;
	}
}
?>

